/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font.otf;

import com.itextpdf.io.font.otf.OtfClass;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import java.io.IOException;
import java.io.Serializable;

public class OpenTypeGdefTableReader
implements Serializable {
    static final int FLAG_IGNORE_BASE = 2;
    static final int FLAG_IGNORE_LIGATURE = 4;
    static final int FLAG_IGNORE_MARK = 8;
    private static final long serialVersionUID = 1564505797329158035L;
    private final int tableLocation;
    private final RandomAccessFileOrArray rf;
    private OtfClass glyphClass;
    private OtfClass markAttachmentClass;

    public OpenTypeGdefTableReader(RandomAccessFileOrArray rf, int tableLocation) {
        this.rf = rf;
        this.tableLocation = tableLocation;
    }

    public void readTable() throws IOException {
        if (this.tableLocation > 0) {
            this.rf.seek(this.tableLocation);
            this.rf.readUnsignedInt();
            int glyphClassDefOffset = this.rf.readUnsignedShort();
            this.rf.readUnsignedShort();
            this.rf.readUnsignedShort();
            int markAttachClassDefOffset = this.rf.readUnsignedShort();
            if (glyphClassDefOffset > 0) {
                this.glyphClass = OtfClass.create(this.rf, glyphClassDefOffset + this.tableLocation);
            }
            if (markAttachClassDefOffset > 0) {
                this.markAttachmentClass = OtfClass.create(this.rf, markAttachClassDefOffset + this.tableLocation);
            }
        }
    }

    public boolean isSkip(int glyph, int flag) {
        int markAttachmentType;
        if (this.glyphClass != null && (flag & 0xE) != 0) {
            int cla = this.glyphClass.getOtfClass(glyph);
            if (cla == 1 && (flag & 2) != 0) {
                return true;
            }
            if (cla == 3 && (flag & 8) != 0) {
                return true;
            }
            if (cla == 2 && (flag & 4) != 0) {
                return true;
            }
        }
        if ((markAttachmentType = flag >> 8) != 0 && this.glyphClass != null) {
            int currentGlyphClass = this.glyphClass.getOtfClass(glyph);
            int glyphMarkAttachmentClass = this.markAttachmentClass != null ? this.markAttachmentClass.getOtfClass(glyph) : 0;
            return currentGlyphClass == 3 && glyphMarkAttachmentClass != markAttachmentType;
        }
        return false;
    }

    public OtfClass getGlyphClassTable() {
        return this.glyphClass;
    }
}

