/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.processors.impl.font;

import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.Range;
import com.itextpdf.styledxmlparser.css.CssFontFaceRule;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.css.font.CssFontFace;
import com.itextpdf.svg.css.impl.SvgStyleResolver;
import com.itextpdf.svg.processors.impl.SvgProcessorContext;
import java.util.Collection;
import java.util.List;
import org.slf4j.LoggerFactory;

public class SvgFontProcessor {
    private SvgProcessorContext context;

    public SvgFontProcessor(SvgProcessorContext context) {
        this.context = context;
    }

    public void addFontFaceFonts(ICssResolver cssResolver) {
        if (cssResolver instanceof SvgStyleResolver) {
            for (CssFontFaceRule fontFace : ((SvgStyleResolver)cssResolver).getFonts()) {
                boolean findSupportedSrc = false;
                CssFontFace ff = CssFontFace.create((List)fontFace.getProperties());
                if (ff != null) {
                    for (CssFontFace.CssFontFaceSrc src : ff.getSources()) {
                        if (!this.createFont(ff.getFontFamily(), src, fontFace.resolveUnicodeRange())) continue;
                        findSupportedSrc = true;
                        break;
                    }
                }
                if (findSupportedSrc) continue;
                LoggerFactory.getLogger(SvgFontProcessor.class).error(MessageFormatUtil.format((String)"Unable to retrieve font:\n {0}", (Object[])new Object[]{fontFace}));
            }
        }
    }

    private boolean createFont(String fontFamily, CssFontFace.CssFontFaceSrc src, Range unicodeRange) {
        if (!CssFontFace.isSupportedFontFormat((CssFontFace.FontFormat)src.getFormat())) {
            return false;
        }
        if (src.isLocal()) {
            Collection fonts = this.context.getFontProvider().getFontSet().get(src.getSrc());
            if (fonts.size() > 0) {
                for (FontInfo fi : fonts) {
                    this.context.addTemporaryFont(fi, fontFamily);
                }
                return true;
            }
            return false;
        }
        try {
            byte[] bytes = this.context.getResourceResolver().retrieveBytesFromResource(src.getSrc());
            if (bytes != null) {
                FontProgram fp = FontProgramFactory.createFont((byte[])bytes, (boolean)false);
                this.context.addTemporaryFont(fp, "Identity-H", fontFamily, unicodeRange);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

