/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.feature.visitor.LimitingVisitor;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Converters;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

public class UniqueVisitor
implements FeatureCalc,
FeatureAttributeVisitor,
LimitingVisitor {
    private Expression expr;
    Set<Object> set = new HashSet<Object>();
    Set<Object> skipped = new HashSet<Object>();
    int startIndex = 0;
    int maxFeatures = Integer.MAX_VALUE;
    int currentItem = 0;
    boolean preserveOrder = false;

    public UniqueVisitor(String attributeTypeName) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(attributeTypeName);
    }

    public UniqueVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attributeTypeIndex).getLocalName());
    }

    public UniqueVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attrName).getLocalName());
    }

    public UniqueVisitor(Expression expr) {
        this.expr = expr;
    }

    public void init(SimpleFeatureCollection collection) {
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public void setMaxFeatures(int maxFeatures) {
        this.maxFeatures = maxFeatures;
    }

    public void setPreserveOrder(boolean preserveOrder) {
        this.preserveOrder = preserveOrder;
        this.set = this.createNewSet(Collections.emptyList());
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getMaxFeatures() {
        return this.maxFeatures;
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.expr);
    }

    @Override
    public Optional<List<Class>> getResultType(List<Class> inputTypes) {
        return CalcUtil.reflectInputTypes(1, inputTypes);
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    public void visit(Feature feature) {
        Object value = this.expr.evaluate((Object)feature);
        if (value != null && !this.set.contains(value) && !this.skipped.contains(value)) {
            if (this.currentItem >= this.startIndex && this.currentItem < this.startIndex + this.maxFeatures) {
                this.set.add(value);
            } else {
                this.skipped.add(value);
            }
            ++this.currentItem;
        }
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Set getUnique() {
        return this.set;
    }

    public void setValue(Object newSet) {
        if (newSet instanceof Collection) {
            Collection cast = (Collection)newSet;
            this.set = this.createNewSet(cast);
        } else {
            List collection = (List)Converters.convert((Object)newSet, List.class);
            this.set = collection != null ? this.createNewSet(collection) : this.createNewSet(Collections.singleton(newSet));
        }
    }

    private Set<Object> createNewSet(Collection<Object> collection) {
        return UniqueResult.createNewSet(collection, this.preserveOrder);
    }

    public void reset() {
        this.set = this.createNewSet(Collections.emptyList());
        this.skipped = new HashSet<Object>();
        this.currentItem = 0;
    }

    @Override
    public CalcResult getResult() {
        if (this.set.isEmpty()) {
            return CalcResult.NULL_RESULT;
        }
        return new UniqueResult(this.set, this.preserveOrder);
    }

    @Override
    public boolean hasLimits() {
        return this.startIndex > 0 || this.maxFeatures < Integer.MAX_VALUE;
    }

    public boolean isPreserveOrder() {
        return this.preserveOrder;
    }

    public static class UniqueResult
    extends AbstractCalcResult {
        private Set<Object> unique;
        private boolean preserveOrder = false;

        public UniqueResult(Set<Object> newSet) {
            this.unique = newSet;
        }

        public UniqueResult(Set<Object> newSet, boolean preserveOrder) {
            this.unique = newSet;
            this.preserveOrder = preserveOrder;
        }

        public static <T> Set<T> createNewSet(Collection<T> collection, boolean preserveOrder) {
            if (preserveOrder) {
                return new LinkedHashSet<T>(collection);
            }
            return new HashSet<T>(collection);
        }

        @Override
        public Object getValue() {
            return UniqueResult.createNewSet(this.unique, this.preserveOrder);
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof UniqueResult || targetResults == CalcResult.NULL_RESULT;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof UniqueResult) {
                Set<Object> newSet = UniqueResult.createNewSet(this.unique, this.preserveOrder);
                Set other = (Set)resultsToAdd.getValue();
                newSet.addAll(other);
                return new UniqueResult(newSet, this.preserveOrder);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

