/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.function.Consumer;

final class Chain<T> {
    private final Link<T>[] vacant;
    private final int[] ivacant;
    private Link<T> head = null;
    private Link<T> tail = null;
    private int size = 0;

    Chain(Link<T>[] linkArray, int[] nArray) {
        this.vacant = linkArray;
        this.ivacant = nArray;
    }

    static <T> void addHead(T t2, Chain<T> ... chainArray) {
        Link<T> link;
        if (0 == chainArray.length) {
            link = null;
        } else {
            Link<T>[] linkArray = chainArray[0].vacant;
            int[] nArray = chainArray[0].ivacant;
            nArray[0] = Math.max(0, nArray[0] - 1);
            link = linkArray[nArray[0]];
            linkArray[nArray[0]] = null;
        }
        if (null == link) {
            new Link<T>(t2, chainArray);
        } else {
            link.link(t2, chainArray);
        }
    }

    T removeHead() {
        return this.remove(this.head);
    }

    T removeTail() {
        return this.remove(this.tail);
    }

    private T remove(Link<T> link) {
        if (null == link) {
            return null;
        }
        this.ivacant[0] = Math.min(this.ivacant[0] + 1, this.vacant.length - 1);
        this.vacant[this.ivacant[0]] = link;
        return link.unlink();
    }

    int size() {
        return this.size;
    }

    void forEach(Consumer<? super T> consumer) {
        Integer n2 = null;
        Link<T> link = this.head;
        while (null != link) {
            consumer.accept(link.value);
            if (null == n2) {
                for (int i2 = 0; i2 < link.chains.length; ++i2) {
                    if (this != link.chains[i2]) continue;
                    n2 = i2;
                    break;
                }
            }
            link = link.next[n2];
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append("[ ");
        boolean[] blArray = new boolean[]{false};
        this.forEach(object -> {
            stringBuilder.append(blArray[0] ? ", " : "").append(object.toString());
            blArray[0] = true;
        });
        return stringBuilder.append(" ]").toString();
    }

    static final class Link<T> {
        private T value;
        private Chain<T>[] chains;
        private final Link<T>[] prev;
        private final Link<T>[] next;

        private Link(T t2, Chain<T> ... chainArray) {
            this.prev = new Link[chainArray.length];
            this.next = new Link[chainArray.length];
            this.link(t2, chainArray);
        }

        private void link(T t2, Chain<T> ... chainArray) {
            this.value = t2;
            this.chains = chainArray;
            for (int i2 = 0; i2 < chainArray.length; ++i2) {
                Chain<T> chain = chainArray[i2];
                ++chain.size;
                this.next[i2] = chain.head;
                this.prev[i2] = null;
                if (null != chain.head) {
                    chain.head.prev[i2] = this;
                }
                chain.head = this;
                if (null != chain.tail) continue;
                chain.tail = this;
            }
        }

        private T unlink() {
            for (int i2 = 0; i2 < this.chains.length; ++i2) {
                Chain<T> chain = this.chains[i2];
                --chain.size;
                if (null == this.prev[i2]) {
                    chain.head = this.next[i2];
                } else {
                    this.prev[i2].next[i2] = this.next[i2];
                }
                if (null == this.next[i2]) {
                    chain.tail = this.prev[i2];
                    continue;
                }
                this.next[i2].prev[i2] = this.prev[i2];
            }
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }
}

