/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.jdbc.SequencedPrimaryKeyColumn;
import org.geotools.util.logging.Logging;

public class HeuristicPrimaryKeyFinder
extends PrimaryKeyFinder {
    protected static final Logger LOGGER = Logging.getLogger(HeuristicPrimaryKeyFinder.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PrimaryKey getPrimaryKey(JDBCDataStore store, String databaseSchema, String tableName, Connection cx) throws SQLException {
        DatabaseMetaData metaData = cx.getMetaData();
        LOGGER.log(Level.FINE, "Getting information about primary keys of {0}", tableName);
        ResultSet primaryKey = metaData.getPrimaryKeys(null, databaseSchema, tableName);
        try {
            PrimaryKey pkey = this.createPrimaryKey(store, primaryKey, metaData, databaseSchema, tableName, cx);
            if (pkey == null && !store.isView(metaData, databaseSchema, tableName) && store.getVirtualTables().get(tableName) == null) {
                LOGGER.log(Level.FINE, "Getting information about unique indexes of {0}", tableName);
                ResultSet uniqueIndex = metaData.getIndexInfo(null, databaseSchema, tableName, true, true);
                try {
                    pkey = this.createPrimaryKey(store, uniqueIndex, metaData, databaseSchema, tableName, cx);
                }
                finally {
                    store.closeSafe(uniqueIndex);
                }
            }
            PrimaryKey primaryKey2 = pkey;
            return primaryKey2;
        }
        finally {
            store.closeSafe(primaryKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PrimaryKey createPrimaryKey(JDBCDataStore store, ResultSet index, DatabaseMetaData metaData, String databaseSchema, String tableName, Connection cx) throws SQLException {
        ArrayList<PrimaryKeyColumn> cols = new ArrayList<PrimaryKeyColumn>();
        while (index.next()) {
            Class<Object> columnType;
            String columnName = index.getString("COLUMN_NAME");
            if (columnName == null) continue;
            ResultSet columns = metaData.getColumns(null, store.escapeNamePattern(metaData, databaseSchema), store.escapeNamePattern(metaData, tableName), store.escapeNamePattern(metaData, columnName));
            try {
                int binding;
                columns.next();
                columnType = store.getSQLDialect().getMapping(columns, cx);
                if (columnType == null && (columnType = store.getMapping(binding = columns.getInt("DATA_TYPE"))) == null) {
                    LOGGER.warning("No class for sql type " + binding);
                    columnType = Object.class;
                }
            }
            finally {
                store.closeSafe(columns);
            }
            PrimaryKeyColumn col = null;
            Statement st = cx.createStatement();
            try {
                st.setFetchSize(1);
                StringBuffer sql = new StringBuffer();
                sql.append("SELECT ");
                store.getSQLDialect().encodeColumnName(null, columnName, sql);
                sql.append(" FROM ");
                store.encodeTableName(tableName, sql, null);
                sql.append(" WHERE 0=1");
                LOGGER.log(Level.FINE, "Grabbing table pk metadata: {0}", sql);
                ResultSet rs = st.executeQuery(sql.toString());
                try {
                    if (rs.getMetaData().isAutoIncrement(1)) {
                        col = new AutoGeneratedPrimaryKeyColumn(columnName, columnType);
                    }
                }
                finally {
                    store.closeSafe(rs);
                }
            }
            finally {
                store.closeSafe(st);
            }
            if (col == null) {
                try {
                    String sequenceName = store.getSQLDialect().getSequenceForColumn(databaseSchema, tableName, columnName, cx);
                    if (sequenceName != null) {
                        col = new SequencedPrimaryKeyColumn(columnName, columnType, sequenceName);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Error occured determining sequence for " + columnName + ", " + tableName, e);
                }
            }
            if (col == null) {
                col = new NonIncrementingPrimaryKeyColumn(columnName, columnType);
            }
            cols.add(col);
        }
        if (!cols.isEmpty()) {
            return new PrimaryKey(tableName, cols);
        }
        return null;
    }
}

