/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.svg.renderers.impl;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.gradients.GradientColorStop;
import com.itextpdf.kernel.colors.gradients.LinearGradientBuilder;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.svg.renderers.ISvgNodeRenderer;
import com.itextpdf.svg.renderers.SvgDrawContext;
import com.itextpdf.svg.renderers.impl.AbstractGradientSvgNodeRenderer;
import com.itextpdf.svg.renderers.impl.StopSvgNodeRenderer;
import com.itextpdf.svg.utils.SvgCoordinateUtils;
import java.util.ArrayList;
import java.util.List;

public class LinearGradientSvgNodeRenderer
extends AbstractGradientSvgNodeRenderer {
    private static final double CONVERT_COEFF = 0.75;

    @Override
    public Color createColor(SvgDrawContext context, Rectangle objectBoundingBox, float objectBoundingBoxMargin, float parentOpacity) {
        if (objectBoundingBox == null) {
            return null;
        }
        LinearGradientBuilder builder = new LinearGradientBuilder();
        for (GradientColorStop stopColor : this.parseStops(parentOpacity)) {
            builder.addColorStop(stopColor);
        }
        builder.setSpreadMethod(this.parseSpreadMethod());
        boolean isObjectBoundingBox = this.isObjectBoundingBoxUnits();
        Point[] coordinates = this.getCoordinates(context, isObjectBoundingBox);
        builder.setGradientVector(coordinates[0].getX(), coordinates[0].getY(), coordinates[1].getX(), coordinates[1].getY());
        AffineTransform gradientTransform = this.getGradientTransformToUserSpaceOnUse(objectBoundingBox, isObjectBoundingBox);
        builder.setCurrentSpaceToGradientVectorSpaceTransformation(gradientTransform);
        return builder.buildColor(objectBoundingBox.applyMargins(objectBoundingBoxMargin, objectBoundingBoxMargin, objectBoundingBoxMargin, objectBoundingBoxMargin, true), context.getCurrentCanvasTransform(), context.getCurrentCanvas().getDocument());
    }

    @Override
    public ISvgNodeRenderer createDeepCopy() {
        LinearGradientSvgNodeRenderer copy = new LinearGradientSvgNodeRenderer();
        this.deepCopyAttributesAndStyles(copy);
        this.deepCopyChildren(copy);
        return copy;
    }

    @Override
    public Rectangle getObjectBoundingBox(SvgDrawContext context) {
        throw new UnsupportedOperationException("The renderer has no object bounding box.");
    }

    private List<GradientColorStop> parseStops(float parentOpacity) {
        ArrayList<GradientColorStop> stopsList = new ArrayList<GradientColorStop>();
        for (StopSvgNodeRenderer stopRenderer : this.getChildStopRenderers()) {
            float[] stopColor = stopRenderer.getStopColor();
            double offset = stopRenderer.getOffset();
            stopsList.add(new GradientColorStop(stopColor, offset, GradientColorStop.OffsetType.RELATIVE));
        }
        if (!stopsList.isEmpty()) {
            GradientColorStop lastStop;
            GradientColorStop firstStop = (GradientColorStop)stopsList.get(0);
            if (firstStop.getOffset() > 0.0) {
                stopsList.add(0, new GradientColorStop(firstStop, 0.0, GradientColorStop.OffsetType.RELATIVE));
            }
            if ((lastStop = (GradientColorStop)stopsList.get(stopsList.size() - 1)).getOffset() < 1.0) {
                stopsList.add(new GradientColorStop(lastStop, 1.0, GradientColorStop.OffsetType.RELATIVE));
            }
        }
        return stopsList;
    }

    private AffineTransform getGradientTransformToUserSpaceOnUse(Rectangle objectBoundingBox, boolean isObjectBoundingBox) {
        AffineTransform svgGradientTransformation;
        AffineTransform gradientTransform = new AffineTransform();
        if (isObjectBoundingBox) {
            gradientTransform.translate((double)objectBoundingBox.getX(), (double)objectBoundingBox.getY());
            gradientTransform.scale((double)objectBoundingBox.getWidth() / 0.75, (double)objectBoundingBox.getHeight() / 0.75);
        }
        if ((svgGradientTransformation = this.getGradientTransform()) != null) {
            gradientTransform.concatenate(svgGradientTransformation);
        }
        return gradientTransform;
    }

    private Point[] getCoordinates(SvgDrawContext context, boolean isObjectBoundingBox) {
        Point end;
        Point start;
        if (isObjectBoundingBox) {
            start = new Point(SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("x1"), 0.0) * 0.75, SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("y1"), 0.0) * 0.75);
            end = new Point(SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("x2"), 1.0) * 0.75, SvgCoordinateUtils.getCoordinateForObjectBoundingBox(this.getAttribute("y2"), 0.0) * 0.75);
        } else {
            Rectangle currentViewPort = context.getCurrentViewPort();
            double x = currentViewPort.getX();
            double y = currentViewPort.getY();
            double width = currentViewPort.getWidth();
            double height = currentViewPort.getHeight();
            float em = this.getCurrentFontSize();
            float rem = context.getCssContext().getRootFontSize();
            start = new Point(SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("x1"), x, x, width, em, rem), SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("y1"), y, y, height, em, rem));
            end = new Point(SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("x2"), x + width, x, width, em, rem), SvgCoordinateUtils.getCoordinateForUserSpaceOnUse(this.getAttribute("y2"), y, y, height, em, rem));
        }
        return new Point[]{start, end};
    }
}

