/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.jdbc.util.converter;

import java.sql.SQLException;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverter;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.oracle.sdo.GeometryConverter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;

public class OracleJdbcConverter
extends GeometryJdbcConverter {
    protected static final Log LOG = LogFactory.getLog(OracleJdbcConverter.class);
    private final GeometryConverter gc;
    private String schema;

    public OracleJdbcConverter(OracleConnection oc) throws SQLException {
        this.gc = new GeometryConverter(oc, this.gf);
    }

    @Override
    public boolean isDuplicateKeyViolationMessage(String message) {
        return message != null && message.startsWith("ORA-00001:");
    }

    @Override
    public boolean isFKConstraintViolationMessage(String message) {
        return message != null && message.startsWith("ORA-02291:");
    }

    @Override
    public String createPSGeometryPlaceholder() {
        return "?";
    }

    @Override
    public Object convertToNativeGeometryObject(Geometry g, int srid) throws SQLException, ParseException {
        if (g == null) {
            return null;
        }
        return this.gc.toSDO(g, srid);
    }

    @Override
    public Object convertToNativeGeometryObject(Geometry g) throws SQLException, ParseException {
        return this.convertToNativeGeometryObject(g, 28992);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getGeomTypeName() {
        return "SDO_GEOMETRY";
    }

    @Override
    public String buildPaginationSql(String sql, int offset, int limit) {
        StringBuilder builder = new StringBuilder();
        builder.append("select * from (");
        builder.append("select /*+ FIRST_ROWS(n) */");
        builder.append(" a.*, ROWNUM rnum from (");
        builder.append(sql);
        builder.append(" ) a where ROWNUM <=");
        builder.append(offset + limit);
        builder.append(" )");
        builder.append(" where rnum  > ");
        builder.append(offset);
        return builder.toString();
    }

    @Override
    public StringBuilder buildLimitSql(StringBuilder sql, int limit) {
        sql.append(" FETCH FIRST ").append(limit).append(" ROWS ONLY");
        return sql;
    }

    @Override
    public boolean useSavepoints() {
        return false;
    }

    @Override
    public boolean isPmdKnownBroken() {
        return true;
    }

    @Override
    public String getGeotoolsDBTypeName() {
        return "oracle";
    }

    @Override
    public String getMViewsSQL() {
        return "SELECT MVIEW_NAME FROM ALL_MVIEWS";
    }

    @Override
    public String getMViewRefreshSQL(String mview) {
        return String.format("begin\ndbms_mview.refresh('%s','C');\nend;", mview);
    }

    @Override
    public String getSelectNextValueFromSequenceSQL(String seqName) {
        return String.format("SELECT %s.nextval FROM dual", seqName);
    }

    @Override
    public Geometry convertToJTSGeometryObject(Object nativeObj) {
        Geometry jts = null;
        if (nativeObj == null) {
            return jts;
        }
        if (OracleStruct.class.isAssignableFrom(nativeObj.getClass())) {
            try {
                jts = this.gc.asGeometry((OracleStruct)nativeObj);
            }
            catch (NullPointerException | SQLException e) {
                LOG.error((Object)"Error parsing OracleStruct to geometry", (Throwable)e);
            }
        } else {
            LOG.error((Object)"Native Oracle object can not be converted to JTS geometry");
        }
        return jts;
    }

    @Override
    public String getUpdateSequenceSQL(String seqName, long nextVal) {
        return String.format("ALTER SEQUENCE %s RESTART START WITH %d", seqName, nextVal);
    }
}

