/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.AbstractInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

public class GrowableInternationalString
extends AbstractInternationalString
implements Serializable {
    private static final long serialVersionUID = 5760033376627376937L;
    private static final Map<Locale, Locale> LOCALES = new HashMap<Locale, Locale>();
    private Map<Locale, String> localMap;

    public GrowableInternationalString() {
        this.localMap = Collections.emptyMap();
    }

    public GrowableInternationalString(String string) {
        this.localMap = string != null ? Collections.singletonMap(null, string) : Collections.emptyMap();
    }

    public GrowableInternationalString(InternationalString internationalString) {
        this.localMap = new LinkedHashMap<Locale, String>();
        boolean isGrowable = internationalString instanceof GrowableInternationalString;
        String defaultValue = null;
        if (!isGrowable) {
            defaultValue = internationalString.toString();
        }
        Set<Locale> locales = isGrowable ? ((GrowableInternationalString)internationalString).getLocales() : Stream.of(Locale.getAvailableLocales()).collect(Collectors.toSet());
        for (Locale locale : locales) {
            String value = internationalString.toString(locale);
            if (value == null || value.equals(defaultValue)) continue;
            this.localMap.put(locale, value);
        }
        if (defaultValue != null) {
            this.localMap.put(Locale.getDefault(), defaultValue);
        }
    }

    public synchronized void add(Locale locale, String string) throws IllegalArgumentException {
        if (string != null) {
            switch (this.localMap.size()) {
                case 0: {
                    this.localMap = Collections.singletonMap(locale, string);
                    this.defaultValue = null;
                    return;
                }
                case 1: {
                    this.localMap = new LinkedHashMap<Locale, String>(this.localMap);
                }
            }
            String old = this.localMap.get(locale);
            if (old != null) {
                if (string.equals(old)) {
                    return;
                }
                throw new IllegalArgumentException();
            }
            this.localMap.put(locale, string);
            this.defaultValue = null;
        }
    }

    public boolean add(String prefix, String key, String string) throws IllegalArgumentException {
        if (!key.startsWith(prefix)) {
            return false;
        }
        int position = prefix.length();
        int length = key.length();
        String[] parts = new String[]{"", "", ""};
        int i = 0;
        while (true) {
            int next;
            if (position == length) {
                Locale locale = i == 0 ? null : GrowableInternationalString.unique(new Locale(parts[0], parts[1], parts[2]));
                this.add(locale, string);
                return true;
            }
            if (key.charAt(position) != '_' || i == parts.length) break;
            if ((next = key.indexOf(95, ++position)) < 0) {
                next = length;
            } else if (next == position) break;
            int n = position;
            position = next;
            parts[i] = key.substring(n, position);
            ++i;
        }
        throw new IllegalArgumentException(Errors.format(58, "locale", key.substring(prefix.length())));
    }

    private static synchronized Locale unique(Locale locale) {
        Locale candidate;
        if (LOCALES.isEmpty()) {
            try {
                Field[] fields;
                for (Field field : fields = Locale.class.getFields()) {
                    if (!Modifier.isStatic(field.getModifiers()) || !Locale.class.isAssignableFrom(field.getType())) continue;
                    Locale toAdd = (Locale)field.get(null);
                    LOCALES.put(toAdd, toAdd);
                }
            }
            catch (Exception exception) {
                Logging.unexpectedException(GrowableInternationalString.class, "unique", exception);
            }
        }
        if ((candidate = LOCALES.get(locale)) != null) {
            return candidate;
        }
        LOCALES.put(locale, locale);
        return locale;
    }

    public Set<Locale> getLocales() {
        return Collections.unmodifiableSet(this.localMap.keySet());
    }

    @Override
    public synchronized String toString(Locale locale) {
        Iterator<String> it;
        String text;
        while (locale != null) {
            text = this.localMap.get(locale);
            if (text != null) {
                return text;
            }
            String language = locale.getLanguage();
            String country = locale.getCountry();
            String variant = locale.getVariant();
            if (variant.length() != 0) {
                locale = new Locale(language, country);
                continue;
            }
            if (country.length() == 0) break;
            locale = new Locale(language);
        }
        if ((text = this.localMap.get(null)) == null && (it = this.localMap.values().iterator()).hasNext()) {
            return it.next();
        }
        return text;
    }

    public boolean isSubsetOf(Object candidate) {
        if (candidate instanceof InternationalString) {
            InternationalString string = (InternationalString)candidate;
            for (Map.Entry<Locale, String> entry : this.localMap.entrySet()) {
                Locale locale = entry.getKey();
                String text = entry.getValue();
                if (text.equals(string.toString(locale))) continue;
                return false;
            }
        } else if (candidate instanceof CharSequence) {
            String string = candidate.toString();
            for (String text : this.localMap.values()) {
                if (text.equals(string)) continue;
                return false;
            }
        } else {
            if (candidate instanceof Map) {
                Map map = (Map)candidate;
                return map.entrySet().containsAll(this.localMap.entrySet());
            }
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GrowableInternationalString that = (GrowableInternationalString)object;
            return Utilities.equals(this.localMap, that.localMap);
        }
        return false;
    }

    public int hashCode() {
        return 0x8C44C329 ^ this.localMap.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int size = this.localMap.size();
        if (size == 0) {
            return;
        }
        Map.Entry[] entries = new Map.Entry[size];
        entries = this.localMap.entrySet().toArray(entries);
        if (size == 1) {
            Map.Entry entry = entries[0];
            this.localMap = Collections.singletonMap(GrowableInternationalString.unique((Locale)entry.getKey()), entry.getValue());
        } else {
            this.localMap.clear();
            for (Map.Entry entry : entries) {
                this.localMap.put(GrowableInternationalString.unique((Locale)entry.getKey()), (String)entry.getValue());
            }
        }
    }
}

