/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Enumeration;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.types.Collation;

public class HsqlDatabaseProperties
extends HsqlProperties {
    public static final String hsqldb_method_class_names = "hsqldb.method_class_names";
    public static final String textdb_allow_full_path = "textdb.allow_full_path";
    public static final String hsqldb_reconfig_logging = "hsqldb.reconfig_logging";
    public static String methodClassNames;
    private static HashSet accessibleJavaMethodNames;
    private static boolean allowFullPath;
    public static final int SYSTEM_PROP = 0;
    public static final int FILES_PROP = 1;
    public static final int DB_PROP = 2;
    public static final int SQL_PROP = 3;
    public static final int URL_PROP = 4;
    public static final int FILES_NOT_MODIFIED = 0;
    public static final int FILES_MODIFIED = 1;
    public static final int FILES_MODIFIED_NEW = 2;
    public static final int FILES_MODIFIED_NEW_DATA = 3;
    public static final int FILES_NEW = 4;
    private static final String MODIFIED_NO = "no";
    private static final String MODIFIED_YES = "yes";
    private static final String MODIFIED_YES_NEW = "yes-new-files";
    private static final String MODIFIED_YES_NEW_DATA = "yes-new-files-data";
    private static final String MODIFIED_NO_NEW = "no-new-files";
    private static final HashMap<String, HsqlProperties.PropertyMeta> dbMeta;
    private static final HashMap<String, HsqlProperties.PropertyMeta> textMeta;
    private static final HashSet<String> excludedMeta;
    private static final HashMap<String, HsqlProperties.PropertyMeta> urlUserConnMeta;
    public static final String VERSION_STRING_1_8_0 = "1.8.0";
    public static final String PRODUCT_NAME = "HSQL Database Engine";
    public static final String THIS_VERSION = "2.7.0";
    public static final String THIS_FULL_VERSION = "2.7.0";
    public static final int MAJOR = 2;
    public static final int MINOR = 7;
    public static final int REVISION = 0;
    public static final String system_lockfile_poll_retries_property = "hsqldb.lockfile_poll_retries";
    public static final String system_max_char_or_varchar_display_size = "hsqldb.max_char_or_varchar_display_size";
    public static final String hsqldb_inc_backup = "hsqldb.inc_backup";
    public static final String hsqldb_version = "version";
    public static final String hsqldb_readonly = "readonly";
    private static final String hsqldb_modified = "modified";
    public static final String tx_timestamp = "tx_timestamp";
    public static final String runtime_gc_interval = "runtime.gc_interval";
    public static final String url_ifexists = "ifexists";
    public static final String url_create = "create";
    public static final String url_default_schema = "default_schema";
    public static final String url_check_props = "check_props";
    public static final String url_get_column_name = "get_column_name";
    public static final String url_close_result = "close_result";
    public static final String url_allow_empty_batch = "allow_empty_batch";
    public static final String url_memory_lobs = "memory_lobs";
    public static final String url_shutdown = "shutdown";
    public static final String url_recover = "recover";
    public static final String url_tls_wrapper = "tls_wrapper";
    public static final String url_crypt_key = "crypt_key";
    public static final String url_crypt_type = "crypt_type";
    public static final String url_crypt_provider = "crypt_provider";
    public static final String url_crypt_iv = "crypt_iv";
    public static final String url_crypt_lobs = "crypt_lobs";
    public static final String hsqldb_tx = "hsqldb.tx";
    public static final String hsqldb_tx_level = "hsqldb.tx_level";
    public static final String hsqldb_tx_conflict_rollback = "hsqldb.tx_conflict_rollback";
    public static final String hsqldb_tx_interrupt_rollback = "hsqldb.tx_interrupt_rollback";
    public static final String hsqldb_applog = "hsqldb.applog";
    public static final String hsqldb_extlog = "hsqldb.extlog";
    public static final String hsqldb_sqllog = "hsqldb.sqllog";
    public static final String hsqldb_lob_file_scale = "hsqldb.lob_file_scale";
    public static final String hsqldb_lob_file_compressed = "hsqldb.lob_compressed";
    public static final String hsqldb_cache_file_scale = "hsqldb.cache_file_scale";
    public static final String hsqldb_cache_free_count = "hsqldb.cache_free_count";
    public static final String hsqldb_cache_rows = "hsqldb.cache_rows";
    public static final String hsqldb_cache_size = "hsqldb.cache_size";
    public static final String hsqldb_default_table_type = "hsqldb.default_table_type";
    public static final String hsqldb_defrag_limit = "hsqldb.defrag_limit";
    public static final String hsqldb_files_readonly = "files_readonly";
    public static final String hsqldb_lock_file = "hsqldb.lock_file";
    public static final String hsqldb_log_data = "hsqldb.log_data";
    public static final String hsqldb_log_size = "hsqldb.log_size";
    public static final String hsqldb_nio_data_file = "hsqldb.nio_data_file";
    public static final String hsqldb_nio_max_size = "hsqldb.nio_max_size";
    public static final String hsqldb_script_format = "hsqldb.script_format";
    public static final String hsqldb_temp_directory = "hsqldb.temp_directory";
    public static final String hsqldb_result_max_memory_rows = "hsqldb.result_max_memory_rows";
    public static final String hsqldb_write_delay = "hsqldb.write_delay";
    public static final String hsqldb_write_delay_millis = "hsqldb.write_delay_millis";
    public static final String hsqldb_full_log_replay = "hsqldb.full_log_replay";
    public static final String hsqldb_large_data = "hsqldb.large_data";
    public static final String hsqldb_files_space = "hsqldb.files_space";
    public static final String hsqldb_digest = "hsqldb.digest";
    public static final String jdbc_translate_tti_types = "jdbc.translate_tti_types";
    public static final String sql_restrict_exec = "sql.restrict_exec";
    public static final String sql_ref_integrity = "sql.ref_integrity";
    public static final String sql_compare_in_locale = "sql.compare_in_locale";
    public static final String sql_enforce_size = "sql.enforce_size";
    public static final String sql_enforce_strict_size = "sql.enforce_strict_size";
    public static final String sql_enforce_refs = "sql.enforce_refs";
    public static final String sql_enforce_names = "sql.enforce_names";
    public static final String sql_regular_names = "sql.regular_names";
    public static final String sql_enforce_types = "sql.enforce_types";
    public static final String sql_enforce_tdcd = "sql.enforce_tdc_delete";
    public static final String sql_enforce_tdcu = "sql.enforce_tdc_update";
    public static final String sql_char_literal = "sql.char_literal";
    public static final String sql_concat_nulls = "sql.concat_nulls";
    public static final String sql_nulls_first = "sql.nulls_first";
    public static final String sql_nulls_order = "sql.nulls_order";
    public static final String sql_unique_nulls = "sql.unique_nulls";
    public static final String sql_convert_trunc = "sql.convert_trunc";
    public static final String sql_trunc_trailing = "sql.truncate_trailing";
    public static final String sql_avg_scale = "sql.avg_scale";
    public static final String sql_max_recursive = "sql.max_recursive";
    public static final String sql_double_nan = "sql.double_nan";
    public static final String sql_syntax_db2 = "sql.syntax_db2";
    public static final String sql_syntax_mss = "sql.syntax_mss";
    public static final String sql_syntax_mys = "sql.syntax_mys";
    public static final String sql_syntax_ora = "sql.syntax_ora";
    public static final String sql_syntax_pgs = "sql.syntax_pgs";
    public static final String sql_longvar_is_lob = "sql.longvar_is_lob";
    public static final String sql_default_collation = "sql.default_collation";
    public static final String sql_pad_space = "sql.pad_space";
    public static final String sql_ignore_case = "sql.ignore_case";
    public static final String sql_live_object = "sql.live_object";
    public static final String sql_sys_index_names = "sql.sys_index_names";
    public static final String sql_lowercase_ident = "sql.lowercase_ident";
    public static final String textdb_cache_scale = "textdb.cache_scale";
    public static final String textdb_cache_size_scale = "textdb.cache_size_scale";
    public static final String textdb_cache_rows = "textdb.cache_rows";
    public static final String textdb_cache_size = "textdb.cache_size";
    public static final String textdb_all_quoted = "textdb.all_quoted";
    public static final String textdb_encoding = "textdb.encoding";
    public static final String textdb_ignore_first = "textdb.ignore_first";
    public static final String textdb_quoted = "textdb.quoted";
    public static final String textdb_fs = "textdb.fs";
    public static final String textdb_vs = "textdb.vs";
    public static final String textdb_lvs = "textdb.lvs";
    public static final String textdb_qc = "textdb.qc";
    public static final String textdb_null_def = "textdb.null_def";
    public static final String hsqldb_min_reuse = "hsqldb.min_reuse";
    public static final String hsqldb_cache_version = "hsqldb.cache_version";
    private Database database;

    public static boolean supportsJavaMethod(String string) {
        if (accessibleJavaMethodNames == null) {
            return true;
        }
        if (string.startsWith("java.lang.Math.")) {
            return true;
        }
        if (accessibleJavaMethodNames.contains(string)) {
            return true;
        }
        Iterator iterator = accessibleJavaMethodNames.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = string2.lastIndexOf(".*");
            if (n < 1 || !string.startsWith(string2.substring(0, n + 1))) continue;
            return true;
        }
        return false;
    }

    public HsqlDatabaseProperties(Database database) {
        super(database.getPath(), database.logger.getFileAccess(), database.isFilesInJar());
        this.database = database;
        this.setNewDatabaseProperties();
    }

    void setNewDatabaseProperties() {
        this.setProperty(hsqldb_version, "2.7.0");
        this.setProperty(hsqldb_modified, MODIFIED_NO_NEW);
    }

    @Override
    public boolean load() {
        boolean bl;
        if (!this.database.getType().isFileBased()) {
            return true;
        }
        try {
            bl = super.load();
        }
        catch (Throwable throwable) {
            throw Error.error(throwable, 452, 27, new String[]{throwable.toString(), this.fileName});
        }
        if (!bl) {
            return false;
        }
        this.filterLoadedProperties();
        String string = this.getStringProperty(hsqldb_version);
        int n = string.substring(0, 5).compareTo(VERSION_STRING_1_8_0);
        if (n < 0) {
            throw Error.error(453);
        }
        if (n == 0 && this.getIntegerProperty(hsqldb_script_format) != 0) {
            throw Error.error(453);
        }
        n = string.substring(0, 2).compareTo("2.7.0");
        if (n > 0) {
            throw Error.error(453);
        }
        return true;
    }

    @Override
    public void save() {
        if (!this.database.getType().isFileBased() || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            HsqlProperties hsqlProperties = new HsqlProperties(this.database.getPath(), this.database.logger.getFileAccess(), false);
            if (this.getIntegerProperty(hsqldb_script_format) == 3) {
                hsqlProperties.setProperty(hsqldb_script_format, 3);
            }
            hsqlProperties.setProperty(hsqldb_version, "2.7.0");
            hsqlProperties.setProperty(tx_timestamp, Long.toString(this.database.logger.getFilesTimestamp()));
            hsqlProperties.setProperty(hsqldb_modified, this.getProperty(hsqldb_modified));
            hsqlProperties.save(this.fileName + ".properties.new");
            this.fa.renameElementOrCopy(this.fileName + ".properties.new", this.fileName + ".properties", this.database.logger);
        }
        catch (Throwable throwable) {
            this.database.logger.logSevereEvent("save failed", throwable);
            throw Error.error(throwable, 452, 27, new String[]{throwable.toString(), this.fileName});
        }
    }

    void filterLoadedProperties() {
        String string = this.stringProps.getProperty(sql_enforce_strict_size);
        if (string != null) {
            this.stringProps.setProperty(sql_enforce_size, string);
        }
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            boolean bl = dbMeta.containsKey(string2);
            if (bl) continue;
            this.stringProps.remove(string2);
        }
    }

    public void setURLProperties(HsqlProperties hsqlProperties) {
        Object object;
        String string;
        boolean bl = false;
        if (hsqlProperties == null) {
            return;
        }
        String string2 = hsqlProperties.getProperty(sql_enforce_strict_size);
        if (string2 != null) {
            hsqlProperties.setProperty(sql_enforce_size, string2);
            hsqlProperties.removeProperty(sql_enforce_strict_size);
        }
        bl = hsqlProperties.isPropertyTrue(url_check_props, false);
        Enumeration enumeration = hsqlProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = hsqlProperties.getProperty(string);
            boolean bl2 = false;
            boolean bl3 = false;
            String string3 = null;
            HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
            if (propertyMeta != null && (propertyMeta.propType == 2 || propertyMeta.propType == 3)) {
                bl2 = true;
                string3 = HsqlDatabaseProperties.validateProperty(string, (String)object, propertyMeta);
                boolean bl4 = bl3 = string3 == null;
            }
            if (!string.startsWith("sql.") && !string.startsWith("hsqldb.") && !string.startsWith("textdb.")) continue;
            if (bl && !bl2) {
                throw Error.error(5555, string);
            }
            if (!bl || bl3) continue;
            throw Error.error(5556, string3);
        }
        enumeration = hsqlProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = dbMeta.get(string);
            if (object == null || ((HsqlProperties.PropertyMeta)object).propType != 2 && ((HsqlProperties.PropertyMeta)object).propType != 3) continue;
            this.setDatabaseProperty(string, hsqlProperties.getProperty(string));
        }
    }

    public static Iterator<HsqlProperties.PropertyMeta> getUserDefinedProperties() {
        return new Iterator(){
            Iterator<HsqlProperties.PropertyMeta> it = dbMeta.values().iterator();
            HsqlProperties.PropertyMeta current;
            boolean b = this.filterToNext();

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            public Object next() {
                HsqlProperties.PropertyMeta propertyMeta = this.current;
                this.filterToNext();
                return propertyMeta;
            }

            @Override
            public int nextInt() {
                return 0;
            }

            @Override
            public long nextLong() {
                return 0L;
            }

            @Override
            public void remove() {
            }

            private boolean filterToNext() {
                while (this.it.hasNext()) {
                    this.current = this.it.next();
                    if (excludedMeta.contains(this.current.propName)) continue;
                    return true;
                }
                this.current = null;
                return false;
            }
        };
    }

    public boolean setDatabaseProperty(String string, String string2) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        String string3 = HsqlDatabaseProperties.validateProperty(string, string2, propertyMeta);
        if (string3 != null) {
            return false;
        }
        this.stringProps.put(string, string2);
        return true;
    }

    public int getDefaultWriteDelay() {
        return 500;
    }

    public void setDBModified(int n) {
        String string;
        switch (n) {
            case 0: {
                string = MODIFIED_NO;
                break;
            }
            case 1: {
                string = MODIFIED_YES;
                break;
            }
            case 2: {
                string = MODIFIED_YES_NEW;
                break;
            }
            case 3: {
                string = MODIFIED_YES_NEW_DATA;
                break;
            }
            default: {
                throw Error.runtimeError(201, "HsqlDatabaseProperties");
            }
        }
        this.stringProps.put(hsqldb_modified, string);
        this.save();
    }

    public int getDBModified() {
        String string = this.getStringProperty(hsqldb_modified);
        if (MODIFIED_YES.equals(string)) {
            return 1;
        }
        if (MODIFIED_YES_NEW.equals(string)) {
            return 2;
        }
        if (MODIFIED_YES_NEW_DATA.equals(string)) {
            return 3;
        }
        if (MODIFIED_NO_NEW.equals(string)) {
            return 4;
        }
        return 0;
    }

    @Override
    public String getProperty(String string) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            throw Error.error(5555, string);
        }
        return this.stringProps.getProperty(string);
    }

    @Override
    public boolean isPropertyTrue(String string) {
        boolean bl;
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            throw Error.error(5555, string);
        }
        Boolean bl2 = (Boolean)propertyMeta.propDefaultValue;
        String string2 = null;
        boolean bl3 = bl = propertyMeta.propType == 0;
        if (bl) {
            try {
                string2 = System.getProperty(string);
            }
            catch (SecurityException securityException) {}
        } else {
            string2 = this.stringProps.getProperty(string);
        }
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static String getStringPropertyDefault(String string) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            throw Error.error(5555, string);
        }
        return (String)propertyMeta.propDefaultValue;
    }

    public String getStringProperty(String string) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            throw Error.error(5555, string);
        }
        String string2 = (String)propertyMeta.propDefaultValue;
        String string3 = this.stringProps.getProperty(string);
        if (string3 != null) {
            string2 = string3;
        }
        return string2;
    }

    public int getIntegerProperty(String string) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            throw Error.error(5555, string);
        }
        int n = (Integer)propertyMeta.propDefaultValue;
        String string2 = this.stringProps.getProperty(string);
        if (string2 != null) {
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public static HsqlProperties.PropertyMeta getMeta(String string) {
        return dbMeta.get(string);
    }

    public static int getIntegerPropertyDefault(String string) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            throw Error.error(5555, string);
        }
        int n = (Integer)propertyMeta.propDefaultValue;
        return n;
    }

    public static int getPropertyWithinRange(String string, int n) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            return n;
        }
        if (propertyMeta.propClass.equals("Integer")) {
            int[] nArray;
            if (propertyMeta.propIsRange) {
                int n2 = propertyMeta.propRangeLow;
                int n3 = propertyMeta.propRangeHigh;
                if (n < n2) {
                    return n2;
                }
                if (n3 < n) {
                    return n3;
                }
            }
            if (propertyMeta.propValues != null && ArrayUtil.find(nArray = propertyMeta.propValues, n) == -1) {
                return nArray[0];
            }
        }
        return n;
    }

    public static boolean validateProperty(String string, int n) {
        HsqlProperties.PropertyMeta propertyMeta = dbMeta.get(string);
        if (propertyMeta == null) {
            return false;
        }
        if (propertyMeta.propClass.equals("Integer")) {
            int[] nArray;
            if (propertyMeta.propIsRange) {
                int n2 = propertyMeta.propRangeLow;
                int n3 = propertyMeta.propRangeHigh;
                if (n < n2 || n3 < n) {
                    return false;
                }
            }
            return propertyMeta.propValues == null || ArrayUtil.find(nArray = propertyMeta.propValues, n) != -1;
        }
        return false;
    }

    public static Iterator<HsqlProperties.PropertyMeta> getUrlUserConnectionProperties() {
        return urlUserConnMeta.values().iterator();
    }

    public String getClientPropertiesAsString() {
        if (this.isPropertyTrue(jdbc_translate_tti_types)) {
            StringBuilder stringBuilder = new StringBuilder(jdbc_translate_tti_types);
            stringBuilder.append('=').append(true);
            return stringBuilder.toString();
        }
        return "";
    }

    public boolean isVersion18() {
        String string = this.getProperty(hsqldb_cache_version, "2.7.0");
        return string.substring(0, 4).equals("1.7.");
    }

    static {
        try {
            String[] stringArray;
            methodClassNames = System.getProperty(hsqldb_method_class_names);
            if (methodClassNames != null) {
                accessibleJavaMethodNames = new HashSet();
                stringArray = StringUtil.split(methodClassNames, ";");
                for (int i = 0; i < stringArray.length; ++i) {
                    accessibleJavaMethodNames.add(stringArray[i]);
                }
            }
            if ((stringArray = System.getProperty(textdb_allow_full_path)) != null && Boolean.valueOf((String)stringArray).booleanValue()) {
                allowFullPath = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        dbMeta = new HashMap(128);
        textMeta = new HashMap(16);
        excludedMeta = new HashSet();
        urlUserConnMeta = new HashMap();
        excludedMeta.add(hsqldb_min_reuse);
        excludedMeta.add(hsqldb_cache_version);
        excludedMeta.add(runtime_gc_interval);
        excludedMeta.add(hsqldb_inc_backup);
        excludedMeta.add(tx_timestamp);
        excludedMeta.add(hsqldb_version);
        excludedMeta.add(hsqldb_modified);
        excludedMeta.add(hsqldb_full_log_replay);
        excludedMeta.add(sql_compare_in_locale);
        urlUserConnMeta.put(url_default_schema, HsqlDatabaseProperties.newMeta(url_default_schema, 4, false));
        urlUserConnMeta.put(url_check_props, HsqlDatabaseProperties.newMeta(url_check_props, 4, false));
        urlUserConnMeta.put(url_get_column_name, HsqlDatabaseProperties.newMeta(url_get_column_name, 4, true));
        urlUserConnMeta.put(url_close_result, HsqlDatabaseProperties.newMeta(url_close_result, 4, false));
        urlUserConnMeta.put(url_allow_empty_batch, HsqlDatabaseProperties.newMeta(url_allow_empty_batch, 4, false));
        urlUserConnMeta.put(url_memory_lobs, HsqlDatabaseProperties.newMeta(url_memory_lobs, 4, false));
        textMeta.put(textdb_allow_full_path, HsqlDatabaseProperties.newMeta(textdb_allow_full_path, 0, true));
        textMeta.put(textdb_quoted, HsqlDatabaseProperties.newMeta(textdb_quoted, 3, true));
        textMeta.put(textdb_all_quoted, HsqlDatabaseProperties.newMeta(textdb_all_quoted, 3, false));
        textMeta.put(textdb_ignore_first, HsqlDatabaseProperties.newMeta(textdb_ignore_first, 3, false));
        textMeta.put(textdb_null_def, HsqlDatabaseProperties.newMeta(textdb_null_def, 3, false));
        textMeta.put(textdb_fs, HsqlDatabaseProperties.newMeta(textdb_fs, 3, ","));
        textMeta.put(textdb_vs, HsqlDatabaseProperties.newMeta(textdb_vs, 3, null));
        textMeta.put(textdb_lvs, HsqlDatabaseProperties.newMeta(textdb_lvs, 3, null));
        textMeta.put(textdb_qc, HsqlDatabaseProperties.newMeta(textdb_qc, 3, "\""));
        textMeta.put(textdb_encoding, HsqlDatabaseProperties.newMeta(textdb_encoding, 3, "ISO-8859-1"));
        textMeta.put(textdb_cache_scale, HsqlDatabaseProperties.newMeta(textdb_cache_scale, 2, 10, 8, 16));
        textMeta.put(textdb_cache_size_scale, HsqlDatabaseProperties.newMeta(textdb_cache_size_scale, 2, 10, 6, 20));
        textMeta.put(textdb_cache_rows, HsqlDatabaseProperties.newMeta(textdb_cache_rows, 2, 1000, 100, 1000000));
        textMeta.put(textdb_cache_size, HsqlDatabaseProperties.newMeta(textdb_cache_size, 2, 100, 10, 1000000));
        dbMeta.putAll(textMeta);
        dbMeta.put(hsqldb_method_class_names, HsqlDatabaseProperties.newMeta(hsqldb_method_class_names, 0, ""));
        dbMeta.put(hsqldb_reconfig_logging, HsqlDatabaseProperties.newMeta(hsqldb_reconfig_logging, 0, false));
        dbMeta.put(hsqldb_version, HsqlDatabaseProperties.newMeta(hsqldb_version, 1, null));
        dbMeta.put(hsqldb_modified, HsqlDatabaseProperties.newMeta(hsqldb_modified, 1, null));
        dbMeta.put(hsqldb_cache_version, HsqlDatabaseProperties.newMeta(hsqldb_cache_version, 1, null));
        dbMeta.put(hsqldb_readonly, HsqlDatabaseProperties.newMeta(hsqldb_readonly, 1, false));
        dbMeta.put(hsqldb_files_readonly, HsqlDatabaseProperties.newMeta(hsqldb_files_readonly, 1, false));
        dbMeta.put(hsqldb_tx, HsqlDatabaseProperties.newMeta(hsqldb_tx, 3, "LOCKS"));
        dbMeta.put(hsqldb_tx_level, HsqlDatabaseProperties.newMeta(hsqldb_tx_level, 3, "READ_COMMITTED"));
        dbMeta.put(hsqldb_temp_directory, HsqlDatabaseProperties.newMeta(hsqldb_temp_directory, 2, null));
        dbMeta.put(hsqldb_default_table_type, HsqlDatabaseProperties.newMeta(hsqldb_default_table_type, 3, "MEMORY"));
        dbMeta.put(hsqldb_digest, HsqlDatabaseProperties.newMeta(hsqldb_digest, 2, "MD5"));
        dbMeta.put(sql_live_object, HsqlDatabaseProperties.newMeta(sql_live_object, 2, false));
        dbMeta.put(tx_timestamp, HsqlDatabaseProperties.newMeta(tx_timestamp, 2, 0L));
        dbMeta.put(hsqldb_tx_conflict_rollback, HsqlDatabaseProperties.newMeta(hsqldb_tx_conflict_rollback, 3, true));
        dbMeta.put(hsqldb_tx_interrupt_rollback, HsqlDatabaseProperties.newMeta(hsqldb_tx_interrupt_rollback, 3, false));
        dbMeta.put(jdbc_translate_tti_types, HsqlDatabaseProperties.newMeta(jdbc_translate_tti_types, 3, true));
        dbMeta.put(hsqldb_inc_backup, HsqlDatabaseProperties.newMeta(hsqldb_inc_backup, 2, true));
        dbMeta.put(hsqldb_lock_file, HsqlDatabaseProperties.newMeta(hsqldb_lock_file, 2, true));
        dbMeta.put(hsqldb_log_data, HsqlDatabaseProperties.newMeta(hsqldb_log_data, 2, true));
        dbMeta.put(hsqldb_nio_data_file, HsqlDatabaseProperties.newMeta(hsqldb_nio_data_file, 2, true));
        dbMeta.put(hsqldb_full_log_replay, HsqlDatabaseProperties.newMeta(hsqldb_full_log_replay, 2, false));
        dbMeta.put(hsqldb_write_delay, HsqlDatabaseProperties.newMeta(hsqldb_write_delay, 2, true));
        dbMeta.put(hsqldb_large_data, HsqlDatabaseProperties.newMeta(hsqldb_large_data, 2, false));
        dbMeta.put(sql_ref_integrity, HsqlDatabaseProperties.newMeta(sql_ref_integrity, 3, true));
        dbMeta.put(sql_restrict_exec, HsqlDatabaseProperties.newMeta(sql_restrict_exec, 3, false));
        dbMeta.put(sql_enforce_names, HsqlDatabaseProperties.newMeta(sql_enforce_names, 3, false));
        dbMeta.put(sql_regular_names, HsqlDatabaseProperties.newMeta(sql_regular_names, 3, true));
        dbMeta.put(sql_enforce_refs, HsqlDatabaseProperties.newMeta(sql_enforce_refs, 3, false));
        dbMeta.put(sql_enforce_size, HsqlDatabaseProperties.newMeta(sql_enforce_size, 3, true));
        dbMeta.put(sql_enforce_types, HsqlDatabaseProperties.newMeta(sql_enforce_types, 3, false));
        dbMeta.put(sql_enforce_tdcd, HsqlDatabaseProperties.newMeta(sql_enforce_tdcd, 3, true));
        dbMeta.put(sql_enforce_tdcu, HsqlDatabaseProperties.newMeta(sql_enforce_tdcu, 3, true));
        dbMeta.put(sql_char_literal, HsqlDatabaseProperties.newMeta(sql_char_literal, 3, true));
        dbMeta.put(sql_concat_nulls, HsqlDatabaseProperties.newMeta(sql_concat_nulls, 3, true));
        dbMeta.put(sql_nulls_first, HsqlDatabaseProperties.newMeta(sql_nulls_first, 3, true));
        dbMeta.put(sql_nulls_order, HsqlDatabaseProperties.newMeta(sql_nulls_order, 3, true));
        dbMeta.put(sql_unique_nulls, HsqlDatabaseProperties.newMeta(sql_unique_nulls, 3, true));
        dbMeta.put(sql_convert_trunc, HsqlDatabaseProperties.newMeta(sql_convert_trunc, 3, true));
        dbMeta.put(sql_trunc_trailing, HsqlDatabaseProperties.newMeta(sql_trunc_trailing, 3, true));
        dbMeta.put(sql_avg_scale, HsqlDatabaseProperties.newMeta(sql_avg_scale, 3, 0, 0, 10));
        dbMeta.put(sql_max_recursive, HsqlDatabaseProperties.newMeta(sql_max_recursive, 3, 256, 16, 0x40000000));
        dbMeta.put(sql_double_nan, HsqlDatabaseProperties.newMeta(sql_double_nan, 3, true));
        dbMeta.put(sql_syntax_db2, HsqlDatabaseProperties.newMeta(sql_syntax_db2, 3, false));
        dbMeta.put(sql_syntax_mss, HsqlDatabaseProperties.newMeta(sql_syntax_mss, 3, false));
        dbMeta.put(sql_syntax_mys, HsqlDatabaseProperties.newMeta(sql_syntax_mys, 3, false));
        dbMeta.put(sql_syntax_ora, HsqlDatabaseProperties.newMeta(sql_syntax_ora, 3, false));
        dbMeta.put(sql_syntax_pgs, HsqlDatabaseProperties.newMeta(sql_syntax_pgs, 3, false));
        dbMeta.put(sql_compare_in_locale, HsqlDatabaseProperties.newMeta(sql_compare_in_locale, 3, false));
        dbMeta.put(sql_longvar_is_lob, HsqlDatabaseProperties.newMeta(sql_longvar_is_lob, 3, false));
        dbMeta.put(sql_default_collation, HsqlDatabaseProperties.newMeta(sql_default_collation, 3, Collation.defaultCollationName));
        dbMeta.put(sql_pad_space, HsqlDatabaseProperties.newMeta(sql_pad_space, 3, true));
        dbMeta.put(sql_ignore_case, HsqlDatabaseProperties.newMeta(sql_ignore_case, 3, false));
        dbMeta.put(sql_sys_index_names, HsqlDatabaseProperties.newMeta(sql_sys_index_names, 3, true));
        dbMeta.put(sql_lowercase_ident, HsqlDatabaseProperties.newMeta(sql_lowercase_ident, 3, false));
        dbMeta.put(hsqldb_files_space, HsqlDatabaseProperties.newMeta(hsqldb_files_space, 2, false));
        dbMeta.put(hsqldb_write_delay_millis, HsqlDatabaseProperties.newMeta(hsqldb_write_delay_millis, 2, 500, 0, 10000));
        dbMeta.put(hsqldb_applog, HsqlDatabaseProperties.newMeta(hsqldb_applog, 2, 0, 0, 4));
        dbMeta.put(hsqldb_extlog, HsqlDatabaseProperties.newMeta(hsqldb_extlog, 2, 0, 0, 4));
        dbMeta.put(hsqldb_sqllog, HsqlDatabaseProperties.newMeta(hsqldb_sqllog, 2, 0, 0, 4));
        dbMeta.put(hsqldb_script_format, HsqlDatabaseProperties.newMeta(hsqldb_script_format, 2, 0, new int[]{0, 1, 3}));
        dbMeta.put(hsqldb_lob_file_scale, HsqlDatabaseProperties.newMeta(hsqldb_lob_file_scale, 2, 32, new int[]{1, 2, 4, 8, 16, 32}));
        dbMeta.put(hsqldb_lob_file_compressed, HsqlDatabaseProperties.newMeta(hsqldb_lob_file_compressed, 2, false));
        dbMeta.put(hsqldb_cache_file_scale, HsqlDatabaseProperties.newMeta(hsqldb_cache_file_scale, 2, 32, new int[]{1, 8, 16, 32, 64, 128, 256, 512, 1024}));
        dbMeta.put(hsqldb_log_size, HsqlDatabaseProperties.newMeta(hsqldb_log_size, 2, 50, 0, 4096));
        dbMeta.put(hsqldb_defrag_limit, HsqlDatabaseProperties.newMeta(hsqldb_defrag_limit, 2, 0, 0, 100));
        dbMeta.put(runtime_gc_interval, HsqlDatabaseProperties.newMeta(runtime_gc_interval, 2, 0, 0, 1000000));
        dbMeta.put(hsqldb_cache_size, HsqlDatabaseProperties.newMeta(hsqldb_cache_size, 2, 10000, 100, 0x400000));
        dbMeta.put(hsqldb_cache_rows, HsqlDatabaseProperties.newMeta(hsqldb_cache_rows, 2, 50000, 100, 0x400000));
        dbMeta.put(hsqldb_cache_free_count, HsqlDatabaseProperties.newMeta(hsqldb_cache_free_count, 2, 512, 0, 4096));
        dbMeta.put(hsqldb_result_max_memory_rows, HsqlDatabaseProperties.newMeta(hsqldb_result_max_memory_rows, 2, 0, 0, 0x400000));
        dbMeta.put(hsqldb_nio_max_size, HsqlDatabaseProperties.newMeta(hsqldb_nio_max_size, 2, 256, 64, 262144));
        dbMeta.put(hsqldb_min_reuse, HsqlDatabaseProperties.newMeta(hsqldb_min_reuse, 2, 0, 0, 0x100000));
    }
}

