/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl;

import java.io.IOException;
import java.net.URL;
import nl.b3p.topnl.TopNLType;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class TopNLTypeFactory {
    private static final String TOP250NLNAMESPACE = "http://register.geostandaarden.nl/gmlapplicatieschema/top250nl/1.2.1";
    private static final String TOP100NLNAMESPACE = "http://register.geostandaarden.nl/gmlapplicatieschema/top100nl/1.1.0";
    private static final String TOP50NLNAMESPACE = "http://register.geostandaarden.nl/gmlapplicatieschema/top50nl/1.1.1";
    private static final String TOP10NLNAMESPACE = "http://register.geostandaarden.nl/gmlapplicatieschema/top10nl/1.2.0";

    public static TopNLType getTopNLType(URL is) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", true);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setExpandEntities(false);
        Document inputXml = saxBuilder.build(is);
        return TopNLTypeFactory.getTopNLType(inputXml);
    }

    public static TopNLType getTopNLType(String is) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", true);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setExpandEntities(false);
        Document inputXml = saxBuilder.build(is);
        return TopNLTypeFactory.getTopNLType(inputXml);
    }

    private static TopNLType getTopNLType(Document inputXml) {
        String currentNamespace;
        if (!inputXml.hasRootElement()) {
            throw new IllegalArgumentException("Document contains no root element");
        }
        Element rootElem = inputXml.getRootElement();
        switch (currentNamespace = rootElem.getNamespace().getURI()) {
            case "http://register.geostandaarden.nl/gmlapplicatieschema/top250nl/1.2.1": {
                return TopNLType.TOP250NL;
            }
            case "http://register.geostandaarden.nl/gmlapplicatieschema/top100nl/1.1.0": {
                return TopNLType.TOP100NL;
            }
            case "http://register.geostandaarden.nl/gmlapplicatieschema/top50nl/1.1.1": {
                return TopNLType.TOP50NL;
            }
            case "http://register.geostandaarden.nl/gmlapplicatieschema/top10nl/1.2.0": {
                return TopNLType.TOP10NL;
            }
        }
        throw new IllegalArgumentException("Type not recognized: " + currentNamespace);
    }
}

