/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.map.ValuePool;

public class HsqlProperties {
    public static final int ANY_ERROR = 0;
    public static final int NO_VALUE_FOR_KEY = 1;
    protected String fileName;
    protected String fileExtension = "";
    protected Properties stringProps;
    protected int[] errorCodes = ValuePool.emptyIntArray;
    protected String[] errorKeys = ValuePool.emptyStringArray;
    protected FileAccess fa;

    public HsqlProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public HsqlProperties(String string) {
        this(string, ".properties");
    }

    public HsqlProperties(String string, String string2) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.fileExtension = string2;
        this.fa = FileUtil.getFileUtil();
    }

    public HsqlProperties(String string, FileAccess fileAccess, boolean bl) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.fileExtension = ".properties";
        this.fa = fileAccess;
    }

    public HsqlProperties(Properties properties) {
        this.stringProps = properties;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String setProperty(String string, int n) {
        return this.setProperty(string, Integer.toString(n));
    }

    public String setProperty(String string, boolean bl) {
        return this.setProperty(string, String.valueOf(bl));
    }

    public String setProperty(String string, String string2) {
        return (String)this.stringProps.put(string, string2);
    }

    public String setPropertyIfNotExists(String string, String string2) {
        string2 = this.getProperty(string, string2);
        return this.setProperty(string, string2);
    }

    public Properties getProperties() {
        return this.stringProps;
    }

    public String getProperty(String string) {
        return this.stringProps.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.stringProps.getProperty(string, string2);
    }

    public int getIntegerProperty(String string, int n) {
        return HsqlProperties.getIntegerProperty(this.stringProps, string, n);
    }

    public static int getIntegerProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        try {
            if (string2 != null) {
                string2 = string2.trim();
                n = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl) {
        String string2 = this.stringProps.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        string2 = string2.trim();
        return string2.toLowerCase().equals("true");
    }

    public void removeProperty(String string) {
        this.stringProps.remove(string);
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.stringProps.put(string, string2);
        }
    }

    public void addProperties(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        this.addProperties(hsqlProperties.stringProps);
    }

    public boolean propertiesFileExists() {
        if (this.fileName == null) {
            return false;
        }
        String string = this.fileName + this.fileExtension;
        return this.fa.isStreamElement(string);
    }

    public boolean load() throws Exception {
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new FileNotFoundException(Error.getMessage(28));
        }
        if (!this.propertiesFileExists()) {
            return false;
        }
        String string = this.fileName + this.fileExtension;
        try (InputStream inputStream = null;){
            inputStream = this.fa.openInputStreamElement(string);
            this.stringProps.load(inputStream);
        }
        return true;
    }

    public void save() throws Exception {
        if (this.fileName == null || this.fileName.isEmpty()) {
            throw new FileNotFoundException(Error.getMessage(28));
        }
        String string = this.fileName + this.fileExtension;
        this.save(string);
    }

    public void save(String string) throws Exception {
        this.fa.createParentDirs(string);
        this.fa.removeElement(string);
        OutputStream outputStream = this.fa.openOutputStreamElement(string);
        FileAccess.FileSync fileSync = this.fa.getFileSync(outputStream);
        String string2 = "HSQL Database Engine 2.7.0";
        this.stringProps.store(outputStream, string2);
        outputStream.flush();
        fileSync.sync();
        outputStream.close();
        fileSync = null;
        outputStream = null;
    }

    protected void addError(int n, String string) {
        this.errorCodes = (int[])ArrayUtil.resizeArray(this.errorCodes, this.errorCodes.length + 1);
        this.errorKeys = (String[])ArrayUtil.resizeArray(this.errorKeys, this.errorKeys.length + 1);
        this.errorCodes[this.errorCodes.length - 1] = n;
        this.errorKeys[this.errorKeys.length - 1] = string;
    }

    public static HsqlProperties argArrayToProps(String[] stringArray, String string) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            if (string3.equals("--help") || string3.equals("-help")) {
                hsqlProperties.addError(1, string3.substring(1));
                continue;
            }
            if (string3.startsWith("--")) {
                string2 = i + 1 < stringArray.length ? stringArray[i + 1] : "";
                hsqlProperties.setProperty(string + "." + string3.substring(2), string2);
                ++i;
                continue;
            }
            if (string3.charAt(0) != '-') continue;
            string2 = i + 1 < stringArray.length ? stringArray[i + 1] : "";
            hsqlProperties.setProperty(string + "." + string3.substring(1), string2);
            ++i;
        }
        return hsqlProperties;
    }

    public static HsqlProperties delimitedArgPairsToProps(String string, String string2, String string3, String string4) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if ((n3 = string.indexOf(string3, n)) == -1) {
                n3 = string.length();
            }
            if ((n2 = string.substring(0, n3).indexOf(string2, n)) == -1) {
                hsqlProperties.addError(1, string.substring(n, n3).trim());
            } else {
                Object object = string.substring(n, n2).trim();
                String string5 = string.substring(n2 + string2.length(), n3).trim();
                if (string4 != null) {
                    object = string4 + "." + (String)object;
                }
                hsqlProperties.setProperty((String)object, string5);
            }
            if (n3 == string.length()) break;
            n = n3 + string3.length();
        }
        return hsqlProperties;
    }

    public Enumeration propertyNames() {
        return this.stringProps.propertyNames();
    }

    public boolean isEmpty() {
        return this.stringProps.isEmpty();
    }

    public String[] getErrorKeys() {
        return this.errorKeys;
    }

    public void validate() {
    }

    public static PropertyMeta newMeta(String string, int n, long l) {
        PropertyMeta propertyMeta = new PropertyMeta();
        propertyMeta.propName = string;
        propertyMeta.propType = n;
        propertyMeta.propClass = "Long";
        propertyMeta.propDefaultValue = l;
        return propertyMeta;
    }

    public static PropertyMeta newMeta(String string, int n, String string2) {
        PropertyMeta propertyMeta = new PropertyMeta();
        propertyMeta.propName = string;
        propertyMeta.propType = n;
        propertyMeta.propClass = "String";
        propertyMeta.propDefaultValue = string2;
        return propertyMeta;
    }

    public static PropertyMeta newMeta(String string, int n, boolean bl) {
        PropertyMeta propertyMeta = new PropertyMeta();
        propertyMeta.propName = string;
        propertyMeta.propType = n;
        propertyMeta.propClass = "Boolean";
        propertyMeta.propDefaultValue = bl ? Boolean.TRUE : Boolean.FALSE;
        return propertyMeta;
    }

    public static PropertyMeta newMeta(String string, int n, int n2, int[] nArray) {
        PropertyMeta propertyMeta = new PropertyMeta();
        propertyMeta.propName = string;
        propertyMeta.propType = n;
        propertyMeta.propClass = "Integer";
        propertyMeta.propDefaultValue = ValuePool.getInt(n2);
        propertyMeta.propValues = nArray;
        return propertyMeta;
    }

    public static PropertyMeta newMeta(String string, int n, int n2, int n3, int n4) {
        PropertyMeta propertyMeta = new PropertyMeta();
        propertyMeta.propName = string;
        propertyMeta.propType = n;
        propertyMeta.propClass = "Integer";
        propertyMeta.propDefaultValue = ValuePool.getInt(n2);
        propertyMeta.propIsRange = true;
        propertyMeta.propRangeLow = n3;
        propertyMeta.propRangeHigh = n4;
        return propertyMeta;
    }

    public static String validateProperty(String string, String string2, PropertyMeta propertyMeta) {
        if (propertyMeta.propClass.equals("Boolean")) {
            if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("false")) {
                return null;
            }
            return "invalid boolean value for property: " + string;
        }
        if (propertyMeta.propClass.equals("String")) {
            return null;
        }
        if (propertyMeta.propClass.equals("Long")) {
            return null;
        }
        if (propertyMeta.propClass.equals("Integer")) {
            try {
                int[] nArray;
                int n = Integer.parseInt(string2);
                if (propertyMeta.propIsRange) {
                    int n2 = propertyMeta.propRangeLow;
                    int n3 = propertyMeta.propRangeHigh;
                    if (n < n2 || n3 < n) {
                        return "value outside range for property: " + string;
                    }
                }
                if (propertyMeta.propValues != null && ArrayUtil.find(nArray = propertyMeta.propValues, n) == -1) {
                    return "value not supported for property: " + string;
                }
            }
            catch (NumberFormatException numberFormatException) {
                return "invalid integer value for property: " + string;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        int n = this.stringProps.size();
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        ArrayList<?> arrayList = Collections.list(enumeration);
        Collections.sort(arrayList);
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            stringBuilder.append(string);
            stringBuilder.append('=');
            stringBuilder.append('\"');
            stringBuilder.append(this.stringProps.get(string));
            stringBuilder.append('\"');
            if (i + 1 >= n) continue;
            stringBuilder.append(',');
            stringBuilder.append(' ');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static class PropertyMeta {
        public String propName;
        public int propType;
        public String propClass;
        public boolean propIsRange;
        public Object propDefaultValue;
        public int propRangeLow;
        public int propRangeHigh;
        public int[] propValues;
    }
}

