/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class RsgbWOZTransformer
extends RsgbTransformer {
    private static final Log LOG = LogFactory.getLog(RsgbWOZTransformer.class);
    private static final String STUF_GEEN_WAARDE = "geenWaarde";
    private final StagingProxy staging;

    public RsgbWOZTransformer(String pathToXsl, StagingProxy staging) throws TransformerConfigurationException, ParserConfigurationException {
        super(pathToXsl);
        this.staging = staging;
    }

    protected static Document merge(String oldFile, String newFile) throws XPathExpressionException, ParserConfigurationException, IOException, SAXException {
        XPathExpression expression = XPathFactory.newInstance().newXPath().compile("/root/data");
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setExpandEntityReferences(false);
        docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        docBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        docBuilderFactory.setIgnoringElementContentWhitespace(true);
        docBuilderFactory.setNamespaceAware(false);
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        Document base = docBuilder.parse(new InputSource(new StringReader(oldFile)));
        Element old = (Element)expression.evaluate(base, XPathConstants.NODE);
        if (old == null) {
            throw new IOException(oldFile + ": expression does not evaluate to node");
        }
        Document merge = docBuilder.parse(new InputSource(new StringReader(newFile)));
        Node newNode = (Node)expression.evaluate(merge, XPathConstants.NODE);
        RsgbWOZTransformer.merge(base, newNode, old, true);
        return base;
    }

    private static void merge(Document base, Node newNode, Element old, boolean first) {
        while (newNode.hasChildNodes()) {
            Node newChild = newNode.getFirstChild();
            newNode.removeChild(newChild);
            String name = newChild.getNodeName();
            NodeList nl = old.getElementsByTagName(name);
            if ("comfort".equalsIgnoreCase(name)) {
                RsgbWOZTransformer.merge(base, newChild, old, true);
            }
            if (nl.getLength() == 0) {
                newChild = base.importNode(newChild, true);
                newChild.setTextContent(newChild.getTextContent());
                old.appendChild(newChild);
                continue;
            }
            Element oldItem = (Element)nl.item(0);
            if ("geom".equalsIgnoreCase(name)) {
                newChild = base.importNode(newChild, true);
                old.removeChild(oldItem);
                old.appendChild(newChild);
                continue;
            }
            if (first) {
                RsgbWOZTransformer.merge(base, newChild, oldItem, false);
                continue;
            }
            String nieuweWaarde = newChild.getTextContent();
            if (nieuweWaarde.equals(STUF_GEEN_WAARDE)) {
                oldItem.setTextContent("");
                continue;
            }
            if (nieuweWaarde.equals("")) continue;
            oldItem.setTextContent(RsgbWOZTransformer.sanitizeValue(newChild.getTextContent()));
        }
    }

    private static String sanitizeValue(String val) {
        if (val.contains(STUF_GEEN_WAARDE)) {
            String newValue = val.replaceAll("geenWaarde ", "");
            newValue = newValue.replaceAll(STUF_GEEN_WAARDE, "");
            return newValue;
        }
        return val;
    }

    protected static String print(Document doc) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("indent", "no");
        DOMSource source = new DOMSource(doc);
        StringWriter sw = new StringWriter();
        StreamResult result = new StreamResult(sw);
        transformer.transform(source, result);
        return sw.toString();
    }

    @Override
    public String transformToDbXml(Bericht bericht) throws SAXException, IOException, TransformerException {
        String current = super.transformToDbXml(bericht);
        StringBuilder loadLog = new StringBuilder();
        LOG.debug((Object)("actuele bericht is: " + bericht));
        try {
            Bericht previousBericht = this.staging.getPreviousBericht(bericht, loadLog);
            if (previousBericht != null) {
                LOG.debug((Object)("vorige bericht is: " + previousBericht));
                String oldDBXml = previousBericht.getDbXml();
                if (null == oldDBXml) {
                    LOG.warn((Object)"Er is wel een vorige bericht, maar de DB_XML ontbreekt");
                }
                Document d = RsgbWOZTransformer.merge(oldDBXml, current);
                String mergedDBXML = RsgbWOZTransformer.print(d);
                bericht.setDbXml(mergedDBXML);
                current = mergedDBXML;
            }
        }
        catch (IOException | SQLException | ParserConfigurationException | XPathExpressionException | SAXException ex) {
            LOG.error((Object)"Vorige bericht kon niet worden opgehaald: ", (Throwable)ex);
        }
        LOG.debug((Object)loadLog);
        return current;
    }
}

