/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import org.ejml.UtilEjml;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.operation.matrix.SingularMatrixException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.util.ContentFormatException;
import org.geotools.util.LineFormat;
import org.geotools.util.SuppressFBWarnings;
import org.geotools.util.Utilities;
import org.geotools.util.XArray;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.Matrix;

public class GeneralMatrix
implements XMatrix,
Serializable {
    private static final long serialVersionUID = 8447482612423035361L;
    DMatrixRMaj mat;

    public GeneralMatrix(int size) {
        this.mat = new DMatrixRMaj(size, size);
        this.setIdentity();
    }

    public GeneralMatrix(int numRow, int numCol) {
        this.mat = new DMatrixRMaj(numRow, numCol);
        this.setIdentity();
    }

    public GeneralMatrix(int numRow, int numCol, double ... matrix) {
        this.mat = new DMatrixRMaj(numRow, numCol, true, matrix);
        if (numRow * numCol != matrix.length) {
            throw new IllegalArgumentException(String.valueOf(matrix.length));
        }
    }

    public GeneralMatrix(int numRow, int numCol, Matrix matrix) {
        this.mat = new DMatrixRMaj(numRow, numCol);
        if (matrix.getNumRow() != numRow || matrix.getNumCol() != numCol) {
            throw new IllegalArgumentException(Errors.format((int)70));
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                this.setElement(j, i, matrix.getElement(j, i));
            }
        }
    }

    public GeneralMatrix(double[][] matrix) throws IllegalArgumentException {
        this.mat = new DMatrixRMaj(matrix);
        int numRow = this.getNumRow();
        int numCol = this.getNumCol();
        for (int j = 0; j < numRow; ++j) {
            if (matrix[j].length != numCol) {
                throw new IllegalArgumentException(Errors.format((int)90));
            }
            for (int i = 0; i < numCol; ++i) {
                this.mat.set(j, i, matrix[j][i]);
            }
        }
    }

    public GeneralMatrix(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            this.mat = new DMatrixRMaj(((GeneralMatrix)matrix).mat);
        } else {
            this.mat = new DMatrixRMaj(matrix.getNumRow(), matrix.getNumCol());
            int height = this.getNumRow();
            int width = this.getNumCol();
            for (int j = 0; j < height; ++j) {
                for (int i = 0; i < width; ++i) {
                    this.mat.set(j, i, matrix.getElement(j, i));
                }
            }
        }
    }

    public GeneralMatrix(GeneralMatrix matrix) {
        this.mat = new DMatrixRMaj(matrix.mat);
    }

    public GeneralMatrix(AffineTransform transform) {
        this.mat = new DMatrixRMaj(3, 3, true, transform.getScaleX(), transform.getShearX(), transform.getTranslateX(), transform.getShearY(), transform.getScaleY(), transform.getTranslateY(), 0.0, 0.0, 1.0);
        assert (this.isAffine()) : this;
    }

    public GeneralMatrix(Envelope srcRegion, Envelope dstRegion) {
        this.mat = new DMatrixRMaj(dstRegion.getDimension() + 1, srcRegion.getDimension() + 1);
        int srcDim = srcRegion.getDimension();
        int dstDim = dstRegion.getDimension();
        int i = Math.min(srcDim, dstDim);
        while (--i >= 0) {
            double scale = dstRegion.getSpan(i) / srcRegion.getSpan(i);
            double translate = dstRegion.getMinimum(i) - srcRegion.getMinimum(i) * scale;
            this.setElement(i, i, scale);
            this.setElement(i, srcDim, translate);
        }
        this.setElement(dstDim, srcDim, 1.0);
        assert (srcDim != dstDim || this.isAffine()) : this;
    }

    public GeneralMatrix(AxisDirection[] srcAxis, AxisDirection[] dstAxis) {
        this(null, srcAxis, null, dstAxis, false);
    }

    public GeneralMatrix(Envelope srcRegion, AxisDirection[] srcAxis, Envelope dstRegion, AxisDirection[] dstAxis) {
        this(srcRegion, srcAxis, dstRegion, dstAxis, true);
    }

    private GeneralMatrix(Envelope srcRegion, AxisDirection[] srcAxis, Envelope dstRegion, AxisDirection[] dstAxis, boolean validRegions) {
        this(dstAxis.length + 1, srcAxis.length + 1);
        if (validRegions) {
            GeneralMatrix.ensureDimensionMatch("srcRegion", srcRegion, srcAxis.length);
            GeneralMatrix.ensureDimensionMatch("dstRegion", dstRegion, dstAxis.length);
        }
        this.setZero();
        for (int dstIndex = 0; dstIndex < dstAxis.length; ++dstIndex) {
            boolean hasFound = false;
            AxisDirection dstAxe = dstAxis[dstIndex];
            AxisDirection search = dstAxe.absolute();
            for (int srcIndex = 0; srcIndex < srcAxis.length; ++srcIndex) {
                AxisDirection srcAxe = srcAxis[srcIndex];
                if (!search.equals((Object)srcAxe.absolute())) continue;
                if (hasFound) {
                    throw new IllegalArgumentException(Errors.format((int)36, (Object)srcAxe.name(), (Object)dstAxe.name()));
                }
                hasFound = true;
                boolean normal = srcAxe.equals((Object)dstAxe);
                double scale = normal ? 1.0 : -1.0;
                double translate = 0.0;
                if (validRegions) {
                    translate = normal ? dstRegion.getMinimum(dstIndex) : dstRegion.getMaximum(dstIndex);
                    translate -= srcRegion.getMinimum(srcIndex) * (scale *= dstRegion.getSpan(dstIndex) / srcRegion.getSpan(srcIndex));
                }
                this.setElement(dstIndex, srcIndex, scale);
                this.setElement(dstIndex, srcAxis.length, translate);
            }
            if (hasFound) continue;
            throw new IllegalArgumentException(Errors.format((int)136, (Object)dstAxis[dstIndex].name()));
        }
        this.setElement(dstAxis.length, srcAxis.length, 1.0);
        assert (srcAxis.length != dstAxis.length || this.isAffine()) : this;
    }

    private DMatrixRMaj internal(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return ((GeneralMatrix)matrix).mat;
        }
        DMatrixRMaj a = new DMatrixRMaj(matrix.getNumRow(), matrix.getNumCol());
        for (int j = 0; j < a.numRows; ++j) {
            for (int i = 0; i < a.numCols; ++i) {
                a.set(j, i, matrix.getElement(j, i));
            }
        }
        return a;
    }

    private static void ensureDimensionMatch(String name, Envelope envelope, int dimension) throws MismatchedDimensionException {
        int dim = envelope.getDimension();
        if (dimension != dim) {
            throw new MismatchedDimensionException(Errors.format((int)94, (Object)name, (Object)dim, (Object)dimension));
        }
    }

    public static double[][] getElements(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return ((GeneralMatrix)matrix).getElements();
        }
        int numCol = matrix.getNumCol();
        double[][] rows = new double[matrix.getNumRow()][];
        for (int j = 0; j < rows.length; ++j) {
            double[] row = new double[numCol];
            rows[j] = row;
            for (int i = 0; i < row.length; ++i) {
                row[i] = matrix.getElement(j, i);
            }
        }
        return rows;
    }

    public final double[][] getElements() {
        int numCol = this.getNumCol();
        double[][] rows = new double[this.getNumRow()][];
        for (int j = 0; j < rows.length; ++j) {
            rows[j] = new double[numCol];
            this.getRow(j, rows[j]);
        }
        return rows;
    }

    @Override
    public final boolean isAffine() {
        int dimension = this.getNumRow();
        if (dimension != this.getNumCol()) {
            return false;
        }
        --dimension;
        for (int i = 0; i <= dimension; ++i) {
            if (this.getElement(dimension, i) == (double)(i == dimension ? 1 : 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void negate() {
        CommonOps_DDRM.changeSign(this.mat);
    }

    @Override
    public void negate(Matrix matrix) {
        DMatrixRMaj a = this.internal(matrix);
        CommonOps_DDRM.changeSign(a);
        this.mat = a;
    }

    @Override
    public void transpose() {
        CommonOps_DDRM.transpose(this.mat);
    }

    @Override
    public void transpose(Matrix matrix) {
        DMatrixRMaj a = this.internal(matrix);
        CommonOps_DDRM.transpose(a, this.mat);
    }

    @Override
    public void invert() {
        boolean success = CommonOps_DDRM.invert(this.mat);
        if (!success) {
            throw new SingularMatrixException("Could not invert, possible singular matrix?");
        }
    }

    @Override
    public void invert(Matrix matrix) throws SingularMatrixException {
        DMatrixRMaj a;
        if (matrix instanceof GeneralMatrix) {
            a = new DMatrixRMaj(((GeneralMatrix)matrix).mat);
        } else {
            a = new DMatrixRMaj(matrix.getNumRow(), matrix.getNumCol());
            for (int j = 0; j < this.mat.numRows; ++j) {
                for (int i = 0; i < this.mat.numCols; ++i) {
                    this.mat.set(j, i, matrix.getElement(j, i));
                }
            }
        }
        boolean success = CommonOps_DDRM.invert(a);
        if (!success) {
            throw new SingularMatrixException("Could not invert, possible singular matrix?");
        }
        this.mat = a;
    }

    @Override
    public int getNumRow() {
        return this.mat.getNumRows();
    }

    @Override
    public int getNumCol() {
        return this.mat.getNumCols();
    }

    @Override
    public double getElement(int row, int column) {
        return this.mat.get(row, column);
    }

    @Override
    public void setColumn(int column, double ... values) {
        if (values.length != this.mat.getNumCols()) {
            throw new IllegalArgumentException("Call setRow received an array of length " + values.length + ".  The dimensions of the matrix is " + this.mat.getNumRows() + " by " + this.mat.getNumCols() + ".");
        }
        for (int i = 0; i < values.length; ++i) {
            this.mat.set(i, column, values[i]);
        }
    }

    @Override
    public void setRow(int row, double ... values) {
        if (values.length != this.mat.getNumCols()) {
            throw new IllegalArgumentException("Call setRow received an array of length " + values.length + ".  The dimensions of the matrix is " + this.mat.getNumRows() + " by " + this.mat.getNumCols() + ".");
        }
        for (int i = 0; i < values.length; ++i) {
            this.mat.set(row, i, values[i]);
        }
    }

    public void setElement(int row, int column, double value) {
        this.mat.set(row, column, value);
    }

    @Override
    public void setZero() {
        this.mat.zero();
    }

    @Override
    public void setIdentity() {
        CommonOps_DDRM.setIdentity(this.mat);
    }

    public final boolean isIdentity() {
        int numCol;
        int numRow = this.getNumRow();
        if (numRow != (numCol = this.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                if (this.getElement(j, i) == (i == j ? 1.0 : 0.0)) continue;
                return false;
            }
        }
        assert (this.isAffine()) : this;
        assert (this.isIdentity(0.0)) : this;
        return true;
    }

    @Override
    public final boolean isIdentity(double tolerance) {
        return GeneralMatrix.isIdentity(this, tolerance);
    }

    static boolean isIdentity(Matrix matrix, double tolerance) {
        int numCol;
        tolerance = Math.abs(tolerance);
        int numRow = matrix.getNumRow();
        if (numRow != (numCol = matrix.getNumCol())) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                double e = matrix.getElement(j, i);
                if (i == j) {
                    e -= 1.0;
                }
                if (Math.abs(e) <= tolerance) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void multiply(Matrix matrix) {
        this.mul(matrix);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.mat == null) {
            return 31 * result;
        }
        result = 31 * result + this.mat.numRows;
        result = 31 * result + this.mat.numCols;
        for (double d : this.mat.data) {
            long bits = Double.doubleToRawLongBits(d);
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeneralMatrix other = (GeneralMatrix)obj;
        return this.equals(other, 0.0);
    }

    @Override
    public boolean equals(Matrix matrix, double tolerance) {
        return GeneralMatrix.epsilonEquals(this, matrix, tolerance);
    }

    static boolean epsilonEquals(Matrix m1, Matrix m2, double tolerance) {
        int numRow = m1.getNumRow();
        if (numRow != m2.getNumRow()) {
            return false;
        }
        int numCol = m1.getNumCol();
        if (numCol != m2.getNumCol()) {
            return false;
        }
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                double v2;
                double v1 = m1.getElement(j, i);
                if (Math.abs(v1 - (v2 = m2.getElement(j, i))) <= tolerance || Double.doubleToLongBits(v1) == Double.doubleToLongBits(v2)) continue;
                return false;
            }
        }
        return true;
    }

    public final AffineTransform toAffineTransform2D() throws IllegalStateException {
        int check = this.getNumRow();
        if (check != 3 || (check = this.getNumCol()) != 3) {
            throw new IllegalStateException(Errors.format((int)127, (Object)(check - 1)));
        }
        if (this.isAffine()) {
            return new AffineTransform(this.getElement(0, 0), this.getElement(1, 0), this.getElement(0, 1), this.getElement(1, 1), this.getElement(0, 2), this.getElement(1, 2));
        }
        throw new IllegalStateException(Errors.format((int)118));
    }

    public static GeneralMatrix load(File file) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(file));){
            GeneralMatrix generalMatrix = GeneralMatrix.load(in, Locale.US);
            return generalMatrix;
        }
    }

    public static GeneralMatrix load(BufferedReader in, Locale locale) throws IOException {
        String line;
        LineFormat parser = new LineFormat(locale);
        double[] data = null;
        double[] row = null;
        int numRow = 0;
        int numData = 0;
        while ((line = in.readLine()) != null) {
            if ((line = line.trim()).length() == 0) {
                if (numRow != 0) break;
                continue;
            }
            try {
                parser.setLine(line);
                row = parser.getValues(row);
            }
            catch (ParseException exception) {
                throw new ContentFormatException(exception.getLocalizedMessage(), (Throwable)exception);
            }
            int upper = numData + row.length;
            if (data == null) {
                data = new double[numData * numData];
            }
            if (upper > data.length) {
                data = XArray.resize((double[])data, (int)(upper * 2));
            }
            System.arraycopy(row, 0, data, numData, row.length);
            numData = upper;
            assert (numData % ++numRow == 0) : numData;
        }
        data = data != null ? XArray.resize(data, (int)numData) : new double[]{};
        return new GeneralMatrix(numRow, numData / numRow, data);
    }

    public String toString() {
        return GeneralMatrix.toString(this);
    }

    static String toString(Matrix matrix) {
        int numRow = matrix.getNumRow();
        int numCol = matrix.getNumCol();
        StringBuffer buffer = new StringBuffer();
        int columnWidth = 12;
        String lineSeparator = System.getProperty("line.separator", "\n");
        FieldPosition dummy = new FieldPosition(0);
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setGroupingUsed(false);
        format.setMinimumFractionDigits(6);
        format.setMaximumFractionDigits(6);
        for (int j = 0; j < numRow; ++j) {
            for (int i = 0; i < numCol; ++i) {
                int position = buffer.length();
                buffer = format.format(matrix.getElement(j, i), buffer, dummy);
                int spaces = Math.max(12 - (buffer.length() - position), 1);
                buffer.insert(position, Utilities.spaces((int)spaces));
            }
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public GeneralMatrix clone() {
        return new GeneralMatrix(this);
    }

    public void copySubMatrix(int rowSource, int colSource, int numRows, int numCol, int rowDest, int colDest, GeneralMatrix target) {
        int rowLimit = rowSource + numRows;
        int colLimit = colSource + numCol;
        CommonOps_DDRM.extract(this.mat, rowSource, rowLimit, colSource, colLimit, target.mat, rowDest, colDest);
    }

    @Override
    public void getColumn(int col, double[] array) {
        for (int j = 0; j < array.length; ++j) {
            array[j] = this.mat.get(j, col);
        }
    }

    @Override
    public void mul(double scalar) {
        CommonOps_DDRM.scale(scalar, this.mat);
    }

    @Override
    public void mul(double scalar, Matrix matrix) {
        DMatrixRMaj a = new DMatrixRMaj(matrix.getNumRow(), matrix.getNumCol());
        CommonOps_DDRM.scale(scalar, this.internal(matrix), a);
        this.mat = a;
    }

    @Override
    public void getRow(int row, double[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.mat.get(row, i);
        }
    }

    @Override
    public final void mul(Matrix matrix) {
        DMatrixRMaj b = this.internal(matrix);
        DMatrixRMaj ret = new DMatrixRMaj(this.mat.numRows, b.numCols);
        CommonOps_DDRM.mult(this.mat, b, ret);
        this.mat = ret;
    }

    @Override
    public void mul(Matrix matrix1, Matrix matrix2) {
        DMatrixRMaj a = this.internal(matrix1);
        DMatrixRMaj b = this.internal(matrix2);
        if (a == this.mat || b == this.mat) {
            this.mat = new DMatrixRMaj(a.numRows, b.numCols);
        } else {
            this.mat.reshape(a.numRows, b.numCols, false);
        }
        CommonOps_DDRM.mult(a, b, this.mat);
    }

    @Override
    public void sub(double scalar) {
        CommonOps_DDRM.subtract((DMatrixD1)this.mat, scalar, (DMatrixD1)this.mat);
    }

    @Override
    public void sub(double scalar, Matrix matrix) {
        DMatrixRMaj a = this.internal(matrix);
        this.mat.reshape(a.numRows, a.numCols, false);
        CommonOps_DDRM.subtract(scalar, (DMatrixD1)a, (DMatrixD1)this.mat);
    }

    @Override
    public void sub(Matrix matrix) {
        CommonOps_DDRM.subtract((DMatrixD1)this.mat, (DMatrixD1)this.internal(matrix), (DMatrixD1)this.mat);
    }

    @Override
    public void sub(Matrix matrix1, Matrix matrix2) {
        DMatrixRMaj a = this.internal(matrix1);
        DMatrixRMaj b = this.internal(matrix2);
        this.mat.reshape(a.numRows, a.numCols, false);
        CommonOps_DDRM.subtract((DMatrixD1)a, (DMatrixD1)b, (DMatrixD1)this.mat);
    }

    public void set(double[] matrix) {
        this.mat.setData(matrix);
    }

    public void setSize(int numRows, int numCols) {
        if (numRows != this.mat.numCols || numCols != this.mat.numCols) {
            DMatrixRMaj ret = new DMatrixRMaj(numRows, numCols);
            CommonOps_DDRM.extract(this.mat, 0, numRows, 0, numCols, ret, 0, 0);
            this.mat = ret;
        }
    }

    @Override
    public void add(double scalar) {
        CommonOps_DDRM.add((DMatrixD1)this.mat, scalar, (DMatrixD1)this.mat);
    }

    @Override
    public void add(double scalar, XMatrix matrix) {
        DMatrixRMaj a = this.internal(matrix);
        this.mat.reshape(a.numRows, a.numCols, false);
        CommonOps_DDRM.add((DMatrixD1)a, scalar, (DMatrixD1)this.mat);
    }

    @Override
    public void add(XMatrix matrix) {
        CommonOps_DDRM.add((DMatrixD1)this.mat, this.internal(matrix), (DMatrixD1)this.mat);
    }

    @Override
    public void add(XMatrix matrix1, XMatrix matrix2) {
        DMatrixRMaj a = this.internal(matrix1);
        DMatrixRMaj b = this.internal(matrix2);
        this.mat.reshape(a.numRows, a.numCols, false);
        CommonOps_DDRM.add((DMatrixD1)a, b, (DMatrixD1)this.mat);
    }

    @Override
    public double determinate() {
        double det = CommonOps_DDRM.det(this.mat);
        if (UtilEjml.isUncountable(det)) {
            return 0.0;
        }
        return det;
    }
}

