/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.oracle.OracleNGDataStoreFactory;

public class OracleNGOCIDataStoreFactory
extends OracleNGDataStoreFactory {
    public static final DataAccessFactory.Param ALIAS = new DataAccessFactory.Param("alias", String.class, "The alias to the oracle server, as defined in the tnsnames.ora file", true);

    @Override
    public String getDisplayName() {
        return "Oracle NG (OCI)";
    }

    @Override
    public String getDescription() {
        return "Oracle Database (OCI)";
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String alias = (String)ALIAS.lookUp(params);
        return "jdbc:oracle:oci:@" + alias;
    }

    protected void setupParameters(Map parameters) {
        parameters.put(OracleNGOCIDataStoreFactory.DBTYPE.key, new DataAccessFactory.Param(OracleNGOCIDataStoreFactory.DBTYPE.key, OracleNGOCIDataStoreFactory.DBTYPE.type, OracleNGOCIDataStoreFactory.DBTYPE.description, OracleNGOCIDataStoreFactory.DBTYPE.required, (Object)this.getDatabaseID()));
        parameters.put(OracleNGOCIDataStoreFactory.SCHEMA.key, SCHEMA);
        parameters.put(OracleNGOCIDataStoreFactory.ALIAS.key, ALIAS);
        parameters.put(OracleNGOCIDataStoreFactory.USER.key, USER);
        parameters.put(OracleNGOCIDataStoreFactory.PASSWD.key, PASSWD);
        parameters.put(OracleNGOCIDataStoreFactory.NAMESPACE.key, NAMESPACE);
        parameters.put(OracleNGOCIDataStoreFactory.MAXCONN.key, MAXCONN);
        parameters.put(OracleNGOCIDataStoreFactory.MINCONN.key, MINCONN);
        parameters.put(OracleNGOCIDataStoreFactory.FETCHSIZE.key, FETCHSIZE);
        parameters.put(OracleNGOCIDataStoreFactory.BATCH_INSERT_SIZE.key, BATCH_INSERT_SIZE);
        parameters.put(OracleNGOCIDataStoreFactory.MAXWAIT.key, MAXWAIT);
        if (this.getValidationQuery() != null) {
            parameters.put(OracleNGOCIDataStoreFactory.VALIDATECONN.key, VALIDATECONN);
        }
        parameters.put(OracleNGOCIDataStoreFactory.PK_METADATA_TABLE.key, PK_METADATA_TABLE);
        parameters.put(OracleNGDataStoreFactory.LOOSEBBOX.key, OracleNGDataStoreFactory.LOOSEBBOX);
        parameters.put(OracleNGOCIDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key, MAX_OPEN_PREPARED_STATEMENTS);
        parameters.put(OracleNGDataStoreFactory.ESTIMATED_EXTENTS.key, OracleNGDataStoreFactory.ESTIMATED_EXTENTS);
        parameters.put(OracleNGDataStoreFactory.GEOMETRY_METADATA_TABLE.key, OracleNGDataStoreFactory.GEOMETRY_METADATA_TABLE);
        parameters.put(OracleNGOCIDataStoreFactory.METADATA_BBOX.key, METADATA_BBOX);
    }
}

