/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.styling;

import java.awt.Color;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.gml.producer.FeatureTransformer;
import org.geotools.referencing.CRS;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.ContrastEnhancement;
import org.geotools.styling.Displacement;
import org.geotools.styling.Extent;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.ImageOutline;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.NamedStyle;
import org.geotools.styling.OtherText;
import org.geotools.styling.OverlapBehavior;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.Rule;
import org.geotools.styling.SelectedChannelType;
import org.geotools.styling.ShadedRelief;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.TextSymbolizer2;
import org.geotools.styling.UomOgcMapping;
import org.geotools.styling.UserLayer;
import org.geotools.util.GrowableInternationalString;
import org.geotools.util.logging.Logging;
import org.geotools.xml.filter.FilterTransformer;
import org.geotools.xml.styling.SLDParser;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.style.ContrastMethod;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.SemanticType;
import org.opengis.util.InternationalString;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SLDTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger(SLDTransformer.class);
    static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    static final Font DEFAULT_FONT = CommonFactoryFinder.getStyleFactory().getDefaultFont();
    private final Map<URI, String> uri2prefix;
    private boolean exportDefaultValues = false;

    public SLDTransformer() {
        this(null);
    }

    public SLDTransformer(Map nsBindings) {
        if (nsBindings == null || nsBindings.isEmpty()) {
            this.uri2prefix = new HashMap<URI, String>();
        } else {
            this.uri2prefix = new HashMap<URI, String>(nsBindings.size());
            int count = 0;
            Iterator iterator = nsBindings.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry o;
                Map.Entry e = o = iterator.next();
                URI uri = (URI)e.getKey();
                String prefix = (String)e.getValue();
                if (uri == null || prefix == null) continue;
                this.uri2prefix.put(uri, prefix.trim());
                ++count;
            }
            LOGGER.info("Added [" + count + "] namespace entries resulting in [" + this.uri2prefix.size() + "] distinct entries");
        }
    }

    public boolean isExportDefaultValues() {
        return this.exportDefaultValues;
    }

    public void setExportDefaultValues(boolean exportDefaultValues) {
        this.exportDefaultValues = exportDefaultValues;
    }

    @Override
    public Translator createTranslator(ContentHandler handler) {
        SLDTranslator result = new SLDTranslator(handler);
        if (!this.uri2prefix.isEmpty()) {
            for (Map.Entry<URI, String> uriStringEntry : this.uri2prefix.entrySet()) {
                Map.Entry<URI, String> e = uriStringEntry;
                URI uri = e.getKey();
                if (uri == null) continue;
                String prefix = e.getValue();
                String uriStr = String.valueOf(uri);
                result.getNamespaceSupport().declarePrefix(prefix, uriStr);
            }
        }
        result.setExportDefaultValues(this.isExportDefaultValues());
        return result;
    }

    public static final void main(String[] args) throws Exception {
        URL url = new File(args[0]).toURI().toURL();
        SLDParser s = new SLDParser(CommonFactoryFinder.getStyleFactory(null), url);
        SLDTransformer transformer = new SLDTransformer();
        transformer.setIndentation(4);
        transformer.transform((Object)s.readXML(), new FileOutputStream(System.getProperty("java.io.tmpdir") + "/junk.eraseme"));
    }

    static class SLDTranslator
    extends TransformerBase.TranslatorSupport
    implements StyleVisitor {
        FilterTransformer.FilterTranslator filterTranslator;
        private boolean exportDefaultValues = false;

        public SLDTranslator(ContentHandler handler) {
            this(handler, "sld", "http://www.opengis.net/sld");
        }

        public SLDTranslator(ContentHandler handler, String prefix, String uri) {
            super(handler, prefix, uri);
            this.filterTranslator = new FilterTransformer.FilterTranslator(handler);
            this.addNamespaceDeclarations(this.filterTranslator);
        }

        boolean isNull(Expression expr) {
            if (expr == null) {
                return true;
            }
            if (expr == Expression.NIL) {
                return true;
            }
            if (expr instanceof Literal) {
                Literal literal = (Literal)expr;
                return literal.getValue() == null;
            }
            return false;
        }

        boolean isDefault(Expression expr, Object defaultValue) {
            if (this.isExportDefaultValues()) {
                return false;
            }
            if (defaultValue == null) {
                return this.isNull(expr);
            }
            if (expr == null) {
                return false;
            }
            if (expr == Expression.NIL) {
                return false;
            }
            if (expr instanceof Literal) {
                Literal literal = (Literal)expr;
                if (defaultValue.equals(literal.getValue())) {
                    return true;
                }
                if (defaultValue.toString().equals(literal.getValue().toString())) {
                    return true;
                }
            }
            return false;
        }

        public void setExportDefaultValues(boolean exportDefaultValues) {
            this.exportDefaultValues = exportDefaultValues;
        }

        public boolean isExportDefaultValues() {
            return this.exportDefaultValues;
        }

        void element(String element, Expression expr) {
            this.element(element, expr, null);
        }

        void element(String element, InternationalString intString) {
            if (intString instanceof GrowableInternationalString) {
                GrowableInternationalString growable = (GrowableInternationalString)intString;
                if (growable.getLocales().isEmpty()) {
                    this.element(element, intString.toString());
                } else {
                    this.start(element);
                    this.chars(intString.toString());
                    for (Locale locale : growable.getLocales()) {
                        if (locale == null) continue;
                        AttributesImpl atts = new AttributesImpl();
                        atts.addAttribute("", "lang", "lang", "", locale.toString());
                        this.element("Localized", growable.toString(locale), atts);
                    }
                    this.end(element);
                }
            } else {
                this.element(element, intString.toString());
            }
        }

        void element(String element, Expression expr, Object defaultValue) {
            this.element(element, expr, defaultValue, null);
        }

        void element(String element, Expression expr, Object defaultValue, AttributesImpl atts) {
            if (expr == null || expr == Expression.NIL) {
                return;
            }
            if (expr instanceof Literal) {
                if (defaultValue != null) {
                    Object value = expr.evaluate(null, defaultValue.getClass());
                    if (value != null && (!value.equals(defaultValue) || this.isExportDefaultValues())) {
                        this.element(element, value.toString(), atts);
                    }
                } else {
                    String value = (String)expr.evaluate(null, String.class);
                    if (value != null) {
                        this.element(element, value, atts);
                    }
                }
                return;
            }
            this.start(element, atts);
            this.filterTranslator.encode(expr);
            this.end(element);
        }

        void labelContent(Expression expr) {
            if (expr instanceof Literal) {
                Literal literalLabel = (Literal)expr;
                String label = (String)literalLabel.evaluate(null, String.class);
                if (label != null) {
                    if (label.matches("^\\s+.*$|^.*\\s+$|^.*\\s{2,}.*$")) {
                        this.cdata(label);
                    } else {
                        this.chars(label);
                    }
                }
            } else if (expr instanceof Function && ("strConcat".equals(((Function)expr).getName()) || "concat".equals(((Function)expr).getName()) || "Concatenate".equals(((Function)expr).getName()))) {
                List parameters = ((Function)expr).getParameters();
                for (Expression parameter : parameters) {
                    this.labelContent(parameter);
                }
            } else {
                this.filterTranslator.encode(expr);
            }
        }

        void elementLiteral(String element, Expression e, String defaultValue) {
            if (e == null || e == Expression.NIL) {
                return;
            }
            String value = (String)e.evaluate(null, String.class);
            if (defaultValue == null || !defaultValue.equals(value)) {
                this.start(element);
                this.start(value);
                this.end(value);
                this.end(element);
            }
        }

        @Override
        public void visit(PointPlacement pp) {
            this.start("LabelPlacement");
            this.start("PointPlacement");
            if (pp.getAnchorPoint() != null) {
                pp.getAnchorPoint().accept(this);
            }
            this.visit(pp.getDisplacement());
            this.encodeValue("Rotation", null, pp.getRotation(), 0.0);
            this.end("PointPlacement");
            this.end("LabelPlacement");
        }

        @Override
        public void visit(Stroke stroke) {
            this.start("Stroke");
            if (stroke.getGraphicFill() != null) {
                this.start("GraphicFill");
                stroke.getGraphicFill().accept(this);
                this.end("GraphicFill");
            }
            if (stroke.getGraphicStroke() != null) {
                this.start("GraphicStroke");
                stroke.getGraphicStroke().accept(this);
                this.end("GraphicStroke");
            }
            this.encodeCssParam("stroke", stroke.getColor(), Color.BLACK);
            this.encodeCssParam("stroke-linecap", stroke.getLineCap(), "butt");
            this.encodeCssParam("stroke-linejoin", stroke.getLineJoin(), "miter");
            this.encodeCssParam("stroke-opacity", stroke.getOpacity(), 1.0);
            this.encodeCssParam("stroke-width", stroke.getWidth(), 1.0);
            this.encodeCssParam("stroke-dashoffset", stroke.getDashOffset(), 0.0);
            this.encodeStrokeDasharray(stroke.dashArray());
            this.end("Stroke");
        }

        private void encodeStrokeDasharray(List<Expression> expressions) {
            if (expressions == null || expressions.isEmpty()) {
                return;
            }
            boolean isLiteral = true;
            for (Expression expression : expressions) {
                if (expression instanceof Literal) continue;
                isLiteral = false;
            }
            if (isLiteral) {
                this.encodeLiteralStrokeDasharray(expressions);
            } else {
                this.encodeMixedStrokeDasharray(expressions);
            }
        }

        private void encodeLiteralStrokeDasharray(List<Expression> expressions) {
            StringBuilder literalDash = new StringBuilder();
            for (Expression expression : expressions) {
                literalDash.append(((Literal)expression).getValue()).append(" ");
            }
            literalDash.deleteCharAt(literalDash.length() - 1);
            this.encodeCssParam("stroke-dasharray", (Expression)ff.literal((Object)literalDash.toString()));
        }

        private void encodeMixedStrokeDasharray(List<Expression> expressions) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "name", "name", "", "stroke-dasharray");
            this.start("CssParameter", attributes);
            for (Expression expression : expressions) {
                this.filterTranslator.encode(expression);
            }
            this.end("CssParameter");
        }

        @Override
        public void visit(LinePlacement lp) {
            this.start("LabelPlacement");
            this.start("LinePlacement");
            this.element("PerpendicularOffset", lp.getPerpendicularOffset());
            this.end("LinePlacement");
            this.end("LabelPlacement");
        }

        @Override
        public void visit(AnchorPoint ap) {
            this.start("AnchorPoint");
            this.element("AnchorPointX", ap.getAnchorPointX());
            this.element("AnchorPointY", ap.getAnchorPointY());
            this.end("AnchorPoint");
        }

        @Override
        public void visit(TextSymbolizer text) {
            if (text == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            Unit uom = text.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get((Unit<Length>)uom).getSEString());
            }
            this.start("TextSymbolizer", atts);
            this.encodeGeometryExpression(text.getGeometry());
            if (text.getLabel() != null) {
                this.start("Label");
                this.labelContent(text.getLabel());
                this.end("Label");
            }
            if (text.fonts() != null && !text.fonts().isEmpty()) {
                List<Font> fonts = text.fonts();
                if (this.areFontsUniform(fonts)) {
                    this.start("Font");
                    Font initialFont = fonts.get(0);
                    for (Font font : fonts) {
                        this.encodeCssParam("font-family", font.getFamily().get(0));
                    }
                    this.encodeCssParam("font-size", initialFont.getSize());
                    this.encodeCssParam("font-style", initialFont.getStyle());
                    this.encodeCssParam("font-weight", initialFont.getWeight());
                    this.end("Font");
                } else {
                    for (Font font : fonts) {
                        this.start("Font");
                        this.encodeCssParam("font-family", font.getFamily().get(0));
                        this.encodeCssParam("font-size", font.getSize());
                        this.encodeCssParam("font-style", font.getStyle());
                        this.encodeCssParam("font-weight", font.getWeight());
                        this.end("Font");
                    }
                }
            }
            if (text.getLabelPlacement() != null) {
                text.getLabelPlacement().accept(this);
            }
            if (text.getHalo() != null) {
                text.getHalo().accept(this);
            }
            if (text.getFill() != null) {
                text.getFill().accept(this);
            }
            if (text instanceof TextSymbolizer2) {
                OtherText otherText;
                TextSymbolizer2 text2 = (TextSymbolizer2)text;
                if (text2.getGraphic() != null) {
                    this.visit(text2.getGraphic());
                }
                if (text2.getSnippet() != null) {
                    this.element("Snippet", text2.getSnippet());
                }
                if (text2.getFeatureDescription() != null) {
                    this.element("FeatureDescription", text2.getFeatureDescription());
                }
                if ((otherText = text2.getOtherText()) != null) {
                    AttributesImpl otherTextAtts = new AttributesImpl();
                    otherTextAtts.addAttribute("", "target", "target", "", otherText.getTarget());
                    this.element("OtherText", otherText.getText(), null, otherTextAtts);
                }
            }
            if (text.getPriority() != null) {
                this.element("Priority", text.getPriority());
            }
            if (text.getOptions() != null) {
                this.encodeVendorOptions(text.getOptions());
            }
            this.end("TextSymbolizer");
        }

        private boolean areFontsUniform(List<Font> fonts) {
            if (fonts.size() == 1) {
                return true;
            }
            Font reference = fonts.get(0);
            Expression referenceSize = reference.getSize();
            Expression referenceStyle = reference.getStyle();
            Expression referenceWeight = reference.getWeight();
            for (int i = 1; i < fonts.size(); ++i) {
                Font f = fonts.get(i);
                Expression size = f.getSize();
                if (!this.expressionEquals(referenceSize, size, DEFAULT_FONT.getSize())) {
                    return false;
                }
                Expression style = f.getStyle();
                if (!this.expressionEquals(referenceStyle, style, DEFAULT_FONT.getStyle())) {
                    return false;
                }
                Expression weight = f.getWeight();
                if (this.expressionEquals(referenceWeight, weight, DEFAULT_FONT.getWeight())) continue;
                return false;
            }
            return true;
        }

        private boolean expressionEquals(Expression reference, Expression exp, Expression defaultValue) {
            if (exp == null) {
                return reference == null || defaultValue.equals(reference);
            }
            if (reference == null) {
                return defaultValue.equals(exp);
            }
            return reference.equals(exp);
        }

        @Override
        public void visit(RasterSymbolizer raster) {
            ColorMap colorMap;
            if (raster == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            Unit uom = raster.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get((Unit<Length>)uom).getSEString());
            }
            this.start("RasterSymbolizer", atts);
            this.encodeGeometryExpression(raster.getGeometry());
            this.element("Opacity", raster.getOpacity(), 1.0);
            if (raster.getChannelSelection() != null) {
                ChannelSelection cs = raster.getChannelSelection();
                if (cs.getGrayChannel() != null) {
                    this.start("ChannelSelection");
                    SelectedChannelType gray = cs.getGrayChannel();
                    this.start("GrayChannel");
                    gray.accept(this);
                    this.end("GrayChannel");
                    this.end("ChannelSelection");
                } else if (cs.getRGBChannels() != null && cs.getRGBChannels().length == 3 && cs.getRGBChannels()[0] != null && cs.getRGBChannels()[1] != null && cs.getRGBChannels()[2] != null) {
                    this.start("ChannelSelection");
                    SelectedChannelType[] rgb = cs.getRGBChannels();
                    this.start("RedChannel");
                    rgb[0].accept(this);
                    this.end("RedChannel");
                    this.start("GreenChannel");
                    rgb[1].accept(this);
                    this.end("GreenChannel");
                    this.start("BlueChannel");
                    rgb[2].accept(this);
                    this.end("BlueChannel");
                    this.end("ChannelSelection");
                }
            }
            if (raster.getOverlap() != null) {
                Expression overlaps = raster.getOverlap();
                if (overlaps instanceof PropertyName) {
                    String pn = ((PropertyName)overlaps).getPropertyName();
                    if ("RANDOM".equals(pn)) {
                        this.start("OverlapBehavior");
                        this.start(pn);
                        this.end(pn);
                        this.end("OverlapBehavior");
                    }
                } else {
                    this.elementLiteral("OverlapBehavior", overlaps, "RANDOM");
                }
            }
            if ((colorMap = raster.getColorMap()) != null && colorMap.getColorMapEntries() != null && colorMap.getColorMapEntries().length > 0) {
                colorMap.accept(this);
            }
            if (raster.getContrastEnhancement() != null) {
                raster.getContrastEnhancement().accept(this);
            }
            if (raster.getShadedRelief() != null) {
                raster.getShadedRelief().accept(this);
            }
            if (raster.getImageOutline() != null) {
                this.start("ImageOutline");
                raster.getImageOutline().accept(this);
                this.end("ImageOutline");
            }
            this.encodeVendorOptions(raster.getOptions());
            this.end("RasterSymbolizer");
        }

        @Override
        public void visit(ColorMap colorMap) {
            ColorMapEntry[] mapEntries;
            boolean extended;
            AttributesImpl atts = new AttributesImpl();
            String typeString = colorMap.getType() == 2 ? "intervals" : (colorMap.getType() == 3 ? "values" : "ramp");
            if (!"ramp".equals(typeString)) {
                atts.addAttribute("", "type", "type", "", typeString);
            }
            if (extended = colorMap.getExtendedColors()) {
                atts.addAttribute("", "extended", "extended", "", "" + extended);
            }
            this.start("ColorMap", atts);
            for (ColorMapEntry mapEntry : mapEntries = colorMap.getColorMapEntries()) {
                mapEntry.accept(this);
            }
            this.end("ColorMap");
        }

        @Override
        public void visit(ColorMapEntry colorEntry) {
            if (colorEntry != null) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "color", "color", "", (String)colorEntry.getColor().evaluate(null, String.class));
                if (colorEntry.getOpacity() != null) {
                    atts.addAttribute("", "opacity", "opacity", "", colorEntry.getOpacity().toString());
                }
                if (colorEntry.getQuantity() != null) {
                    atts.addAttribute("", "quantity", "quantity", "", colorEntry.getQuantity().toString());
                }
                if (colorEntry.getLabel() != null) {
                    atts.addAttribute("", "label", "label", "", colorEntry.getLabel());
                }
                this.element("ColorMapEntry", (String)null, atts);
            }
        }

        @Override
        public void visit(Symbolizer sym) {
            try {
                this.contentHandler.startElement("", "!--", "!--", this.NULL_ATTS);
                this.chars("Unidentified Symbolizer " + sym.getClass());
                this.contentHandler.endElement("", "--", "--");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        @Override
        public void visit(PolygonSymbolizer poly) {
            AttributesImpl atts = new AttributesImpl();
            Unit uom = poly.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get((Unit<Length>)uom).getSEString());
            }
            this.start("PolygonSymbolizer", atts);
            this.encodeGeometryExpression(poly.getGeometry());
            if (poly.getFill() != null) {
                poly.getFill().accept(this);
            }
            if (poly.getStroke() != null) {
                poly.getStroke().accept(this);
            }
            if (poly.getOptions() != null) {
                this.encodeVendorOptions(poly.getOptions());
            }
            this.end("PolygonSymbolizer");
        }

        @Override
        public void visit(ExternalGraphic exgr) {
            this.start("ExternalGraphic");
            if (exgr.getURI() != null) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("http://www.w3.org/2000/xmlns/", "xlink", "xmlns:xlink", "", SLDTransformer.XLINK_NAMESPACE);
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "type", "xlink:type", "", "simple");
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "xlink", "xlink:href", "", exgr.getURI());
                this.element("OnlineResource", (String)null, atts);
            } else if (exgr.getInlineContent() != null) {
                throw new RuntimeException("SLDTransformer doesn't support InlineContent.");
            }
            this.element("Format", exgr.getFormat());
            this.end("ExternalGraphic");
        }

        @Override
        public void visit(LineSymbolizer line) {
            AttributesImpl atts = new AttributesImpl();
            Unit uom = line.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get((Unit<Length>)uom).getSEString());
            }
            this.start("LineSymbolizer", atts);
            this.encodeGeometryExpression(line.getGeometry());
            if (line.getStroke() != null) {
                line.getStroke().accept(this);
            }
            if (line.getOptions() != null) {
                this.encodeVendorOptions(line.getOptions());
            }
            if (line.getPerpendicularOffset() != null) {
                this.element("PerpendicularOffset", line.getPerpendicularOffset());
            }
            this.end("LineSymbolizer");
        }

        @Override
        public void visit(Fill fill) {
            this.start("Fill");
            if (fill.getGraphicFill() != null) {
                this.start("GraphicFill");
                fill.getGraphicFill().accept(this);
                this.end("GraphicFill");
            }
            this.encodeCssParam("fill", fill.getColor(), "#808080");
            this.encodeCssParam("fill-opacity", fill.getOpacity(), 1.0);
            this.end("Fill");
        }

        @Override
        public void visit(Rule rule) {
            Filter filter;
            Graphic legend;
            this.start("Rule");
            if (rule.getName() != null) {
                this.element("Name", rule.getName());
            }
            if (rule.getDescription() != null && rule.getDescription().getTitle() != null) {
                this.element("Title", rule.getDescription().getTitle());
            }
            if (rule.getDescription() != null && rule.getDescription().getAbstract() != null) {
                this.element("Abstract", rule.getDescription().getAbstract());
            }
            if ((legend = (Graphic)rule.getLegend()) != null) {
                this.start("LegendGraphic");
                legend.accept(this);
                this.end("LegendGraphic");
            }
            if ((filter = rule.getFilter()) != null && filter != Filter.INCLUDE) {
                this.visit(filter);
            }
            if (rule.isElseFilter()) {
                this.start("ElseFilter");
                this.end("ElseFilter");
            }
            if (rule.getMinScaleDenominator() != 0.0) {
                this.element("MinScaleDenominator", "" + rule.getMinScaleDenominator());
            }
            if (rule.getMaxScaleDenominator() != Double.POSITIVE_INFINITY) {
                this.element("MaxScaleDenominator", "" + rule.getMaxScaleDenominator());
            }
            for (Symbolizer symbolizer : rule.symbolizers()) {
                symbolizer.accept(this);
            }
            if (rule.getOptions() != null) {
                this.encodeVendorOptions(rule.getOptions());
            }
            this.end("Rule");
        }

        @Override
        public void visit(Mark mark) {
            this.start("Mark");
            if (mark.getWellKnownName() != null && (!"square".equals(mark.getWellKnownName().evaluate(null)) || this.isExportDefaultValues())) {
                this.encodeValue("WellKnownName", null, mark.getWellKnownName(), null);
            }
            if (mark.getFill() != null) {
                mark.getFill().accept(this);
            }
            if (mark.getStroke() != null) {
                mark.getStroke().accept(this);
            }
            this.end("Mark");
        }

        @Override
        public void visit(PointSymbolizer ps) {
            AttributesImpl atts = new AttributesImpl();
            Unit uom = ps.getUnitOfMeasure();
            if (uom != null) {
                atts.addAttribute("", "uom", "uom", "", UomOgcMapping.get((Unit<Length>)uom).getSEString());
            }
            this.start("PointSymbolizer", atts);
            this.encodeGeometryExpression(ps.getGeometry());
            ps.getGraphic().accept(this);
            if (ps.getOptions() != null) {
                this.encodeVendorOptions(ps.getOptions());
            }
            this.end("PointSymbolizer");
        }

        @Override
        public void visit(Halo halo) {
            this.start("Halo");
            if (halo.getRadius() != null) {
                this.encodeValue("Radius", null, halo.getRadius(), null);
            }
            if (halo.getFill() != null) {
                halo.getFill().accept(this);
            }
            this.end("Halo");
        }

        @Override
        public void visit(Graphic gr) {
            this.start("Graphic");
            for (GraphicalSymbol symbol : gr.graphicalSymbols()) {
                if (symbol instanceof Symbol) {
                    ((Symbol)symbol).accept(this);
                    continue;
                }
                throw new RuntimeException("Don't know how to visit " + symbol);
            }
            this.element("Opacity", gr.getOpacity(), 1.0);
            this.element("Size", gr.getSize());
            this.element("Rotation", gr.getRotation(), 0.0);
            if (gr.getAnchorPoint() != null) {
                this.visit(gr.getAnchorPoint());
            }
            if (gr.getDisplacement() != null) {
                this.visit(gr.getDisplacement());
            }
            this.end("Graphic");
        }

        @Override
        public void visit(StyledLayerDescriptor sld) {
            StyledLayer[] layers;
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "version", "version", "", "1.0.0");
            this.start("StyledLayerDescriptor", atts);
            if (sld.getName() != null && sld.getName().length() > 0) {
                this.element("Name", sld.getName());
            }
            if (sld.getTitle() != null && sld.getTitle().length() > 0) {
                this.element("Title", sld.getTitle());
            }
            if (sld.getAbstract() != null && sld.getAbstract().length() > 0) {
                this.element("Abstract", sld.getAbstract());
            }
            for (StyledLayer layer : layers = sld.getStyledLayers()) {
                if (layer instanceof NamedLayer) {
                    this.visit((NamedLayer)layer);
                    continue;
                }
                if (layer instanceof UserLayer) {
                    this.visit((UserLayer)layer);
                    continue;
                }
                throw new IllegalArgumentException("StyledLayer '" + layer.getClass().toString() + "' not found");
            }
            this.end("StyledLayerDescriptor");
        }

        @Override
        public void visit(NamedLayer layer) {
            Style[] styles;
            this.start("NamedLayer");
            this.element("Name", layer.getName());
            FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
            if (lfc != null && lfc.length > 0) {
                this.start("LayerFeatureConstraints");
                for (FeatureTypeConstraint featureTypeConstraint : lfc) {
                    this.visit(featureTypeConstraint);
                }
                this.end("LayerFeatureConstraints");
            }
            for (Style style : styles = layer.getStyles()) {
                this.visit(style);
            }
            this.end("NamedLayer");
        }

        @Override
        public void visit(UserLayer layer) {
            Style[] styles;
            DataStore inlineFDS;
            this.start("UserLayer");
            if (layer.getName() != null && layer.getName().length() > 0) {
                this.element("Name", layer.getName());
            }
            if ((inlineFDS = layer.getInlineFeatureDatastore()) != null) {
                this.visitInlineFeatureType(inlineFDS, layer.getInlineFeatureType());
            } else if (layer.getRemoteOWS() != null) {
                this.visit(layer.getRemoteOWS());
            }
            this.start("LayerFeatureConstraints");
            FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
            if (lfc != null && lfc.length > 0) {
                for (FeatureTypeConstraint featureTypeConstraint : lfc) {
                    this.visit(featureTypeConstraint);
                }
            } else {
                this.start("FeatureTypeConstraint");
                this.end("FeatureTypeConstraint");
            }
            this.end("LayerFeatureConstraints");
            for (Style style : styles = layer.getUserStyles()) {
                this.visit(style);
            }
            this.end("UserLayer");
        }

        private void visitInlineFeatureType(DataStore dataStore, SimpleFeatureType featureType) {
            this.start("InlineFeature");
            try {
                String ftName = featureType.getTypeName();
                SimpleFeatureSource fs = dataStore.getFeatureSource(ftName);
                SimpleFeatureCollection fc = fs.getFeatures();
                FeatureTransformer ftrax = new FeatureTransformer();
                ftrax.setCollectionNamespace(null);
                ftrax.setCollectionPrefix(null);
                ftrax.setGmlPrefixing(true);
                ftrax.setIndentation(2);
                CoordinateReferenceSystem crs = featureType.getGeometryDescriptor().getCoordinateReferenceSystem();
                String srsName = null;
                if (crs == null) {
                    LOGGER.warning("Null CRS in feature type named [" + ftName + "]. Ignore CRS");
                } else {
                    int ndx;
                    srsName = CRS.toSRS(crs, true);
                    if (srsName == null) {
                        Set ids = crs.getIdentifiers();
                        if (ids == null || ids.isEmpty()) {
                            LOGGER.warning("Null or empty set of named identifiers in CRS [" + crs + "] of feature type named [" + ftName + "]. Ignore CRS");
                        } else {
                            for (ReferenceIdentifier id : ids) {
                                if (id == null) continue;
                                srsName = String.valueOf(id);
                                break;
                            }
                        }
                    }
                    if (srsName != null && (ndx = srsName.indexOf(58)) > 0) {
                        LOGGER.info("Reducing CRS name [" + srsName + "] to its SRID");
                        srsName = srsName.substring(ndx + 1).trim();
                    }
                }
                if (srsName != null) {
                    ftrax.setSrsName(srsName);
                }
                String defaultNS = this.getDefaultNamespace();
                ftrax.getFeatureTypeNamespaces().declareDefaultNamespace("", defaultNS);
                String ns = featureType.getName().getNamespaceURI();
                if (ns == null) {
                    LOGGER.info("Null namespace URI in feature type named [" + ftName + "]. Ignore namespace in features");
                } else {
                    String prefix = this.nsSupport.getPrefix(ns);
                    if (prefix != null) {
                        ftrax.getFeatureTypeNamespaces().declareNamespace((FeatureType)featureType, prefix, ns);
                    }
                }
                Translator t = ftrax.createTranslator(this.contentHandler);
                t.encode(fc);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.end("InlineFeature");
        }

        public void visit(RemoteOWS remoteOWS) {
            this.start("RemoteOWS");
            this.element("Service", remoteOWS.getService());
            this.element("OnlineResource", remoteOWS.getOnlineResource());
            this.end("RemoteOWS");
        }

        @Override
        public void visit(FeatureTypeConstraint ftc) {
            this.start("FeatureTypeConstraint");
            if (ftc != null) {
                Extent[] extent;
                this.element("FeatureTypeName", ftc.getFeatureTypeName());
                this.visit(ftc.getFilter());
                for (Extent value : extent = ftc.getExtents()) {
                    this.visit(value);
                }
            }
            this.end("FeatureTypeConstraint");
        }

        public void visit(Extent extent) {
            this.start("Extent");
            this.element("Name", extent.getName());
            this.element("Value", extent.getValue());
            this.end("Extent");
        }

        public void visit(Filter filter) {
            try {
                this.contentHandler.startElement("", "", "ogc:Filter", this.NULL_ATTS);
                this.filterTranslator.encode(filter);
                this.contentHandler.endElement("", "", "ogc:Filter");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        @Override
        public void visit(Style style) {
            if (style instanceof NamedStyle) {
                this.start("NamedStyle");
                this.element("Name", style.getName());
                this.end("NamedStyle");
            } else {
                Fill background;
                this.start("UserStyle");
                this.element("Name", style.getName());
                if (style.getDescription() != null && style.getDescription().getTitle() != null) {
                    this.element("Title", style.getDescription().getTitle());
                }
                if (style.isDefault()) {
                    this.element("IsDefault", "1");
                }
                if (style.getDescription() != null && style.getDescription().getAbstract() != null) {
                    this.element("Abstract", style.getDescription().getAbstract());
                }
                if ((background = style.getBackground()) != null) {
                    this.start("Background");
                    if (background.getGraphicFill() != null) {
                        this.start("GraphicFill");
                        background.getGraphicFill().accept(this);
                        this.end("GraphicFill");
                    }
                    this.encodeCssParam("fill", background.getColor(), "#808080");
                    this.encodeCssParam("fill-opacity", background.getOpacity(), 1.0);
                    this.end("Background");
                }
                for (FeatureTypeStyle featureTypeStyle : style.featureTypeStyles()) {
                    this.visit(featureTypeStyle);
                }
                this.end("UserStyle");
            }
        }

        @Override
        public void visit(FeatureTypeStyle fts) {
            ArrayList sti;
            this.start("FeatureTypeStyle");
            if (fts.getName() != null && fts.getName().length() > 0) {
                this.element("Name", fts.getName());
            }
            if (fts.getDescription() != null && fts.getDescription().getTitle() != null) {
                this.element("Title", fts.getDescription().getTitle());
            }
            if (fts.getDescription() != null && fts.getDescription().getAbstract() != null) {
                this.element("Abstract", fts.getDescription().getAbstract());
            }
            if (fts.featureTypeNames() != null && fts.featureTypeNames().size() > 0) {
                this.element("FeatureTypeName", ((Name)fts.featureTypeNames().iterator().next()).toString());
            }
            if (fts.getTransformation() != null) {
                this.element("Transformation", fts.getTransformation());
            }
            if ((sti = new ArrayList(fts.semanticTypeIdentifiers())).size() != 1 || !((SemanticType)sti.get(0)).equals((Object)SemanticType.ANY)) {
                for (SemanticType semanticType : sti) {
                    this.element("SemanticTypeIdentifier", semanticType.name());
                }
            }
            for (Rule rule : fts.rules()) {
                rule.accept(this);
            }
            this.encodeVendorOptions(fts.getOptions());
            this.end("FeatureTypeStyle");
        }

        @Override
        public void visit(Displacement dis) {
            if (dis == null) {
                return;
            }
            Expression dx = dis.getDisplacementX();
            Expression dy = dis.getDisplacementY();
            if (this.isNull(dx) && this.isNull(dy)) {
                return;
            }
            if (this.isDefault(dx, 0) && this.isDefault(dy, 0)) {
                return;
            }
            this.start("Displacement");
            this.element("DisplacementX", dis.getDisplacementX());
            this.element("DisplacementY", dis.getDisplacementY());
            this.end("Displacement");
        }

        void encodeGeometryProperty(String name) {
            if (name == null || name.trim().length() == 0) {
                return;
            }
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            PropertyName expression = ff.property(name);
            this.start("Geometry");
            this.filterTranslator.encode(expression);
            this.end("Geometry");
        }

        void encodeGeometryExpression(Expression geom) {
            if (geom == null) {
                return;
            }
            this.start("Geometry");
            this.filterTranslator.encode(geom);
            this.end("Geometry");
        }

        void encodeCssParam(String name, Expression expression) {
            this.encodeCssParam(name, expression, null);
        }

        void encodeCssParam(String name, Expression expression, Object defaultValue) {
            if (expression == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name);
            this.encodeValue("CssParameter", atts, expression, defaultValue);
        }

        void encodeValue(String elementName, Attributes atts, Expression expression, Object defaultValue) {
            Object value;
            if (expression == null) {
                return;
            }
            if (!this.isExportDefaultValues() && expression instanceof Literal && defaultValue != null && (value = expression.evaluate(null, defaultValue.getClass())) != null && value.equals(defaultValue)) {
                return;
            }
            if (atts == null) {
                atts = this.NULL_ATTS;
            }
            if (expression instanceof Literal) {
                this.element(elementName, (String)expression.evaluate(null, String.class), atts);
            } else {
                this.start(elementName, atts);
                this.filterTranslator.encode(expression);
                this.end(elementName);
            }
        }

        void encodeVendorOptions(Map options) {
            if (options != null) {
                for (String key : options.keySet()) {
                    String value = (String)options.get(key);
                    this.encodeVendorOption(key, value);
                }
            }
        }

        void encodeVendorOption(String key, String value) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", key);
            this.start("VendorOption", atts);
            this.chars(value);
            this.end("VendorOption");
        }

        public void encode(Style[] styles) {
            try {
                this.contentHandler.startDocument();
                this.start("StyledLayerDescriptor", this.NULL_ATTS);
                this.start("NamedLayer", this.NULL_ATTS);
                for (Style style : styles) {
                    style.accept(this);
                }
                this.end("NamedLayer");
                this.end("StyledLayerDescriptor");
                this.contentHandler.endDocument();
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void encode(StyledLayerDescriptor sld) {
            try {
                this.contentHandler.startDocument();
                sld.accept(this);
                this.contentHandler.endDocument();
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        @Override
        public void encode(Object o) throws IllegalArgumentException {
            if (o instanceof StyledLayerDescriptor) {
                this.encode((StyledLayerDescriptor)o);
            } else if (o instanceof Style[]) {
                this.encode((Style[])o);
            } else {
                Class<?> c = o.getClass();
                try {
                    Method m = c.getMethod("accept", StyleVisitor.class);
                    m.invoke(o, this);
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalArgumentException("Cannot encode " + o);
                }
                catch (Exception e) {
                    throw new RuntimeException("Internal transformation exception", e);
                }
            }
        }

        @Override
        public void visit(ContrastEnhancement ce) {
            Expression exp;
            if (ce == null) {
                return;
            }
            this.start("ContrastEnhancement");
            ContrastMethod method = ce.getMethod();
            if (method != null && method != ContrastMethod.NONE) {
                Object val = method.name();
                val = ((String)val).substring(0, 1).toUpperCase() + ((String)val).substring(1).toLowerCase();
                this.start((String)val);
                Map<String, Expression> opts = ce.getOptions();
                for (Map.Entry<String, Expression> entry : opts.entrySet()) {
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "name", "name", "", entry.getKey());
                    this.element("VendorOption", entry.getValue().evaluate(null).toString(), atts);
                }
                this.end((String)val);
            }
            if ((exp = ce.getGammaValue()) != null) {
                this.element("GammaValue", exp);
            }
            this.end("ContrastEnhancement");
        }

        @Override
        public void visit(ImageOutline outline) {
            if (outline == null) {
                return;
            }
            this.start("ImageOutline");
            outline.getSymbolizer().accept(this);
            this.end("ImageOutline");
        }

        @Override
        public void visit(ChannelSelection cs) {
            if (cs == null) {
                return;
            }
            this.start("ChannelSelection");
            SelectedChannelType[] sct = cs.getRGBChannels();
            if (sct == null && cs.getGrayChannel() != null) {
                sct = new SelectedChannelType[]{cs.getGrayChannel()};
            }
            for (int i = 0; sct != null && i < sct.length; ++i) {
                this.visit(sct[i]);
            }
            this.end("ChannelSelection");
        }

        @Override
        public void visit(OverlapBehavior ob) {
            this.start("OverlapBehavior");
            String pn = (String)ob.getValue();
            this.start(pn);
            this.end(pn);
            this.end("OverlapBehavior");
        }

        @Override
        public void visit(SelectedChannelType sct) {
            this.element("SourceChannelName", sct.getChannelName());
            ContrastEnhancement ce = sct.getContrastEnhancement();
            if (ce != null) {
                ce.accept(this);
            }
        }

        @Override
        public void visit(ShadedRelief sr) {
            this.start("ShadedRelief");
            if (sr.isBrightnessOnly()) {
                this.element("BrightnessOnly", "true");
            } else {
                this.element("BrightnessOnly", "false");
            }
            if (sr.getReliefFactor() != null) {
                Literal l = (Literal)sr.getReliefFactor();
                this.element("ReliefFactor", l.getValue().toString());
            }
            this.end("ShadedRelief");
        }
    }
}

