/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.styledxmlparser.css.util;

import com.itextpdf.styledxmlparser.css.CommonCssConstants;
import com.itextpdf.styledxmlparser.css.CssDeclaration;
import com.itextpdf.styledxmlparser.css.validate.CssDeclarationValidationMaster;
import java.util.regex.Pattern;

public final class CssTypesValidationUtils {
    private static final String[] ANGLE_MEASUREMENTS_VALUES = new String[]{"deg", "grad", "rad"};
    private static final String[] RELATIVE_MEASUREMENTS_VALUES = new String[]{"%", "em", "ex", "rem"};
    private static final Pattern BASE64_PATTERN = Pattern.compile("^data:[^\\s]+;base64,");

    private CssTypesValidationUtils() {
    }

    public static boolean isAngleValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        value = value.trim();
        for (String metricPostfix : ANGLE_MEASUREMENTS_VALUES) {
            if (!value.endsWith(metricPostfix) || !CssTypesValidationUtils.isNumber(value.substring(0, value.length() - metricPostfix.length()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBase64Data(String data) {
        return BASE64_PATTERN.matcher(data).find();
    }

    public static boolean isColorProperty(String value) {
        return CssDeclarationValidationMaster.checkDeclaration(new CssDeclaration("color", value));
    }

    public static boolean isEmValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        return (value = value.trim()).endsWith("em") && CssTypesValidationUtils.isNumber(value.substring(0, value.length() - "em".length()));
    }

    public static boolean isExValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        return (value = value.trim()) != null && value.endsWith("ex") && CssTypesValidationUtils.isNumber(value.substring(0, value.length() - "ex".length()));
    }

    public static boolean isMetricValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        value = value.trim();
        for (String metricPostfix : CommonCssConstants.METRIC_MEASUREMENTS_VALUES) {
            if (!value.endsWith(metricPostfix) || !CssTypesValidationUtils.isNumber(value.substring(0, value.length() - metricPostfix.length()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNegativeValue(String value) {
        if (value == null) {
            return false;
        }
        if (CssTypesValidationUtils.isNumber(value) || CssTypesValidationUtils.isRelativeValue(value) || CssTypesValidationUtils.isMetricValue(value)) {
            return value.startsWith("-");
        }
        return false;
    }

    public static boolean isNumber(String value) {
        return value != null && (value.matches("^[-+]?\\d\\d*\\.\\d*$") || value.matches("^[-+]?\\d\\d*$") || value.matches("^[-+]?\\.\\d\\d*$"));
    }

    public static boolean isPercentageValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        return (value = value.trim()).endsWith("%") && CssTypesValidationUtils.isNumber(value.substring(0, value.length() - "%".length()));
    }

    public static boolean isRelativeValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        value = value.trim();
        for (String relativePostfix : RELATIVE_MEASUREMENTS_VALUES) {
            if (!value.endsWith(relativePostfix) || !CssTypesValidationUtils.isNumber(value.substring(0, value.length() - relativePostfix.length()))) continue;
            return true;
        }
        return false;
    }

    public static boolean isRemValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        return (value = value.trim()) != null && value.endsWith("rem") && CssTypesValidationUtils.isNumber(value.substring(0, value.length() - "rem".length()));
    }

    public static boolean isValidNumericValue(String value) {
        if (value == null || value.contains(" ")) {
            return false;
        }
        return CssTypesValidationUtils.isRelativeValue(value) || CssTypesValidationUtils.isMetricValue(value) || CssTypesValidationUtils.isNumber(value);
    }

    public static boolean isInitialOrInheritOrUnset(String value) {
        return "initial".equals(value) || "inherit".equals(value) || "unset".equals(value);
    }

    public static boolean containsInitialOrInheritOrUnset(String value) {
        if (value == null) {
            return false;
        }
        return value.contains("initial") || value.contains("inherit") || value.contains("unset");
    }

    public static boolean isZero(String value) {
        return CssTypesValidationUtils.isNumericZeroValue(value) || CssTypesValidationUtils.isMetricZeroValue(value) || CssTypesValidationUtils.isRelativeZeroValue(value);
    }

    static boolean isMetricZeroValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        value = value.trim();
        for (String metricPostfix : CommonCssConstants.METRIC_MEASUREMENTS_VALUES) {
            if (!value.endsWith(metricPostfix) || !CssTypesValidationUtils.isNumericZeroValue(value.substring(0, value.length() - metricPostfix.length()))) continue;
            return true;
        }
        return false;
    }

    static boolean isNumericZeroValue(String value) {
        return value != null && (value.matches("^[-+]?0$") || value.matches("^[-+]?\\.0$"));
    }

    static boolean isRelativeZeroValue(String valueArgument) {
        String value = valueArgument;
        if (value == null) {
            return false;
        }
        value = value.trim();
        for (String relativePostfix : RELATIVE_MEASUREMENTS_VALUES) {
            if (!value.endsWith(relativePostfix) || !CssTypesValidationUtils.isNumericZeroValue(value.substring(0, value.length() - relativePostfix.length()))) continue;
            return true;
        }
        return false;
    }
}

