/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import java.util.HashMap;
import java.util.Map;

public class SignatureMechanisms {
    static final Map<String, String> algorithmNames = new HashMap<String, String>();
    static final Map<String, String> rsaOidsByDigest = new HashMap<String, String>();
    static final Map<String, String> dsaOidsByDigest = new HashMap<String, String>();
    static final Map<String, String> ecdsaOidsByDigest = new HashMap<String, String>();

    public static String getSignatureMechanismOid(String signatureAlgorithmName, String digestAlgorithmName) {
        switch (signatureAlgorithmName) {
            case "RSA": {
                String oId = rsaOidsByDigest.get(digestAlgorithmName);
                return oId == null ? "1.2.840.113549.1.1.1" : oId;
            }
            case "DSA": {
                return dsaOidsByDigest.get(digestAlgorithmName);
            }
            case "ECDSA": {
                return ecdsaOidsByDigest.get(digestAlgorithmName);
            }
            case "Ed25519": {
                return "1.3.101.112";
            }
            case "Ed448": {
                return "1.3.101.113";
            }
            case "RSASSA-PSS": 
            case "RSA/PSS": {
                return "1.2.840.113549.1.1.10";
            }
        }
        return null;
    }

    public static String getAlgorithm(String oid) {
        String ret = algorithmNames.get(oid);
        if (ret == null) {
            return oid;
        }
        return ret;
    }

    static {
        algorithmNames.put("1.2.840.113549.1.1.1", "RSA");
        algorithmNames.put("1.2.840.10040.4.1", "DSA");
        algorithmNames.put("1.2.840.113549.1.1.2", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.4", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.5", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.11", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.12", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.13", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.14", "RSA");
        algorithmNames.put("1.2.840.10040.4.3", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.1", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.2", "DSA");
        algorithmNames.put("1.3.14.3.2.29", "RSA");
        algorithmNames.put("1.3.36.3.3.1.2", "RSA");
        algorithmNames.put("1.3.36.3.3.1.3", "RSA");
        algorithmNames.put("1.3.36.3.3.1.4", "RSA");
        algorithmNames.put("1.2.643.2.2.19", "ECGOST3410");
        algorithmNames.put("1.2.840.10045.2.1", "ECDSA");
        algorithmNames.put("1.2.840.10045.4.1", "ECDSA");
        algorithmNames.put("1.2.840.10045.4.3", "ECDSA");
        algorithmNames.put("1.2.840.10045.4.3.2", "ECDSA");
        algorithmNames.put("1.2.840.10045.4.3.3", "ECDSA");
        algorithmNames.put("1.2.840.10045.4.3.4", "ECDSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.5", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.6", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.7", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.8", "DSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.9", "ECDSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.10", "ECDSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.11", "ECDSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.12", "ECDSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.13", "RSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.14", "RSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.15", "RSA");
        algorithmNames.put("2.16.840.1.101.3.4.3.16", "RSA");
        algorithmNames.put("1.2.840.113549.1.1.10", "RSASSA-PSS");
        algorithmNames.put("1.3.101.112", "Ed25519");
        algorithmNames.put("1.3.101.113", "Ed448");
        rsaOidsByDigest.put("SHA224", "1.2.840.113549.1.1.14");
        rsaOidsByDigest.put("SHA256", "1.2.840.113549.1.1.11");
        rsaOidsByDigest.put("SHA384", "1.2.840.113549.1.1.12");
        rsaOidsByDigest.put("SHA512", "1.2.840.113549.1.1.13");
        rsaOidsByDigest.put("SHA-224", "1.2.840.113549.1.1.14");
        rsaOidsByDigest.put("SHA-256", "1.2.840.113549.1.1.11");
        rsaOidsByDigest.put("SHA-384", "1.2.840.113549.1.1.12");
        rsaOidsByDigest.put("SHA-512", "1.2.840.113549.1.1.13");
        rsaOidsByDigest.put("SHA3-224", "2.16.840.1.101.3.4.3.13");
        rsaOidsByDigest.put("SHA3-256", "2.16.840.1.101.3.4.3.14");
        rsaOidsByDigest.put("SHA3-384", "2.16.840.1.101.3.4.3.15");
        rsaOidsByDigest.put("SHA3-512", "2.16.840.1.101.3.4.3.16");
        dsaOidsByDigest.put("SHA224", "2.16.840.1.101.3.4.3.1");
        dsaOidsByDigest.put("SHA256", "2.16.840.1.101.3.4.3.2");
        dsaOidsByDigest.put("SHA384", "2.16.840.1.101.3.4.3.3");
        dsaOidsByDigest.put("SHA512", "2.16.840.1.101.3.4.3.4");
        dsaOidsByDigest.put("SHA3-224", "2.16.840.1.101.3.4.3.5");
        dsaOidsByDigest.put("SHA3-256", "2.16.840.1.101.3.4.3.6");
        dsaOidsByDigest.put("SHA3-384", "2.16.840.1.101.3.4.3.7");
        dsaOidsByDigest.put("SHA3-512", "2.16.840.1.101.3.4.3.8");
        ecdsaOidsByDigest.put("SHA1", "1.2.840.10045.4.1");
        ecdsaOidsByDigest.put("SHA224", "1.2.840.10045.4.3.1");
        ecdsaOidsByDigest.put("SHA256", "1.2.840.10045.4.3.2");
        ecdsaOidsByDigest.put("SHA384", "1.2.840.10045.4.3.3");
        ecdsaOidsByDigest.put("SHA512", "1.2.840.10045.4.3.4");
        ecdsaOidsByDigest.put("SHA3-224", "2.16.840.1.101.3.4.3.9");
        ecdsaOidsByDigest.put("SHA3-256", "2.16.840.1.101.3.4.3.10");
        ecdsaOidsByDigest.put("SHA3-384", "2.16.840.1.101.3.4.3.11");
        ecdsaOidsByDigest.put("SHA3-512", "2.16.840.1.101.3.4.3.12");
    }
}

