/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.utils;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.util.GhostscriptHelper;
import com.itextpdf.io.util.ImageMagickHelper;
import com.itextpdf.io.util.UrlUtil;
import com.itextpdf.io.util.XmlUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfDocumentInfo;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNameTree;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.ReaderProperties;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.utils.TaggedPdfReaderTool;
import com.itextpdf.kernel.utils.XmlUtils;
import com.itextpdf.kernel.utils.objectpathitems.ObjectPath;
import com.itextpdf.kernel.utils.objectpathitems.TrailerPath;
import com.itextpdf.kernel.xmp.XMPMeta;
import com.itextpdf.kernel.xmp.XMPMetaFactory;
import com.itextpdf.kernel.xmp.XMPUtils;
import com.itextpdf.kernel.xmp.options.ParseOptions;
import com.itextpdf.kernel.xmp.options.SerializeOptions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CompareTool {
    private static final String FILE_PROTOCOL = "file://";
    private static final String UNEXPECTED_NUMBER_OF_PAGES = "Unexpected number of pages for <filename>.";
    private static final String DIFFERENT_PAGES = "File file://<filename> differs on page <pagenumber>.";
    private static final String IGNORED_AREAS_PREFIX = "ignored_areas_";
    private static final String VERSION_REGEXP = "(\\d+\\.)+\\d+(-SNAPSHOT)?";
    private static final String VERSION_REPLACEMENT = "<version>";
    private static final String COPYRIGHT_REGEXP = "\u00a9\\d+-\\d+ (?:iText Group NV|Apryse Group NV)";
    private static final String COPYRIGHT_REPLACEMENT = "\u00a9<copyright years> Apryse Group NV";
    private static final String NEW_LINES = "\\r|\\n";
    private String cmpPdfName;
    private String outPdfName;
    private String cmpPdf;
    private String cmpImage;
    private String outPdf;
    private String outImage;
    private ReaderProperties outProps;
    private ReaderProperties cmpProps;
    private List<PdfIndirectReference> outPagesRef;
    private List<PdfIndirectReference> cmpPagesRef;
    private int compareByContentErrorsLimit = 1000;
    private boolean generateCompareByContentXmlReport = false;
    private boolean encryptionCompareEnabled = false;
    private boolean useCachedPagesForComparison = true;
    private IMetaInfo metaInfo;
    private String gsExec;
    private String compareExec;

    public CompareTool() {
    }

    CompareTool(String gsExec, String compareExec) {
        this.gsExec = gsExec;
        this.compareExec = compareExec;
    }

    public CompareResult compareByCatalog(PdfDocument outDocument, PdfDocument cmpDocument) {
        CompareResult compareResult = null;
        compareResult = new CompareResult(this.compareByContentErrorsLimit);
        ObjectPath catalogPath = new ObjectPath(((PdfDictionary)cmpDocument.getCatalog().getPdfObject()).getIndirectReference(), ((PdfDictionary)outDocument.getCatalog().getPdfObject()).getIndirectReference());
        LinkedHashSet<PdfName> ignoredCatalogEntries = new LinkedHashSet<PdfName>(Arrays.asList(PdfName.Metadata));
        this.compareDictionariesExtended((PdfDictionary)outDocument.getCatalog().getPdfObject(), (PdfDictionary)cmpDocument.getCatalog().getPdfObject(), catalogPath, compareResult, ignoredCatalogEntries);
        if (this.cmpPagesRef == null || this.outPagesRef == null) {
            return compareResult;
        }
        if (this.outPagesRef.size() != this.cmpPagesRef.size() && !compareResult.isMessageLimitReached()) {
            compareResult.addError(catalogPath, "Documents have different numbers of pages.");
        }
        for (int i = 0; i < Math.min(this.cmpPagesRef.size(), this.outPagesRef.size()) && !compareResult.isMessageLimitReached(); ++i) {
            ObjectPath currentPath = new ObjectPath(this.cmpPagesRef.get(i), this.outPagesRef.get(i));
            PdfDictionary outPageDict = (PdfDictionary)this.outPagesRef.get(i).getRefersTo();
            PdfDictionary cmpPageDict = (PdfDictionary)this.cmpPagesRef.get(i).getRefersTo();
            this.compareDictionariesExtended(outPageDict, cmpPageDict, currentPath, compareResult);
        }
        return compareResult;
    }

    public CompareTool disableCachedPagesComparison() {
        this.useCachedPagesForComparison = false;
        return this;
    }

    public CompareTool setCompareByContentErrorsLimit(int compareByContentMaxErrorCount) {
        this.compareByContentErrorsLimit = compareByContentMaxErrorCount;
        return this;
    }

    public CompareTool setGenerateCompareByContentXmlReport(boolean generateCompareByContentXmlReport) {
        this.generateCompareByContentXmlReport = generateCompareByContentXmlReport;
        return this;
    }

    public void setEventCountingMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public CompareTool enableEncryptionCompare() {
        this.encryptionCompareEnabled = true;
        return this;
    }

    public ReaderProperties getOutReaderProperties() {
        if (this.outProps == null) {
            this.outProps = new ReaderProperties();
        }
        return this.outProps;
    }

    public ReaderProperties getCmpReaderProperties() {
        if (this.cmpProps == null) {
            this.cmpProps = new ReaderProperties();
        }
        return this.cmpProps;
    }

    public String compareVisually(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws InterruptedException, IOException {
        return this.compareVisually(outPdf, cmpPdf, outPath, differenceImagePrefix, null);
    }

    public String compareVisually(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, IOException {
        this.init(outPdf, cmpPdf);
        System.out.println("Out pdf: " + UrlUtil.getNormalizedFileUriString((String)outPdf));
        System.out.println("Cmp pdf: " + UrlUtil.getNormalizedFileUriString((String)cmpPdf) + "\n");
        return this.compareVisually(outPath, differenceImagePrefix, ignoredAreas);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath) throws InterruptedException, IOException {
        return this.compareByContent(outPdf, cmpPdf, outPath, null, null, null, null);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix) throws InterruptedException, IOException {
        return this.compareByContent(outPdf, cmpPdf, outPath, differenceImagePrefix, null, null, null);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, byte[] outPass, byte[] cmpPass) throws InterruptedException, IOException {
        return this.compareByContent(outPdf, cmpPdf, outPath, differenceImagePrefix, null, outPass, cmpPass);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, IOException {
        return this.compareByContent(outPdf, cmpPdf, outPath, differenceImagePrefix, ignoredAreas, null, null);
    }

    public String compareByContent(String outPdf, String cmpPdf, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, byte[] outPass, byte[] cmpPass) throws InterruptedException, IOException {
        this.init(outPdf, cmpPdf);
        System.out.println("Out pdf: " + UrlUtil.getNormalizedFileUriString((String)outPdf));
        System.out.println("Cmp pdf: " + UrlUtil.getNormalizedFileUriString((String)cmpPdf) + "\n");
        this.setPassword(outPass, cmpPass);
        return this.compareByContent(outPath, differenceImagePrefix, ignoredAreas);
    }

    public boolean compareDictionaries(PdfDictionary outDict, PdfDictionary cmpDict) {
        return this.compareDictionariesExtended(outDict, cmpDict, null, null);
    }

    public CompareResult compareDictionariesStructure(PdfDictionary outDict, PdfDictionary cmpDict) {
        return this.compareDictionariesStructure(outDict, cmpDict, null);
    }

    public CompareResult compareDictionariesStructure(PdfDictionary outDict, PdfDictionary cmpDict, Set<PdfName> excludedKeys) {
        if (outDict.getIndirectReference() == null || cmpDict.getIndirectReference() == null) {
            throw new IllegalArgumentException("The 'outDict' and 'cmpDict' objects shall have indirect references.");
        }
        CompareResult compareResult = new CompareResult(this.compareByContentErrorsLimit);
        ObjectPath currentPath = new ObjectPath(cmpDict.getIndirectReference(), outDict.getIndirectReference());
        if (!this.compareDictionariesExtended(outDict, cmpDict, currentPath, compareResult, excludedKeys)) {
            assert (!compareResult.isOk());
            System.out.println(compareResult.getReport());
            return compareResult;
        }
        assert (compareResult.isOk());
        return null;
    }

    public CompareResult compareStreamsStructure(PdfStream outStream, PdfStream cmpStream) {
        CompareResult compareResult = new CompareResult(this.compareByContentErrorsLimit);
        ObjectPath currentPath = new ObjectPath(cmpStream.getIndirectReference(), outStream.getIndirectReference());
        if (!this.compareStreamsExtended(outStream, cmpStream, currentPath, compareResult)) {
            assert (!compareResult.isOk());
            System.out.println(compareResult.getReport());
            return compareResult;
        }
        assert (compareResult.isOk());
        return null;
    }

    public boolean compareStreams(PdfStream outStream, PdfStream cmpStream) {
        return this.compareStreamsExtended(outStream, cmpStream, null, null);
    }

    public boolean compareArrays(PdfArray outArray, PdfArray cmpArray) {
        return this.compareArraysExtended(outArray, cmpArray, null, null);
    }

    public boolean compareNames(PdfName outName, PdfName cmpName) {
        return cmpName.equals(outName);
    }

    public boolean compareNumbers(PdfNumber outNumber, PdfNumber cmpNumber) {
        return cmpNumber.getValue() == outNumber.getValue();
    }

    public boolean compareStrings(PdfString outString, PdfString cmpString) {
        return cmpString.getValue().equals(outString.getValue());
    }

    public boolean compareBooleans(PdfBoolean outBoolean, PdfBoolean cmpBoolean) {
        return cmpBoolean.getValue() == outBoolean.getValue();
    }

    public String compareXmp(String outPdf, String cmpPdf) {
        return this.compareXmp(outPdf, cmpPdf, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String compareXmp(String outPdf, String cmpPdf, boolean ignoreDateAndProducerProperties) {
        this.init(outPdf, cmpPdf);
        try (PdfReader readerCmp = new PdfReader(this.cmpPdf);
             PdfDocument cmpDocument = new PdfDocument(readerCmp, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));
             PdfReader readerOut = new PdfReader(this.outPdf);
             PdfDocument outDocument = new PdfDocument(readerOut, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
            byte[] cmpBytes = cmpDocument.getXmpMetadata();
            byte[] outBytes = outDocument.getXmpMetadata();
            if (ignoreDateAndProducerProperties) {
                XMPMeta xmpMeta = XMPMetaFactory.parseFromBuffer(cmpBytes, new ParseOptions().setOmitNormalization(true));
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                cmpBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
                xmpMeta = XMPMetaFactory.parseFromBuffer(outBytes, new ParseOptions().setOmitNormalization(true));
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "CreateDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "ModifyDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/xap/1.0/", "MetadataDate", true, true);
                XMPUtils.removeProperties(xmpMeta, "http://ns.adobe.com/pdf/1.3/", "Producer", true, true);
                outBytes = XMPMetaFactory.serializeToBuffer(xmpMeta, new SerializeOptions(8192));
            }
            if (this.compareXmls(cmpBytes, outBytes)) return null;
            String string = "The XMP packages different!";
            return string;
        }
        catch (Exception ex) {
            return "XMP parsing failure!";
        }
    }

    public boolean compareXmls(byte[] xml1, byte[] xml2) throws ParserConfigurationException, SAXException, IOException {
        return XmlUtils.compareXmls(new ByteArrayInputStream(xml1), new ByteArrayInputStream(xml2));
    }

    /*
     * Exception decompiling
     */
    public boolean compareXmls(String outXmlFile, String cmpXmlFile) throws ParserConfigurationException, SAXException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String compareDocumentInfo(String outPdf, String cmpPdf, byte[] outPass, byte[] cmpPass) throws IOException {
        System.out.print("[itext] INFO  Comparing document info.......");
        String message = null;
        this.setPassword(outPass, cmpPass);
        try (PdfReader readerOut = new PdfReader(outPdf, this.getOutReaderProperties());
             PdfDocument outDocument = new PdfDocument(readerOut, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));
             PdfReader readerCmp = new PdfReader(cmpPdf, this.getCmpReaderProperties());
             PdfDocument cmpDocument = new PdfDocument(readerCmp, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
            String[] cmpInfo = this.convertDocInfoToStrings(cmpDocument.getDocumentInfo());
            String[] outInfo = this.convertDocInfoToStrings(outDocument.getDocumentInfo());
            for (int i = 0; i < cmpInfo.length; ++i) {
                if (cmpInfo[i].equals(outInfo[i])) continue;
                message = MessageFormatUtil.format((String)"Document info fail. Expected: \"{0}\", actual: \"{1}\"", (Object[])new Object[]{cmpInfo[i], outInfo[i]});
                break;
            }
        }
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    public String compareDocumentInfo(String outPdf, String cmpPdf) throws IOException {
        return this.compareDocumentInfo(outPdf, cmpPdf, null, null);
    }

    public String compareLinkAnnotations(String outPdf, String cmpPdf) throws IOException {
        System.out.print("[itext] INFO  Comparing link annotations....");
        String message = null;
        try (PdfReader readerOut = new PdfReader(outPdf);
             PdfDocument outDocument = new PdfDocument(readerOut, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));
             PdfReader readerCmp = new PdfReader(cmpPdf);
             PdfDocument cmpDocument = new PdfDocument(readerCmp, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
            block36: for (int i = 0; i < outDocument.getNumberOfPages() && i < cmpDocument.getNumberOfPages(); ++i) {
                List<PdfLinkAnnotation> outLinks = this.getLinkAnnotations(i + 1, outDocument);
                List<PdfLinkAnnotation> cmpLinks = this.getLinkAnnotations(i + 1, cmpDocument);
                if (cmpLinks.size() != outLinks.size()) {
                    message = MessageFormatUtil.format((String)"Different number of links on page {0}.", (Object[])new Object[]{i + 1});
                    break;
                }
                for (int j = 0; j < cmpLinks.size(); ++j) {
                    if (this.compareLinkAnnotations(cmpLinks.get(j), outLinks.get(j), cmpDocument, outDocument)) continue;
                    message = MessageFormatUtil.format((String)"Different links on page {0}.\n{1}\n{2}", (Object[])new Object[]{i + 1, cmpLinks.get(j).toString(), outLinks.get(j).toString()});
                    continue block36;
                }
            }
        }
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    public String compareTagStructures(String outPdf, String cmpPdf) throws IOException, ParserConfigurationException, SAXException {
        Throwable throwable;
        Throwable throwable2;
        System.out.print("[itext] INFO  Comparing tag structures......");
        String outXmlPath = outPdf.replace(".pdf", ".xml");
        String cmpXmlPath = outPdf.replace(".pdf", ".cmp.xml");
        String message = null;
        try (PdfReader readerOut = new PdfReader(outPdf);){
            throwable2 = null;
            try (PdfDocument docOut = new PdfDocument(readerOut, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
                throwable = null;
                try (FileOutputStream xmlOut = new FileOutputStream(outXmlPath);){
                    new TaggedPdfReaderTool(docOut).setRootTag("root").convertToXml(xmlOut);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
            catch (Throwable xmlOut) {
                throwable2 = xmlOut;
                throw xmlOut;
            }
        }
        var7_7 = null;
        try (PdfReader readerCmp = new PdfReader(cmpPdf);){
            throwable2 = null;
            try (PdfDocument docCmp = new PdfDocument(readerCmp, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
                throwable = null;
                try (FileOutputStream xmlCmp = new FileOutputStream(cmpXmlPath);){
                    new TaggedPdfReaderTool(docCmp).setRootTag("root").convertToXml(xmlCmp);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
        }
        catch (Throwable throwable6) {
            var7_7 = throwable6;
            throw throwable6;
        }
        if (!this.compareXmls(outXmlPath, cmpXmlPath)) {
            message = "The tag structures are different.";
        }
        if (message == null) {
            System.out.println("OK");
        } else {
            System.out.println("Fail");
        }
        System.out.flush();
        return message;
    }

    protected String[] convertDocInfoToStrings(PdfDocumentInfo info) {
        String[] convertedInfo = new String[]{"", "", "", "", ""};
        String infoValue = info.getTitle();
        if (infoValue != null) {
            convertedInfo[0] = infoValue;
        }
        if ((infoValue = info.getAuthor()) != null) {
            convertedInfo[1] = infoValue;
        }
        if ((infoValue = info.getSubject()) != null) {
            convertedInfo[2] = infoValue;
        }
        if ((infoValue = info.getKeywords()) != null) {
            convertedInfo[3] = infoValue;
        }
        if ((infoValue = info.getProducer()) != null) {
            convertedInfo[4] = this.convertProducerLine(infoValue);
        }
        return convertedInfo;
    }

    String convertProducerLine(String producer) {
        return producer.replaceAll(VERSION_REGEXP, VERSION_REPLACEMENT).replaceAll(COPYRIGHT_REGEXP, COPYRIGHT_REPLACEMENT);
    }

    private void init(String outPdf, String cmpPdf) {
        this.outPdf = outPdf;
        this.cmpPdf = cmpPdf;
        this.outPdfName = new File(outPdf).getName();
        this.cmpPdfName = new File(cmpPdf).getName();
        this.outImage = this.outPdfName;
        this.cmpImage = this.cmpPdfName.startsWith("cmp_") ? this.cmpPdfName : "cmp_" + this.cmpPdfName;
    }

    private void setPassword(byte[] outPass, byte[] cmpPass) {
        if (outPass != null) {
            this.getOutReaderProperties().setPassword(outPass);
        }
        if (cmpPass != null) {
            this.getCmpReaderProperties().setPassword(outPass);
        }
    }

    private String compareVisually(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, IOException {
        return this.compareVisually(outPath, differenceImagePrefix, ignoredAreas, null);
    }

    private String compareVisually(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, List<Integer> equalPages) throws IOException, InterruptedException {
        if (!outPath.endsWith("/")) {
            outPath = outPath + "/";
        }
        if (differenceImagePrefix == null) {
            String fileBasedPrefix = "";
            if (this.outPdfName != null) {
                fileBasedPrefix = this.outPdfName + "_";
            }
            differenceImagePrefix = "diff_" + fileBasedPrefix;
        }
        this.prepareOutputDirs(outPath, differenceImagePrefix);
        System.out.println("Comparing visually..........");
        if (ignoredAreas != null && !ignoredAreas.isEmpty()) {
            this.createIgnoredAreasPdfs(outPath, ignoredAreas);
        }
        GhostscriptHelper ghostscriptHelper = null;
        try {
            ghostscriptHelper = new GhostscriptHelper(this.gsExec);
        }
        catch (IllegalArgumentException e) {
            throw new CompareToolExecutionException(e.getMessage());
        }
        ghostscriptHelper.runGhostScriptImageGeneration(this.outPdf, outPath, this.outImage);
        ghostscriptHelper.runGhostScriptImageGeneration(this.cmpPdf, outPath, this.cmpImage);
        return this.compareImagesOfPdfs(outPath, differenceImagePrefix, equalPages);
    }

    private String compareImagesOfPdfs(String outPath, String differenceImagePrefix, List<Integer> equalPages) throws IOException, InterruptedException {
        boolean compareExecIsOk;
        int cnt;
        File[] imageFiles = FileUtil.listFilesInDirectoryByFilter((String)outPath, (FileFilter)new PngFileFilter(this.outPdfName));
        File[] cmpImageFiles = FileUtil.listFilesInDirectoryByFilter((String)outPath, (FileFilter)new CmpPngFileFilter(this.cmpPdfName));
        boolean bUnexpectedNumberOfPages = false;
        if (imageFiles.length != cmpImageFiles.length) {
            bUnexpectedNumberOfPages = true;
        }
        if ((cnt = Math.min(imageFiles.length, cmpImageFiles.length)) < 1) {
            throw new CompareToolExecutionException("No files for comparing. The result or sample pdf file is not processed by GhostScript.");
        }
        Arrays.sort(imageFiles, new ImageNameComparator());
        Arrays.sort(cmpImageFiles, new ImageNameComparator());
        String imageMagickInitError = null;
        ImageMagickHelper imageMagickHelper = null;
        try {
            imageMagickHelper = new ImageMagickHelper(this.compareExec);
            compareExecIsOk = true;
        }
        catch (IllegalArgumentException e) {
            compareExecIsOk = false;
            imageMagickInitError = e.getMessage();
            LoggerFactory.getLogger(CompareTool.class).warn(e.getMessage());
        }
        ArrayList<Integer> diffPages = new ArrayList<Integer>();
        String differentPagesFail = null;
        for (int i = 0; i < cnt; ++i) {
            if (equalPages != null && equalPages.contains(i)) continue;
            System.out.println("Comparing page " + Integer.toString(i + 1) + ": " + UrlUtil.getNormalizedFileUriString((String)imageFiles[i].getName()) + " ...");
            System.out.println("Comparing page " + Integer.toString(i + 1) + ": " + UrlUtil.getNormalizedFileUriString((String)imageFiles[i].getName()) + " ...");
            FileInputStream is1 = new FileInputStream(imageFiles[i].getAbsolutePath());
            FileInputStream is2 = new FileInputStream(cmpImageFiles[i].getAbsolutePath());
            boolean cmpResult = this.compareStreams(is1, is2);
            is1.close();
            is2.close();
            if (!cmpResult) {
                differentPagesFail = "Page is different!";
                diffPages.add(i + 1);
                if (compareExecIsOk) {
                    String diffName = outPath + differenceImagePrefix + Integer.toString(i + 1) + ".png";
                    if (!imageMagickHelper.runImageMagickImageCompare(imageFiles[i].getAbsolutePath(), cmpImageFiles[i].getAbsolutePath(), diffName)) {
                        File diffFile = new File(diffName);
                        differentPagesFail = differentPagesFail + "\nPlease, examine file://" + UrlUtil.toNormalizedURI((File)diffFile).getPath() + " for more details.";
                    }
                }
                System.out.println(differentPagesFail);
                continue;
            }
            System.out.println(" done.");
        }
        if (differentPagesFail != null) {
            String errorMessage = DIFFERENT_PAGES.replace("<filename>", UrlUtil.toNormalizedURI((String)this.outPdf).getPath()).replace("<pagenumber>", this.listDiffPagesAsString(diffPages));
            if (!compareExecIsOk) {
                errorMessage = errorMessage + "\n" + imageMagickInitError;
            }
            return errorMessage;
        }
        if (bUnexpectedNumberOfPages) {
            return UNEXPECTED_NUMBER_OF_PAGES.replace("<filename>", this.outPdf);
        }
        return null;
    }

    private String listDiffPagesAsString(List<Integer> diffPages) {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < diffPages.size(); ++i) {
            sb.append(diffPages.get(i));
            if (i >= diffPages.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private void createIgnoredAreasPdfs(String outPath, Map<Integer, List<Rectangle>> ignoredAreas) throws IOException {
        StampingProperties properties = new StampingProperties();
        properties.setEventCountingMetaInfo(this.metaInfo);
        try (PdfWriter outWriter = new PdfWriter(outPath + IGNORED_AREAS_PREFIX + this.outPdfName);
             PdfReader readerOut = new PdfReader(this.outPdf);
             PdfDocument pdfOutDoc = new PdfDocument(readerOut, outWriter, properties);
             PdfWriter cmpWriter = new PdfWriter(outPath + IGNORED_AREAS_PREFIX + this.cmpPdfName);
             PdfReader readerCmp = new PdfReader(this.cmpPdf);
             PdfDocument pdfCmpDoc = new PdfDocument(readerCmp, cmpWriter, properties);){
            for (Map.Entry<Integer, List<Rectangle>> entry : ignoredAreas.entrySet()) {
                int pageNumber = entry.getKey();
                List<Rectangle> rectangles = entry.getValue();
                if (rectangles == null || rectangles.isEmpty()) continue;
                PdfCanvas outCanvas = new PdfCanvas(pdfOutDoc.getPage(pageNumber));
                PdfCanvas cmpCanvas = new PdfCanvas(pdfCmpDoc.getPage(pageNumber));
                outCanvas.saveState();
                cmpCanvas.saveState();
                for (Rectangle rect : rectangles) {
                    outCanvas.rectangle(rect).fill();
                    cmpCanvas.rectangle(rect).fill();
                }
                outCanvas.restoreState();
                cmpCanvas.restoreState();
            }
        }
        this.init(outPath + IGNORED_AREAS_PREFIX + this.outPdfName, outPath + IGNORED_AREAS_PREFIX + this.cmpPdfName);
    }

    private void prepareOutputDirs(String outPath, String differenceImagePrefix) {
        if (!FileUtil.directoryExists((String)outPath)) {
            FileUtil.createDirectories((String)outPath);
        } else {
            File[] diffFiles;
            File[] cmpImageFiles;
            File[] imageFiles;
            for (File file : imageFiles = FileUtil.listFilesInDirectoryByFilter((String)outPath, (FileFilter)new PngFileFilter(this.cmpPdfName))) {
                file.delete();
            }
            for (File file : cmpImageFiles = FileUtil.listFilesInDirectoryByFilter((String)outPath, (FileFilter)new CmpPngFileFilter(this.cmpPdfName))) {
                file.delete();
            }
            for (File file : diffFiles = FileUtil.listFilesInDirectoryByFilter((String)outPath, (FileFilter)new DiffPngFileFilter(differenceImagePrefix))) {
                file.delete();
            }
        }
    }

    private void printOutCmpDirectories() {
        System.out.println("Out file folder: file://" + UrlUtil.toNormalizedURI((File)new File(this.outPdf).getParentFile()).getPath());
        System.out.println("Cmp file folder: file://" + UrlUtil.toNormalizedURI((File)new File(this.cmpPdf).getParentFile()).getPath());
    }

    /*
     * Exception decompiling
     */
    private String compareByContent(String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas) throws InterruptedException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 2[TRYBLOCK], 3[TRYBLOCK]], but top level block is 81[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String compareVisuallyAndCombineReports(String compareByFailContentReason, String outPath, String differenceImagePrefix, Map<Integer, List<Rectangle>> ignoredAreas, List<Integer> equalPages) throws IOException, InterruptedException {
        System.out.println("Fail");
        System.out.flush();
        String compareByContentReport = "Compare by content report:\n" + compareByFailContentReason;
        System.out.println(compareByContentReport);
        System.out.flush();
        String message = this.compareVisually(outPath, differenceImagePrefix, ignoredAreas, equalPages);
        if (message == null || message.length() == 0) {
            return "Compare by content fails. No visual differences";
        }
        return message;
    }

    private void loadPagesFromReader(PdfDocument doc, List<PdfDictionary> pages, List<PdfIndirectReference> pagesRef) {
        int numOfPages = doc.getNumberOfPages();
        for (int i = 0; i < numOfPages; ++i) {
            pages.add((PdfDictionary)doc.getPage(i + 1).getPdfObject());
            pagesRef.add(pages.get(i).getIndirectReference());
        }
    }

    private void compareDocumentsEncryption(PdfDocument outDocument, PdfDocument cmpDocument, CompareResult compareResult) {
        PdfDictionary outEncrypt = outDocument.getTrailer().getAsDictionary(PdfName.Encrypt);
        PdfDictionary cmpEncrypt = cmpDocument.getTrailer().getAsDictionary(PdfName.Encrypt);
        if (outEncrypt == null && cmpEncrypt == null) {
            return;
        }
        TrailerPath trailerPath = new TrailerPath(cmpDocument, outDocument);
        if (outEncrypt == null) {
            compareResult.addError(trailerPath, "Expected encrypted document.");
            return;
        }
        if (cmpEncrypt == null) {
            compareResult.addError(trailerPath, "Expected not encrypted document.");
            return;
        }
        LinkedHashSet<PdfName> ignoredEncryptEntries = new LinkedHashSet<PdfName>(Arrays.asList(PdfName.O, PdfName.U, PdfName.OE, PdfName.UE, PdfName.Perms, PdfName.CF, PdfName.Recipients));
        ObjectPath objectPath = new ObjectPath(outEncrypt.getIndirectReference(), cmpEncrypt.getIndirectReference());
        this.compareDictionariesExtended(outEncrypt, cmpEncrypt, objectPath, compareResult, ignoredEncryptEntries);
        PdfDictionary outCfDict = outEncrypt.getAsDictionary(PdfName.CF);
        PdfDictionary cmpCfDict = cmpEncrypt.getAsDictionary(PdfName.CF);
        if (cmpCfDict != null || outCfDict != null) {
            if (cmpCfDict != null && outCfDict == null || cmpCfDict == null) {
                compareResult.addError(objectPath, "One of the dictionaries is null, the other is not.");
            } else {
                TreeSet<PdfName> mergedKeys = new TreeSet<PdfName>(outCfDict.keySet());
                mergedKeys.addAll(cmpCfDict.keySet());
                for (PdfName key : mergedKeys) {
                    objectPath.pushDictItemToPath(key);
                    LinkedHashSet<PdfName> excludedKeys = new LinkedHashSet<PdfName>(Arrays.asList(PdfName.Recipients));
                    this.compareDictionariesExtended(outCfDict.getAsDictionary(key), cmpCfDict.getAsDictionary(key), objectPath, compareResult, excludedKeys);
                    objectPath.pop();
                }
            }
        }
    }

    private boolean compareStreams(InputStream is1, InputStream is2) throws IOException {
        int len1;
        byte[] buffer1 = new byte[65536];
        byte[] buffer2 = new byte[65536];
        do {
            int len2;
            if ((len1 = is1.read(buffer1)) != (len2 = is2.read(buffer2))) {
                return false;
            }
            if (Arrays.equals(buffer1, buffer2)) continue;
            return false;
        } while (len1 != -1);
        return true;
    }

    private boolean compareDictionariesExtended(PdfDictionary outDict, PdfDictionary cmpDict, ObjectPath currentPath, CompareResult compareResult) {
        return this.compareDictionariesExtended(outDict, cmpDict, currentPath, compareResult, null);
    }

    private boolean compareDictionariesExtended(PdfDictionary outDict, PdfDictionary cmpDict, ObjectPath currentPath, CompareResult compareResult, Set<PdfName> excludedKeys) {
        if (cmpDict != null && outDict == null || outDict != null && cmpDict == null) {
            compareResult.addError(currentPath, "One of the dictionaries is null, the other is not.");
            return false;
        }
        boolean dictsAreSame = true;
        TreeSet<PdfName> mergedKeys = new TreeSet<PdfName>(cmpDict.keySet());
        mergedKeys.addAll(outDict.keySet());
        for (PdfName key : mergedKeys) {
            PdfObject cmpObj;
            if (!dictsAreSame && (currentPath == null || compareResult == null || compareResult.isMessageLimitReached())) {
                return false;
            }
            if (excludedKeys != null && excludedKeys.contains(key) || key.equals(PdfName.Parent) || key.equals(PdfName.P) || key.equals(PdfName.ModDate) || outDict.isStream() && cmpDict.isStream() && (key.equals(PdfName.Filter) || key.equals(PdfName.Length))) continue;
            if ((key.equals(PdfName.BaseFont) || key.equals(PdfName.FontName)) && (cmpObj = cmpDict.get(key)) != null && cmpObj.isName() && cmpObj.toString().indexOf(43) > 0) {
                String outName;
                PdfObject outObj = outDict.get(key);
                if (!outObj.isName() || outObj.toString().indexOf(43) == -1) {
                    if (compareResult != null && currentPath != null) {
                        compareResult.addError(currentPath, MessageFormatUtil.format((String)"PdfDictionary {0} entry: Expected: {1}. Found: {2}", (Object[])new Object[]{key.toString(), cmpObj.toString(), outObj.toString()}));
                    }
                    dictsAreSame = false;
                    continue;
                }
                String cmpName = cmpObj.toString().substring(cmpObj.toString().indexOf(43));
                if (cmpName.equals(outName = outObj.toString().substring(outObj.toString().indexOf(43)))) continue;
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, MessageFormatUtil.format((String)"PdfDictionary {0} entry: Expected: {1}. Found: {2}", (Object[])new Object[]{key.toString(), cmpObj.toString(), outObj.toString()}));
                }
                dictsAreSame = false;
                continue;
            }
            if (key.equals(PdfName.ParentTree) || key.equals(PdfName.PageLabels)) {
                PdfArray cmpArray;
                PdfArray outArray;
                if (currentPath != null) {
                    currentPath.pushDictItemToPath(key);
                }
                PdfDictionary outNumTree = outDict.getAsDictionary(key);
                PdfDictionary cmpNumTree = cmpDict.getAsDictionary(key);
                LinkedList<PdfObject> outItems = new LinkedList<PdfObject>();
                LinkedList<PdfObject> cmpItems = new LinkedList<PdfObject>();
                PdfNumber outLeftover = this.flattenNumTree(outNumTree, null, outItems);
                PdfNumber cmpLeftover = this.flattenNumTree(cmpNumTree, null, cmpItems);
                if (outLeftover != null) {
                    LoggerFactory.getLogger(CompareTool.class).warn("Number tree ends with a key which is invalid according to the PDF specification.");
                    if (cmpLeftover == null) {
                        if (compareResult != null && currentPath != null) {
                            compareResult.addError(currentPath, "Number tree unexpectedly ends with a key");
                        }
                        dictsAreSame = false;
                    }
                }
                if (cmpLeftover != null) {
                    LoggerFactory.getLogger(CompareTool.class).warn("Number tree ends with a key which is invalid according to the PDF specification.");
                    if (outLeftover == null) {
                        if (compareResult != null && currentPath != null) {
                            compareResult.addError(currentPath, "Number tree was expected to end with a key (although it is invalid according to the specification), but ended with a value");
                        }
                        dictsAreSame = false;
                    }
                }
                if (outLeftover != null && cmpLeftover != null && !this.compareNumbers(outLeftover, cmpLeftover)) {
                    if (compareResult != null && currentPath != null) {
                        compareResult.addError(currentPath, "Number tree was expected to end with a different key (although it is invalid according to the specification)");
                    }
                    dictsAreSame = false;
                }
                if (!this.compareArraysExtended(outArray = new PdfArray(outItems, outItems.size()), cmpArray = new PdfArray(cmpItems, cmpItems.size()), currentPath, compareResult)) {
                    if (compareResult != null && currentPath != null) {
                        compareResult.addError(currentPath, "Number trees were flattened, compared and found to be different.");
                    }
                    dictsAreSame = false;
                }
                if (currentPath == null) continue;
                currentPath.pop();
                continue;
            }
            if (currentPath != null) {
                currentPath.pushDictItemToPath(key);
            }
            boolean bl = dictsAreSame = this.compareObjects(outDict.get(key, false), cmpDict.get(key, false), currentPath, compareResult) && dictsAreSame;
            if (currentPath == null) continue;
            currentPath.pop();
        }
        return dictsAreSame;
    }

    private PdfNumber flattenNumTree(PdfDictionary dictionary, PdfNumber leftOver, LinkedList<PdfObject> items) {
        block6: {
            PdfArray nums;
            block5: {
                nums = dictionary.getAsArray(PdfName.Nums);
                if (nums == null) break block5;
                for (int k = 0; k < nums.size(); ++k) {
                    PdfNumber number;
                    if (leftOver == null) {
                        number = nums.getAsNumber(k++);
                    } else {
                        number = leftOver;
                        leftOver = null;
                    }
                    if (k >= nums.size()) {
                        return number;
                    }
                    items.addLast(number);
                    items.addLast(nums.get(k, false));
                }
                break block6;
            }
            nums = dictionary.getAsArray(PdfName.Kids);
            if (nums == null) break block6;
            for (int k = 0; k < nums.size(); ++k) {
                PdfDictionary kid = nums.getAsDictionary(k);
                leftOver = this.flattenNumTree(kid, leftOver, items);
            }
        }
        return null;
    }

    protected boolean compareObjects(PdfObject outObj, PdfObject cmpObj, ObjectPath currentPath, CompareResult compareResult) {
        PdfObject outDirectObj = null;
        PdfObject cmpDirectObj = null;
        if (outObj != null) {
            PdfObject pdfObject = outDirectObj = outObj.isIndirectReference() ? ((PdfIndirectReference)outObj).getRefersTo(false) : outObj;
        }
        if (cmpObj != null) {
            PdfObject pdfObject = cmpDirectObj = cmpObj.isIndirectReference() ? ((PdfIndirectReference)cmpObj).getRefersTo(false) : cmpObj;
        }
        if (cmpDirectObj == null && outDirectObj == null) {
            return true;
        }
        if (outDirectObj == null) {
            compareResult.addError(currentPath, "Expected object was not found.");
            return false;
        }
        if (cmpDirectObj == null) {
            compareResult.addError(currentPath, "Found object which was not expected to be found.");
            return false;
        }
        if (cmpDirectObj.getType() != outDirectObj.getType()) {
            compareResult.addError(currentPath, MessageFormatUtil.format((String)"Types do not match. Expected: {0}. Found: {1}.", (Object[])new Object[]{cmpDirectObj.getClass().getSimpleName(), outDirectObj.getClass().getSimpleName()}));
            return false;
        }
        if (cmpObj.isIndirectReference() && !outObj.isIndirectReference()) {
            compareResult.addError(currentPath, "Expected indirect object.");
            return false;
        }
        if (!cmpObj.isIndirectReference() && outObj.isIndirectReference()) {
            compareResult.addError(currentPath, "Expected direct object.");
            return false;
        }
        if (currentPath != null && cmpObj.isIndirectReference() && outObj.isIndirectReference()) {
            if (currentPath.isComparing((PdfIndirectReference)cmpObj, (PdfIndirectReference)outObj)) {
                return true;
            }
            currentPath = currentPath.resetDirectPath((PdfIndirectReference)cmpObj, (PdfIndirectReference)outObj);
        }
        if (cmpDirectObj.isDictionary() && PdfName.Page.equals(((PdfDictionary)cmpDirectObj).getAsName(PdfName.Type)) && this.useCachedPagesForComparison) {
            int i;
            PdfIndirectReference outRefKey;
            if (!outDirectObj.isDictionary() || !PdfName.Page.equals(((PdfDictionary)outDirectObj).getAsName(PdfName.Type))) {
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, "Expected a page. Found not a page.");
                }
                return false;
            }
            PdfIndirectReference cmpRefKey = cmpObj.isIndirectReference() ? (PdfIndirectReference)cmpObj : cmpObj.getIndirectReference();
            PdfIndirectReference pdfIndirectReference = outRefKey = outObj.isIndirectReference() ? (PdfIndirectReference)outObj : outObj.getIndirectReference();
            if (this.cmpPagesRef == null) {
                this.cmpPagesRef = new ArrayList<PdfIndirectReference>();
                for (i = 1; i <= cmpRefKey.getDocument().getNumberOfPages(); ++i) {
                    this.cmpPagesRef.add(((PdfDictionary)cmpRefKey.getDocument().getPage(i).getPdfObject()).getIndirectReference());
                }
            }
            if (this.outPagesRef == null) {
                this.outPagesRef = new ArrayList<PdfIndirectReference>();
                for (i = 1; i <= outRefKey.getDocument().getNumberOfPages(); ++i) {
                    this.outPagesRef.add(((PdfDictionary)outRefKey.getDocument().getPage(i).getPdfObject()).getIndirectReference());
                }
            }
            if (this.cmpPagesRef.contains(cmpRefKey) || this.outPagesRef.contains(outRefKey)) {
                if (this.cmpPagesRef.contains(cmpRefKey) && this.cmpPagesRef.indexOf(cmpRefKey) == this.outPagesRef.indexOf(outRefKey)) {
                    return true;
                }
                if (compareResult != null && currentPath != null) {
                    compareResult.addError(currentPath, MessageFormatUtil.format((String)"The dictionaries refer to different pages. Expected page number: {0}. Found: {1}", (Object[])new Object[]{this.cmpPagesRef.indexOf(cmpRefKey) + 1, this.outPagesRef.indexOf(outRefKey) + 1}));
                }
                return false;
            }
        }
        if (cmpDirectObj.isDictionary()) {
            return this.compareDictionariesExtended((PdfDictionary)outDirectObj, (PdfDictionary)cmpDirectObj, currentPath, compareResult);
        }
        if (cmpDirectObj.isStream()) {
            return this.compareStreamsExtended((PdfStream)outDirectObj, (PdfStream)cmpDirectObj, currentPath, compareResult);
        }
        if (cmpDirectObj.isArray()) {
            return this.compareArraysExtended((PdfArray)outDirectObj, (PdfArray)cmpDirectObj, currentPath, compareResult);
        }
        if (cmpDirectObj.isName()) {
            return this.compareNamesExtended((PdfName)outDirectObj, (PdfName)cmpDirectObj, currentPath, compareResult);
        }
        if (cmpDirectObj.isNumber()) {
            return this.compareNumbersExtended((PdfNumber)outDirectObj, (PdfNumber)cmpDirectObj, currentPath, compareResult);
        }
        if (cmpDirectObj.isString()) {
            return this.compareStringsExtended((PdfString)outDirectObj, (PdfString)cmpDirectObj, currentPath, compareResult);
        }
        if (cmpDirectObj.isBoolean()) {
            return this.compareBooleansExtended((PdfBoolean)outDirectObj, (PdfBoolean)cmpDirectObj, currentPath, compareResult);
        }
        if (outDirectObj.isNull() && cmpDirectObj.isNull()) {
            return true;
        }
        throw new UnsupportedOperationException();
    }

    private boolean compareStreamsExtended(PdfStream outStream, PdfStream cmpStream, ObjectPath currentPath, CompareResult compareResult) {
        byte[] cmpStreamBytes;
        boolean toDecode = PdfName.FlateDecode.equals(outStream.get(PdfName.Filter));
        byte[] outStreamBytes = outStream.getBytes(toDecode);
        if (Arrays.equals(outStreamBytes, cmpStreamBytes = cmpStream.getBytes(toDecode))) {
            return this.compareDictionariesExtended(outStream, cmpStream, currentPath, compareResult);
        }
        StringBuilder errorMessage = new StringBuilder();
        if (cmpStreamBytes.length != outStreamBytes.length) {
            errorMessage.append(MessageFormatUtil.format((String)"PdfStream. Lengths are different. Expected: {0}. Found: {1}\n", (Object[])new Object[]{cmpStreamBytes.length, outStreamBytes.length}));
        } else {
            errorMessage.append("PdfStream. Bytes are different.\n");
        }
        int firstDifferenceOffset = this.findBytesDifference(outStreamBytes, cmpStreamBytes, errorMessage);
        if (compareResult != null && currentPath != null) {
            currentPath.pushOffsetToPath(firstDifferenceOffset);
            compareResult.addError(currentPath, errorMessage.toString());
            currentPath.pop();
        }
        return false;
    }

    private int findBytesDifference(byte[] outStreamBytes, byte[] cmpStreamBytes, StringBuilder errorMessage) {
        int numberOfDifferentBytes = 0;
        int firstDifferenceOffset = 0;
        int minLength = Math.min(cmpStreamBytes.length, outStreamBytes.length);
        for (int i = 0; i < minLength; ++i) {
            if (cmpStreamBytes[i] == outStreamBytes[i] || ++numberOfDifferentBytes != 1) continue;
            firstDifferenceOffset = i;
        }
        String bytesDifference = null;
        if (numberOfDifferentBytes > 0) {
            int diffBytesAreaL = 10;
            int diffBytesAreaR = 10;
            int lCmp = Math.max(0, firstDifferenceOffset - diffBytesAreaL);
            int rCmp = Math.min(cmpStreamBytes.length, firstDifferenceOffset + diffBytesAreaR);
            int lOut = Math.max(0, firstDifferenceOffset - diffBytesAreaL);
            int rOut = Math.min(outStreamBytes.length, firstDifferenceOffset + diffBytesAreaR);
            String cmpByte = new String(new byte[]{cmpStreamBytes[firstDifferenceOffset]}, StandardCharsets.ISO_8859_1);
            String cmpByteNeighbours = new String(cmpStreamBytes, lCmp, rCmp - lCmp, StandardCharsets.ISO_8859_1).replaceAll(NEW_LINES, " ");
            String outByte = new String(new byte[]{outStreamBytes[firstDifferenceOffset]}, StandardCharsets.ISO_8859_1);
            String outBytesNeighbours = new String(outStreamBytes, lOut, rOut - lOut, StandardCharsets.ISO_8859_1).replaceAll(NEW_LINES, " ");
            bytesDifference = MessageFormatUtil.format((String)"First bytes difference is encountered at index {0}. Expected: {1} ({2}). Found: {3} ({4}). Total number of different bytes: {5}", (Object[])new Object[]{Integer.valueOf(firstDifferenceOffset).toString(), cmpByte, cmpByteNeighbours, outByte, outBytesNeighbours, numberOfDifferentBytes});
        } else {
            firstDifferenceOffset = minLength;
            bytesDifference = MessageFormatUtil.format((String)"Bytes of the shorter array are the same as the first {0} bytes of the longer one.", (Object[])new Object[]{minLength});
        }
        errorMessage.append(bytesDifference);
        return firstDifferenceOffset;
    }

    private boolean compareArraysExtended(PdfArray outArray, PdfArray cmpArray, ObjectPath currentPath, CompareResult compareResult) {
        if (outArray == null) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, "Found null. Expected PdfArray.");
            }
            return false;
        }
        if (outArray.size() != cmpArray.size()) {
            if (compareResult != null && currentPath != null) {
                compareResult.addError(currentPath, MessageFormatUtil.format((String)"PdfArrays. Lengths are different. Expected: {0}. Found: {1}.", (Object[])new Object[]{cmpArray.size(), outArray.size()}));
            }
            return false;
        }
        boolean arraysAreEqual = true;
        for (int i = 0; i < cmpArray.size(); ++i) {
            if (currentPath != null) {
                currentPath.pushArrayItemToPath(i);
            }
            boolean bl = arraysAreEqual = this.compareObjects(outArray.get(i, false), cmpArray.get(i, false), currentPath, compareResult) && arraysAreEqual;
            if (currentPath != null) {
                currentPath.pop();
            }
            if (arraysAreEqual || currentPath != null && compareResult != null && !compareResult.isMessageLimitReached()) continue;
            return false;
        }
        return arraysAreEqual;
    }

    private boolean compareNamesExtended(PdfName outName, PdfName cmpName, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpName.equals(outName)) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, MessageFormatUtil.format((String)"PdfName. Expected: {0}. Found: {1}", (Object[])new Object[]{cmpName.toString(), outName.toString()}));
        }
        return false;
    }

    private boolean compareNumbersExtended(PdfNumber outNumber, PdfNumber cmpNumber, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpNumber.getValue() == outNumber.getValue()) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, MessageFormatUtil.format((String)"PdfNumber. Expected: {0}. Found: {1}", (Object[])new Object[]{cmpNumber, outNumber}));
        }
        return false;
    }

    private boolean compareStringsExtended(PdfString outString, PdfString cmpString, ObjectPath currentPath, CompareResult compareResult) {
        if (Arrays.equals(this.convertPdfStringToBytes(cmpString), this.convertPdfStringToBytes(outString))) {
            return true;
        }
        String cmpStr = cmpString.toUnicodeString();
        String outStr = outString.toUnicodeString();
        StringBuilder errorMessage = new StringBuilder();
        if (cmpStr.length() != outStr.length()) {
            errorMessage.append(MessageFormatUtil.format((String)"PdfString. Lengths are different. Expected: {0}. Found: {1}\n", (Object[])new Object[]{cmpStr.length(), outStr.length()}));
        } else {
            errorMessage.append("PdfString. Characters are different.\n");
        }
        int firstDifferenceOffset = this.findStringDifference(outStr, cmpStr, errorMessage);
        if (compareResult != null && currentPath != null) {
            currentPath.pushOffsetToPath(firstDifferenceOffset);
            compareResult.addError(currentPath, errorMessage.toString());
            currentPath.pop();
        }
        return false;
    }

    private int findStringDifference(String outString, String cmpString, StringBuilder errorMessage) {
        int numberOfDifferentChars = 0;
        int firstDifferenceOffset = 0;
        int minLength = Math.min(cmpString.length(), outString.length());
        for (int i = 0; i < minLength; ++i) {
            if (cmpString.charAt(i) == outString.charAt(i) || ++numberOfDifferentChars != 1) continue;
            firstDifferenceOffset = i;
        }
        String stringDifference = null;
        if (numberOfDifferentChars > 0) {
            int diffBytesAreaL = 15;
            int diffBytesAreaR = 15;
            int lCmp = Math.max(0, firstDifferenceOffset - diffBytesAreaL);
            int rCmp = Math.min(cmpString.length(), firstDifferenceOffset + diffBytesAreaR);
            int lOut = Math.max(0, firstDifferenceOffset - diffBytesAreaL);
            int rOut = Math.min(outString.length(), firstDifferenceOffset + diffBytesAreaR);
            String cmpByte = String.valueOf(cmpString.charAt(firstDifferenceOffset));
            String cmpByteNeighbours = cmpString.substring(lCmp, rCmp).replaceAll(NEW_LINES, " ");
            String outByte = String.valueOf(outString.charAt(firstDifferenceOffset));
            String outBytesNeighbours = outString.substring(lOut, rOut).replaceAll(NEW_LINES, " ");
            stringDifference = MessageFormatUtil.format((String)"First characters difference is encountered at index {0}.\nExpected: {1} ({2}).\nFound: {3} ({4}).\nTotal number of different characters: {5}", (Object[])new Object[]{Integer.valueOf(firstDifferenceOffset).toString(), cmpByte, cmpByteNeighbours, outByte, outBytesNeighbours, numberOfDifferentChars});
        } else {
            firstDifferenceOffset = minLength;
            stringDifference = MessageFormatUtil.format((String)"All characters of the shorter string are the same as the first {0} characters of the longer one.", (Object[])new Object[]{minLength});
        }
        errorMessage.append(stringDifference);
        return firstDifferenceOffset;
    }

    private byte[] convertPdfStringToBytes(PdfString pdfString) {
        String value = pdfString.getValue();
        String encoding = pdfString.getEncoding();
        byte[] bytes = encoding != null && "UnicodeBig".equals(encoding) && PdfEncodings.isPdfDocEncoding((String)value) ? PdfEncodings.convertToBytes((String)value, (String)"PDF") : PdfEncodings.convertToBytes((String)value, (String)encoding);
        return bytes;
    }

    private boolean compareBooleansExtended(PdfBoolean outBoolean, PdfBoolean cmpBoolean, ObjectPath currentPath, CompareResult compareResult) {
        if (cmpBoolean.getValue() == outBoolean.getValue()) {
            return true;
        }
        if (compareResult != null && currentPath != null) {
            compareResult.addError(currentPath, MessageFormatUtil.format((String)"PdfBoolean. Expected: {0}. Found: {1}.", (Object[])new Object[]{cmpBoolean.getValue(), outBoolean.getValue()}));
        }
        return false;
    }

    private List<PdfLinkAnnotation> getLinkAnnotations(int pageNum, PdfDocument document) {
        ArrayList<PdfLinkAnnotation> linkAnnotations = new ArrayList<PdfLinkAnnotation>();
        List<PdfAnnotation> annotations = document.getPage(pageNum).getAnnotations();
        for (PdfAnnotation annotation : annotations) {
            if (!PdfName.Link.equals(annotation.getSubtype())) continue;
            linkAnnotations.add((PdfLinkAnnotation)annotation);
        }
        return linkAnnotations;
    }

    private boolean compareLinkAnnotations(PdfLinkAnnotation cmpLink, PdfLinkAnnotation outLink, PdfDocument cmpDocument, PdfDocument outDocument) {
        PdfObject cmpDestObject = cmpLink.getDestinationObject();
        PdfObject outDestObject = outLink.getDestinationObject();
        if (cmpDestObject != null && outDestObject != null) {
            if (cmpDestObject.getType() != outDestObject.getType()) {
                return false;
            }
            PdfArray explicitCmpDest = null;
            PdfArray explicitOutDest = null;
            PdfNameTree cmpNamedDestinations = cmpDocument.getCatalog().getNameTree(PdfName.Dests);
            PdfNameTree outNamedDestinations = outDocument.getCatalog().getNameTree(PdfName.Dests);
            switch (cmpDestObject.getType()) {
                case 1: {
                    explicitCmpDest = (PdfArray)cmpDestObject;
                    explicitOutDest = (PdfArray)outDestObject;
                    break;
                }
                case 6: {
                    String cmpDestName = ((PdfName)cmpDestObject).getValue();
                    explicitCmpDest = (PdfArray)cmpNamedDestinations.getEntry(cmpDestName);
                    String outDestName = ((PdfName)outDestObject).getValue();
                    explicitOutDest = (PdfArray)outNamedDestinations.getEntry(outDestName);
                    break;
                }
                case 10: {
                    explicitCmpDest = (PdfArray)cmpNamedDestinations.getEntry((PdfString)cmpDestObject);
                    explicitOutDest = (PdfArray)outNamedDestinations.getEntry((PdfString)outDestObject);
                    break;
                }
            }
            if (this.getExplicitDestinationPageNum(explicitCmpDest) != this.getExplicitDestinationPageNum(explicitOutDest)) {
                return false;
            }
        }
        PdfDictionary cmpDict = (PdfDictionary)cmpLink.getPdfObject();
        PdfDictionary outDict = (PdfDictionary)outLink.getPdfObject();
        if (cmpDict.size() != outDict.size()) {
            return false;
        }
        Rectangle cmpRect = cmpDict.getAsRectangle(PdfName.Rect);
        Rectangle outRect = outDict.getAsRectangle(PdfName.Rect);
        if (cmpRect.getHeight() != outRect.getHeight() || cmpRect.getWidth() != outRect.getWidth() || cmpRect.getX() != outRect.getX() || cmpRect.getY() != outRect.getY()) {
            return false;
        }
        for (Map.Entry<PdfName, PdfObject> cmpEntry : cmpDict.entrySet()) {
            PdfObject cmpObj = cmpEntry.getValue();
            if (!outDict.containsKey(cmpEntry.getKey())) {
                return false;
            }
            PdfObject outObj = outDict.get(cmpEntry.getKey());
            if (cmpObj.getType() != outObj.getType()) {
                return false;
            }
            switch (cmpObj.getType()) {
                case 2: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (cmpObj.toString().equals(outObj.toString())) break;
                    return false;
                }
            }
        }
        return true;
    }

    private int getExplicitDestinationPageNum(PdfArray explicitDest) {
        PdfIndirectReference pageReference = (PdfIndirectReference)explicitDest.get(0, false);
        PdfDocument doc = pageReference.getDocument();
        for (int i = 1; i <= doc.getNumberOfPages(); ++i) {
            if (!((PdfDictionary)doc.getPage(i).getPdfObject()).getIndirectReference().equals(pageReference)) continue;
            return i;
        }
        throw new IllegalArgumentException("PdfLinkAnnotation comparison: Page not found.");
    }

    public static class CompareToolExecutionException
    extends RuntimeException {
        public CompareToolExecutionException(String msg) {
            super(msg);
        }
    }

    public static class CompareResult {
        protected Map<ObjectPath, String> differences = new LinkedHashMap<ObjectPath, String>();
        protected int messageLimit = 1;

        public CompareResult(int messageLimit) {
            this.messageLimit = messageLimit;
        }

        public boolean isOk() {
            return this.differences.size() == 0;
        }

        public int getErrorCount() {
            return this.differences.size();
        }

        public String getReport() {
            StringBuilder sb = new StringBuilder();
            boolean firstEntry = true;
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                if (!firstEntry) {
                    sb.append("-----------------------------").append("\n");
                }
                ObjectPath diffPath = entry.getKey();
                sb.append(entry.getValue()).append("\n").append(diffPath.toString()).append("\n");
                firstEntry = false;
            }
            return sb.toString();
        }

        public Map<ObjectPath, String> getDifferences() {
            return this.differences;
        }

        public void writeReportToXml(OutputStream stream) throws ParserConfigurationException, TransformerException {
            Document xmlReport = XmlUtil.initNewXmlDocument();
            Element root = xmlReport.createElement("report");
            Element errors = xmlReport.createElement("errors");
            errors.setAttribute("count", String.valueOf(this.differences.size()));
            root.appendChild(errors);
            for (Map.Entry<ObjectPath, String> entry : this.differences.entrySet()) {
                Element errorNode = xmlReport.createElement("error");
                Element message = xmlReport.createElement("message");
                message.appendChild(xmlReport.createTextNode(entry.getValue()));
                Node path = entry.getKey().toXmlNode(xmlReport);
                errorNode.appendChild(message);
                errorNode.appendChild(path);
                errors.appendChild(errorNode);
            }
            xmlReport.appendChild(root);
            XmlUtils.writeXmlDocToStream(xmlReport, stream);
        }

        protected boolean isMessageLimitReached() {
            return this.differences.size() >= this.messageLimit;
        }

        protected void addError(ObjectPath path, String message) {
            if (this.differences.size() < this.messageLimit) {
                this.differences.put(new ObjectPath(path), message);
            }
        }
    }

    private static class ImageNameComparator
    implements Comparator<File> {
        private ImageNameComparator() {
        }

        @Override
        public int compare(File f1, File f2) {
            String f1Name = f1.getName();
            String f2Name = f2.getName();
            return f1Name.compareTo(f2Name);
        }
    }

    private static class DiffPngFileFilter
    implements FileFilter {
        private String differenceImagePrefix;

        public DiffPngFileFilter(String differenceImagePrefix) {
            this.differenceImagePrefix = differenceImagePrefix;
        }

        @Override
        public boolean accept(File pathname) {
            String ap = pathname.getName();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.startsWith(this.differenceImagePrefix);
            return b1 && b2;
        }
    }

    private static class CmpPngFileFilter
    implements FileFilter {
        private String currentCmpPdfName;

        public CmpPngFileFilter(String currentCmpPdfName) {
            this.currentCmpPdfName = currentCmpPdfName;
        }

        @Override
        public boolean accept(File pathname) {
            String ap = pathname.getName();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && b2 && ap.contains(this.currentCmpPdfName);
        }
    }

    private static class PngFileFilter
    implements FileFilter {
        private String currentOutPdfName;

        public PngFileFilter(String currentOutPdfName) {
            this.currentOutPdfName = currentOutPdfName;
        }

        @Override
        public boolean accept(File pathname) {
            String ap = pathname.getName();
            boolean b1 = ap.endsWith(".png");
            boolean b2 = ap.contains("cmp_");
            return b1 && !b2 && ap.contains(this.currentOutPdfName);
        }
    }
}

