/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleStruct;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.oracle.OracleFilterToSQL;
import org.geotools.data.oracle.sdo.GeometryConverter;
import org.geotools.data.oracle.sdo.SDOSqlDumper;
import org.geotools.data.oracle.sdo.TT;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PreparedFilterToSQL;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.referencing.CRS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.util.GenericName;

public class OracleDialect
extends PreparedStatementSQLDialect {
    private static final int DEFAULT_AXIS_MAX = 10000000;
    private static final int DEFAULT_AXIS_MIN = -10000000;
    private static final Pattern AXIS_NAME_VALIDATOR = Pattern.compile("^[\\w]{1,30}");
    public static final String GEODETIC = "geodetic";
    private int nameLenghtLimit = 30;
    public static final Map<Class, String> CLASSES_TO_GEOM = Collections.unmodifiableMap(new GeomClasses());
    static final Map<String, Class> TYPES_TO_CLASSES = new HashMap<String, Class>(){
        {
            this.put("CHAR", String.class);
            this.put("NCHAR", String.class);
            this.put("NVARCHAR", String.class);
            this.put("NVARCHAR2", String.class);
            this.put("DATE", Date.class);
            this.put("TIMESTAMP", Timestamp.class);
        }
    };
    boolean looseBBOXEnabled = false;
    boolean estimatedExtentsEnabled = false;
    boolean isGetColumnRemarksEnabled = false;
    SoftValueHashMap<Integer, Boolean> geodeticCache = new SoftValueHashMap(20);
    Boolean canAccessUserViews;
    String geometryMetadataTable;
    boolean metadataBboxEnabled = false;
    static Set<String> reservedWords = new TreeSet<String>();

    public void initVersion(Connection cx) {
        try {
            int databaseMajorVersion = cx.getMetaData().getDatabaseMajorVersion();
            if (databaseMajorVersion >= 12) {
                this.nameLenghtLimit = 128;
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to determine database major version, will assume length cannot be longer than 30 chars", e);
        }
    }

    public void setRemarksReporting(Connection cx, boolean reportRemarks) throws SQLException {
        OracleConnection ocx = this.unwrapConnection(cx);
        ocx.setRemarksReporting(reportRemarks);
    }

    public OracleDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void initializeConnection(Connection cx) throws SQLException {
        this.setRemarksReporting(cx, this.isGetColumnRemarksEnabled);
    }

    public boolean isAggregatedSortSupported(String function) {
        return "distinct".equalsIgnoreCase(function);
    }

    public void setGetColumnRemarksEnabled(boolean getColumnRemarksEnabled) {
        this.isGetColumnRemarksEnabled = getColumnRemarksEnabled;
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean isEstimatedExtentsEnabled() {
        return this.estimatedExtentsEnabled;
    }

    public void setEstimatedExtentsEnabled(boolean estimatedExtenstEnabled) {
        this.estimatedExtentsEnabled = estimatedExtenstEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean canAccessUserViews(Connection cx) {
        if (this.canAccessUserViews == null) {
            Statement st = null;
            ResultSet rs = null;
            try {
                st = cx.createStatement();
                String sql = "SELECT * FROM MDSYS.USER_SDO_INDEX_METADATA WHERE ROWNUM < 2";
                LOGGER.log(Level.FINE, "Check user can access user metadata views: {0}", sql);
                rs = st.executeQuery(sql);
                this.dataStore.closeSafe(rs);
                sql = "SELECT * FROM MDSYS.USER_SDO_GEOM_METADATA WHERE ROWNUM < 2";
                LOGGER.log(Level.FINE, "Check user can access user metadata views: {0}", sql);
                LOGGER.log(Level.FINE, sql);
                rs = st.executeQuery(sql);
                this.dataStore.closeSafe(rs);
                this.canAccessUserViews = true;
            }
            catch (SQLException e) {
                try {
                    this.canAccessUserViews = false;
                }
                catch (Throwable throwable) {
                    this.dataStore.closeSafe(st);
                    this.dataStore.closeSafe(rs);
                    throw throwable;
                }
                this.dataStore.closeSafe(st);
                this.dataStore.closeSafe(rs);
            }
            this.dataStore.closeSafe(st);
            this.dataStore.closeSafe(rs);
        }
        return this.canAccessUserViews;
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        int TABLE_NAME = 3;
        int COLUMN_NAME = 4;
        int TYPE_NAME = 6;
        String typeName = columnMetaData.getString(6);
        if (typeName.equals("SDO_GEOMETRY")) {
            String schema;
            String columnName;
            String tableName = columnMetaData.getString(3);
            Class<Object> geometryClass = this.lookupGeometryOnMetadataTable(cx, tableName, columnName = columnMetaData.getString(4), schema = this.dataStore.getDatabaseSchema());
            if (geometryClass == null) {
                this.lookupGeometryClassOnUserIndex(cx, tableName, columnName, schema);
            }
            if (geometryClass == null) {
                geometryClass = this.lookupGeometryClassOnAllIndex(cx, tableName, columnName, schema);
            }
            if (geometryClass == null) {
                geometryClass = Geometry.class;
            }
            return geometryClass;
        }
        return TYPES_TO_CLASSES.get(typeName);
    }

    private Class<?> lookupGeometryOnMetadataTable(Connection cx, String tableName, String columnName, String schema) throws SQLException {
        if (this.geometryMetadataTable == null) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        String metadataTableStatement = "SELECT TYPE FROM " + this.geometryMetadataTable + " WHERE F_TABLE_NAME = ? AND F_GEOMETRY_COLUMN = ?";
        parameters.add(tableName);
        parameters.add(columnName);
        if (schema != null && !"".equals(schema)) {
            metadataTableStatement = metadataTableStatement + " AND F_TABLE_SCHEMA = ?";
            parameters.add(schema);
        }
        return this.readGeometryClassFromStatement(cx, metadataTableStatement, parameters);
    }

    private Class<?> lookupGeometryClassOnAllIndex(Connection cx, String tableName, String columnName, String schema) throws SQLException {
        ArrayList<String> parameters = new ArrayList<String>();
        Object allSdoSqlStatement = "SELECT META.SDO_LAYER_GTYPE\nFROM ALL_INDEXES INFO\nINNER JOIN MDSYS.ALL_SDO_INDEX_METADATA META\nON INFO.INDEX_NAME = META.SDO_INDEX_NAME\nWHERE INFO.TABLE_NAME = ?\nAND REPLACE(meta.sdo_column_name, '\"') = ?\n";
        parameters.add(tableName);
        parameters.add(columnName);
        if (schema != null && !"".equals(schema)) {
            allSdoSqlStatement = (String)allSdoSqlStatement + " AND INFO.TABLE_OWNER = ?";
            parameters.add(schema);
            allSdoSqlStatement = (String)allSdoSqlStatement + " AND META.SDO_INDEX_OWNER = ?";
            parameters.add(schema);
        }
        return this.readGeometryClassFromStatement(cx, (String)allSdoSqlStatement, parameters);
    }

    private Class lookupGeometryClassOnUserIndex(Connection cx, String tableName, String columnName, String schema) throws SQLException {
        if (!this.canAccessUserViews(cx)) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        Object userSdoSqlStatement = "SELECT META.SDO_LAYER_GTYPE\nFROM ALL_INDEXES INFO\nINNER JOIN MDSYS.USER_SDO_INDEX_METADATA META\nON INFO.INDEX_NAME = META.SDO_INDEX_NAME\nWHERE INFO.TABLE_NAME = ?\nAND REPLACE(meta.sdo_column_name, '\"') = ?\n";
        parameters.add(tableName);
        parameters.add(columnName);
        if (schema != null && !"".equals(schema)) {
            userSdoSqlStatement = (String)userSdoSqlStatement + " AND INFO.TABLE_OWNER = ?";
            parameters.add(schema);
        }
        return this.readGeometryClassFromStatement(cx, (String)userSdoSqlStatement, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class readGeometryClassFromStatement(Connection cx, String sql, List<String> parameters) throws SQLException {
        ResultSet rs;
        PreparedStatement st;
        block4: {
            Class<?> clazz;
            st = null;
            rs = null;
            try {
                LOGGER.log(Level.FINE, "Geometry type check; {0} [ parameters = {1} ]", new Object[]{sql, parameters});
                st = cx.prepareStatement(sql);
                for (int i = 0; i < parameters.size(); ++i) {
                    st.setString(i + 1, parameters.get(i));
                }
                rs = st.executeQuery();
                if (!rs.next()) break block4;
                String gType = rs.getString(1);
                Class<Object> geometryClass = TT.GEOM_CLASSES.get(gType);
                if (geometryClass == null) {
                    LOGGER.fine("Unrecognized geometry type " + gType + " falling back on generic 'GEOMETRY'");
                    geometryClass = Geometry.class;
                }
                clazz = geometryClass;
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            this.dataStore.closeSafe((Statement)st);
            return clazz;
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe((Statement)st);
        return null;
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (tableName.endsWith("$")) {
            return false;
        }
        if (tableName.startsWith("BIN$")) {
            return false;
        }
        if (tableName.startsWith("XDB$")) {
            return false;
        }
        if (tableName.startsWith("DR$")) {
            return false;
        }
        if (tableName.startsWith("DEF$")) {
            return false;
        }
        if (tableName.startsWith("SDO_")) {
            return false;
        }
        if (tableName.startsWith("WM$")) {
            return false;
        }
        if (tableName.startsWith("WK$")) {
            return false;
        }
        if (tableName.startsWith("AW$")) {
            return false;
        }
        if (tableName.startsWith("AQ$")) {
            return false;
        }
        if (tableName.startsWith("APPLY$")) {
            return false;
        }
        if (tableName.startsWith("REPCAT$")) {
            return false;
        }
        if (tableName.startsWith("CWM$")) {
            return false;
        }
        if (tableName.startsWith("CWM2$")) {
            return false;
        }
        if (tableName.startsWith("EXF$")) {
            return false;
        }
        if (tableName.startsWith("DM$")) {
            return false;
        }
        return !tableName.startsWith("MDXT_") || !tableName.endsWith("$_BKTS") && !tableName.endsWith("$_MBR");
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("SDO_GEOMETRY", Geometry.class);
        mappings.put("MDSYS.SDO_GEOMETRY", Geometry.class);
    }

    public String getNameEscape() {
        return "";
    }

    public void encodeColumnName(String prefix, String raw, StringBuffer sql) {
        if (prefix != null && !prefix.isEmpty()) {
            if ((prefix = prefix.toUpperCase()).length() > this.nameLenghtLimit) {
                prefix = prefix.substring(0, this.nameLenghtLimit);
            }
            sql.append(prefix).append(".");
        }
        if (((String)(raw = ((String)raw).toUpperCase())).length() > this.nameLenghtLimit) {
            raw = ((String)raw).substring(0, this.nameLenghtLimit);
        }
        if (((String)raw).contains(" ") || reservedWords.contains(((String)raw).toUpperCase())) {
            raw = "\"" + (String)raw + "\"";
        }
        sql.append((String)raw);
    }

    public void encodeTableName(String raw, StringBuffer sql) {
        if (((String)(raw = ((String)raw).toUpperCase())).length() > this.nameLenghtLimit) {
            raw = ((String)raw).substring(0, this.nameLenghtLimit);
        }
        if (((String)raw).contains(" ")) {
            raw = "\"" + (String)raw + "\"";
        }
        sql.append((String)raw);
    }

    public String getGeometryTypeName(Integer type) {
        return "MDSYS.SDO_GEOMETRY";
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        Geometry geom = this.readGeometry(rs, column, new GeometryFactory(), cx);
        return geom != null ? geom.getEnvelopeInternal() : null;
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        Geometry geom = this.readGeometry(rs, column, factory, cx);
        return this.convertGeometry(geom, descriptor, factory);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        Geometry geom = this.readGeometry(rs, column, factory, cx);
        return this.convertGeometry(geom, descriptor, factory);
    }

    Geometry convertGeometry(Geometry geom, GeometryDescriptor descriptor, GeometryFactory factory) {
        if (geom == null) {
            return null;
        }
        Class targetClazz = descriptor.getType().getBinding();
        if (targetClazz.equals(MultiPolygon.class) && geom instanceof Polygon) {
            return factory.createMultiPolygon(new Polygon[]{(Polygon)geom});
        }
        if (targetClazz.equals(MultiPoint.class) && geom instanceof Point) {
            return factory.createMultiPoint(new Point[]{(Point)geom});
        }
        if (targetClazz.equals(MultiLineString.class) && geom instanceof LineString) {
            return factory.createMultiLineString(new LineString[]{(LineString)geom});
        }
        if (targetClazz.equals(GeometryCollection.class)) {
            return factory.createGeometryCollection(new Geometry[]{geom});
        }
        return geom;
    }

    Geometry readGeometry(ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.readGeometry(rs.getObject(column), factory, cx);
    }

    Geometry readGeometry(ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        return this.readGeometry(rs.getObject(column), factory, cx);
    }

    Geometry readGeometry(Object struct, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        if (struct == null) {
            return null;
        }
        OracleConnection ocx = this.unwrapConnection(cx);
        GeometryConverter converter = factory != null ? new GeometryConverter(ocx, factory) : new GeometryConverter(ocx);
        return converter.asGeometry((OracleStruct)struct);
    }

    public void setGeometryValue(Geometry g, int dimension, int srid, Class binding, PreparedStatement ps, int column) throws SQLException {
        if (g == null || g.isEmpty()) {
            ps.setNull(column, 2002, "MDSYS.SDO_GEOMETRY");
            return;
        }
        OracleConnection ocx = this.unwrapConnection(ps.getConnection());
        GeometryConverter converter = new GeometryConverter(ocx);
        OracleStruct s = converter.toSDO(g, srid);
        ps.setObject(column, s);
        if (LOGGER.isLoggable(Level.FINE)) {
            Object sdo;
            try {
                sdo = SDOSqlDumper.toSDOGeom(g, srid);
            }
            catch (Exception e) {
                sdo = "Could not translate this geometry into a SDO string, WKT representation is: " + g;
            }
            LOGGER.fine("Setting parameter " + column + " as " + (String)sdo);
        }
    }

    OracleConnection unwrapConnection(Connection cx) throws SQLException {
        return (OracleConnection)this.unwrapConnection(cx, OracleConnection.class);
    }

    public FilterToSQL createFilterToSQL() {
        throw new UnsupportedOperationException("This dialect works with prepared statements only");
    }

    public PreparedFilterToSQL createPreparedFilterToSQL() {
        OracleFilterToSQL sql = new OracleFilterToSQL(this);
        sql.setLooseBBOXEnabled(this.looseBBOXEnabled);
        return sql;
    }

    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Integer srid = this.lookupSRIDOnMetadataTable(schemaName, tableName, columnName, cx);
        if (srid == null) {
            srid = this.lookupSRIDFromUserViews(tableName, columnName, cx);
        }
        if (srid == null) {
            srid = this.lookupSRIDFromAllViews(schemaName, tableName, columnName, cx);
        }
        return srid;
    }

    private Integer lookupSRIDOnMetadataTable(String schema, String tableName, String columnName, Connection cx) throws SQLException {
        if (this.geometryMetadataTable == null) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        String metadataTableStatement = "SELECT SRID FROM " + this.geometryMetadataTable + " WHERE F_TABLE_NAME = ? AND F_GEOMETRY_COLUMN = ?";
        parameters.add(tableName);
        parameters.add(columnName);
        if (schema != null && !"".equals(schema)) {
            metadataTableStatement = metadataTableStatement + " AND F_TABLE_SCHEMA = ?";
            parameters.add(schema);
        }
        return this.readIntegerFromStatement(cx, metadataTableStatement, parameters);
    }

    private Integer lookupSRIDFromAllViews(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ArrayList<String> parameters = new ArrayList<String>();
        Object allSdoSql = "SELECT SRID FROM MDSYS.ALL_SDO_GEOM_METADATA WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
        parameters.add(tableName.toUpperCase());
        parameters.add(columnName.toUpperCase());
        if (schemaName != null) {
            allSdoSql = (String)allSdoSql + " AND OWNER=?";
            parameters.add(schemaName);
        }
        return this.readIntegerFromStatement(cx, (String)allSdoSql, parameters);
    }

    private Integer lookupSRIDFromUserViews(String tableName, String columnName, Connection cx) throws SQLException {
        if (!this.canAccessUserViews(cx)) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        String userSdoSql = "SELECT SRID FROM MDSYS.USER_SDO_GEOM_METADATA WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
        parameters.add(tableName.toUpperCase());
        parameters.add(columnName.toUpperCase());
        return this.readIntegerFromStatement(cx, userSdoSql, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer readIntegerFromStatement(Connection cx, String sql, List<String> parameters) throws SQLException {
        ResultSet userSdoResult;
        PreparedStatement userSdoStatement;
        block3: {
            Integer n;
            userSdoStatement = null;
            userSdoResult = null;
            try {
                Object intValue;
                LOGGER.log(Level.FINE, "SRID check; {0} [ parameters = {1} ]", new Object[]{sql, parameters});
                userSdoStatement = cx.prepareStatement(sql);
                for (int i = 0; i < parameters.size(); ++i) {
                    userSdoStatement.setString(i + 1, parameters.get(i));
                }
                userSdoResult = userSdoStatement.executeQuery();
                if (!userSdoResult.next() || (intValue = userSdoResult.getObject(1)) == null) break block3;
                n = ((Number)intValue).intValue();
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(userSdoResult);
                this.dataStore.closeSafe(userSdoStatement);
                throw throwable;
            }
            this.dataStore.closeSafe(userSdoResult);
            this.dataStore.closeSafe((Statement)userSdoStatement);
            return n;
        }
        this.dataStore.closeSafe(userSdoResult);
        this.dataStore.closeSafe((Statement)userSdoStatement);
        return null;
    }

    public int getGeometryDimension(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Integer srid = this.lookupDimensionOnMetadataTable(schemaName, tableName, columnName, cx);
        if (srid == null) {
            srid = this.lookupDimensionFromUserViews(tableName, columnName, cx);
        }
        if (srid == null) {
            srid = this.lookupDimensionFromAllViews(schemaName, tableName, columnName, cx);
        }
        if (srid == null) {
            srid = 2;
        }
        return srid;
    }

    private Integer lookupDimensionOnMetadataTable(String schema, String tableName, String columnName, Connection cx) throws SQLException {
        if (this.geometryMetadataTable == null) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        String metadataTableStatement = "SELECT COORD_DIMENSION FROM " + this.geometryMetadataTable + " WHERE F_TABLE_NAME = ? AND F_GEOMETRY_COLUMN = ?";
        parameters.add(tableName);
        parameters.add(columnName);
        if (schema != null && !"".equals(schema)) {
            metadataTableStatement = metadataTableStatement + " AND F_TABLE_SCHEMA = ?";
            parameters.add(schema);
        }
        return this.readIntegerFromStatement(cx, metadataTableStatement, parameters);
    }

    private Integer lookupDimensionFromAllViews(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        ArrayList<String> parameters = new ArrayList<String>();
        Object allSdoSql = "SELECT DIMINFO FROM MDSYS.ALL_SDO_GEOM_METADATA USGM, table(USGM.DIMINFO) WHERE TABLE_NAME = ? AND COLUMN_NAME= ?";
        parameters.add(tableName.toUpperCase());
        parameters.add(columnName.toUpperCase());
        if (schemaName != null) {
            allSdoSql = (String)allSdoSql + " AND OWNER = ?";
            parameters.add(schemaName);
        }
        return this.readIntegerFromStatement(cx, (String)allSdoSql, parameters);
    }

    private Integer lookupDimensionFromUserViews(String tableName, String columnName, Connection cx) throws SQLException {
        if (!this.canAccessUserViews(cx)) {
            return null;
        }
        ArrayList<String> parameters = new ArrayList<String>();
        String userSdoSql = "SELECT COUNT(*) FROM MDSYS.USER_SDO_GEOM_METADATA USGM, table(USGM.DIMINFO) WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
        parameters.add(tableName.toUpperCase());
        parameters.add(columnName.toUpperCase());
        return this.readIntegerFromStatement(cx, userSdoSql, parameters);
    }

    /*
     * Exception decompiling
     */
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 7[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("SDO_AGGR_MBR(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append(")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        if (this.dataStore.getVirtualTables().get(featureType.getTypeName()) != null) {
            return null;
        }
        if (this.metadataBboxEnabled) {
            String tableName = featureType.getTypeName();
            PreparedStatement st = null;
            ResultSet rs = null;
            ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
            Savepoint savePoint = null;
            try {
                if (!cx.getAutoCommit()) {
                    savePoint = cx.setSavepoint();
                }
                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                    CoordinateReferenceSystem crs;
                    Envelope env;
                    Object sql;
                    if (!(att instanceof GeometryDescriptor)) continue;
                    String columnName = att.getName().getLocalPart();
                    if (this.canAccessUserViews(cx)) {
                        sql = "SELECT DIMINFO FROM MDSYS.USER_SDO_GEOM_METADATA WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
                        st = cx.prepareStatement((String)sql);
                        st.setString(1, tableName.toUpperCase());
                        st.setString(2, columnName.toUpperCase());
                        rs = st.executeQuery();
                        if (rs.next() && (env = this.decodeDiminfoEnvelope(rs, 1)) != null && !env.isNull()) {
                            crs = ((GeometryDescriptor)att).getCoordinateReferenceSystem();
                            result.add(new ReferencedEnvelope(env, crs));
                            rs.close();
                            continue;
                        }
                        this.dataStore.closeSafe(rs);
                        this.dataStore.closeSafe((Statement)st);
                    }
                    sql = "SELECT DIMINFO FROM MDSYS.ALL_SDO_GEOM_METADATA WHERE TABLE_NAME = ? AND COLUMN_NAME = ?";
                    if (schema != null) {
                        sql = (String)sql + " AND OWNER = ?";
                    }
                    st = cx.prepareStatement((String)sql);
                    st.setString(1, tableName.toUpperCase());
                    st.setString(2, columnName.toUpperCase());
                    if (schema != null) {
                        st.setString(3, schema);
                    }
                    if ((rs = st.executeQuery()).next() && (env = this.decodeDiminfoEnvelope(rs, 1)) != null && !env.isNull()) {
                        crs = ((GeometryDescriptor)att).getCoordinateReferenceSystem();
                        result.add(new ReferencedEnvelope(env, crs));
                    }
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe((Statement)st);
                }
            }
            catch (SQLException e) {
                if (savePoint != null) {
                    cx.rollback(savePoint);
                }
                LOGGER.log(Level.WARNING, "Failed to use METADATA DIMINFO, falling back on SDO_TUNE.EXTENT_OF", e);
                List<ReferencedEnvelope> list = this.getOptimizedBoundsSDO_TUNE(schema, featureType, cx);
                return list;
            }
            finally {
                if (savePoint != null) {
                    cx.rollback(savePoint);
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
            }
            return result;
        }
        return this.getOptimizedBoundsSDO_TUNE(schema, featureType, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ReferencedEnvelope> getOptimizedBoundsSDO_TUNE(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        ArrayList<ReferencedEnvelope> result;
        ResultSet rs;
        Statement st;
        block11: {
            if (!this.estimatedExtentsEnabled) {
                return null;
            }
            Object tableName = schema != null && !"".equals(schema) ? schema + "." + featureType.getTypeName() : featureType.getTypeName();
            st = null;
            rs = null;
            result = new ArrayList<ReferencedEnvelope>();
            Savepoint savePoint = null;
            try {
                st = cx.createStatement();
                if (!cx.getAutoCommit()) {
                    savePoint = cx.setSavepoint();
                }
                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                    if (!(att instanceof GeometryDescriptor)) continue;
                    StringBuilder sql = new StringBuilder();
                    sql.append("select SDO_TUNE.EXTENT_OF('");
                    sql.append((String)tableName);
                    sql.append("', '");
                    sql.append(att.getName().getLocalPart());
                    sql.append("') FROM DUAL");
                    LOGGER.log(Level.FINE, "Getting the full extent of the table using optimized search: {0}", sql);
                    rs = st.executeQuery(sql.toString());
                    if (rs.next()) {
                        GeometryDescriptor descriptor = (GeometryDescriptor)att;
                        Geometry geometry = this.readGeometry(rs, 1, new GeometryFactory(), cx);
                        ReferencedEnvelope env = JTS.bounds(geometry, descriptor.getCoordinateReferenceSystem());
                        if (env != null && !env.isNull()) {
                            result.add(env);
                        }
                    }
                    rs.close();
                }
                if (savePoint == null) break block11;
            }
            catch (SQLException e) {
                List<ReferencedEnvelope> list;
                block12: {
                    try {
                        if (savePoint != null) {
                            cx.rollback(savePoint);
                        }
                        LOGGER.log(Level.WARNING, "Failed to use SDO_TUNE.EXTENT_OF, falling back on envelope aggregation", e);
                        list = null;
                        if (savePoint == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (savePoint != null) {
                            cx.rollback(savePoint);
                        }
                        this.dataStore.closeSafe(rs);
                        this.dataStore.closeSafe(st);
                        throw throwable;
                    }
                    cx.rollback(savePoint);
                }
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe(st);
                return list;
            }
            cx.rollback(savePoint);
        }
        this.dataStore.closeSafe(rs);
        this.dataStore.closeSafe(st);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        String tableName = featureType.getName().getLocalPart().toUpperCase();
        Statement st = null;
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                double tolerance;
                String[] axisNames;
                double[] max;
                double[] min;
                int dims;
                if (!(att instanceof GeometryDescriptor)) continue;
                GeometryDescriptor geom = (GeometryDescriptor)att;
                if (geom.getCoordinateReferenceSystem() != null) {
                    CoordinateSystem cs = geom.getCoordinateReferenceSystem().getCoordinateSystem();
                    Object userDims = geom.getUserData().get(Hints.COORDINATE_DIMENSION);
                    dims = userDims != null && ((Number)userDims).intValue() > 0 ? ((Number)userDims).intValue() : cs.getDimension();
                    min = new double[dims];
                    max = new double[dims];
                    axisNames = new String[dims];
                    double extent = Double.MAX_VALUE;
                    for (int i = 0; i < dims; ++i) {
                        if (i < cs.getDimension()) {
                            CoordinateSystemAxis axis = cs.getAxis(i);
                            axisNames[i] = this.getCompatibleAxisName(axis, i);
                            min[i] = Double.isInfinite(axis.getMinimumValue()) ? -1.0E7 : axis.getMinimumValue();
                            double d = max[i] = Double.isInfinite(axis.getMaximumValue()) ? 1.0E7 : axis.getMaximumValue();
                            if (!(max[i] - min[i] < extent)) continue;
                            extent = max[i] - min[i];
                            continue;
                        }
                        min[i] = -1.0E7;
                        max[i] = 1.0E7;
                    }
                    tolerance = extent / 1.0E7;
                } else {
                    dims = 2;
                    axisNames = new String[2];
                    min = new double[2];
                    max = new double[2];
                    axisNames[0] = "X";
                    axisNames[1] = "Y";
                    min[0] = -1.0E7;
                    min[1] = -1.0E7;
                    max[0] = 1.0E7;
                    max[1] = 1.0E7;
                    tolerance = 0.01;
                }
                int srid = -1;
                if (geom.getUserData().get("nativeSRID") != null) {
                    srid = (Integer)geom.getUserData().get("nativeSRID");
                } else if (geom.getCoordinateReferenceSystem() != null) {
                    try {
                        Integer result = CRS.lookupEpsgCode((CoordinateReferenceSystem)geom.getCoordinateReferenceSystem(), (boolean)true);
                        if (result != null) {
                            srid = result;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion, assuming -1", e);
                    }
                }
                String geomColumnName = geom.getLocalName().toUpperCase();
                String sql = "INSERT INTO USER_SDO_GEOM_METADATA(TABLE_NAME, COLUMN_NAME, DIMINFO, SRID)\nVALUES (\n'" + tableName + "',\n'" + geomColumnName + "',\nMDSYS.SDO_DIM_ARRAY(\n";
                for (int i = 0; i < dims; ++i) {
                    sql = sql + "   MDSYS.SDO_DIM_ELEMENT('" + axisNames[i] + "', " + min[i] + ", " + max[i] + ", " + tolerance + ")";
                    if (i < dims - 1) {
                        sql = sql + ", ";
                    }
                    sql = sql + "\n";
                }
                sql = sql + "),\n" + (srid == -1 ? "NULL" : String.valueOf(srid)) + ")";
                LOGGER.log(Level.FINE, "Creating metadata with sql: {0}", sql);
                st.execute(sql);
                int idxDim = this.isGeodeticSrid(srid, cx) ? 2 : dims;
                String type = CLASSES_TO_GEOM.get(geom.getType().getBinding());
                String idxName = tableName + "_" + geomColumnName + "_IDX";
                if (idxName.length() > this.nameLenghtLimit) {
                    idxName = "IDX_" + UUID.randomUUID().toString().replace("-", "").substring(0, 26);
                }
                sql = "CREATE INDEX " + idxName + " ON \"" + tableName + "\"(\"" + geomColumnName + "\") INDEXTYPE IS MDSYS.SPATIAL_INDEX PARAMETERS ('SDO_INDX_DIMS=" + idxDim;
                sql = type != null ? sql + " LAYER_GTYPE=\"" + type + "\"')" : sql + "')";
                LOGGER.log(Level.FINE, "Creating index with sql: {0}", sql);
                st.execute(sql);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    private String getCompatibleAxisName(CoordinateSystemAxis axis, int dimensionIdx) {
        String abbreviation = axis.getAbbreviation();
        if (AXIS_NAME_VALIDATOR.matcher(abbreviation).matches()) {
            return abbreviation;
        }
        String name = axis.getName().getCode();
        if (AXIS_NAME_VALIDATOR.matcher(name).matches()) {
            return name;
        }
        for (GenericName gn : axis.getAlias()) {
            String alias = gn.tip().toString();
            if (!AXIS_NAME_VALIDATOR.matcher(alias).matches()) continue;
            return alias;
        }
        if (CRS.equalsIgnoreMetadata((Object)DefaultCoordinateSystemAxis.LONGITUDE, (Object)axis)) {
            return "Longitude";
        }
        if (CRS.equalsIgnoreMetadata((Object)DefaultCoordinateSystemAxis.LATITUDE, (Object)axis)) {
            return "Latitude";
        }
        if (CRS.equalsIgnoreMetadata((Object)DefaultCoordinateSystemAxis.ALTITUDE, (Object)axis)) {
            return "Altitude";
        }
        return "DIM_" + (dimensionIdx + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sequenceName = (tableName + "_" + columnName + "_%").toUpperCase();
        PreparedStatement st = null;
        try {
            String sql = "SELECT SEQUENCE_NAME FROM USER_SEQUENCES WHERE SEQUENCE_NAME like ?";
            st = cx.prepareStatement(sql);
            st.setString(1, sequenceName);
            ResultSet rs = st.executeQuery();
            try {
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
                this.dataStore.closeSafe((Statement)st);
            }
            sql = "SELECT SEQUENCE_NAME, SEQUENCE_OWNER FROM ALL_SEQUENCES WHERE SEQUENCE_NAME like ?";
            st = cx.prepareStatement(sql);
            st.setString(1, sequenceName);
            rs = st.executeQuery();
            try {
                if (rs.next()) {
                    String schema = rs.getString(2);
                    String string = schema + "." + rs.getString(1);
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe((Statement)st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            Integer n;
            ResultSet rs = st.executeQuery("SELECT " + this.encodeNextSequenceValue(schemaName, sequenceName) + " FROM DUAL");
            try {
                if (!rs.next()) {
                    throw new SQLException("Could not find next sequence value");
                }
                n = rs.getInt(1);
            }
            catch (Throwable throwable) {
                this.dataStore.closeSafe(rs);
                throw throwable;
            }
            this.dataStore.closeSafe(rs);
            return n;
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public String encodeNextSequenceValue(String schemaName, String sequenceName) {
        return sequenceName + ".NEXTVAL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postDropTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        PreparedStatement st = null;
        String tableName = featureType.getTypeName();
        try {
            String sql = "DELETE FROM USER_SDO_GEOM_METADATA WHERE TABLE_NAME = ?";
            st = cx.prepareStatement(sql);
            st.setString(1, tableName);
            LOGGER.log(Level.FINE, "Post drop table: {0} [ TABLE_NAME = {1} ]", new Object[]{sql, tableName});
            st.execute();
        }
        finally {
            this.dataStore.closeSafe((Statement)st);
        }
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected boolean isGeodeticSrid(Integer srid, Connection cx) {
        if (srid == null) {
            return false;
        }
        geodetic = (Boolean)this.geodeticCache.get((Object)srid);
        if (geodetic == null) {
            var4_4 = this;
            synchronized (var4_4) {
                geodetic = (Boolean)this.geodeticCache.get((Object)srid);
                if (geodetic == null) {
                    ps = null;
                    rs = null;
                    closeConnection = false;
                    try {
                        ps = cx.prepareStatement("SELECT COUNT(*) FROM MDSYS.GEODETIC_SRIDS WHERE SRID = ?");
                        ps.setInt(1, srid);
                        rs = ps.executeQuery();
                        rs.next();
                        geodetic = rs.getInt(1) > 0;
                        this.geodeticCache.put((Object)srid, (Object)geodetic);
                    }
                    catch (SQLException e) {
                        try {
                            OracleDialect.LOGGER.log(Level.WARNING, "Could not evaluate if the SRID " + srid + " is geodetic", e);
                        }
                        catch (Throwable var9_9) {
                            this.dataStore.closeSafe(rs);
                            this.dataStore.closeSafe((Statement)ps);
                            if (closeConnection) {
                                this.dataStore.closeSafe(cx);
                            }
                            throw var9_9;
                        }
                        this.dataStore.closeSafe(rs);
                        this.dataStore.closeSafe((Statement)ps);
                        if (closeConnection) {
                            this.dataStore.closeSafe(cx);
                        } else {
                            ** GOTO lbl41
                        }
                    }
                    this.dataStore.closeSafe(rs);
                    this.dataStore.closeSafe((Statement)ps);
                    if (closeConnection) {
                        this.dataStore.closeSafe(cx);
                    }
                }
            }
        }
        return geodetic != null ? geodetic : false;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (offset == 0) {
            sql.insert(0, "SELECT * FROM (");
            sql.append(") WHERE ROWNUM <= " + limit);
        } else {
            long max = limit == Integer.MAX_VALUE ? Long.MAX_VALUE : (long)(limit + offset);
            sql.insert(0, "SELECT * FROM (SELECT A.*, ROWNUM RNUM FROM ( ");
            sql.append(") A WHERE ROWNUM <= " + max + ")");
            sql.append("WHERE RNUM > " + offset);
        }
    }

    public void encodeTableAlias(String raw, StringBuffer sql) {
        sql.append(" ");
        this.encodeTableName(raw, sql);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        super.registerSqlTypeToSqlTypeNameOverrides(overrides);
        overrides.put(7, "DOUBLE PRECISION");
        overrides.put(8, "DOUBLE PRECISION");
        overrides.put(6, "FLOAT");
        overrides.put(91, "DATE");
        overrides.put(93, "TIMESTAMP");
    }

    public void postCreateAttribute(AttributeDescriptor att, String tableName, String schemaName, Connection cx) throws SQLException {
        super.postCreateAttribute(att, tableName, schemaName, cx);
        if (att instanceof GeometryDescriptor) {
            Integer srid = (Integer)att.getUserData().get("nativeSRID");
            boolean geodetic = this.isGeodeticSrid(srid, cx);
            att.getUserData().put(GEODETIC, geodetic);
        }
    }

    public String getGeometryMetadataTable() {
        return this.geometryMetadataTable;
    }

    public void setGeometryMetadataTable(String geometryMetadataTable) {
        this.geometryMetadataTable = geometryMetadataTable;
    }

    public void setMetadataBboxEnabled(boolean metadataBboxEnabled) {
        this.metadataBboxEnabled = metadataBboxEnabled;
    }

    private Envelope decodeDiminfoEnvelope(ResultSet rs, int column) throws SQLException {
        Array returnArray = rs.getArray(column);
        if (returnArray == null) {
            throw new SQLException("no data inside the specified column");
        }
        Object[] data = (Object[])returnArray.getArray();
        if (data.length < 2) {
            throw new SQLException("too little dimension information found in sdo_geom_metadata");
        }
        Object[] xInfo = ((Struct)data[0]).getAttributes();
        Object[] yInfo = ((Struct)data[1]).getAttributes();
        Double minx = ((Number)xInfo[1]).doubleValue();
        Double maxx = ((Number)xInfo[2]).doubleValue();
        Double miny = ((Number)yInfo[1]).doubleValue();
        Double maxy = ((Number)yInfo[2]).doubleValue();
        returnArray.free();
        return new Envelope(minx.doubleValue(), maxx.doubleValue(), miny.doubleValue(), maxy.doubleValue());
    }

    public int getDefaultVarcharSize() {
        return 4000;
    }

    static {
        String[] words = new String[]{"ACCESS", "ACCOUNT", "ACTIVATE", "ADD", "ADMIN", "ADVISE", "AFTER", "ALL", "ALL_ROWS", "ALLOCATE", "ALTER", "ANALYZE", "AND", "ANY", "ARCHIVE", "ARCHIVELOG", "ARRAY", "AS", "ASC", "AT", "AUDIT", "AUTHENTICATED", "AUTHORIZATION", "AUTOEXTEND", "AUTOMATIC", "BACKUP", "BECOME", "BEFORE", "BEGIN", "BETWEEN", "BFILE", "BITMAP", "BLOB", "BLOCK", "BODY", "BY", "CACHE", "CACHE_INSTANCES", "CANCEL", "CASCADE", "CAST", "CFILE", "CHAINED", "CHANGE", "CHAR", "CHAR_CS", "CHARACTER", "CHECK", "CHECKPOINT", "CHOOSE", "CHUNK", "CLEAR", "CLOB", "CLONE", "CLOSE", "CLOSE_CACHED_OPEN_CURSORS", "CLUSTER", "COALESCE", "COLUMN", "COLUMNS", "COMMENT", "COMMIT", "COMMITTED", "COMPATIBILITY", "COMPILE", "COMPLETE", "COMPOSITE_LIMIT", "COMPRESS", "COMPUTE", "CONNECT", "CONNECT_TIME", "CONSTRAINT", "CONSTRAINTS", "CONTENTS", "CONTINUE", "CONTROLFILE", "CONVERT", "COST", "CPU_PER_CALL", "CPU_PER_SESSION", "CREATE", "CURRENT", "CURRENT_SCHEMA", "CURREN_USER", "CURSOR", "CYCLE", "DANGLING", "DATABASE", "DATAFILE", "DATAFILES", "DATAOBJNO", "DATE", "DBA", "DBHIGH", "DBLOW", "DBMAC", "DEALLOCATE", "DEBUG", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DEGREE", "DELETE", "DEREF", "DESC", "DIRECTORY", "DISABLE", "DISCONNECT", "DISMOUNT", "DISTINCT", "DISTRIBUTED", "DML", "DOUBLE", "DROP", "DUMP", "EACH", "ELSE", "ENABLE", "END", "ENFORCE", "ENTRY", "ESCAPE", "EXCEPT", "EXCEPTIONS", "EXCHANGE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", "EXPIRE", "EXPLAIN", "EXTENT", "EXTENTS", "EXTERNALLY", "FAILED_LOGIN_ATTEMPTS", "FALSE", "FAST", "FILE", "FIRST_ROWS", "FLAGGER", "FLOAT", "FLOB", "FLUSH", "FOR", "FORCE", "FOREIGN", "FREELIST", "FREELISTS", "FROM", "FULL", "FUNCTION", "GLOBAL", "GLOBALLY", "GLOBAL_NAME", "GRANT", "GROUP", "GROUPS", "HASH", "HASHKEYS", "HAVING", "HEADER", "HEAP", "IDENTIFIED", "IDGENERATORS", "IDLE_TIME", "IF", "IMMEDIATE", "IN", "INCLUDING", "INCREMENT", "INDEX", "INDEXED", "INDEXES", "INDICATOR", "IND_PARTITION", "INITIAL", "INITIALLY", "INITRANS", "INSERT", "INSTANCE", "INSTANCES", "INSTEAD", "INT", "INTEGER", "INTERMEDIATE", "INTERSECT", "INTO", "IS", "ISOLATION", "ISOLATION_LEVEL", "KEEP", "KEY", "KILL", "LABEL", "LAYER", "LESS", "LEVEL", "LIBRARY", "LIKE", "LIMIT", "LINK", "LIST", "LOB", "LOCAL", "LOCK", "LOCKED", "LOG", "LOGFILE", "LOGGING", "LOGICAL_READS_PER_CALL", "LOGICAL_READS_PER_SESSION", "LONG", "MANAGE", "MASTER", "MAX", "MAXARCHLOGS", "MAXDATAFILES", "MAXEXTENTS", "MAXINSTANCES", "MAXLOGFILES", "MAXLOGHISTORY", "MAXLOGMEMBERS", "MAXSIZE", "MAXTRANS", "MAXVALUE", "MIN", "MEMBER", "MINIMUM", "MINEXTENTS", "MINUS", "MINVALUE", "MLSLABEL", "MLS_LABEL_FORMAT", "MODE", "MODIFY", "MOUNT", "MOVE", "MTS_DISPATCHERS", "MULTISET", "NATIONAL", "NCHAR", "NCHAR_CS", "NCLOB", "NEEDED", "NESTED", "NETWORK", "NEW", "NEXT", "NOARCHIVELOG", "NOAUDIT", "NOCACHE", "NOCOMPRESS", "NOCYCLE", "NOFORCE", "NOLOGGING", "NOMAXVALUE", "NOMINVALUE", "NONE", "NOORDER", "NOOVERRIDE", "NOPARALLEL", "NOPARALLEL", "NOREVERSE", "NORMAL", "NOSORT", "NOT", "NOTHING", "NOWAIT", "NULL", "NUMBER", "NUMERIC", "NVARCHAR2", "OBJECT", "OBJNO", "OBJNO_REUSE", "OF", "OFF", "OFFLINE", "OID", "OIDINDEX", "OLD", "ON", "ONLINE", "ONLY", "OPCODE", "OPEN", "OPTIMAL", "OPTIMIZER_GOAL", "OPTION", "OR", "ORDER", "ORGANIZATION", "OSLABEL", "OVERFLOW", "OWN", "PACKAGE", "PARALLEL", "PARTITION", "PASSWORD", "PASSWORD_GRACE_TIME", "PASSWORD_LIFE_TIME", "PASSWORD_LOCK_TIME", "PASSWORD_REUSE_MAX", "PASSWORD_REUSE_TIME", "PASSWORD_VERIFY_FUNCTION", "PCTFREE", "PCTINCREASE", "PCTTHRESHOLD", "PCTUSED", "PCTVERSION", "PERCENT", "PERMANENT", "PLAN", "PLSQL_DEBUG", "POST_TRANSACTION", "PRECISION", "PRESERVE", "PRIMARY", "PRIOR", "PRIVATE", "PRIVATE_SGA", "PRIVILEGE", "PRIVILEGES", "PROCEDURE", "PROFILE", "PUBLIC", "PURGE", "QUEUE", "QUOTA", "RANGE", "RAW", "RBA", "READ", "READUP", "REAL", "REBUILD", "RECOVER", "RECOVERABLE", "RECOVERY", "REF", "REFERENCES", "REFERENCING", "REFRESH", "RENAME", "REPLACE", "RESET", "RESETLOGS", "RESIZE", "RESOURCE", "RESTRICTED", "RETURN", "RETURNING", "REUSE", "REVERSE", "REVOKE", "ROLE", "ROLES", "ROLLBACK", "ROW", "ROWID", "ROWNUM", "ROWS", "RULE", "SAMPLE", "SAVEPOINT", "SB4", "SCAN_INSTANCES", "SCHEMA", "SCN", "SCOPE", "SD_ALL", "SD_INHIBIT", "SD_SHOW", "SEGMENT", "SEG_BLOCK", "SEG_FILE", "SELECT", "SEQUENCE", "SERIALIZABLE", "SESSION", "SESSION_CACHED_CURSORS", "SESSIONS_PER_USER", "SET", "SHARE", "SHARED", "SHARED_POOL", "SHRINK", "SIZE", "SKIP", "SKIP_UNUSABLE_INDEXES", "SMALLINT", "SNAPSHOT", "SOME", "SORT", "SPECIFICATION", "SPLIT", "SQL_TRACE", "STANDBY", "START", "STATEMENT_ID", "STATISTICS", "STOP", "STORAGE", "STORE", "STRUCTURE", "SUCCESSFUL", "SWITCH", "SYS_OP_ENFORCE_NOT_NULL$", "SYS_OP_NTCIMG$", "SYNONYM", "SYSDATE", "SYSDBA", "SYSOPER", "SYSTEM", "TABLE", "TABLES", "TABLESPACE", "TABLESPACE_NO", "TABNO", "TEMPORARY", "THAN", "THE", "THEN", "THREAD", "TIMESTAMP", "TIME", "TO", "TOPLEVEL", "TRACE", "TRACING", "TRANSACTION", "TRANSITIONAL", "TRIGGER", "TRIGGERS", "TRUE", "TRUNCATE", "TX", "TYPE", "UB2", "UBA", "UID", "UNARCHIVED", "UNDO", "UNION", "UNIQUE", "UNLIMITED", "UNLOCK", "UNRECOVERABLE", "UNTIL", "UNUSABLE", "UNUSED", "UPDATABLE", "UPDATE", "USAGE", "USE", "USER", "USING", "VALIDATE", "VALIDATION", "VALUE", "VALUES", "VARCHAR", "VARCHAR2", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WITH", "WITHOUT", "WORK", "WRITE", "WRITEDOWN", "WRITEUP", "XID", "YEAR", "ZONE"};
        reservedWords.addAll(Arrays.asList(words));
    }

    static final class GeomClasses
    extends HashMap<Class, String> {
        private static final long serialVersionUID = -3359664692996608331L;

        public GeomClasses() {
            this.put(Point.class, "POINT");
            this.put(LineString.class, "LINE");
            this.put(LinearRing.class, "LINE");
            this.put(Polygon.class, "POLYGON");
            this.put(GeometryCollection.class, "COLLECTION");
            this.put(MultiPoint.class, "MULTIPOINT");
            this.put(MultiLineString.class, "MULTILINE");
            this.put(MultiPolygon.class, "MULTIPOLYGON");
        }
    }
}

