/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.awt.RenderingHints;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.FeatureListener;
import org.geotools.api.data.FeatureLock;
import org.geotools.api.data.FeatureLockException;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.ResourceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.filter.sort.SortBy;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.util.ProgressListener;
import org.geotools.data.DataUtilities;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.crs.ForceCoordinateSystemFeatureReader;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.sort.SortedFeatureReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureCollection;
import org.geotools.data.store.ContentState;
import org.geotools.data.store.DiffTransactionState;
import org.geotools.data.util.NullProgressListener;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.factory.Hints;

public abstract class ContentFeatureSource
implements SimpleFeatureSource {
    protected ContentEntry entry;
    protected Transaction transaction;
    protected FeatureLock lock = FeatureLock.TRANSACTION;
    protected Set<Hints.Key> hints;
    protected Query query;
    protected SimpleFeatureType schema;
    protected QueryCapabilities queryCapabilities;

    public ContentFeatureSource(ContentEntry entry, Query query) {
        this.entry = entry;
        this.query = query;
        this.hints = new HashSet<Hints.Key>();
        this.hints.add((Hints.Key)Hints.JTS_GEOMETRY_FACTORY);
        this.hints.add((Hints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
        this.addHints(this.hints);
        this.hints = Collections.unmodifiableSet(this.hints);
    }

    public ContentEntry getEntry() {
        return this.entry;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public ContentState getState() {
        return this.entry.getState(this.transaction);
    }

    public ContentDataStore getDataStore() {
        return this.entry.getDataStore();
    }

    public final boolean isView() {
        return this.query != null && this.query != Query.ALL;
    }

    @Override
    public ResourceInfo getInfo() {
        return new ResourceInfo(){
            final Set<String> words = new HashSet<String>();
            {
                this.words.add("features");
                this.words.add(ContentFeatureSource.this.getSchema().getTypeName());
            }

            @Override
            public ReferencedEnvelope getBounds() {
                try {
                    return ContentFeatureSource.this.getBounds();
                }
                catch (IOException e) {
                    return null;
                }
            }

            @Override
            public CoordinateReferenceSystem getCRS() {
                return ContentFeatureSource.this.getSchema().getCoordinateReferenceSystem();
            }

            @Override
            public String getDescription() {
                return null;
            }

            @Override
            public Set<String> getKeywords() {
                return this.words;
            }

            @Override
            public String getName() {
                return ContentFeatureSource.this.getSchema().getTypeName();
            }

            @Override
            public URI getSchema() {
                Name name = ContentFeatureSource.this.getSchema().getName();
                try {
                    URI namespace = new URI(name.getNamespaceURI());
                    return namespace;
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            @Override
            public String getTitle() {
                Name name = ContentFeatureSource.this.getSchema().getName();
                return name.getLocalPart();
            }
        };
    }

    @Override
    public Name getName() {
        return this.getSchema().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SimpleFeatureType getSchema() {
        if (this.schema != null) {
            return this.schema;
        }
        SimpleFeatureType featureType = this.getAbsoluteSchema();
        if (this.query != null && this.query.getPropertyNames() != Query.ALL_NAMES) {
            ContentFeatureSource contentFeatureSource = this;
            synchronized (contentFeatureSource) {
                if (this.schema == null) {
                    this.schema = SimpleFeatureTypeBuilder.retype(featureType, this.query.getPropertyNames());
                }
            }
            return this.schema;
        }
        return featureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final SimpleFeatureType getAbsoluteSchema() {
        ContentState state = this.entry.getState(this.transaction);
        SimpleFeatureType featureType = state.getFeatureType();
        if (featureType == null) {
            ContentState contentState = state;
            synchronized (contentState) {
                if (featureType == null) {
                    try {
                        featureType = this.buildFeatureType();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    state.setFeatureType(featureType);
                }
            }
        }
        return featureType;
    }

    @Override
    public final ReferencedEnvelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    @Override
    public final ReferencedEnvelope getBounds(Query query) throws IOException {
        ReferencedEnvelope bounds;
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        if (!this.canTransact() && this.transaction != null && this.transaction != Transaction.AUTO_COMMIT) {
            BoundingBox fb;
            DiffTransactionState state = (DiffTransactionState)this.getTransaction().getState(this.getEntry());
            Diff diff = state.getDiff();
            Iterator<String> i = diff.getModified().keySet().iterator();
            FilterFactory ff = CommonFactoryFinder.getFilterFactory();
            HashSet<FeatureId> modifiedFids = new HashSet<FeatureId>();
            while (i.hasNext()) {
                String featureId = i.next();
                modifiedFids.add(ff.featureId(featureId));
            }
            Query q = new Query(query);
            if (!modifiedFids.isEmpty()) {
                Not skipFilter = ff.not((Filter)ff.id(modifiedFids));
                q.setFilter((Filter)ff.and((Filter)skipFilter, query.getFilter()));
            }
            bounds = this.getBoundsInternal(q);
            for (SimpleFeature feature : diff.getAdded().values()) {
                fb = feature.getBounds();
                if (fb == null) continue;
                if (bounds == null) {
                    bounds = ReferencedEnvelope.reference((Bounds)fb);
                    continue;
                }
                bounds.expandToInclude(ReferencedEnvelope.reference((Bounds)fb));
            }
            for (SimpleFeature feature : diff.getModified().values()) {
                if (feature == Diff.NULL || (fb = feature.getBounds()) == null) continue;
                if (bounds == null) {
                    bounds = ReferencedEnvelope.reference((Bounds)fb);
                    continue;
                }
                bounds.expandToInclude(ReferencedEnvelope.reference((Bounds)fb));
            }
        } else {
            bounds = this.getBoundsInternal(query);
        }
        if (!this.canReproject()) {
            CoordinateReferenceSystem sourceCRS = query.getCoordinateSystem();
            CoordinateReferenceSystem targetCRS = query.getCoordinateSystemReproject();
            CoordinateReferenceSystem nativeCRS = this.getSchema().getCoordinateReferenceSystem();
            if (sourceCRS != null && !sourceCRS.equals(nativeCRS)) {
                bounds = new ReferencedEnvelope(bounds, sourceCRS);
            } else {
                sourceCRS = nativeCRS;
            }
            if (targetCRS != null) {
                if (sourceCRS == null) {
                    throw new IOException("Cannot reproject data, the source CRS is not available");
                }
                if (!sourceCRS.equals(targetCRS)) {
                    try {
                        bounds = bounds.transform(targetCRS, true);
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        throw (IOException)new IOException("Error occurred trying to reproject data").initCause(e);
                    }
                }
            }
        }
        return bounds;
    }

    protected abstract ReferencedEnvelope getBoundsInternal(Query var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getCount(Query query) throws IOException {
        int offset;
        query = this.joinQuery(query);
        int count = this.getCountInternal(query = this.resolvePropertyNames(query));
        if (count < 0) {
            return count;
        }
        if (!this.canTransact() && this.transaction != null && this.transaction != Transaction.AUTO_COMMIT) {
            Diff diff;
            DiffTransactionState state = (DiffTransactionState)this.getTransaction().getState(this.getEntry());
            Diff diff2 = diff = state.getDiff();
            synchronized (diff2) {
                Iterator<SimpleFeature> it = diff.getAdded().values().iterator();
                Filter filter = query.getFilter();
                while (it.hasNext()) {
                    SimpleFeature feature = it.next();
                    if (!filter.evaluate((Object)feature)) continue;
                    ++count;
                }
                it = diff.getModified().values().iterator();
                FilterFactory ff = CommonFactoryFinder.getFilterFactory();
                HashSet<FeatureId> modifiedFids = new HashSet<FeatureId>();
                int modifiedPostCount = 0;
                while (it.hasNext()) {
                    SimpleFeature feature = it.next();
                    if (feature == Diff.NULL) {
                        --count;
                        continue;
                    }
                    modifiedFids.add(ff.featureId(feature.getID()));
                    if (!filter.evaluate((Object)feature)) continue;
                    ++modifiedPostCount;
                }
                if (!modifiedFids.isEmpty()) {
                    Id idFilter = ff.id(modifiedFids);
                    Query q = new Query(query);
                    q.setFilter((Filter)ff.and((Filter)idFilter, query.getFilter()));
                    int modifiedPreCount = this.getCountInternal(q);
                    if (modifiedPreCount == -1) {
                        return -1;
                    }
                    count = count + modifiedPostCount - modifiedPreCount;
                }
            }
        }
        int n = offset = query.getStartIndex() != null ? query.getStartIndex() : 0;
        if (!this.canOffset() && offset > 0) {
            count = Math.max(0, count - offset);
        }
        if (!this.canLimit() && query.getMaxFeatures() != -1 && query.getMaxFeatures() < Integer.MAX_VALUE) {
            count = Math.min(query.getMaxFeatures(), count);
        }
        return count;
    }

    protected abstract int getCountInternal(Query var1) throws IOException;

    @Override
    public final ContentFeatureCollection getFeatures() throws IOException {
        Query query = this.joinQuery(Query.ALL);
        return new ContentFeatureCollection(this, query);
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader() throws IOException {
        return this.getReader(Query.ALL);
    }

    @Override
    public final ContentFeatureCollection getFeatures(Query query) throws IOException {
        query = this.joinQuery(query);
        return new ContentFeatureCollection(this, query);
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader(Query query) throws IOException {
        int offset;
        SimpleFeatureType target;
        FeatureReader<SimpleFeatureType, SimpleFeature> reader;
        boolean postRetypeRequired;
        query = this.joinQuery(query);
        if ((query = this.resolvePropertyNames(query)).getStartIndex() != null && (query.getSortBy() == null || query.getSortBy().length == 0)) {
            Query dq = new Query(query);
            dq.setSortBy(SortBy.NATURAL_ORDER);
            query = dq;
        }
        if (!query.getJoins().isEmpty() && this.getQueryCapabilities().isJoiningSupported()) {
            throw new IOException("Feature source does not support joins");
        }
        boolean bl = postRetypeRequired = !this.canSort() && this.canRetype() && query.getSortBy() != null && query.getPropertyNames() != Query.ALL_NAMES;
        if (postRetypeRequired) {
            Set<String> sortProperties;
            ArrayList<String> requestedProperties = new ArrayList<String>(Arrays.asList(query.getPropertyNames()));
            if (requestedProperties.containsAll(sortProperties = this.getSortPropertyNames(query.getSortBy()))) {
                reader = this.getReaderInternal(query);
            } else {
                Query loadingQuery = new Query(query);
                sortProperties.removeAll(requestedProperties);
                requestedProperties.addAll(sortProperties);
                loadingQuery.setPropertyNames(requestedProperties);
                reader = this.getReaderInternal(loadingQuery);
            }
        } else {
            reader = this.getReaderInternal(query);
        }
        if (!this.canTransact() && this.transaction != null && this.transaction != Transaction.AUTO_COMMIT) {
            DiffTransactionState state = (DiffTransactionState)this.getTransaction().getState(this.getEntry());
            reader = new DiffFeatureReader<SimpleFeatureType, SimpleFeature>(reader, state.getDiff(), query.getFilter());
        }
        if (!this.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
            reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(reader, query.getFilter());
        }
        if (query.getSortBy() != null && query.getSortBy().length != 0 && !this.canSort()) {
            reader = new SortedFeatureReader(DataUtilities.simple(reader), query);
        }
        if (!(this.canRetype() && !postRetypeRequired || query.getPropertyNames() == Query.ALL_NAMES || (target = SimpleFeatureTypeBuilder.retype(reader.getFeatureType(), query.getPropertyNames())).equals(reader.getFeatureType()))) {
            reader = new ReTypeFeatureReader(reader, target, false);
        }
        int n = offset = query.getStartIndex() != null ? query.getStartIndex() : 0;
        if (!this.canOffset() && offset > 0) {
            for (int i = 0; i < offset && reader.hasNext(); ++i) {
                reader.next();
            }
        }
        if (!this.canLimit() && query.getMaxFeatures() != -1 && query.getMaxFeatures() < Integer.MAX_VALUE) {
            reader = new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(reader, query.getMaxFeatures());
        }
        if (!this.canReproject()) {
            CoordinateReferenceSystem sourceCRS = query.getCoordinateSystem();
            CoordinateReferenceSystem targetCRS = query.getCoordinateSystemReproject();
            CoordinateReferenceSystem nativeCRS = reader.getFeatureType().getCoordinateReferenceSystem();
            if (sourceCRS != null && !sourceCRS.equals(nativeCRS)) {
                try {
                    reader = new ForceCoordinateSystemFeatureReader(reader, sourceCRS);
                }
                catch (SchemaException e) {
                    throw (IOException)new IOException("Error occurred trying to force CRS").initCause(e);
                }
            } else {
                sourceCRS = nativeCRS;
            }
            if (targetCRS != null) {
                if (sourceCRS == null) {
                    throw new IOException("Cannot reproject data, the source CRS is not available");
                }
                if (FeatureTypes.shouldReproject(reader.getFeatureType(), targetCRS)) {
                    try {
                        reader = new ReprojectFeatureReader(reader, targetCRS);
                    }
                    catch (Exception e) {
                        if (e instanceof IOException) {
                            throw (IOException)e;
                        }
                        throw (IOException)new IOException("Error occurred trying to reproject data").initCause(e);
                    }
                }
            }
        }
        return reader;
    }

    private Set<String> getSortPropertyNames(SortBy ... sortBy) {
        HashSet<String> result = new HashSet<String>();
        for (SortBy sort : sortBy) {
            PropertyName p = sort.getPropertyName();
            if (p == null || p.getPropertyName() == null) continue;
            result.add(p.getPropertyName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void accepts(Query query, FeatureVisitor visitor, ProgressListener progress) throws IOException {
        query = DataUtilities.simplifyFilter(query);
        if (progress == null) {
            progress = new NullProgressListener();
        }
        if (this.handleVisitor(query, visitor)) {
            return;
        }
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(query);){
            float size = progress instanceof NullProgressListener ? 0.0f : (float)this.getCount(query);
            float position = 0.0f;
            progress.started();
            while (reader.hasNext()) {
                SimpleFeature feature = null;
                if (size > 0.0f) {
                    float f = position;
                    position = f + 1.0f;
                    progress.progress(f / size);
                }
                try {
                    feature = reader.next();
                    visitor.visit((Feature)feature);
                }
                catch (IOException erp) {
                    progress.exceptionOccurred((Throwable)erp);
                    throw erp;
                }
                catch (Exception unexpected) {
                    progress.exceptionOccurred((Throwable)unexpected);
                    String fid = feature == null ? "feature" : feature.getIdentifier().toString();
                    throw new IOException("Problem visiting " + query.getTypeName() + " visiting " + fid + ":" + unexpected, unexpected);
                    return;
                }
            }
        }
        finally {
            progress.complete();
        }
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return false;
    }

    protected abstract FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query var1) throws IOException;

    protected boolean canReproject() {
        return false;
    }

    protected boolean canLimit() {
        return false;
    }

    protected boolean canOffset() {
        return false;
    }

    protected boolean canFilter() {
        return false;
    }

    protected boolean canRetype() {
        return false;
    }

    protected boolean canSort() {
        return false;
    }

    protected boolean canTransact() {
        return false;
    }

    protected boolean canEvent() {
        return false;
    }

    public final ContentFeatureSource getView(Query query) throws IOException {
        query = this.joinQuery(query);
        query = this.resolvePropertyNames(query);
        Class<?> clazz = this.getClass();
        try {
            Constructor<?> c = clazz.getConstructor(ContentEntry.class, Query.class);
            ContentFeatureSource source = (ContentFeatureSource)c.newInstance(this.getEntry(), query);
            source.setTransaction(this.transaction);
            return source;
        }
        catch (Exception e) {
            String msg = "Subclass must implement Constructor(ContentEntry,Query)";
            throw (IOException)new IOException(msg).initCause(e);
        }
    }

    @Override
    public final ContentFeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new Query(this.getSchema().getTypeName(), filter));
    }

    public final FeatureReader<SimpleFeatureType, SimpleFeature> getReader(Filter filter) throws IOException {
        return this.getReader(new Query(this.getSchema().getTypeName(), filter));
    }

    public final ContentFeatureSource getView(Filter filter) throws IOException {
        return this.getView(new Query(this.getSchema().getTypeName(), filter));
    }

    @Override
    public final void addFeatureListener(FeatureListener listener) {
        this.entry.getState(this.transaction).addListener(listener);
    }

    @Override
    public final void removeFeatureListener(FeatureListener listener) {
        this.entry.getState(this.transaction).removeListener(listener);
    }

    @Override
    public final Set<RenderingHints.Key> getSupportedHints() {
        return this.hints;
    }

    protected void addHints(Set<Hints.Key> hints) {
    }

    protected Query joinQuery(Query query) {
        return DataUtilities.mixQueries(this.query, query, null);
    }

    protected Query resolvePropertyNames(Query query) {
        return DataUtilities.resolvePropertyNames(query, this.getSchema());
    }

    protected Filter resolvePropertyNames(Filter filter) {
        return DataUtilities.resolvePropertyNames(filter, this.getSchema());
    }

    protected abstract SimpleFeatureType buildFeatureType() throws IOException;

    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities();
    }

    @Override
    public QueryCapabilities getQueryCapabilities() {
        if (this.queryCapabilities == null) {
            this.queryCapabilities = this.buildQueryCapabilities();
        }
        return new QueryCapabilities(){

            @Override
            public boolean isOffsetSupported() {
                return true;
            }

            @Override
            public boolean supportsSorting(SortBy[] sortAttributes) {
                if (ContentFeatureSource.this.queryCapabilities.supportsSorting(sortAttributes)) {
                    return true;
                }
                return SortedFeatureReader.canSort(ContentFeatureSource.this.getSchema(), sortAttributes);
            }

            @Override
            public boolean isReliableFIDSupported() {
                return ContentFeatureSource.this.queryCapabilities.isReliableFIDSupported();
            }

            @Override
            public boolean isUseProvidedFIDSupported() {
                return ContentFeatureSource.this.queryCapabilities.isUseProvidedFIDSupported();
            }
        };
    }

    public final void setFeatureLock(FeatureLock lock) {
        if (this.canLock()) {
            lock = this.processLock(lock);
        }
        this.lock = lock;
    }

    public final int lockFeatures() throws IOException {
        return this.lockFeatures((Filter)Filter.INCLUDE);
    }

    public final int lockFeatures(Query query) throws IOException {
        return this.lockFeatures(query.getFilter());
    }

    public final int lockFeatures(Filter filter) throws IOException {
        Logger logger = this.getDataStore().getLogger();
        String typeName = this.getSchema().getTypeName();
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(filter);){
            int locked = 0;
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                try {
                    if (this.canLock()) {
                        this.doLockInternal(typeName, feature);
                    } else {
                        this.getDataStore().getLockingManager().lockFeatureID(typeName, feature.getID(), this.transaction, this.lock);
                    }
                    logger.fine("Locked feature: " + feature.getID());
                    ++locked;
                }
                catch (FeatureLockException e) {
                    String msg = "Unable to lock feature:" + feature.getID() + ". Change logging to FINEST for stack trace";
                    logger.fine(msg);
                    logger.log(Level.FINEST, "Unable to lock feature: " + feature.getID(), e);
                }
            }
            int n = locked;
            return n;
        }
    }

    public final void unLockFeatures() throws IOException {
        this.unLockFeatures((Filter)Filter.INCLUDE);
    }

    public final void unLockFeatures(Query query) throws IOException {
        this.unLockFeatures(query.getFilter());
    }

    public final void unLockFeatures(Filter filter) throws IOException {
        filter = this.resolvePropertyNames(filter);
        String typeName = this.getSchema().getTypeName();
        try (FeatureReader<SimpleFeatureType, SimpleFeature> reader = this.getReader(filter);){
            while (reader.hasNext()) {
                SimpleFeature feature = reader.next();
                if (this.canLock()) {
                    this.doUnlockInternal(typeName, feature);
                    continue;
                }
                this.getDataStore().getLockingManager().unLockFeatureID(typeName, feature.getID(), this.transaction, this.lock);
            }
        }
    }

    protected boolean canLock() {
        return false;
    }

    protected FeatureLock processLock(FeatureLock lock) {
        return lock;
    }

    protected void doLockInternal(String typeName, SimpleFeature feature) throws IOException {
        throw new UnsupportedOperationException("native locking not implemented");
    }

    protected void doUnlockInternal(String typeName, SimpleFeature feature) throws IOException {
        throw new UnsupportedOperationException("native locking not implemented");
    }
}

