/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.HashMap;
import java.util.Map;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.capability.FilterCapabilities;
import org.geotools.api.filter.capability.GeometryOperand;
import org.geotools.api.filter.capability.TemporalOperators;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.filter.capability.ArithmeticOperatorsImpl;
import org.geotools.filter.capability.ComparisonOperatorsImpl;
import org.geotools.filter.capability.FilterCapabilitiesImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.capability.FunctionsImpl;
import org.geotools.filter.capability.OperatorImpl;
import org.geotools.filter.capability.SpatialOperatorImpl;
import org.geotools.filter.capability.SpatialOperatorsImpl;
import org.geotools.filter.capability.TemporalOperatorImpl;
import org.geotools.filter.visitor.IsFullySupportedFilterVisitor;
import org.geotools.filter.visitor.IsSupportedFilterVisitor;
import org.geotools.filter.visitor.OperatorNameFilterVisitor;

public class Capabilities {
    private static Map<Class<?>, String> scalarNames = new HashMap();
    private static Map<Class<?>, String> spatialNames;
    private static Map<Class<?>, String> temporalNames;
    private static Map<Class<?>, String> logicalNames;
    private static Map<Class<?>, String> filterNames;
    private static Map<Class<? extends Expression>, String> arithmaticNames;
    private static Map<Class<? extends Expression>, String> exprNames;
    private static final OperatorNameFilterVisitor operationNameVisitor;
    public static Capabilities LOGICAL;
    public static Capabilities LOGICAL_OPENGIS;
    public static Capabilities SIMPLE_COMPARISONS;
    public static Capabilities SIMPLE_COMPARISONS_OPENGIS;
    IsSupportedFilterVisitor supportedVisitor;
    IsFullySupportedFilterVisitor fullySupportedVisitor;
    FilterCapabilitiesImpl contents;

    public Capabilities() {
        this(new FilterCapabilitiesImpl());
    }

    public Capabilities(FilterCapabilities contents) {
        this.contents = contents instanceof FilterCapabilitiesImpl ? (FilterCapabilitiesImpl)contents : new FilterCapabilitiesImpl(contents);
        this.supportedVisitor = new IsSupportedFilterVisitor(contents);
        this.fullySupportedVisitor = new IsFullySupportedFilterVisitor(contents);
    }

    public FilterCapabilitiesImpl getContents() {
        return this.contents;
    }

    public void addType(Class type) {
        String name = this.toOperationName(type);
        if (name == null) {
            return;
        }
        this.addName(name);
    }

    public void addName(String name) {
        if (name == null) {
            return;
        }
        if (spatialNames.containsValue(name)) {
            SpatialOperatorsImpl operators = this.contents.getSpatialCapabilities().getSpatialOperators();
            if (operators.getOperator(name) == null) {
                SpatialOperatorImpl operator = new SpatialOperatorImpl(name);
                operator.getGeometryOperands().add(GeometryOperand.LineString);
                operator.getGeometryOperands().add(GeometryOperand.Point);
                operator.getGeometryOperands().add(GeometryOperand.Polygon);
                operators.getOperators().add(operator);
            }
        } else if (temporalNames.containsValue(name)) {
            TemporalOperators operators = this.contents.getTemporalCapabilities().getTemporalOperators();
            if (operators.getOperator(name) == null) {
                TemporalOperatorImpl operator = new TemporalOperatorImpl(name);
                operators.getOperators().add(operator);
            }
        } else if (scalarNames.containsValue(name)) {
            ComparisonOperatorsImpl operators = this.contents.getScalarCapabilities().getComparisonOperators();
            if (operators.getOperator(name) == null) {
                OperatorImpl operator = new OperatorImpl(name);
                operators.getOperators().add(operator);
            }
        } else if (arithmaticNames.containsValue(name)) {
            ArithmeticOperatorsImpl operators = this.contents.getScalarCapabilities().getArithmeticOperators();
            operators.setSimpleArithmetic(true);
        } else if (logicalNames.containsValue(name)) {
            this.contents.getScalarCapabilities().setLogicalOperators(true);
        } else if ("Id".equals(name)) {
            this.contents.getIdCapabilities().setFID(true);
        } else {
            FunctionsImpl functions = this.contents.getScalarCapabilities().getArithmeticOperators().getFunctions();
            if (functions.getFunctionName(name) == null) {
                FunctionNameImpl function = new FunctionNameImpl(name, 0);
                functions.getFunctionNames().add(function);
            }
        }
    }

    public void addName(String name, int argumentCount) {
        FunctionsImpl functions = this.contents.getScalarCapabilities().getArithmeticOperators().getFunctions();
        if (functions.getFunctionName(name) == null) {
            FunctionNameImpl function = new FunctionNameImpl(name, argumentCount);
            functions.getFunctionNames().add(function);
        }
    }

    public void addName(String name, String ... argumentNames) {
        FunctionsImpl functions = this.contents.getScalarCapabilities().getArithmeticOperators().getFunctions();
        if (functions.getFunctionName(name) == null) {
            FunctionNameImpl function = new FunctionNameImpl(name, argumentNames);
            functions.getFunctionNames().add(function);
        }
    }

    public boolean supports(Filter filter) {
        if (filter == null) {
            return false;
        }
        if (this.supportedVisitor == null) {
            this.supportedVisitor = new IsSupportedFilterVisitor(this.contents);
        }
        return (Boolean)filter.accept((FilterVisitor)this.supportedVisitor, null);
    }

    public boolean fullySupports(Filter filter) {
        if (filter == null) {
            return false;
        }
        if (this.fullySupportedVisitor == null) {
            this.fullySupportedVisitor = new IsFullySupportedFilterVisitor(this.contents);
        }
        return (Boolean)filter.accept((FilterVisitor)this.fullySupportedVisitor, null);
    }

    public boolean fullySupports(Expression expression) {
        if (expression == null) {
            return false;
        }
        if (this.fullySupportedVisitor == null) {
            this.fullySupportedVisitor = new IsFullySupportedFilterVisitor(this.contents);
        }
        return (Boolean)expression.accept((ExpressionVisitor)this.fullySupportedVisitor, null);
    }

    public String toOperationName(Filter filter) {
        if (filter == null) {
            return null;
        }
        return (String)filter.accept((FilterVisitor)operationNameVisitor, null);
    }

    public String toOperationName(Class filterType) {
        if (filterType == null) {
            return null;
        }
        String quick = filterNames.get(filterType);
        if (quick != null) {
            return quick;
        }
        for (Map.Entry<Class<?>, String> mapping : filterNames.entrySet()) {
            if (!mapping.getKey().isAssignableFrom(filterType)) continue;
            return mapping.getValue();
        }
        return null;
    }

    public void addAll(Capabilities copy) {
        this.addAll(copy.getContents());
    }

    public void addAll(FilterCapabilities copy) {
        this.contents.addAll(copy);
    }

    static {
        scalarNames.put(PropertyIsEqualTo.class, "EqualTo");
        scalarNames.put(PropertyIsNotEqualTo.class, "NotEqualTo");
        scalarNames.put(PropertyIsGreaterThan.class, "GreaterThan");
        scalarNames.put(PropertyIsGreaterThanOrEqualTo.class, "GreaterThanEqualTo");
        scalarNames.put(PropertyIsLessThan.class, "LessThan");
        scalarNames.put(PropertyIsLessThanOrEqualTo.class, "LessThanEqualTo");
        scalarNames.put(PropertyIsNull.class, "NullCheck");
        scalarNames.put(PropertyIsLike.class, "Like");
        scalarNames.put(PropertyIsBetween.class, "Between");
        spatialNames = new HashMap();
        spatialNames.put(BBOX.class, "BBOX");
        spatialNames.put(Equals.class, "Equals");
        spatialNames.put(Disjoint.class, "Disjoint");
        spatialNames.put(Intersects.class, "Intersects");
        spatialNames.put(Touches.class, "Touches");
        spatialNames.put(Crosses.class, "Crosses");
        spatialNames.put(Within.class, "Within");
        spatialNames.put(Contains.class, "Contains");
        spatialNames.put(Overlaps.class, "Overlaps");
        spatialNames.put(Beyond.class, "Beyond");
        spatialNames.put(DWithin.class, "DWithin");
        temporalNames = new HashMap();
        temporalNames.put(After.class, "After");
        temporalNames.put(AnyInteracts.class, "AnyInteracts");
        temporalNames.put(Before.class, "Before");
        temporalNames.put(Begins.class, "Begins");
        temporalNames.put(BegunBy.class, "BegunBy");
        temporalNames.put(During.class, "During");
        temporalNames.put(EndedBy.class, "EndedBy");
        temporalNames.put(Ends.class, "Ends");
        temporalNames.put(Meets.class, "Meets");
        temporalNames.put(MetBy.class, "MetBy");
        temporalNames.put(OverlappedBy.class, "OverlappedBy");
        temporalNames.put(TContains.class, "TContains");
        temporalNames.put(TEquals.class, "TEquals");
        temporalNames.put(TOverlaps.class, "TOverlaps");
        logicalNames = new HashMap();
        logicalNames.put(And.class, "And");
        logicalNames.put(Or.class, "Or");
        logicalNames.put(Not.class, "Not");
        filterNames = new HashMap();
        filterNames.putAll(scalarNames);
        filterNames.putAll(spatialNames);
        filterNames.putAll(temporalNames);
        filterNames.putAll(logicalNames);
        filterNames.put(Id.class, "Id");
        arithmaticNames = new HashMap<Class<? extends Expression>, String>();
        arithmaticNames.put(Add.class, "Add");
        arithmaticNames.put(Subtract.class, "Sub");
        arithmaticNames.put(Multiply.class, "Mul");
        arithmaticNames.put(Divide.class, "Div");
        exprNames = new HashMap<Class<? extends Expression>, String>();
        exprNames.putAll(arithmaticNames);
        exprNames.put(Function.class, "Function");
        operationNameVisitor = new OperatorNameFilterVisitor();
        LOGICAL = new Capabilities();
        LOGICAL.addType(And.class);
        LOGICAL.addType(Not.class);
        LOGICAL.addType(Or.class);
        LOGICAL_OPENGIS = LOGICAL;
        SIMPLE_COMPARISONS = new Capabilities();
        SIMPLE_COMPARISONS.addType(PropertyIsEqualTo.class);
        SIMPLE_COMPARISONS.addType(PropertyIsGreaterThan.class);
        SIMPLE_COMPARISONS.addType(PropertyIsGreaterThanOrEqualTo.class);
        SIMPLE_COMPARISONS.addType(PropertyIsLessThan.class);
        SIMPLE_COMPARISONS.addType(PropertyIsLessThanOrEqualTo.class);
        SIMPLE_COMPARISONS.addType(PropertyIsNotEqualTo.class);
        SIMPLE_COMPARISONS_OPENGIS = SIMPLE_COMPARISONS;
    }
}

