/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.AbstractPosition;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.Position2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.Classes;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;

public class ReferencedEnvelope
extends Envelope
implements Bounds,
BoundingBox {
    public static ReferencedEnvelope EVERYTHING = new ReferencedEnvelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null){
        private static final long serialVersionUID = -3188702602373537164L;

        @Override
        public boolean contains(BoundingBox bbox) {
            return true;
        }

        public boolean contains(Coordinate p) {
            return true;
        }

        @Override
        public boolean contains(Position pos) {
            return true;
        }

        public boolean contains(double x, double y) {
            return true;
        }

        public boolean contains(Envelope other) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        public boolean isNull() {
            return true;
        }

        public double getArea() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public void setBounds(BoundingBox arg0) {
            throw new IllegalStateException("Cannot modify ReferencedEnvelope.EVERYTHING");
        }

        public Coordinate centre() {
            return new Coordinate();
        }

        public void setToNull() {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == EVERYTHING) {
                return true;
            }
            if (obj instanceof ReferencedEnvelope) {
                ReferencedEnvelope other = (ReferencedEnvelope)((Object)obj);
                if (other.crs != 1.EVERYTHING.crs) {
                    return false;
                }
                if (other.getMinX() != EVERYTHING.getMinX()) {
                    return false;
                }
                if (other.getMinY() != EVERYTHING.getMinY()) {
                    return false;
                }
                if (other.getMaxX() != EVERYTHING.getMaxX()) {
                    return false;
                }
                return other.getMaxY() == EVERYTHING.getMaxY();
            }
            return super.equals(obj);
        }

        @Override
        public String toString() {
            return "ReferencedEnvelope.EVERYTHING";
        }
    };
    private static final long serialVersionUID = -3188702602373537163L;
    protected CoordinateReferenceSystem crs;

    public ReferencedEnvelope() {
        this((CoordinateReferenceSystem)null);
    }

    public ReferencedEnvelope(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(double x1, double x2, double y1, double y2, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(x1, x2, y1, y2);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(Rectangle2D rectangle, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY(), crs);
    }

    public ReferencedEnvelope(ReferencedEnvelope envelope) throws MismatchedDimensionException {
        super((Envelope)envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(BoundingBox bbox) throws MismatchedDimensionException {
        this(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), bbox.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope(Bounds bounds) throws MismatchedDimensionException {
        super(bounds.getMinimum(0), bounds.getMaximum(0), bounds.getMinimum(1), bounds.getMaximum(1));
        this.crs = bounds.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(envelope);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public void init(BoundingBox bounds) {
        super.init(bounds.getMinimum(0), bounds.getMaximum(0), bounds.getMinimum(1), bounds.getMaximum(1));
        this.crs = bounds.getCoordinateReferenceSystem();
    }

    private static Envelope toJTSEnvelope(BoundingBox bbox) {
        if (bbox == null) {
            throw new NullPointerException("Provided bbox envelope was null");
        }
        if (bbox instanceof Envelope) {
            return (Envelope)bbox;
        }
        return ReferencedEnvelope.create((Bounds)bbox, bbox.getCoordinateReferenceSystem());
    }

    protected void checkCoordinateReferenceSystemDimension() throws MismatchedDimensionException {
        if (this.crs != null) {
            int expected = this.getDimension();
            int dimension = this.crs.getCoordinateSystem().getDimension();
            if (dimension > expected) {
                String arg0 = this.crs.getName().getCode();
                throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", arg0, dimension, expected));
            }
        }
    }

    protected void ensureCompatibleReferenceSystem(BoundingBox bbox) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = bbox.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, other)) {
            throw new MismatchedReferenceSystemException("The coordinate reference system must be the same for all objects.");
        }
    }

    protected void ensureCompatibleReferenceSystem(Position location) {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = location.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, other)) {
            throw new MismatchedReferenceSystemException("The coordinate reference system must be the same for all objects.");
        }
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        AbstractPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    public int getDimension() {
        return 2;
    }

    public double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getMedian(int dimension) {
        switch (dimension) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public Position getLowerCorner() {
        return new Position2D(this.crs, this.getMinX(), this.getMinY());
    }

    public Position getUpperCorner() {
        return new Position2D(this.crs, this.getMaxX(), this.getMaxY());
    }

    public boolean isEmpty() {
        return super.isNull();
    }

    public boolean contains(Position pos) {
        this.ensureCompatibleReferenceSystem(pos);
        return super.contains(pos.getOrdinate(0), pos.getOrdinate(1));
    }

    public boolean contains(ReferencedEnvelope bounds) {
        this.ensureCompatibleReferenceSystem(bounds);
        return super.contains(ReferencedEnvelope.toJTSEnvelope(bounds));
    }

    public boolean contains(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        return super.contains(ReferencedEnvelope.toJTSEnvelope(bbox));
    }

    public boolean intersects(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        return super.intersects(ReferencedEnvelope.toJTSEnvelope(bbox));
    }

    public ReferencedEnvelope intersection(Envelope env) {
        if (env instanceof BoundingBox) {
            BoundingBox bbox = (BoundingBox)env;
            this.ensureCompatibleReferenceSystem(bbox);
        }
        return new ReferencedEnvelope(super.intersection(env), this.getCoordinateReferenceSystem());
    }

    public void include(BoundingBox bbox) {
        if (this.crs == null) {
            this.crs = bbox.getCoordinateReferenceSystem();
        } else {
            this.ensureCompatibleReferenceSystem(bbox);
        }
        this.expandToInclude(ReferencedEnvelope.reference((Bounds)bbox));
    }

    public void expandToInclude(Position pt) {
        Coordinate coordinate = new Coordinate(pt.getOrdinate(0), pt.getOrdinate(1));
        this.expandToInclude(coordinate);
    }

    public void expandToInclude(Point2D pt) {
        Position2D pos = new Position2D();
        pos.setLocation(pt);
        this.expandToInclude(pos);
    }

    public double getCenterX() {
        return this.getMedian(0);
    }

    public double getCenterY() {
        return this.getMedian(1);
    }

    public void expandToInclude(Envelope other) {
        if (other instanceof BoundingBox) {
            if (other.isNull()) {
                return;
            }
            BoundingBox bbox = (BoundingBox)other;
            this.ensureCompatibleReferenceSystem(bbox);
            this.expandToInclude(bbox.getLowerCorner());
            this.expandToInclude(bbox.getUpperCorner());
        } else {
            super.expandToInclude(other);
        }
    }

    public void include(double x, double y) {
        super.expandToInclude(x, y);
    }

    public void setBounds(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        super.init(ReferencedEnvelope.toJTSEnvelope(bbox));
    }

    public void setFrameFromCenter(Point2D center, Point2D corner) {
        double widthDelta = Math.abs(corner.getX() - center.getX());
        double heightDelta = Math.abs(corner.getY() - center.getY());
        super.init(center.getX() - widthDelta, center.getX() + widthDelta, center.getY() - heightDelta, center.getY() + heightDelta);
    }

    public void setFrameFromDiagonal(Point2D lowerLeft, Point2D upperRight) {
        super.init(lowerLeft.getX(), upperRight.getX(), lowerLeft.getY(), upperRight.getY());
    }

    public void setFrame(double x, double y, double width, double height) {
        super.init(x, x + width, y, y + height);
    }

    public BoundingBox toBounds(CoordinateReferenceSystem targetCRS) throws TransformException {
        try {
            return this.transform(targetCRS, true);
        }
        catch (FactoryException e) {
            throw new TransformException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient) throws TransformException, FactoryException {
        return this.transform(targetCRS, lenient, 5);
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient, int numPointsForTransformation) throws TransformException, FactoryException {
        if (this.crs == null) {
            if (this.isEmpty()) {
                return new ReferencedEnvelope(targetCRS);
            }
            throw new NullPointerException("Unable to transform referenced envelope, crs has not yet been provided.");
        }
        if (this.getDimension() != targetCRS.getCoordinateSystem().getDimension()) {
            if (lenient) {
                return JTS.transformTo3D(this, targetCRS, lenient, numPointsForTransformation);
            }
            String arg0 = this.crs.getName().getCode();
            Integer arg1 = this.getDimension();
            Integer arg2 = targetCRS.getCoordinateSystem().getDimension();
            throw new MismatchedDimensionException(MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", arg0, arg1, arg2));
        }
        CoordinateOperationFactory coordinateOperationFactory = CRS.getCoordinateOperationFactory(lenient);
        CoordinateOperation operation = coordinateOperationFactory.createOperation(this.crs, targetCRS);
        GeneralBounds transformed = CRS.transform(operation, (Bounds)this);
        transformed.setCoordinateReferenceSystem(targetCRS);
        ReferencedEnvelope target = new ReferencedEnvelope(transformed);
        MathTransform transform = operation.getMathTransform();
        JTS.transform(this, target, transform, numPointsForTransformation);
        return target;
    }

    public int hashCode() {
        int code = super.hashCode() ^ 0xAB296275;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem otherCRS = object instanceof ReferencedEnvelope ? ((ReferencedEnvelope)((Object)object)).crs : null;
            return CRS.equalsIgnoreMetadata(this.crs, otherCRS);
        }
        return false;
    }

    public boolean boundsEquals2D(Bounds other, double eps) {
        eps *= 0.5 * (this.getWidth() + this.getHeight());
        double[] delta = new double[]{this.getMinimum(0) - other.getMinimum(0), this.getMaximum(0) - other.getMaximum(0), this.getMinimum(1) - other.getMinimum(1), this.getMaximum(1) - other.getMaximum(1)};
        for (double v : delta) {
            if (Math.abs(v) <= eps) continue;
            return false;
        }
        return true;
    }

    public boolean boundsEquals2D(Rectangle2D other, double eps) {
        eps *= 0.5 * (this.getWidth() + this.getHeight());
        double[] delta = new double[]{this.getMinimum(0) - other.getMinX(), this.getMaximum(0) - other.getMaxX(), this.getMinimum(1) - other.getMinY(), this.getMaximum(1) - other.getMaxX()};
        for (double v : delta) {
            if (Math.abs(v) <= eps) continue;
            return false;
        }
        return true;
    }

    public boolean boundsEquals(Bounds that, int xDim, int yDim, double eps) {
        eps *= 0.5 * (this.getWidth() + this.getHeight());
        for (int i = 0; i < 4; ++i) {
            double valueND;
            double value2D;
            int dimND;
            int dim2D = i & 1;
            int n = dimND = dim2D == 0 ? xDim : yDim;
            if ((i & 2) == 0) {
                value2D = this.getMinimum(dim2D);
                valueND = that.getMinimum(dimND);
            } else {
                value2D = this.getMaximum(dim2D);
                valueND = that.getMaximum(dimND);
            }
            if (Math.abs(value2D - valueND) <= eps) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName((Object)((Object)this))).append('[');
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.getMinimum(i)).append(" : ").append(this.getMaximum(i));
        }
        buffer.append(']');
        CoordinateReferenceSystem crs = this.getCoordinateReferenceSystem();
        if (crs != null) {
            buffer.append(" ").append(Classes.getShortClassName((Object)crs)).append("[").append(crs.getName()).append("]");
            CoordinateSystem cs = crs.getCoordinateSystem();
            if (cs != null) {
                for (int i = 0; i < cs.getDimension(); ++i) {
                    buffer.append(" ").append(cs.getAxis(i));
                }
            }
        }
        return buffer.toString();
    }

    public static ReferencedEnvelope create(ReferencedEnvelope original) {
        if (original instanceof ReferencedEnvelope3D) {
            return new ReferencedEnvelope3D((ReferencedEnvelope3D)original);
        }
        return new ReferencedEnvelope(original);
    }

    public static ReferencedEnvelope create(CoordinateReferenceSystem crs) {
        if (crs != null && crs.getCoordinateSystem().getDimension() > 2) {
            return new ReferencedEnvelope3D(crs);
        }
        return new ReferencedEnvelope(crs);
    }

    public static ReferencedEnvelope create(Bounds bounds) {
        if (bounds == null) {
            return null;
        }
        if (bounds.getDimension() >= 3) {
            return new ReferencedEnvelope3D((ReferencedEnvelope3D)ReferencedEnvelope.reference(bounds), bounds.getCoordinateReferenceSystem());
        }
        return new ReferencedEnvelope(ReferencedEnvelope.reference(bounds), bounds.getCoordinateReferenceSystem());
    }

    public static ReferencedEnvelope create(Bounds env, CoordinateReferenceSystem crs) {
        if (env == null) {
            return null;
        }
        if (env.getDimension() >= 3) {
            return new ReferencedEnvelope3D((ReferencedEnvelope3D)ReferencedEnvelope.reference(env), crs);
        }
        return new ReferencedEnvelope(ReferencedEnvelope.reference(env), crs);
    }

    public static ReferencedEnvelope rect(Rectangle2D rectangle) {
        if (rectangle.isEmpty()) {
            return new ReferencedEnvelope(DefaultGeographicCRS.WGS84);
        }
        return new ReferencedEnvelope(rectangle.getX(), rectangle.getWidth(), rectangle.getY(), rectangle.getHeight(), DefaultGeographicCRS.WGS84);
    }

    public static ReferencedEnvelope rect(Rectangle2D rectangle, CoordinateReferenceSystem crs) {
        if (rectangle.isEmpty()) {
            return new ReferencedEnvelope(crs);
        }
        return new ReferencedEnvelope(rectangle.getMinX(), rectangle.getMaxX(), rectangle.getMinY(), rectangle.getMaxY(), crs);
    }

    public static ReferencedEnvelope rect(double x, double y, double width, double height) {
        return new ReferencedEnvelope(x, x + width, y, y + height, DefaultGeographicCRS.WGS84);
    }

    public static ReferencedEnvelope rect(double x, double y, double width, double height, CoordinateReferenceSystem crs) {
        return new ReferencedEnvelope(x, x + width, y, y + height, crs);
    }

    public static ReferencedEnvelope envelope(Envelope env, CoordinateReferenceSystem crs) {
        if (env == null) {
            return null;
        }
        if (crs != null && crs.getCoordinateSystem().getDimension() >= 3) {
            if (env.isNull()) {
                return new ReferencedEnvelope3D(crs);
            }
            return new ReferencedEnvelope3D(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), Double.NaN, Double.NaN, crs);
        }
        if (env.isNull()) {
            return new ReferencedEnvelope(crs);
        }
        return new ReferencedEnvelope(env, crs);
    }

    public static ReferencedEnvelope reference(Envelope e) {
        if (e == null) {
            return null;
        }
        if (e instanceof ReferencedEnvelope3D) {
            return (ReferencedEnvelope3D)e;
        }
        if (e instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)e;
        }
        return new ReferencedEnvelope(e, null);
    }

    public static ReferencedEnvelope reference(ReferencedEnvelope e) {
        return ReferencedEnvelope.reference((Bounds)e);
    }

    public static ReferencedEnvelope reference(Bounds env) {
        if (env == null) {
            return null;
        }
        if (env instanceof ReferencedEnvelope3D) {
            return (ReferencedEnvelope3D)env;
        }
        if (env instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)env;
        }
        if (env.getDimension() >= 3) {
            if (!(env.getMinimum(0) < env.getMaximum(0))) {
                return new ReferencedEnvelope3D(env.getCoordinateReferenceSystem());
            }
            return new ReferencedEnvelope3D(env);
        }
        if (!(env.getMinimum(0) < env.getMaximum(0))) {
            if (env.getCoordinateReferenceSystem() instanceof GeographicCRS && env.getMinimum(1) <= env.getMaximum(1)) {
                return new ReferencedEnvelope(-180.0, 180.0, env.getMinimum(1), env.getMaximum(1), env.getCoordinateReferenceSystem());
            }
            return new ReferencedEnvelope(env.getCoordinateReferenceSystem());
        }
        return new ReferencedEnvelope(env);
    }

    public static ReferencedEnvelope create(Rectangle2D rectangle, CoordinateReferenceSystem crs) {
        if (rectangle.isEmpty()) {
            return new ReferencedEnvelope(crs);
        }
        return new ReferencedEnvelope(rectangle, crs);
    }
}

