/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.logging.Logger;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class DisplacementImpl
implements Cloneable,
Displacement {
    public static final Displacement DEFAULT = new ConstantDisplacement(){

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Stroke may not be modified");
        }

        public Expression getDisplacementX() {
            return ConstantExpression.ZERO;
        }

        public Expression getDisplacementY() {
            return ConstantExpression.ZERO;
        }

        public Object accept(TraversingStyleVisitor visitor, Object extraData) {
            this.cannotModifyConstant();
            return null;
        }
    };
    public static final Displacement NULL = new ConstantDisplacement(){

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Stroke may not be modified");
        }

        public Expression getDisplacementX() {
            return ConstantExpression.NULL;
        }

        public Expression getDisplacementY() {
            return ConstantExpression.NULL;
        }

        public Object accept(TraversingStyleVisitor visitor, Object extraData) {
            this.cannotModifyConstant();
            return null;
        }
    };
    private static final Logger LOGGER = Logging.getLogger(DisplacementImpl.class);
    private FilterFactory filterFactory;
    private Expression displacementX = null;
    private Expression displacementY = null;

    public DisplacementImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public DisplacementImpl(FilterFactory factory) {
        this.filterFactory = factory;
        try {
            this.displacementX = this.filterFactory.literal(0);
            this.displacementY = this.filterFactory.literal(0);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultDisplacement: " + ife);
        }
    }

    public DisplacementImpl(Expression dx, Expression dy) {
        this.filterFactory = CommonFactoryFinder.getFilterFactory(null);
        this.displacementX = dx;
        this.displacementY = dy;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.filterFactory = factory;
        try {
            this.displacementX = this.filterFactory.literal(0);
            this.displacementY = this.filterFactory.literal(0);
        }
        catch (IllegalFilterException ife) {
            LOGGER.severe("Failed to build defaultDisplacement: " + ife);
        }
    }

    public void setDisplacementX(Expression displacementX) {
        this.displacementX = displacementX;
    }

    public void setDisplacementX(double displacementX) {
        this.displacementX = this.filterFactory.literal(displacementX);
    }

    public void setDisplacementY(Expression displacementY) {
        this.displacementY = displacementY;
    }

    public void setDisplacementY(double displacementY) {
        this.displacementY = this.filterFactory.literal(displacementY);
    }

    public Expression getDisplacementX() {
        return this.displacementX;
    }

    public Expression getDisplacementY() {
        return this.displacementY;
    }

    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit((Displacement)this, data);
    }

    public void accept(StyleVisitor visitor) {
        visitor.visit((Displacement)this);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Will not happen");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DisplacementImpl) {
            DisplacementImpl other = (DisplacementImpl)obj;
            return Utilities.equals((Object)this.displacementX, (Object)other.displacementX) && Utilities.equals((Object)this.displacementY, (Object)other.displacementY);
        }
        return false;
    }

    public int hashCode() {
        int PRIME = 37;
        int result = 17;
        if (this.displacementX != null) {
            result = result * 37 + this.displacementX.hashCode();
        }
        if (this.displacementY != null) {
            result = result * 37 + this.displacementY.hashCode();
        }
        return result;
    }

    static DisplacementImpl cast(Displacement displacement) {
        if (displacement == null) {
            return null;
        }
        if (displacement instanceof DisplacementImpl) {
            return (DisplacementImpl)displacement;
        }
        DisplacementImpl copy = new DisplacementImpl();
        copy.setDisplacementX(displacement.getDisplacementX());
        copy.setDisplacementY(displacement.getDisplacementY());
        return copy;
    }

    static abstract class ConstantDisplacement
    implements Displacement {
        ConstantDisplacement() {
        }

        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Displacement may not be modified");
        }

        public void setDisplacementX(Expression x) {
            this.cannotModifyConstant();
        }

        public void setDisplacementY(Expression y) {
            this.cannotModifyConstant();
        }

        public void accept(StyleVisitor visitor) {
            this.cannotModifyConstant();
        }
    }
}

