/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import nl.b3p.brmo.loader.util.TableData;
import nl.b3p.brmo.loader.util.TableRow;
import org.geotools.gml.stream.XmlStreamGeometryReader;
import org.javasimon.SimonManager;
import org.javasimon.Split;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class DataComfortXMLReader {
    private static final int LEVEL_ROOT = 0;
    private static final int LEVEL_DATA = 1;
    private static final int LEVEL_COMFORT = 2;
    private static final int LEVEL_TABLE = 3;
    private static final int LEVEL_DELETE = 4;
    private final XMLInputFactory xif = XMLInputFactory.newInstance();

    public DataComfortXMLReader() {
        this.xif.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this.xif.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<TableData> readDataXML(Source dataXML) throws Exception {
        Split split = SimonManager.getStopwatch((String)"b3p.util.datacomfortxmlreader").start();
        XMLStreamReader xer = this.xif.createXMLStreamReader(dataXML);
        XmlStreamGeometryReader geometryReader = new XmlStreamGeometryReader(xer);
        int level = 0;
        ArrayList<TableData> list = new ArrayList<TableData>();
        TableData data = null;
        TableRow row = null;
        boolean inComfortData = false;
        boolean inDeleteData = false;
        block7: while (xer.hasNext()) {
            xer.nextTag();
            String tag = xer.getLocalName();
            switch (level) {
                case 0: {
                    if (!"data".equals(tag)) break;
                    level = 1;
                    break;
                }
                case 1: {
                    if (xer.isEndElement()) break block7;
                    if ("comfort".equals(tag)) {
                        String comfortSearchTable = xer.getAttributeValue(null, "search-table");
                        String comfortSearchColumn = xer.getAttributeValue(null, "search-column");
                        String comfortSearchValue = xer.getAttributeValue(null, "search-value");
                        String snapshotDate = xer.getAttributeValue(null, "snapshot-date");
                        data = new TableData(comfortSearchTable, comfortSearchColumn, comfortSearchValue, snapshotDate);
                        level = 2;
                        inComfortData = true;
                        inDeleteData = false;
                    } else if ("delete".equals(tag)) {
                        data = new TableData();
                        level = 4;
                        inComfortData = false;
                        inDeleteData = true;
                    } else {
                        row = new TableRow();
                        row.setTable(tag);
                        row.setIgnoreDuplicates("yes".equals(xer.getAttributeValue(null, "ignore-duplicates")));
                        String beginDatumColumn = xer.getAttributeValue(null, "column-dat-beg-geldh");
                        String eindeDatumColumn = xer.getAttributeValue(null, "column-datum-einde-geldh");
                        row.setColumnDatumBeginGeldigheid(beginDatumColumn);
                        row.setColumnDatumEindeGeldigheid(eindeDatumColumn);
                        data = new TableData(row);
                        level = 3;
                        inComfortData = false;
                        inDeleteData = false;
                    }
                    list.add(data);
                    break;
                }
                case 2: {
                    if (xer.isEndElement() && "comfort".equals(tag)) {
                        level = 1;
                        break;
                    }
                    row = new TableRow();
                    row.setTable(tag);
                    data.addRow(row);
                    level = 3;
                    break;
                }
                case 4: {
                    if (xer.isEndElement() && "delete".equals(tag)) {
                        level = 1;
                        break;
                    }
                    row = new TableRow();
                    row.setTable(tag);
                    data.addRow(row);
                    level = 3;
                    break;
                }
                case 3: {
                    if (xer.isEndElement()) {
                        if (inComfortData) {
                            level = 2;
                            break;
                        }
                        if (inDeleteData) {
                            level = 4;
                            break;
                        }
                        level = 1;
                        break;
                    }
                    data = (TableData)list.get(list.size() - 1);
                    row.getColumns().add(tag);
                    String alleenArchief = xer.getAttributeValue(null, "alleen-archief");
                    if ("true".equals(alleenArchief)) {
                        row.setAlleenArchiefColumn(tag);
                    }
                    xer.next();
                    while (xer.isWhiteSpace()) {
                        xer.next();
                    }
                    if (xer.isStartElement()) {
                        Split split2 = SimonManager.getStopwatch((String)"b3p.util.datacomfortxmlreader.parsegml").start();
                        Geometry geom = geometryReader.readGeometry();
                        if (geom instanceof Polygon) {
                            geom = new MultiPolygon(new Polygon[]{(Polygon)geom}, geom.getFactory());
                        }
                        row.getValues().add(geom.toString());
                        split2.stop();
                        while (!tag.equals(xer.getLocalName()) || !xer.isEndElement()) {
                            xer.nextTag();
                        }
                        break;
                    }
                    if (xer.isCharacters()) {
                        StringBuilder t = new StringBuilder();
                        do {
                            t.append(xer.getText());
                            xer.next();
                        } while (xer.isCharacters());
                        row.getValues().add(t.toString());
                        break;
                    }
                    assert (xer.isEndElement());
                    row.getValues().add(null);
                }
            }
        }
        split.stop();
        return list;
    }
}

