/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.util;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TableRow {
    private String table;
    private boolean ignoreDuplicates;
    private List<String> columns = new ArrayList<String>();
    private List<String> values = new ArrayList<String>();
    private final Set<String> alleenArchiefColumns = new HashSet<String>();
    private String columnDatumBeginGeldigheid;
    private String columnDatumEindeGeldigheid;

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public boolean isAlleenArchiefColumn(String column) {
        return this.alleenArchiefColumns.contains(column);
    }

    public void setAlleenArchiefColumn(String column) {
        this.alleenArchiefColumns.add(column);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean isIgnoreDuplicates() {
        return this.ignoreDuplicates;
    }

    public void setIgnoreDuplicates(boolean ignoreDuplicates) {
        this.ignoreDuplicates = ignoreDuplicates;
    }

    public String getColumnDatumBeginGeldigheid() {
        return this.columnDatumBeginGeldigheid;
    }

    public void setColumnDatumBeginGeldigheid(String columnDatumBeginGeldigheid) {
        this.columnDatumBeginGeldigheid = columnDatumBeginGeldigheid;
    }

    public String getColumnDatumEindeGeldigheid() {
        return this.columnDatumEindeGeldigheid;
    }

    public void setColumnDatumEindeGeldigheid(String columnDatumEindeGeldigheid) {
        this.columnDatumEindeGeldigheid = columnDatumEindeGeldigheid;
    }

    public String toString(List<String> displayColumns) {
        StringBuilder s = new StringBuilder();
        s.append(this.table).append("[");
        ArrayList<CallSite> keys = new ArrayList<CallSite>();
        int i = -1;
        for (String column : this.columns) {
            ++i;
            if (!displayColumns.contains(column)) continue;
            keys.add((CallSite)((Object)(column + "=" + this.values.get(i))));
        }
        s.append(String.join((CharSequence)", ", keys));
        s.append("]");
        return s.toString();
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("TABLE: ");
        str.append(this.table);
        str.append("\n");
        int i = 0;
        for (String column : this.columns) {
            str.append(column);
            str.append("=");
            str.append(this.values.get(i));
            if (this.isAlleenArchiefColumn(column)) {
                str.append(" (alleen archief)");
            }
            str.append("\n");
            ++i;
        }
        return str.toString();
    }

    public String getColumnValue(String column) {
        int i = this.columns.indexOf(column);
        if (i == -1) {
            return null;
        }
        return this.values.get(i);
    }
}

