/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import nl.b3p.brmo.loader.entity.Brk2Bericht;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Brk2SnapshotXMLReader
extends BrmoXMLReader {
    private static final Log log = LogFactory.getLog(Brk2SnapshotXMLReader.class);
    private final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final XMLStreamReader streamReader;
    private final Transformer transformer;
    private static final String KAD_OBJ_SNAP = "KadastraalObjectSnapshot";
    private static final String BRK_DATUM = "brkDatum";
    private static final String MUTATIE = "Mutatie";
    private static final String VOLGNUMMER = "volgnummerKadastraalObjectDatum";
    private static final String NS_MUTATIE = "http://www.kadaster.nl/schemas/brk-levering/product-mutatie/v20211119";
    private static final String NS_ONRRNDZKREF = "http://www.kadaster.nl/schemas/brk-levering/snapshot/imkad-onroerendezaak-ref/v20210702";
    private static final String KENMERKNAAM = "kenmerknaam";
    private static final String KENMERKWAARDE = "kenmerkwaarde";
    private static final String PRODUCTSPECIFICATIE = "productSpecificatie";
    private MutatieGegevens mutatieGegevens = null;

    public Brk2SnapshotXMLReader(InputStream in) throws XMLStreamException, TransformerConfigurationException {
        this.streamReader = this.factory.createXMLStreamReader(in);
        TransformerFactory tf = TransformerFactory.newInstance();
        this.transformer = tf.newTransformer();
        this.init();
    }

    @Override
    public void init() throws XMLStreamException {
        this.soort = "brk2";
        this.positionToNext();
    }

    private void positionToNext() throws XMLStreamException {
        boolean inMutatie = false;
        this.mutatieGegevens = null;
        boolean inWas = false;
        boolean inProductSpecificatie = false;
        String inProductSpecificatieNaam = null;
        while (this.streamReader.hasNext()) {
            if (this.streamReader.isStartElement()) {
                if (!inWas && this.streamReader.getLocalName().equals(KAD_OBJ_SNAP)) break;
                if (this.streamReader.getLocalName().equals(BRK_DATUM)) {
                    this.setDatumAsString(this.streamReader.getElementText());
                } else if (this.streamReader.getLocalName().equals(PRODUCTSPECIFICATIE)) {
                    inProductSpecificatie = true;
                } else if (inProductSpecificatie && this.streamReader.getLocalName().equals(KENMERKNAAM)) {
                    inProductSpecificatieNaam = this.streamReader.getElementText();
                } else if (inProductSpecificatie && this.streamReader.getLocalName().equals(KENMERKWAARDE)) {
                    if ("Peildatum".equals(inProductSpecificatieNaam)) {
                        this.setDatumAsString(this.streamReader.getElementText());
                    } else if ("Gebiednummer".equals(inProductSpecificatieNaam)) {
                        this.setGebied(this.streamReader.getElementText());
                    }
                } else if (this.streamReader.getLocalName().equals(MUTATIE)) {
                    inMutatie = true;
                    this.mutatieGegevens = new MutatieGegevens();
                } else if (inMutatie && this.streamReader.getLocalName().equals(VOLGNUMMER)) {
                    this.mutatieGegevens.volgnummerKadastraalObjectDatum = Integer.parseInt(this.streamReader.getElementText());
                } else if (inMutatie && this.streamReader.getLocalName().equals("kadastraalObject") && this.streamReader.getNamespaceURI().equals(NS_MUTATIE)) {
                    this.mutatieGegevens.inMutatieObjectRef = true;
                } else if (inMutatie && this.mutatieGegevens.inMutatieObjectRef && this.streamReader.getNamespaceURI().equals(NS_ONRRNDZKREF)) {
                    this.mutatieGegevens.mutatieObjectRef = this.streamReader.getAttributeValue(null, "domein") + ":" + this.streamReader.getElementText();
                    if (this.mutatieGegevens.mutatieObjectRef != null) {
                        this.mutatieGegevens.inMutatieObjectRef = false;
                    }
                } else if (inMutatie && this.streamReader.getLocalName().equals("was")) {
                    inWas = true;
                } else if (inMutatie && this.streamReader.getLocalName().equals("wordt")) {
                    this.mutatieGegevens.isMutatieZonderWordt = false;
                }
            } else if (this.streamReader.isEndElement()) {
                if (this.streamReader.getLocalName().equals(PRODUCTSPECIFICATIE)) {
                    inProductSpecificatie = false;
                    inProductSpecificatieNaam = null;
                }
                if (this.streamReader.getLocalName().equals("was")) {
                    inWas = false;
                }
                if (inMutatie && this.streamReader.getLocalName().equals(MUTATIE)) break;
            }
            this.streamReader.next();
        }
    }

    @Override
    public boolean hasNext() {
        try {
            return this.mutatieGegevens != null && this.mutatieGegevens.isMutatieZonderWordt || this.streamReader.hasNext();
        }
        catch (XMLStreamException ex) {
            log.error((Object)"Fout tijdens streaming XML", (Throwable)ex);
            return false;
        }
    }

    @Override
    public Brk2Bericht next() throws TransformerException, XMLStreamException {
        Brk2Bericht b;
        if (this.mutatieGegevens != null && this.mutatieGegevens.isMutatieZonderWordt) {
            b = new Brk2Bericht("<empty/>");
            b.setVervallenInfo(this.mutatieGegevens.mutatieObjectRef, this.getBestandsDatum());
            b.setVolgordeNummer(this.mutatieGegevens.volgnummerKadastraalObjectDatum);
        } else {
            StringWriter sw = new StringWriter();
            XMLOutputFactory of = XMLOutputFactory.newInstance();
            of.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
            XMLStreamWriter writer = of.createXMLStreamWriter(sw);
            this.transformer.transform(new StAXSource(this.streamReader), new StAXResult(writer));
            b = new Brk2Bericht(sw.toString());
            b.setVolgordeNummer(this.mutatieGegevens != null ? this.mutatieGegevens.volgnummerKadastraalObjectDatum : -1);
            b.setDatum(this.getBestandsDatum());
            b.setObjectRef(this.mutatieGegevens != null ? this.mutatieGegevens.mutatieObjectRef : null);
        }
        this.positionToNext();
        return b;
    }

    private static class MutatieGegevens {
        boolean inMutatieObjectRef = false;
        String mutatieObjectRef = null;
        boolean isMutatieZonderWordt = true;
        Integer volgnummerKadastraalObjectDatum = null;

        private MutatieGegevens() {
        }
    }
}

