/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureSource;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Association;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.NearestVisitor;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureReader;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCJoiningFeatureReader;
import org.geotools.jdbc.JDBCJoiningFilteringFeatureReader;
import org.geotools.jdbc.JDBCQueryCapabilities;
import org.geotools.jdbc.JDBCState;
import org.geotools.jdbc.JoinInfo;
import org.geotools.jdbc.NullHandlingVisitor;
import org.geotools.jdbc.NullPrimaryKey;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.PrimaryKeyFIDValidator;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;

public class JDBCFeatureSource
extends ContentFeatureSource {
    private static final Logger LOGGER = Logging.getLogger(JDBCFeatureSource.class);
    private static final String REMARKS = "REMARKS";
    PrimaryKey primaryKey;

    public JDBCFeatureSource(ContentEntry entry, Query query) throws IOException {
        super(entry, query);
        this.primaryKey = ((JDBCDataStore)entry.getDataStore()).getPrimaryKey(entry);
    }

    protected JDBCFeatureSource(JDBCFeatureSource featureSource) throws IOException {
        super(featureSource.entry, featureSource.query);
    }

    @Override
    protected QueryCapabilities buildQueryCapabilities() {
        return new JDBCQueryCapabilities(this);
    }

    @Override
    protected void addHints(Set<Hints.Key> hints) {
        hints.add(Hints.FEATURE_DETACHED);
        this.getDataStore().getSQLDialect().addSupportedHints(hints);
    }

    @Override
    public JDBCDataStore getDataStore() {
        return (JDBCDataStore)super.getDataStore();
    }

    @Override
    public JDBCState getState() {
        return (JDBCState)super.getState();
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setExposePrimaryKeyColumns(boolean exposePrimaryKeyColumns) {
        ((JDBCState)this.entry.getState(this.transaction)).setExposePrimaryKeyColumns(exposePrimaryKeyColumns);
    }

    public boolean isExposePrimaryKeyColumns() {
        return ((JDBCState)this.entry.getState(this.transaction)).isExposePrimaryKeyColumns();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        PrimaryKey pkey = this.getDataStore().getPrimaryKey(this.entry);
        VirtualTable virtualTable = this.getDataStore().getVirtualTables().get(this.entry.getTypeName());
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        boolean readOnly = false;
        if (pkey == null || pkey instanceof NullPrimaryKey || virtualTable != null) {
            readOnly = true;
        }
        String tableName = this.entry.getName().getLocalPart();
        tb.setName(tableName);
        if (this.entry.getName().getNamespaceURI() != null) {
            tb.setNamespaceURI(this.entry.getName().getNamespaceURI());
        } else {
            tb.setNamespaceURI(this.getDataStore().getNamespaceURI());
        }
        JDBCState state = this.getState();
        String databaseSchema = this.getDataStore().getDatabaseSchema();
        Connection cx = this.getDataStore().getConnection(state);
        SQLDialect dialect = this.getDataStore().getSQLDialect();
        Logger storeLogger = this.getDataStore().getLogger();
        try {
            DatabaseMetaData metaData = cx.getMetaData();
            List<ColumnMetadata> columns = virtualTable != null ? JDBCFeatureSource.getColumnMetadata(cx, virtualTable, dialect, this.getDataStore()) : this.getColumnMetadata(cx, databaseSchema, tableName, dialect);
            for (ColumnMetadata column : columns) {
                Class<?> binding;
                String name = column.name;
                for (PrimaryKeyColumn pkeycol : pkey.getColumns()) {
                    if (name.equals(pkeycol.getName()) && !state.isExposePrimaryKeyColumns()) {
                        name = null;
                        break;
                    }
                    if (pkeycol.type != null) continue;
                    pkeycol.type = column.binding;
                }
                if (name == null) continue;
                if (this.getDataStore().isAssociations()) {
                    this.getDataStore().ensureAssociationTablesExist(cx);
                    Statement st = null;
                    ResultSet relationships = null;
                    if (this.getDataStore().getSQLDialect() instanceof PreparedStatementSQLDialect) {
                        st = this.getDataStore().selectRelationshipSQLPS(tableName, name, cx);
                        relationships = st.executeQuery();
                    } else {
                        String sql = this.getDataStore().selectRelationshipSQL(tableName, name);
                        storeLogger.fine(sql);
                        st = cx.createStatement();
                        relationships = st.executeQuery(sql);
                    }
                    try {
                        if (relationships.next()) {
                            tb.add(name, Association.class);
                            continue;
                        }
                    }
                    finally {
                        this.getDataStore().closeSafe(relationships);
                        this.getDataStore().closeSafe(st);
                        continue;
                    }
                }
                if ((binding = column.binding) == null) {
                    binding = this.getDataStore().getMapping(column.typeName);
                }
                if (binding == null) {
                    binding = this.getDataStore().getMapping(column.sqlType);
                }
                if (binding == null) {
                    storeLogger.warning("Could not find mapping for '" + name + "', ignoring the column and setting the feature type read only");
                    readOnly = true;
                    continue;
                }
                ab.addUserData("org.geotools.jdbc.nativeTypeName", column.typeName);
                ab.addUserData("org.geotools.jdbc.nativeType", column.sqlType);
                if (!column.nullable) {
                    ab.nillable(false);
                    ab.minOccurs(1);
                }
                if (column.restriction != null) {
                    ab.addRestriction(column.restriction);
                }
                if (column.getRemarks() != null && !column.getRemarks().isEmpty()) {
                    ab.setDescription(column.getRemarks());
                }
                AttributeDescriptor att = null;
                if (Geometry.class.isAssignableFrom(binding)) {
                    Integer srid = null;
                    CoordinateReferenceSystem crs = null;
                    try {
                        srid = virtualTable != null ? Integer.valueOf(virtualTable.getNativeSrid(name)) : dialect.getGeometrySRID(databaseSchema, tableName, name, cx);
                        if (srid != null) {
                            crs = dialect.createCRS(srid, cx);
                            if (crs == null) {
                                storeLogger.warning("Couldn't determine CRS of table " + tableName + " with srid: " + srid + ".");
                            }
                        } else {
                            storeLogger.info("No srid returned of database table:" + tableName);
                        }
                    }
                    catch (Exception e) {
                        String msg = "Error occured determing srid for " + tableName + "." + name;
                        storeLogger.log(Level.WARNING, msg, e);
                    }
                    int dimension = 2;
                    try {
                        dimension = virtualTable != null ? virtualTable.getDimension(name) : dialect.getGeometryDimension(databaseSchema, tableName, name, cx);
                    }
                    catch (Exception e) {
                        String msg = "Error occured determing dimension for " + tableName + "." + name;
                        storeLogger.log(Level.WARNING, msg, e);
                    }
                    ab.setBinding(binding);
                    ab.setName(name);
                    ab.setCRS(crs);
                    if (srid != null) {
                        ab.addUserData("nativeSRID", srid);
                    }
                    ab.addUserData(Hints.COORDINATE_DIMENSION, dimension);
                    att = ab.buildDescriptor(name, ab.buildGeometryType());
                } else {
                    ab.setName(name);
                    ab.setBinding(binding);
                    att = ab.buildDescriptor(name, ab.buildType());
                }
                if (pkey.getColumn(att.getLocalName()) != null) {
                    att.getUserData().put("org.geotools.jdbc.pk.column", true);
                }
                dialect.postCreateAttribute(att, tableName, databaseSchema, cx);
                tb.add(att);
            }
            SimpleFeatureType ft = tb.buildFeatureType();
            if (readOnly) {
                ft.getUserData().put("org.geotools.jdbc.readOnly", Boolean.TRUE);
            }
            dialect.postCreateFeatureType(ft, metaData, databaseSchema, cx);
            SimpleFeatureType simpleFeatureType = ft;
            return simpleFeatureType;
        }
        catch (SQLException e) {
            String msg = "Error occurred building feature type";
            throw (IOException)new IOException(msg).initCause(e);
        }
        finally {
            this.getDataStore().releaseConnection(cx, state);
        }
    }

    protected Filter[] splitFilter(Filter original) {
        return this.splitFilter(original, this);
    }

    Filter[] splitFilter(Filter original, FeatureSource source) {
        JDBCFeatureSource featureSource = null;
        featureSource = source instanceof JDBCFeatureSource ? (JDBCFeatureSource)source : ((JDBCFeatureStore)source).getFeatureSource();
        Filter[] split = new Filter[2];
        if (original != null) {
            split = this.getDataStore().getSQLDialect().splitFilter(original, featureSource.getSchema());
        }
        NullHandlingVisitor nhv = new NullHandlingVisitor((FeatureType)source.getSchema());
        split[0] = (Filter)split[0].accept((FilterVisitor)nhv, null);
        SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
        visitor.setFIDValidator(new PrimaryKeyFIDValidator(featureSource));
        visitor.setFeatureType((FeatureType)this.getSchema());
        split[0] = (Filter)split[0].accept((FilterVisitor)visitor, null);
        split[1] = (Filter)split[1].accept((FilterVisitor)visitor, null);
        return split;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getCountInternal(Query query) throws IOException {
        boolean manual;
        JDBCDataStore store = this.getDataStore();
        Filter[] split = this.splitFilter(query.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        boolean bl = manual = postFilter != null && postFilter != Filter.INCLUDE;
        if (!manual && !query.getJoins().isEmpty()) {
            JoinInfo join = JoinInfo.create(query, this);
            manual = join.hasPostFilters();
        }
        if (manual) {
            try {
                this.getDataStore().getLogger().fine("Calculating size manually");
                int count = 0;
                Query preQuery = new Query(query);
                query.setFilter(preFilter);
                try (FeatureReader<SimpleFeatureType, SimpleFeature> preReader = this.getReader(preQuery);
                     FilteringFeatureReader<SimpleFeatureType, SimpleFeature> reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(preReader, postFilter);){
                    while (reader.hasNext()) {
                        reader.next();
                        ++count;
                    }
                }
                return count;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        Connection cx = store.getConnection(this.getState());
        try {
            Query q = new Query(query);
            q.setFilter(preFilter);
            int count = store.getCount(this.getSchema(), q, cx);
            if (!store.getSQLDialect().isLimitOffsetSupported()) {
                if (query.getStartIndex() != null && query.getStartIndex() > 0) {
                    count = query.getStartIndex() > count ? 0 : (count -= query.getStartIndex().intValue());
                }
                if (query.getMaxFeatures() > 0 && count > query.getMaxFeatures()) {
                    count = query.getMaxFeatures();
                }
            }
            int n = count;
            return n;
        }
        finally {
            store.releaseConnection(cx, this.getState());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        JDBCDataStore dataStore = this.getDataStore();
        Filter[] split = this.splitFilter(query.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        if (postFilter != null && postFilter != Filter.INCLUDE || query.getMaxFeatures() < Integer.MAX_VALUE && !this.canLimit() || query.getStartIndex() != null && query.getStartIndex() > 0 && !this.canOffset()) {
            this.getDataStore().getLogger().fine("Calculating bounds manually");
            SingleCRS flatCRS = CRS.getHorizontalCRS(this.getSchema().getCoordinateReferenceSystem());
            ReferencedEnvelope bounds = new ReferencedEnvelope((CoordinateReferenceSystem)flatCRS);
            Query q = new Query(query);
            q.setFilter(postFilter);
            try (FeatureReader<SimpleFeatureType, SimpleFeature> i = this.getReader(q);){
                if (i.hasNext()) {
                    SimpleFeature f = i.next();
                    bounds.init(f.getBounds());
                    while (i.hasNext()) {
                        f = i.next();
                        bounds.include(f.getBounds());
                    }
                }
            }
            return bounds;
        }
        Connection cx = dataStore.getConnection(this.getState());
        try {
            Query q = new Query(query);
            q.setFilter(preFilter);
            ReferencedEnvelope referencedEnvelope = dataStore.getBounds(this.getSchema(), q, cx);
            this.getDataStore().releaseConnection(cx, this.getState());
            return referencedEnvelope;
        }
        catch (Throwable throwable) {
            try {
                this.getDataStore().releaseConnection(cx, this.getState());
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected boolean canFilter() {
        return true;
    }

    @Override
    protected boolean canSort() {
        return true;
    }

    @Override
    protected boolean canRetype() {
        return true;
    }

    @Override
    protected boolean canLimit() {
        return this.getDataStore().getSQLDialect().isLimitOffsetSupported();
    }

    @Override
    protected boolean canOffset() {
        return this.getDataStore().getSQLDialect().isLimitOffsetSupported();
    }

    @Override
    protected boolean canTransact() {
        return true;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader;
        Filter[] split = this.splitFilter(query.getFilter());
        Filter preFilter = split[0];
        Filter postFilter = split[1];
        boolean postFilterRequired = postFilter != null && postFilter != Filter.INCLUDE;
        Query preQuery = new Query(query);
        preQuery.setFilter(preFilter);
        if (postFilterRequired) {
            preQuery.setStartIndex(0);
            preQuery.setMaxFeatures(Integer.MAX_VALUE);
        }
        SimpleFeatureType[] types = this.buildQueryAndReturnFeatureTypes(this.getSchema(), query.getPropertyNames(), postFilter);
        SimpleFeatureType querySchema = types[0];
        SimpleFeatureType returnedSchema = types[1];
        Connection cx = this.getDataStore().getConnection(this.getState());
        try {
            SQLDialect dialect = this.getDataStore().getSQLDialect();
            if (this.getState().getTransaction() == Transaction.AUTO_COMMIT) {
                cx.setAutoCommit(dialect.isAutoCommitQuery());
            }
            if (query.getJoins().isEmpty()) {
                if (dialect instanceof PreparedStatementSQLDialect) {
                    PreparedStatement ps = this.getDataStore().selectSQLPS(querySchema, preQuery, cx);
                    reader = new JDBCFeatureReader(ps, cx, this, querySchema, query);
                } else {
                    String sql = this.getDataStore().selectSQL(querySchema, preQuery);
                    this.getDataStore().getLogger().fine(sql);
                    reader = new JDBCFeatureReader(sql, cx, this, querySchema, query);
                }
            } else {
                JoinInfo join = JoinInfo.create(preQuery, this);
                if (dialect instanceof PreparedStatementSQLDialect) {
                    PreparedStatement ps = this.getDataStore().selectJoinSQLPS(querySchema, join, preQuery, cx);
                    reader = new JDBCJoiningFeatureReader(ps, cx, this, querySchema, join, query);
                } else {
                    String sql = this.getDataStore().selectJoinSQL(querySchema, join, preQuery);
                    this.getDataStore().getLogger().fine(sql);
                    reader = new JDBCJoiningFeatureReader(sql, cx, this, querySchema, join, query);
                }
                if (join.hasPostFilters()) {
                    reader = new JDBCJoiningFilteringFeatureReader(reader, join);
                }
            }
        }
        catch (Throwable e) {
            this.getDataStore().closeSafe(cx);
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        if (postFilterRequired) {
            int offset;
            reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(reader, postFilter);
            if (!returnedSchema.equals(querySchema)) {
                reader = new ReTypeFeatureReader(reader, returnedSchema);
            }
            int n = offset = query.getStartIndex() != null ? query.getStartIndex() : 0;
            if (offset > 0) {
                for (int i = 0; i < offset && reader.hasNext(); ++i) {
                    reader.next();
                }
            }
            if (query.getMaxFeatures() >= 0 && query.getMaxFeatures() < Integer.MAX_VALUE) {
                reader = new MaxFeatureReader<SimpleFeatureType, SimpleFeature>(reader, query.getMaxFeatures());
            }
        }
        return reader;
    }

    SimpleFeatureType[] buildQueryAndReturnFeatureTypes(SimpleFeatureType featureType, String[] propertyNames, Filter filter) {
        SimpleFeatureType returnedSchema;
        SimpleFeatureType[] types = null;
        if (propertyNames == Query.ALL_NAMES) {
            return new SimpleFeatureType[]{featureType, featureType};
        }
        SimpleFeatureType querySchema = returnedSchema = SimpleFeatureTypeBuilder.retype(featureType, propertyNames);
        if (filter != null && !filter.equals(Filter.INCLUDE)) {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor(featureType);
            filter.accept((FilterVisitor)extractor, null);
            String[] extraAttributes = extractor.getAttributeNames();
            if (extraAttributes != null && extraAttributes.length > 0) {
                ArrayList<String> allAttributes = new ArrayList<String>(Arrays.asList(propertyNames));
                for (String extraAttribute : extraAttributes) {
                    if (allAttributes.contains(extraAttribute)) continue;
                    allAttributes.add(extraAttribute);
                }
                String[] allAttributeArray = allAttributes.toArray(new String[allAttributes.size()]);
                querySchema = SimpleFeatureTypeBuilder.retype(this.getSchema(), allAttributeArray);
            }
        }
        types = new SimpleFeatureType[]{querySchema, returnedSchema};
        return types;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        if (visitor instanceof NearestVisitor) {
            return this.handleNearestVisitor(query, visitor);
        }
        Connection cx = this.getDataStore().getConnection(this.getState());
        try {
            Object result = this.getDataStore().getAggregateValue(visitor, this.getSchema(), query, cx);
            boolean bl = result != null;
            return bl;
        }
        finally {
            this.getDataStore().releaseConnection(cx, this.getState());
        }
    }

    private boolean handleNearestVisitor(Query query, FeatureVisitor visitor) throws IOException {
        NearestVisitor nearest = (NearestVisitor)visitor;
        Object targetValue = nearest.getValueToMatch();
        Expression expr = nearest.getExpression();
        String attribute = null;
        if (expr != null && expr instanceof PropertyName) {
            attribute = ((PropertyName)expr).getPropertyName();
        }
        if (attribute == null) {
            return false;
        }
        AttributeDescriptor descriptor = this.getSchema().getDescriptor(attribute);
        if (descriptor == null) {
            return false;
        }
        Class binding = descriptor.getType().getBinding();
        if (Geometry.class.isAssignableFrom(binding) || !Comparable.class.isAssignableFrom(binding)) {
            return false;
        }
        FilterFactory ff = this.getDataStore().getFilterFactory();
        Query qBelow = new Query(query);
        PropertyIsLessThanOrEqualTo lessFilter = ff.lessOrEqual((Expression)ff.property(attribute), (Expression)ff.literal(targetValue));
        qBelow.setFilter((Filter)ff.and(query.getFilter(), (Filter)lessFilter));
        MaxVisitor max = new MaxVisitor(attribute);
        this.handleVisitor(qBelow, max);
        Comparable maxBelow = (Comparable)max.getResult().getValue();
        if (maxBelow != null && maxBelow.equals(targetValue)) {
            nearest.setValue(maxBelow, null);
        } else {
            Query qAbove = new Query(query);
            PropertyIsGreaterThan aboveFilter = ff.greater((Expression)ff.property(attribute), (Expression)ff.literal(targetValue));
            qAbove.setFilter((Filter)ff.and(query.getFilter(), (Filter)aboveFilter));
            MinVisitor min = new MinVisitor(attribute);
            this.handleVisitor(qAbove, min);
            Comparable minAbove = (Comparable)min.getResult().getValue();
            nearest.setValue(maxBelow, minAbove);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ColumnMetadata> getColumnMetadata(Connection cx, String databaseSchema, String tableName, SQLDialect dialect) throws SQLException {
        ArrayList<ColumnMetadata> result = new ArrayList<ColumnMetadata>();
        DatabaseMetaData metaData = cx.getMetaData();
        ResultSet columns = metaData.getColumns(cx.getCatalog(), this.getDataStore().escapeNamePattern(metaData, databaseSchema), this.getDataStore().escapeNamePattern(metaData, tableName), "%");
        try {
            if (this.getDataStore().getFetchSize() > 0) {
                columns.setFetchSize(this.getDataStore().getFetchSize());
            }
            while (columns.next()) {
                ColumnMetadata column = new ColumnMetadata();
                column.name = columns.getString("COLUMN_NAME");
                column.typeName = columns.getString("TYPE_NAME");
                column.sqlType = columns.getInt("DATA_TYPE");
                column.nullable = "YES".equalsIgnoreCase(columns.getString("IS_NULLABLE"));
                column.binding = dialect.getMapping(columns, cx);
                column.restriction = dialect.getRestrictions(columns, cx);
                column.setRemarks(columns.getString(REMARKS));
                if (column.sqlType == 2001) {
                    dialect.handleUserDefinedType(columns, column, cx);
                }
                result.add(column);
            }
        }
        finally {
            this.getDataStore().closeSafe(columns);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<ColumnMetadata> getColumnMetadata(Connection cx, VirtualTable vtable, SQLDialect dialect, JDBCDataStore store) throws SQLException {
        ArrayList<ColumnMetadata> result = new ArrayList<ColumnMetadata>();
        Statement st = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select * from (");
            sb.append(vtable.expandParameters(null));
            sb.append(")");
            dialect.encodeTableAlias("vtable", sb);
            sb.append(" where 1 = 0");
            String sql = sb.toString();
            st = cx.createStatement();
            LOGGER.log(Level.FINE, "Gathering sql view result structure: {0}", sql);
            rs = st.executeQuery(sql);
            ResultSetMetaData metadata = rs.getMetaData();
            for (int i = 1; i < metadata.getColumnCount() + 1; ++i) {
                ColumnMetadata column = new ColumnMetadata();
                column.name = metadata.getColumnLabel(i);
                column.typeName = metadata.getColumnTypeName(i);
                column.sqlType = metadata.getColumnType(i);
                column.nullable = metadata.isNullable(i) != 0;
                column.srid = vtable.getNativeSrid(column.name);
                column.binding = vtable.getGeometryType(column.name);
                if (column.binding == null) {
                    column.binding = store.getMapping(column.typeName);
                    if (column.binding == null) {
                        column.binding = store.getMapping(column.sqlType);
                    }
                }
                result.add(column);
            }
            store.closeSafe(st);
            store.closeSafe(rs);
        }
        catch (Throwable throwable) {
            store.closeSafe(st);
            store.closeSafe(rs);
            throw throwable;
        }
        return result;
    }
}

