/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.cs.DefaultSphericalCS;
import org.geotools.referencing.datum.DefaultGeodeticDatum;
import org.geotools.referencing.wkt.Formatter;

public class DefaultGeocentricCRS
extends AbstractSingleCRS
implements GeocentricCRS {
    private static final long serialVersionUID = 6784642848287659827L;
    public static final DefaultGeocentricCRS CARTESIAN = new DefaultGeocentricCRS(DefaultGeocentricCRS.name(14), (GeodeticDatum)DefaultGeodeticDatum.WGS84, (CartesianCS)DefaultCartesianCS.GEOCENTRIC);
    public static final DefaultGeocentricCRS SPHERICAL = new DefaultGeocentricCRS(DefaultGeocentricCRS.name(204), (GeodeticDatum)DefaultGeodeticDatum.WGS84, (SphericalCS)DefaultSphericalCS.GEOCENTRIC);

    public DefaultGeocentricCRS(GeocentricCRS crs) {
        super((SingleCRS)crs);
    }

    public DefaultGeocentricCRS(String name, GeodeticDatum datum, CartesianCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeocentricCRS(String name, GeodeticDatum datum, SphericalCS cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, CartesianCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public DefaultGeocentricCRS(Map<String, ?> properties, GeodeticDatum datum, SphericalCS cs) {
        super(properties, (Datum)datum, (CoordinateSystem)cs);
    }

    public GeodeticDatum getDatum() {
        return (GeodeticDatum)super.getDatum();
    }

    @Override
    public int hashCode() {
        return 0x54149733 ^ super.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        Unit<?> unit = this.getUnit();
        formatter.append((IdentifiedObject)this.datum);
        formatter.append((IdentifiedObject)((GeodeticDatum)this.datum).getPrimeMeridian());
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append((IdentifiedObject)this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(GeocentricCRS.class);
        }
        return "GEOCCS";
    }
}

