/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.wms;

import java.util.Collections;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.factory.wms.Code;
import org.geotools.referencing.operation.DefiningConversion;

abstract class Factlet {
    Factlet() {
    }

    public abstract int code();

    public abstract String getName();

    public abstract String getClassification();

    public final ProjectedCRS create(Code code, ReferencingFactoryContainer factories) throws FactoryException {
        String classification = this.getClassification();
        ParameterValueGroup parameters = factories.getMathTransformFactory().getDefaultParameters(classification);
        this.setProjectionParameters(parameters, code);
        String name = this.getName();
        DefiningConversion conversion = new DefiningConversion(name, parameters);
        return factories.getCRSFactory().createProjectedCRS(Collections.singletonMap("name", name), (GeographicCRS)DefaultGeographicCRS.WGS84, (Conversion)conversion, (CartesianCS)DefaultCartesianCS.PROJECTED);
    }

    protected abstract void setProjectionParameters(ParameterValueGroup var1, Code var2);
}

