/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.ConicProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.MapProjection;

public class LambertConformal2SP
extends LambertConformal {
    private static final long serialVersionUID = 7184350446186057405L;

    protected LambertConformal2SP(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3240860802816724947L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Lambert_Conformal_Conic_2SP"), new NamedIdentifier(Citations.EPSG, "Lambert Conic Conformal (2SP)"), new NamedIdentifier(Citations.EPSG, "9802"), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertConfConic_2SP"), new NamedIdentifier(Citations.GEOTIFF, "CT_LambertConfConic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational((int)119))}, (GeneralParameterDescriptor[])new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, CENTRAL_MERIDIAN, LATITUDE_OF_ORIGIN, STANDARD_PARALLEL_1, STANDARD_PARALLEL_2, FALSE_EASTING, FALSE_NORTHING, SCALE_FACTOR});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<ConicProjection> getOperationType() {
            return ConicProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            ParameterValue sp1 = Provider.getParameter(STANDARD_PARALLEL_1, parameters);
            ParameterValue sp2 = Provider.getParameter(STANDARD_PARALLEL_2, parameters);
            if (sp1 != null && sp2 != null && sp1.doubleValue() < sp2.doubleValue()) {
                double temp = sp1.doubleValue();
                sp1.setValue(sp2.doubleValue());
                sp2.setValue(temp);
            }
            return new LambertConformal2SP(parameters);
        }
    }
}

