/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.filter;

import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.filter.AbstractFilter;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.ExpressionSAXParser;
import org.geotools.filter.FilterHandler;
import org.geotools.filter.FilterSAXParser;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LogicSAXParser;
import org.geotools.gml.GMLHandlerJTS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class FilterFilter
extends XMLFilterImpl
implements GMLHandlerJTS {
    private static final Logger LOGGER = Logging.getLogger(FilterFilter.class);
    private LogicSAXParser logicFactory;
    private FilterSAXParser filterFactory;
    private ExpressionSAXParser expressionFactory;
    private FilterHandler parent;
    private SimpleFeatureType schema;
    private boolean isLogicFilter = false;
    private boolean isFidFilter = false;
    protected boolean insideFilter = false;
    private boolean insideDistance = false;
    private String units;
    private StringBuffer characters;
    private boolean convertLiteralToNumber = true;

    public FilterFilter(FilterHandler parent, SimpleFeatureType schema) {
        this.parent = parent;
        this.schema = schema;
        this.expressionFactory = new ExpressionSAXParser(schema);
        this.filterFactory = new FilterSAXParser();
        this.logicFactory = new LogicSAXParser();
        this.characters = new StringBuffer();
    }

    public FilterFilter(FilterHandler parent, SimpleFeatureType schema, boolean convertLiteralToNumber) {
        this(parent, schema);
        this.convertLiteralToNumber = convertLiteralToNumber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        LOGGER.finer("found start element: " + localName);
        this.characters.setLength(0);
        if (localName.equals("Filter")) {
            this.insideFilter = true;
            this.expressionFactory = new ExpressionSAXParser(this.schema);
            return;
        } else if (this.insideFilter) {
            short filterType = FilterFilter.convertType(localName);
            LOGGER.finest("types: (xml): " + localName + "; (internal): " + filterType);
            if (!(filterType != -1 || localName.equals("UpperBoundary") || localName.equals("LowerBoundary") || localName.equals("Distance") || localName.endsWith("Member"))) {
                throw new SAXException("Attempted to construct illegal filter - I dont understand the tag: " + qName + ".  HINT: tags are case-sensitive!");
            }
            try {
                if (this.isFidFilter) {
                    if (filterType == 22) {
                        LOGGER.finer("sending attributes to existing FID filter");
                        this.filterFactory.setAttributes(atts);
                    } else {
                        this.isFidFilter = false;
                        LOGGER.finer("is fid (1): " + this.isFidFilter);
                        if (this.isLogicFilter) {
                            this.addFilterToLogicFactory();
                        } else {
                            this.addFilterToParent();
                        }
                    }
                }
                if (this.isFidFilter) return;
                LOGGER.finest("is logic?");
                if (AbstractFilter.isLogicFilter(filterType)) {
                    LOGGER.finer("found a logic filter start");
                    this.isLogicFilter = true;
                    this.logicFactory.start(filterType);
                    return;
                }
                if (AbstractFilter.isSimpleFilter(filterType)) {
                    LOGGER.finer("found a simple filter start");
                    this.filterFactory.start(filterType);
                    if (filterType == 20) {
                        LOGGER.finer("sending attributes for like filter");
                        this.filterFactory.setAttributes(atts);
                        return;
                    }
                    if (filterType != 22) return;
                    LOGGER.finer("sending attributes to new FID filter");
                    this.filterFactory.setAttributes(atts);
                    this.isFidFilter = true;
                    LOGGER.finer("is fid (3): " + this.isFidFilter);
                    return;
                }
                if (DefaultExpression.isExpression(filterType)) {
                    LOGGER.finest("found an expression filter start");
                    this.expressionFactory.start(localName, atts);
                    return;
                }
                if (!localName.equals("Distance")) return;
                LOGGER.finest("inside distance");
                if ("units".equals(atts.getLocalName(0))) {
                    this.units = atts.getValue(0);
                    LOGGER.finest("units = " + this.units);
                }
                this.insideDistance = true;
                return;
            }
            catch (IllegalFilterException ife) {
                throw new SAXException("Attempted to construct illegal filter: " + ife.getMessage(), ife);
            }
        } else {
            this.parent.startElement(namespaceURI, localName, qName, atts);
        }
    }

    private void addFilterToParent() throws IllegalFilterException {
        this.parent.filter(this.filterFactory.create());
        this.expressionFactory = new ExpressionSAXParser(this.schema);
    }

    private void addFilterToLogicFactory() throws IllegalFilterException {
        this.logicFactory.add(this.filterFactory.create());
        this.expressionFactory = new ExpressionSAXParser(this.schema);
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        this.characters.append(chars, start, length);
    }

    private void processCharacters() throws SAXException {
        if (this.insideFilter) {
            String message = this.characters.toString();
            try {
                if (this.insideDistance) {
                    LOGGER.finest("calling set distance on " + message + ", " + this.units);
                    this.filterFactory.setDistance(message, this.units);
                }
                LOGGER.finest("sending to expression factory: " + message);
                this.expressionFactory.message(message, this.convertLiteralToNumber);
            }
            catch (IllegalFilterException ife) {
                throw new SAXException(ife);
            }
        } else if (this.characters.length() > 0) {
            LOGGER.finer("delegating characters to parent: " + this.characters.toString());
            int len = this.characters.length();
            char[] chars = new char[this.characters.length()];
            this.characters.getChars(0, len, chars, 0);
            this.parent.characters(chars, 0, len);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        LOGGER.finer("found end element: " + localName);
        this.processCharacters();
        if (localName.equals("Filter")) {
            if (this.isFidFilter && !localName.equals("FeatureId")) {
                this.isFidFilter = false;
                LOGGER.finer("is fid (2): " + this.isFidFilter);
                try {
                    if (this.isLogicFilter) {
                        this.addFilterToLogicFactory();
                    } else {
                        this.addFilterToParent();
                    }
                }
                catch (IllegalFilterException e) {
                    throw new SAXException("Attempted to construct illegal filter: " + e.getMessage());
                }
            }
            this.insideFilter = false;
            return;
        }
        if (this.insideFilter) {
            short filterType = FilterFilter.convertType(localName);
            try {
                if (AbstractFilter.isLogicFilter(filterType)) {
                    LOGGER.finest("found a logic filter end");
                    if (this.isFidFilter) {
                        this.addFilterToLogicFactory();
                        this.isFidFilter = false;
                    }
                    this.logicFactory.end(filterType);
                    if (!this.logicFactory.isComplete()) return;
                    LOGGER.finer("creating logic factory");
                    this.parent.filter(this.logicFactory.create());
                    return;
                }
                if (AbstractFilter.isSimpleFilter(filterType) && !this.isFidFilter) {
                    LOGGER.finest("found a simple filter end");
                    if (this.isLogicFilter) {
                        this.addFilterToLogicFactory();
                        return;
                    }
                    this.addFilterToParent();
                    return;
                }
                if (DefaultExpression.isExpression(filterType)) {
                    LOGGER.finer("found an expression filter end");
                    this.expressionFactory.end(localName);
                    if (!this.expressionFactory.isReady()) return;
                    LOGGER.finer("expression factory is ready");
                    this.filterFactory.expression(this.expressionFactory.create());
                    return;
                }
                if (!localName.equals("Distance")) return;
                this.insideDistance = false;
                return;
            }
            catch (IllegalFilterException e) {
                throw new SAXException("Attempted to construct illegal filter: " + e.getMessage(), e);
            }
        } else {
            this.parent.endElement(namespaceURI, localName, qName);
        }
    }

    @Override
    public void geometry(Geometry geometry) throws RuntimeException {
        try {
            LOGGER.finer("got geometry: " + geometry);
            this.expressionFactory.geometry(geometry);
            if (this.expressionFactory.isReady()) {
                LOGGER.finer("expression factory made expression and sent to filter factory");
                this.filterFactory.expression(this.expressionFactory.create());
            }
        }
        catch (IllegalFilterException ife) {
            LOGGER.finer("Had problems adding geometry: " + geometry.toString());
            throw new RuntimeException("problem adding geometry to filter ", ife);
        }
    }

    protected static short convertType(String filterType) {
        if (filterType.equals("Or")) {
            return 1;
        }
        if (filterType.equals("And")) {
            return 2;
        }
        if (filterType.equals("Not")) {
            return 3;
        }
        if (filterType.equals("Equals")) {
            return 5;
        }
        if (filterType.equals("Disjoint")) {
            return 6;
        }
        if (filterType.equals("DWithin")) {
            return 24;
        }
        if (filterType.equals("Intersects")) {
            return 7;
        }
        if (filterType.equals("Touches")) {
            return 8;
        }
        if (filterType.equals("Crosses")) {
            return 9;
        }
        if (filterType.equals("Within")) {
            return 10;
        }
        if (filterType.equals("Contains")) {
            return 11;
        }
        if (filterType.equals("Overlaps")) {
            return 12;
        }
        if (filterType.equals("Beyond")) {
            return 13;
        }
        if (filterType.equals("BBOX")) {
            return 4;
        }
        if (filterType.equals("PropertyIsEqualTo")) {
            return 14;
        }
        if (filterType.equals("PropertyIsNotEqualTo")) {
            return 23;
        }
        if (filterType.equals("PropertyIsLessThan")) {
            return 15;
        }
        if (filterType.equals("PropertyIsGreaterThan")) {
            return 16;
        }
        if (filterType.equals("PropertyIsLessThanOrEqualTo")) {
            return 17;
        }
        if (filterType.equals("PropertyIsGreaterThanOrEqualTo")) {
            return 18;
        }
        if (filterType.equals("PropertyIsBetween")) {
            return 19;
        }
        if (filterType.equals("PropertyIsLike")) {
            return 20;
        }
        if (filterType.equals("PropertyIsNull")) {
            return 21;
        }
        if (filterType.equals("FeatureId")) {
            return 22;
        }
        if (filterType.equals("Add")) {
            return 105;
        }
        if (filterType.equals("Sub")) {
            return 106;
        }
        if (filterType.equals("Mul")) {
            return 107;
        }
        if (filterType.equals("Div")) {
            return 108;
        }
        if (filterType.equals("PropertyName")) {
            return 101;
        }
        if (filterType.equals("Literal")) {
            return 109;
        }
        if (filterType.equals("Function")) {
            return 114;
        }
        return -1;
    }
}

