/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;

class NullHandlingVisitor
extends DuplicatingFilterVisitor {
    private FeatureType schema;

    public NullHandlingVisitor(FeatureType schema) {
        this.schema = schema;
    }

    public NullHandlingVisitor() {
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        return this.guardAgainstNulls((BinaryComparisonOperator)super.visit(filter, extraData));
    }

    private Object guardAgainstNulls(BinaryComparisonOperator clone) {
        Filter result = this.guardAgainstNulls((Filter)clone, clone.getExpression1());
        result = this.guardAgainstNulls(result, clone.getExpression2());
        return result;
    }

    @Override
    public Object visit(PropertyIsLike filter, Object extraData) {
        PropertyIsLike clone = (PropertyIsLike)super.visit(filter, extraData);
        return this.guardAgainstNulls((Filter)filter, clone.getExpression());
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extraData) {
        PropertyIsBetween clone = (PropertyIsBetween)super.visit(filter, extraData);
        Filter f = this.guardAgainstNulls((Filter)clone, clone.getExpression());
        f = this.guardAgainstNulls(f, clone.getLowerBoundary());
        f = this.guardAgainstNulls(f, clone.getUpperBoundary());
        return f;
    }

    @Override
    public Object visit(Or filter, Object extraData) {
        if (filter.getChildren().size() < 2) {
            return super.visit(filter, extraData);
        }
        LinkedHashMap<Object, Object> grouped = new LinkedHashMap<Object, Object>();
        int maxListSize = 0;
        for (Filter child : filter.getChildren()) {
            if (child instanceof PropertyIsNotEqualTo || !(child instanceof BinaryComparisonOperator)) {
                grouped.put(child, child.accept((FilterVisitor)this, null));
                continue;
            }
            String name = this.getComparisonPropertyName((BinaryComparisonOperator)child);
            if (name == null) {
                grouped.put(child, child.accept((FilterVisitor)this, null));
                continue;
            }
            ArrayList<Filter> filters = (ArrayList<Filter>)grouped.get(name);
            if (filters == null) {
                filters = new ArrayList<Filter>();
                grouped.put(name, filters);
            }
            filters.add(child);
            maxListSize = Math.max(filters.size(), maxListSize);
        }
        if (maxListSize < 2) {
            return super.visit(filter, extraData);
        }
        ArrayList<Object> children = new ArrayList<Object>();
        for (Map.Entry entry : grouped.entrySet()) {
            if (entry.getKey() instanceof String) {
                Not notNull = this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property((String)entry.getKey())));
                List filters = (List)entry.getValue();
                if (filters.size() == 1) {
                    children.add(this.ff.and((Filter)filters.get(0), (Filter)notNull));
                    continue;
                }
                children.add(this.ff.and((Filter)this.ff.or(filters), (Filter)notNull));
                continue;
            }
            children.add((Filter)entry.getValue());
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return this.ff.or(children);
    }

    private String getComparisonPropertyName(BinaryComparisonOperator filter) {
        if (filter.getExpression1() instanceof PropertyName && filter.getExpression2() instanceof Literal) {
            return ((PropertyName)filter.getExpression1()).getPropertyName();
        }
        if (filter.getExpression2() instanceof PropertyName && filter.getExpression1() instanceof Literal) {
            return ((PropertyName)filter.getExpression2()).getPropertyName();
        }
        return null;
    }

    private Filter guardAgainstNulls(Filter filter, Expression potentialPropertyName) {
        PropertyName pn;
        String name;
        if (potentialPropertyName instanceof PropertyName && this.isNillable(name = (pn = (PropertyName)potentialPropertyName).getPropertyName())) {
            Not notNull = this.ff.not((Filter)this.ff.isNull((Expression)this.ff.property(name)));
            if (filter instanceof And) {
                And and = (And)filter;
                ArrayList<Not> children = new ArrayList<Not>(and.getChildren());
                children.add(notNull);
                return this.ff.and(children);
            }
            return this.ff.and(filter, (Filter)notNull);
        }
        return filter;
    }

    private boolean isNillable(String name) {
        if (this.schema == null) {
            return true;
        }
        PropertyDescriptor descriptor = this.schema.getDescriptor(name);
        return descriptor == null || descriptor.isNillable();
    }
}

