/*
 * Decompiled with CFR 0.152.
 */
package org.atteo.xmlcombiner;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.atteo.xmlcombiner.ChildContextsMapper;
import org.atteo.xmlcombiner.Context;
import org.atteo.xmlcombiner.Key;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class KeyAttributesChildContextsMapper
implements ChildContextsMapper {
    @Override
    public Map<Key, List<Context>> mapChildContexts(Context parent, List<String> keyAttributeNames) {
        List<Context> contexts = parent.groupChildContexts();
        LinkedHashMap<Key, List<Context>> map = new LinkedHashMap<Key, List<Context>>();
        for (Context context : contexts) {
            Element contextElement = context.getElement();
            if (contextElement != null) {
                LinkedHashMap<String, String> keys = new LinkedHashMap<String, String>();
                for (String keyAttributeName : keyAttributeNames) {
                    Attr keyNode = contextElement.getAttributeNode(keyAttributeName);
                    if (keyNode == null) continue;
                    keys.put(keyAttributeName, keyNode.getValue());
                }
                Attr keyNode = contextElement.getAttributeNode("combine.id");
                if (keyNode != null) {
                    keys.put("combine.id", keyNode.getValue());
                }
                Key key = new Key(contextElement.getTagName(), keys);
                List destinationContexts = map.computeIfAbsent(key, k -> new ArrayList());
                destinationContexts.add(context);
                continue;
            }
            List destinationContexts = map.computeIfAbsent(Key.BEFORE_END, k -> new ArrayList());
            destinationContexts.add(context);
        }
        return map;
    }
}

