/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.io.source.IRandomAccessSource;
import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RASInputStream;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.WindowRandomAccessSource;
import com.itextpdf.kernel.pdf.DocumentProperties;
import com.itextpdf.kernel.pdf.DocumentRevision;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfXrefTable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class PdfRevisionsReader {
    private final PdfReader reader;
    private List<DocumentRevision> documentRevisions = null;
    private IMetaInfo metaInfo;

    public PdfRevisionsReader(PdfReader reader) {
        this.reader = reader;
    }

    public void setEventCountingMetaInfo(IMetaInfo metaInfo) {
        this.metaInfo = metaInfo;
    }

    public List<DocumentRevision> getAllRevisions() throws IOException {
        if (this.documentRevisions == null) {
            RandomAccessFileOrArray raf = this.reader.getSafeFile();
            WindowRandomAccessSource source = new WindowRandomAccessSource(raf.createSourceView(), 0L, raf.length());
            try (RASInputStream inputStream = new RASInputStream((IRandomAccessSource)source);
                 PdfReader newReader = new PdfReader((InputStream)inputStream);
                 PdfDocument newDocument = new PdfDocument(newReader, new DocumentProperties().setEventCountingMetaInfo(this.metaInfo));){
                newDocument.getXref().unmarkReadingCompleted();
                newDocument.getXref().clearAllReferences();
                RevisionsXrefProcessor xrefProcessor = new RevisionsXrefProcessor();
                newReader.setXrefProcessor(xrefProcessor);
                newReader.readXref();
                this.documentRevisions = xrefProcessor.getDocumentRevisions();
            }
            Collections.reverse(this.documentRevisions);
        }
        return this.documentRevisions;
    }

    static class RevisionsXrefProcessor
    extends PdfReader.XrefProcessor {
        private final List<DocumentRevision> documentRevisions = new ArrayList<DocumentRevision>();

        RevisionsXrefProcessor() {
        }

        @Override
        void processXref(PdfXrefTable xrefTable, PdfTokenizer tokenizer) throws IOException {
            HashSet<PdfIndirectReference> modifiedObjects = new HashSet<PdfIndirectReference>();
            for (int i = 0; i < xrefTable.size(); ++i) {
                if (xrefTable.get(i) == null) continue;
                modifiedObjects.add(xrefTable.get(i));
            }
            long eofOffset = tokenizer.getNextEof();
            this.documentRevisions.add(new DocumentRevision(eofOffset, modifiedObjects));
            xrefTable.clearAllReferences();
        }

        List<DocumentRevision> getDocumentRevisions() {
            return this.documentRevisions;
        }
    }
}

