/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import net.opengis.ows11.ResponsiblePartySubsetType;
import org.geotools.api.metadata.citation.Contact;
import org.geotools.api.metadata.citation.OnLineFunction;
import org.geotools.api.metadata.citation.OnLineResource;
import org.geotools.api.metadata.citation.ResponsibleParty;
import org.geotools.api.metadata.citation.Role;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.citation.ContactImpl;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;

public class ResponsiblePartyImpl
extends MetadataEntity
implements ResponsibleParty {
    private static final long serialVersionUID = -2477962229031486552L;
    static final InternationalString OGC_NAME = new SimpleInternationalString("Open Geospatial Consortium");
    public static ResponsibleParty OGC;
    public static ResponsibleParty OPEN_GIS;
    public static ResponsibleParty EPSG;
    public static ResponsibleParty GEOTIFF;
    public static ResponsibleParty ESRI;
    public static ResponsibleParty IAU;
    public static ResponsibleParty ORACLE;
    public static ResponsibleParty POSTGIS;
    public static ResponsibleParty SUN_MICROSYSTEMS;
    public static ResponsibleParty GEOTOOLS;
    private String individualName;
    private InternationalString organisationName;
    private InternationalString positionName;
    private Contact contactInfo;
    private Role role;

    public static ResponsibleParty OGC(Role role, OnLineResource resource) {
        ContactImpl contact = new ContactImpl(resource);
        contact.freeze();
        ResponsiblePartyImpl ogc = new ResponsiblePartyImpl(role);
        ogc.setOrganisationName(OGC_NAME);
        ogc.setContactInfo(contact);
        ogc.freeze();
        return ogc;
    }

    public static ResponsibleParty OGC(Role role, OnLineFunction function, URI onlineResource) {
        OnLineResourceImpl resource = new OnLineResourceImpl(onlineResource);
        resource.setFunction(function);
        resource.freeze();
        return ResponsiblePartyImpl.OGC(role, resource);
    }

    static ResponsibleParty OGC(Role role, OnLineFunction function, String onlineResource) {
        try {
            return ResponsiblePartyImpl.OGC(role, function, new URI(onlineResource));
        }
        catch (URISyntaxException badContact) {
            Logging.unexpectedException(LOGGER, ResponsibleParty.class, "OGC", badContact);
            return OGC;
        }
    }

    public ResponsiblePartyImpl() {
    }

    public ResponsiblePartyImpl(ResponsibleParty source) {
        super(source);
    }

    public ResponsiblePartyImpl(Role role) {
        this.setRole(role);
    }

    public ResponsiblePartyImpl(ResponsiblePartySubsetType rpSubset) {
        if (rpSubset.getContactInfo() != null) {
            this.setContactInfo(new ContactImpl(rpSubset.getContactInfo()));
        }
        if (rpSubset.getIndividualName() != null) {
            this.setIndividualName(rpSubset.getIndividualName().toString());
        }
        if (rpSubset.getPositionName() != null) {
            this.setPositionName(new SimpleInternationalString(rpSubset.getPositionName()));
        }
    }

    @Override
    public String getIndividualName() {
        return this.individualName;
    }

    public void setIndividualName(String newValue) {
        this.checkWritePermission();
        this.individualName = newValue;
    }

    @Override
    public InternationalString getOrganisationName() {
        return this.organisationName;
    }

    public void setOrganisationName(InternationalString newValue) {
        this.checkWritePermission();
        this.organisationName = newValue;
    }

    @Override
    public InternationalString getPositionName() {
        return this.positionName;
    }

    public void setPositionName(InternationalString newValue) {
        this.checkWritePermission();
        this.positionName = newValue;
    }

    @Override
    public Contact getContactInfo() {
        return this.contactInfo;
    }

    public void setContactInfo(Contact newValue) {
        this.checkWritePermission();
        this.contactInfo = newValue;
    }

    @Override
    public Role getRole() {
        return this.role;
    }

    public void setRole(Role newValue) {
        this.checkWritePermission();
        this.role = newValue;
    }

    static {
        ResponsiblePartyImpl r = new ResponsiblePartyImpl(Role.RESOURCE_PROVIDER);
        r.setOrganisationName(OGC_NAME);
        r.setContactInfo(ContactImpl.OGC);
        r.freeze();
        OGC = r;
        r = new ResponsiblePartyImpl(Role.RESOURCE_PROVIDER);
        r.setOrganisationName(new SimpleInternationalString("OpenGIS consortium"));
        r.setContactInfo(ContactImpl.OPEN_GIS);
        r.freeze();
        OPEN_GIS = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("European Petroleum Survey Group"));
        r.setContactInfo(ContactImpl.EPSG);
        r.freeze();
        EPSG = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("GeoTIFF"));
        r.setContactInfo(ContactImpl.GEOTIFF);
        r.freeze();
        GEOTIFF = r;
        r = new ResponsiblePartyImpl(Role.OWNER);
        r.setOrganisationName(new SimpleInternationalString("ESRI"));
        r.setContactInfo(ContactImpl.ESRI);
        r.freeze();
        ESRI = r;
        r = new ResponsiblePartyImpl(Role.OWNER);
        r.setOrganisationName(new SimpleInternationalString("IAU"));
        r.setContactInfo(ContactImpl.IAU);
        r.freeze();
        IAU = r;
        r = new ResponsiblePartyImpl(Role.OWNER);
        r.setOrganisationName(new SimpleInternationalString("Oracle"));
        r.setContactInfo(ContactImpl.ORACLE);
        r.freeze();
        ORACLE = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("PostGIS"));
        r.setContactInfo(ContactImpl.POSTGIS);
        r.freeze();
        POSTGIS = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("Sun Microsystems"));
        r.setContactInfo(ContactImpl.SUN_MICROSYSTEMS);
        r.freeze();
        SUN_MICROSYSTEMS = r;
        r = new ResponsiblePartyImpl(Role.PRINCIPAL_INVESTIGATOR);
        r.setOrganisationName(new SimpleInternationalString("Geotools"));
        r.setContactInfo(ContactImpl.GEOTOOLS);
        r.freeze();
        GEOTOOLS = r;
    }
}

