/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.jdbc.util.converter;

import java.sql.Connection;
import java.sql.SQLException;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverter;
import nl.b3p.jdbc.util.converter.HSQLJdbcConverter;
import nl.b3p.jdbc.util.converter.MssqlJdbcConverter;
import nl.b3p.jdbc.util.converter.OracleConnectionUnwrapper;
import nl.b3p.jdbc.util.converter.OracleJdbcConverter;
import nl.b3p.jdbc.util.converter.PostgisJdbcConverter;
import oracle.jdbc.OracleConnection;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeometryJdbcConverterFactory {
    private static final Log LOG = LogFactory.getLog(GeometryJdbcConverterFactory.class);

    public static GeometryJdbcConverter getGeometryJdbcConverter(Connection conn) {
        String databaseProductName;
        try {
            databaseProductName = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            throw new UnsupportedOperationException("Cannot get database product name", ex);
        }
        if (databaseProductName.contains("PostgreSQL")) {
            PostgisJdbcConverter geomToJdbc = new PostgisJdbcConverter();
            try {
                String schema = (String)new QueryRunner().query(conn, "select current_schema", (ResultSetHandler)new ScalarHandler());
                geomToJdbc.setSchema(schema);
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get/set schema: " + databaseProductName, ex);
            }
            return geomToJdbc;
        }
        if (databaseProductName.contains("Oracle")) {
            int majorVersion = 19;
            try {
                majorVersion = conn.getMetaData().getDatabaseMajorVersion();
            }
            catch (SQLException ex) {
                LOG.warn((Object)"Uitlezen database versie is mislukt.", (Throwable)ex);
            }
            try {
                OracleConnection oc = OracleConnectionUnwrapper.unwrap(conn);
                switch (majorVersion) {
                    case 11: {
                        throw new UnsupportedOperationException("Oracle 11 is niet ondersteund");
                    }
                    case 12: {
                        throw new UnsupportedOperationException("Oracle 12 is niet ondersteund");
                    }
                }
                OracleJdbcConverter geomToJdbc = new OracleJdbcConverter(oc);
                geomToJdbc.setSchema(oc.getCurrentSchema());
                return geomToJdbc;
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get connection: " + databaseProductName, ex);
            }
        }
        if (databaseProductName.contains("Microsoft SQL Server")) {
            MssqlJdbcConverter geomToJdbc = new MssqlJdbcConverter();
            try {
                String schema = (String)new QueryRunner().query(conn, "SELECT SCHEMA_NAME()", (ResultSetHandler)new ScalarHandler());
                geomToJdbc.setSchema(schema);
            }
            catch (SQLException ex) {
                throw new UnsupportedOperationException("Cannot get/set schema: " + databaseProductName, ex);
            }
            return geomToJdbc;
        }
        if (databaseProductName.contains("HSQL Database Engine")) {
            return new HSQLJdbcConverter();
        }
        throw new UnsupportedOperationException("Unknown database: " + databaseProductName);
    }
}

