/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.utils;

import org.javasimon.CounterSample;
import org.javasimon.utils.SimonUtils;

public class CounterAggregate {
    private long counter;
    private long incrementSum;
    private long decrementSum;
    private long max = Long.MIN_VALUE;
    private long min = Long.MAX_VALUE;
    private long maxTimestamp;
    private long minTimestamp;

    CounterAggregate() {
    }

    public long getCounter() {
        return this.counter;
    }

    public long getIncrementSum() {
        return this.incrementSum;
    }

    public long getDecrementSum() {
        return this.decrementSum;
    }

    public long getMax() {
        return this.max;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    public long getMin() {
        return this.min;
    }

    public long getMinTimestamp() {
        return this.minTimestamp;
    }

    void addSample(CounterSample sample) {
        this.counter += sample.getCounter();
        this.incrementSum += sample.getIncrementSum();
        this.decrementSum += sample.getDecrementSum();
        if (this.min > sample.getMin()) {
            this.min = sample.getMin();
            this.minTimestamp = sample.getMinTimestamp();
        }
        if (this.max < sample.getMax()) {
            this.max = sample.getMax();
            this.maxTimestamp = sample.getMaxTimestamp();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CounterAggregate that = (CounterAggregate)o;
        if (this.counter != that.counter) {
            return false;
        }
        if (this.decrementSum != that.decrementSum) {
            return false;
        }
        if (this.incrementSum != that.incrementSum) {
            return false;
        }
        if (this.max != that.max) {
            return false;
        }
        if (this.maxTimestamp != that.maxTimestamp) {
            return false;
        }
        if (this.min != that.min) {
            return false;
        }
        return this.minTimestamp == that.minTimestamp;
    }

    public int hashCode() {
        int result = (int)(this.counter ^ this.counter >>> 32);
        result = 31 * result + (int)(this.incrementSum ^ this.incrementSum >>> 32);
        result = 31 * result + (int)(this.decrementSum ^ this.decrementSum >>> 32);
        result = 31 * result + (int)(this.max ^ this.max >>> 32);
        result = 31 * result + (int)(this.min ^ this.min >>> 32);
        result = 31 * result + (int)(this.maxTimestamp ^ this.maxTimestamp >>> 32);
        result = 31 * result + (int)(this.minTimestamp ^ this.minTimestamp >>> 32);
        return result;
    }

    public String toString() {
        return "CounterAggregate{counter=" + this.counter + ", incrementSum=" + this.incrementSum + ", decrementSum=" + this.decrementSum + ", max=" + SimonUtils.presentMinMaxCount(this.max) + ", min=" + SimonUtils.presentMinMaxCount(this.min) + ", maxTimestamp=" + SimonUtils.presentTimestamp(this.maxTimestamp) + ", minTimestamp=" + SimonUtils.presentTimestamp(this.minTimestamp) + '}';
    }
}

