/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.checks;

import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import nl.b3p.brmo.loader.checks.Afgifte;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class AfgiftelijstParser {
    private final DecimalFormat decimalFormat = new DecimalFormat("0");

    public List<Afgifte> parse(InputStream input) throws IOException {
        return this.parseExcel(input);
    }

    private List<Afgifte> parseExcel(InputStream input) throws IOException {
        ArrayList<Afgifte> afgiftes = new ArrayList<Afgifte>();
        Workbook wb = WorkbookFactory.create((InputStream)input);
        Sheet sheet = wb.getSheetAt(0);
        boolean first = true;
        for (Row row : sheet) {
            if (first) {
                first = false;
                continue;
            }
            Cell c = row.getCell(0);
            if (c == null) break;
            Afgifte afgifte = new Afgifte();
            afgiftes.add(afgifte);
            afgifte.setKlantnummer(this.getStringValue(row.getCell(0)));
            afgifte.setContractnummer(this.getStringValue(row.getCell(1)));
            afgifte.setDatum(row.getCell(2).getStringCellValue());
            afgifte.setBestandsnaam(row.getCell(3).getStringCellValue());
            afgifte.setRapport(row.getCell(4).getStringCellValue().equals("J"));
            afgifte.setGeleverd(row.getCell(5).getStringCellValue().equals("J"));
        }
        return afgiftes;
    }

    private String getStringValue(Cell c) {
        switch (c.getCellType()) {
            case STRING: {
                return c.getStringCellValue();
            }
            case NUMERIC: {
                return this.decimalFormat.format(c.getNumericCellValue());
            }
        }
        return null;
    }
}

