/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.brmo.loader.xml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.brmo.loader.StagingProxy;
import nl.b3p.brmo.loader.entity.Bericht;
import nl.b3p.brmo.loader.entity.WozBericht;
import nl.b3p.brmo.loader.util.RsgbTransformer;
import nl.b3p.brmo.loader.xml.BrmoXMLReader;
import org.apache.commons.io.input.TeeInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WozXMLReader
extends BrmoXMLReader {
    public static final String PREFIX_PRS = "WOZ.NPS.";
    public static final String PREFIX_NNP = "WOZ.NNP.";
    public static final String PREFIX_WOZ = "WOZ.WOZ.";
    public static final String PREFIX_VES = "WOZ.VES.";
    private static final Log LOG = LogFactory.getLog(WozXMLReader.class);
    private final String pathToXsl = "/xsl/woz-brxml-preprocessor.xsl";
    private final StagingProxy staging;
    private final XPathFactory xPathfactory = XPathFactory.newInstance();
    private InputStream in;
    private Templates template;
    private NodeList objectNodes = null;
    private int index;
    private String brOrigXML = null;
    private String betrokkenWaterschap = null;
    private String gemeenteCode = null;

    public WozXMLReader(InputStream in, Date bestandsDatum, StagingProxy staging) throws Exception {
        this.in = in;
        this.staging = staging;
        this.setBestandsDatum(bestandsDatum);
        this.init();
    }

    @Override
    public void init() throws Exception {
        XPathExpression eersteWaterschap;
        Node ws;
        XPathExpression eersteGemeente;
        Node gem;
        this.soort = "woz";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.in = new TeeInputStream(this.in, (OutputStream)bos, true);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(this.in);
        this.brOrigXML = bos.toString(StandardCharsets.UTF_8);
        LOG.trace((Object)("Originele WOZ xml is: \n" + this.brOrigXML));
        TransformerFactory tf = TransformerFactory.newInstance();
        tf.setURIResolver((href, base) -> {
            LOG.debug((Object)("looking for: " + href + " base: " + base));
            return new StreamSource(RsgbTransformer.class.getResourceAsStream("/xsl/" + href));
        });
        StreamSource xsl = new StreamSource(WozXMLReader.class.getResourceAsStream("/xsl/woz-brxml-preprocessor.xsl"));
        this.template = tf.newTemplates(xsl);
        XPath xpath = this.xPathfactory.newXPath();
        if (this.getBestandsDatum() == null) {
            LOG.debug((Object)"Tijdstip bericht was niet gegeven; alsnog proberen op te zoeken in bericht.");
            XPathExpression tijdstipBericht = xpath.compile("//*[local-name()='tijdstipBericht']");
            Node datum = (Node)tijdstipBericht.evaluate(doc, XPathConstants.NODE);
            this.setDatumAsString(datum.getTextContent(), "yyyyMMddHHmmssSSS");
            LOG.debug((Object)("Tijdstip bericht ingesteld op " + this.getBestandsDatum()));
        }
        String string = this.gemeenteCode = null != (gem = (Node)(eersteGemeente = xpath.compile("//*[local-name()='verantwoordelijkeGemeente']/*[local-name()='gemeenteCode'][1]")).evaluate(doc, XPathConstants.NODE)) ? gem.getTextContent() : null;
        if (null == this.gemeenteCode) {
            eersteGemeente = xpath.compile("//*[local-name()='verantwoordelijkeGemeente'][1]");
            gem = (Node)eersteGemeente.evaluate(doc, XPathConstants.NODE);
            this.gemeenteCode = null != gem ? gem.getTextContent() : null;
        }
        this.betrokkenWaterschap = null != (ws = (Node)(eersteWaterschap = xpath.compile("//*[local-name()='ligtIn']/*[local-name()='gerelateerde']/*[local-name()='betrokkenWaterschap'][1]")).evaluate(doc, XPathConstants.NODE)) ? ws.getTextContent() : null;
        XPathExpression objectNode = xpath.compile("//*[local-name()='object'][not(ancestor::*[local-name()='historie'])]");
        this.objectNodes = (NodeList)objectNode.evaluate(doc, XPathConstants.NODESET);
        if (this.objectNodes.getLength() < 1) {
            objectNode = xpath.compile("//*[local-name()='nieuweGemeenteNPS']");
            this.objectNodes = (NodeList)objectNode.evaluate(doc, XPathConstants.NODESET);
            if (LOG.isDebugEnabled() && this.objectNodes.getLength() > 0) {
                LOG.debug((Object)"nieuweGemeente NPS omhangbericht");
            }
        }
        if (this.objectNodes.getLength() < 1) {
            objectNode = xpath.compile("//*[local-name()='nieuweGemeenteNNP']");
            this.objectNodes = (NodeList)objectNode.evaluate(doc, XPathConstants.NODESET);
            if (LOG.isDebugEnabled() && this.objectNodes.getLength() > 0) {
                LOG.debug((Object)"nieuweGemeente NNP omhangbericht");
            }
        }
        if (this.objectNodes.getLength() < 1) {
            objectNode = xpath.compile("//*[local-name()='nieuweGemeenteVES']");
            this.objectNodes = (NodeList)objectNode.evaluate(doc, XPathConstants.NODESET);
            if (LOG.isDebugEnabled() && this.objectNodes.getLength() > 0) {
                LOG.debug((Object)"nieuweGemeente VES omhangbericht");
            }
        }
        this.index = 0;
    }

    @Override
    public boolean hasNext() throws Exception {
        return this.index < this.objectNodes.getLength();
    }

    @Override
    public WozBericht next() throws Exception {
        Transformer t;
        Node n = this.objectNodes.item(this.index);
        ++this.index;
        String object_ref = this.getObjectRef(n);
        StringWriter sw = new StringWriter();
        Bericht old = this.staging.getPreviousBericht(object_ref, this.getBestandsDatum(), -1L, new StringBuilder());
        if (old != null) {
            LOG.debug((Object)"gebruik preprocessor xsl");
            t = this.template.newTransformer();
        } else {
            LOG.debug((Object)"gebruik extractie xsl");
            t = TransformerFactory.newInstance().newTransformer();
        }
        t.setOutputProperty("omit-xml-declaration", "yes");
        t.setOutputProperty("encoding", "UTF-8");
        t.setOutputProperty("indent", "no");
        t.setOutputProperty("method", "xml");
        t.transform(new DOMSource(n), new StreamResult(sw));
        Map<String, String> bsns = this.extractBSN(n);
        String origXML = sw.toString();
        StringBuilder brXML = new StringBuilder("<root>").append(origXML).append(this.getXML(bsns)).append("<fallback>");
        if (null != this.gemeenteCode) {
            brXML.append("<gemeenteCode>").append(this.gemeenteCode).append("</gemeenteCode>");
        }
        if (null != this.betrokkenWaterschap) {
            brXML.append("<betrokkenWaterschap>").append(this.betrokkenWaterschap).append("</betrokkenWaterschap>");
        }
        brXML.append("</fallback>").append("</root>");
        WozBericht b = new WozBericht(brXML.toString());
        b.setDatum(this.getBestandsDatum());
        if (this.index == 1) {
            b.setBrOrgineelXml(this.brOrigXML);
        }
        b.setVolgordeNummer(this.index);
        if (this.index > 1) {
            b.setDatum(new Date(this.getBestandsDatum().getTime() + 10L));
        }
        b.setObjectRef(object_ref);
        if (StringUtils.isEmpty((CharSequence)b.getObjectRef())) {
            b.setStatus(Bericht.STATUS.STAGING_NOK);
            b.setOpmerking("Er kon geen object_ref bepaald worden uit de natuurlijke sleutel van het bericht.");
        }
        LOG.trace((Object)("bericht: " + b));
        return b;
    }

    private String getObjectRef(Node wozObjectNode) throws XPathExpressionException {
        XPathExpression wozObjectNummer = this.xPathfactory.newXPath().compile("./*[local-name()='wozObjectNummer']");
        NodeList obRefs = (NodeList)wozObjectNummer.evaluate(wozObjectNode, XPathConstants.NODESET);
        if (obRefs.getLength() > 0) {
            return PREFIX_WOZ + obRefs.item(0).getTextContent();
        }
        XPathExpression bsn = this.xPathfactory.newXPath().compile("./*/*[local-name()='gerelateerde']/*[local-name()='inp.bsn']");
        obRefs = (NodeList)bsn.evaluate(wozObjectNode, XPathConstants.NODESET);
        if (obRefs.getLength() > 0) {
            return PREFIX_PRS + this.getHash(obRefs.item(0).getTextContent());
        }
        bsn = this.xPathfactory.newXPath().compile("//*[local-name()='heeftBelanghebbende']/*[local-name()='gerelateerde']/*[local-name()='natuurlijkPersoon']/*[local-name()='soFiNummer']");
        obRefs = (NodeList)bsn.evaluate(wozObjectNode, XPathConstants.NODESET);
        if (obRefs.getLength() > 0 && !StringUtils.isEmpty((CharSequence)obRefs.item(0).getTextContent())) {
            return PREFIX_PRS + obRefs.item(0).getTextContent();
        }
        XPathExpression nnpIdXpath = this.xPathfactory.newXPath().compile("./*/*[local-name()='gerelateerde']/*[local-name()='inn.nnpId']");
        obRefs = (NodeList)nnpIdXpath.evaluate(wozObjectNode, XPathConstants.NODESET);
        if (obRefs.getLength() > 0 && !StringUtils.isEmpty((CharSequence)obRefs.item(0).getTextContent())) {
            return PREFIX_NNP + obRefs.item(0).getTextContent();
        }
        nnpIdXpath = this.xPathfactory.newXPath().compile("*[@StUF:entiteittype='NNP']/*[local-name()='aanvullingSoFiNummer']");
        obRefs = (NodeList)nnpIdXpath.evaluate(wozObjectNode, XPathConstants.NODESET);
        if (obRefs.getLength() > 0 && !StringUtils.isEmpty((CharSequence)obRefs.item(0).getTextContent())) {
            LOG.warn((Object)"WOZ NNP zonder `inn.nnpId`, gebruik `aanvullingSoFiNummer` voor id.");
            return PREFIX_NNP + obRefs.item(0).getTextContent();
        }
        XPathExpression wrd = this.xPathfactory.newXPath().compile("./*/*[local-name()='gerelateerde']/*[local-name()='wozObjectNummer']");
        obRefs = (NodeList)wrd.evaluate(wozObjectNode, XPathConstants.NODESET);
        if (obRefs.getLength() > 0 && !StringUtils.isEmpty((CharSequence)obRefs.item(0).getTextContent())) {
            return PREFIX_WOZ + obRefs.item(0).getTextContent();
        }
        XPathExpression ves = this.xPathfactory.newXPath().compile("./*/*[local-name()='gerelateerde']/*[local-name()='vestigingsNummer']");
        obRefs = (NodeList)ves.evaluate(wozObjectNode, XPathConstants.NODESET);
        if (obRefs.getLength() > 0 && !StringUtils.isEmpty((CharSequence)obRefs.item(0).getTextContent())) {
            return PREFIX_VES + obRefs.item(0).getTextContent();
        }
        return null;
    }

    public Map<String, String> extractBSN(Node n) throws XPathExpressionException {
        HashMap<String, String> hashes = new HashMap<String, String>();
        XPath xpath = this.xPathfactory.newXPath();
        XPathExpression expr = xpath.compile("//*[local-name() = 'inp.bsn']");
        NodeList nodelist = (NodeList)expr.evaluate(n, XPathConstants.NODESET);
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node bsn = nodelist.item(i);
            String bsnString = bsn.getTextContent();
            String hash = this.getHash(bsnString);
            hashes.put(bsnString, hash);
        }
        return hashes;
    }

    public String getXML(Map<String, String> map) throws ParserConfigurationException {
        if (map.isEmpty()) {
            return "";
        }
        Object root = "<bsnhashes>";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().isEmpty() || entry.getValue().isEmpty()) continue;
            String hash = entry.getValue();
            String el = "<WOZ.NPS." + entry.getKey() + ">" + hash + "</WOZ.NPS." + entry.getKey() + ">";
            root = (String)root + el;
        }
        root = (String)root + "</bsnhashes>";
        return root;
    }
}

