/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.borders;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.borders.FixedDashedBorder;

public class DashedBorder
extends Border {
    private static final float DASH_MODIFIER = 5.0f;
    private static final float GAP_MODIFIER = 3.5f;

    public DashedBorder(float width) {
        super(width);
    }

    public DashedBorder(Color color, float width) {
        super(color, width);
    }

    public DashedBorder(Color color, float width, float opacity) {
        super(color, width, opacity);
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 3.5f;
        float dash = this.width * 5.0f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = super.getDotsGap(borderLength, initialGap + dash);
        if (adjustedGap > dash) {
            adjustedGap -= dash;
        }
        new FixedDashedBorder(this.getColor(), this.width, this.getOpacity(), dash, adjustedGap, dash + adjustedGap / 2.0f).draw(canvas, x1, y1, x2, y2, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    @Override
    public void draw(PdfCanvas canvas, float x1, float y1, float x2, float y2, float horizontalRadius1, float verticalRadius1, float horizontalRadius2, float verticalRadius2, Border.Side defaultSide, float borderWidthBefore, float borderWidthAfter) {
        float initialGap = this.width * 3.5f;
        float dash = this.width * 5.0f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = super.getDotsGap(borderLength, initialGap + dash);
        if (adjustedGap > dash) {
            adjustedGap -= dash;
        }
        new FixedDashedBorder(this.getColor(), this.width, this.getOpacity(), dash, adjustedGap, dash + adjustedGap / 2.0f).draw(canvas, x1, y1, x2, y2, horizontalRadius1, verticalRadius1, horizontalRadius2, verticalRadius2, defaultSide, borderWidthBefore, borderWidthAfter);
    }

    @Override
    public void drawCellBorder(PdfCanvas canvas, float x1, float y1, float x2, float y2, Border.Side defaultSide) {
        float initialGap = this.width * 3.5f;
        float dash = this.width * 5.0f;
        float dx = x2 - x1;
        float dy = y2 - y1;
        double borderLength = Math.sqrt(dx * dx + dy * dy);
        float adjustedGap = super.getDotsGap(borderLength, initialGap + dash);
        if (adjustedGap > dash) {
            adjustedGap -= dash;
        }
        new FixedDashedBorder(this.getColor(), this.width, this.getOpacity(), dash, adjustedGap, dash + adjustedGap / 2.0f).drawCellBorder(canvas, x1, y1, x2, y2, defaultSide);
    }
}

