/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.io.source.ByteArrayOutputStream;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.io.source.DeflaterOutputStream;
import com.itextpdf.io.source.HighPrecisionOutputStream;
import com.itextpdf.kernel.crypto.OutputStreamEncryption;
import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.IndirectFilterUtils;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfEncryption;
import com.itextpdf.kernel.pdf.PdfIndirectReference;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNull;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfObjectStream;
import com.itextpdf.kernel.pdf.PdfPrimitiveObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.filters.FlateDecodeFilter;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfOutputStream
extends HighPrecisionOutputStream<PdfOutputStream> {
    private static final byte[] stream = ByteUtils.getIsoBytes((String)"stream\n");
    private static final byte[] endstream = ByteUtils.getIsoBytes((String)"\nendstream");
    private static final byte[] openDict = ByteUtils.getIsoBytes((String)"<<");
    private static final byte[] closeDict = ByteUtils.getIsoBytes((String)">>");
    private static final byte[] endIndirect = ByteUtils.getIsoBytes((String)" R");
    private static final byte[] endIndirectWithZeroGenNr = ByteUtils.getIsoBytes((String)" 0 R");
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfOutputStream.class);
    protected PdfDocument document = null;
    protected PdfEncryption crypto;

    public PdfOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public PdfOutputStream write(PdfObject pdfObject) {
        if (pdfObject.checkState((short)64) && this.document != null) {
            pdfObject.makeIndirect(this.document);
            pdfObject = pdfObject.getIndirectReference();
        }
        if (pdfObject.checkState((short)256)) {
            throw new PdfException("Cannot write object after it was released. In normal situation the object must be read once again before being written.");
        }
        switch (pdfObject.getType()) {
            case 1: {
                this.write((PdfArray)pdfObject);
                break;
            }
            case 3: {
                this.write((PdfDictionary)pdfObject);
                break;
            }
            case 5: {
                this.write((PdfIndirectReference)pdfObject);
                break;
            }
            case 6: {
                this.write((PdfName)pdfObject);
                break;
            }
            case 2: 
            case 7: {
                this.write((PdfPrimitiveObject)pdfObject);
                break;
            }
            case 4: {
                this.write((PdfLiteral)pdfObject);
                break;
            }
            case 10: {
                this.write((PdfString)pdfObject);
                break;
            }
            case 8: {
                this.write((PdfNumber)pdfObject);
                break;
            }
            case 9: {
                this.write((PdfStream)pdfObject);
            }
        }
        return this;
    }

    void write(long bytes, int size) throws IOException {
        assert (bytes >= 0L);
        while (--size >= 0) {
            this.write((byte)(bytes >> 8 * size & 0xFFL));
        }
    }

    void write(int bytes, int size) throws IOException {
        this.write((long)bytes & 0xFFFFFFFFL, size);
    }

    private void write(PdfArray pdfArray) {
        this.writeByte(91);
        for (int i = 0; i < pdfArray.size(); ++i) {
            PdfObject value = pdfArray.get(i, false);
            PdfIndirectReference indirectReference = value.getIndirectReference();
            if (indirectReference != null) {
                this.write(indirectReference);
            } else {
                this.write(value);
            }
            if (i >= pdfArray.size() - 1) continue;
            this.writeSpace();
        }
        this.writeByte(93);
    }

    private void write(PdfDictionary pdfDictionary) {
        this.writeBytes(openDict);
        for (PdfName key : pdfDictionary.keySet()) {
            PdfIndirectReference indirectReference;
            boolean isAlreadyWriteSpace = false;
            this.write(key);
            PdfObject value = pdfDictionary.get(key, false);
            if (value == null) {
                LOGGER.warn(MessageFormatUtil.format((String)"Invalid key value: key {0} has null value.", (Object[])new Object[]{key}));
                value = PdfNull.PDF_NULL;
            }
            if (value.getType() == 8 || value.getType() == 4 || value.getType() == 2 || value.getType() == 7 || value.getType() == 5 || value.checkState((short)64)) {
                isAlreadyWriteSpace = true;
                this.writeSpace();
            }
            if ((indirectReference = value.getIndirectReference()) != null) {
                if (!isAlreadyWriteSpace) {
                    this.writeSpace();
                }
                this.write(indirectReference);
                continue;
            }
            this.write(value);
        }
        this.writeBytes(closeDict);
    }

    private void write(PdfIndirectReference indirectReference) {
        if (this.document != null && !indirectReference.getDocument().equals(this.document)) {
            throw new PdfException("Pdf indirect object belongs to other PDF document. Copy object to current pdf document.");
        }
        if (indirectReference.isFree()) {
            LOGGER.error("Flushed object contains indirect reference which is free. Null object will be written instead.");
            this.write(PdfNull.PDF_NULL);
        } else if (indirectReference.refersTo == null && (indirectReference.checkState((short)8) || indirectReference.getReader() == null || indirectReference.getOffset() <= 0L && indirectReference.getIndex() < 0)) {
            LOGGER.error("Flushed object contains indirect reference which doesn't refer to any other object. Null object will be written instead.");
            this.write(PdfNull.PDF_NULL);
        } else if (indirectReference.getGenNumber() == 0) {
            ((PdfOutputStream)((Object)this.writeInteger(indirectReference.getObjNumber()))).writeBytes(endIndirectWithZeroGenNr);
        } else {
            ((PdfOutputStream)((Object)((PdfOutputStream)((Object)((PdfOutputStream)((Object)this.writeInteger(indirectReference.getObjNumber()))).writeSpace())).writeInteger(indirectReference.getGenNumber()))).writeBytes(endIndirect);
        }
    }

    private void write(PdfPrimitiveObject pdfPrimitive) {
        this.writeBytes(pdfPrimitive.getInternalContent());
    }

    private void write(PdfLiteral literal) {
        literal.setPosition(this.getCurrentPos());
        this.writeBytes(literal.getInternalContent());
    }

    private void write(PdfString pdfString) {
        pdfString.encrypt(this.crypto);
        if (pdfString.isHexWriting()) {
            this.writeByte(60);
            this.writeBytes(pdfString.getInternalContent());
            this.writeByte(62);
        } else {
            this.writeByte(40);
            this.writeBytes(pdfString.getInternalContent());
            this.writeByte(41);
        }
    }

    private void write(PdfName name) {
        this.writeByte(47);
        this.writeBytes(name.getInternalContent());
    }

    private void write(PdfNumber pdfNumber) {
        if (pdfNumber.hasContent()) {
            this.writeBytes(pdfNumber.getInternalContent());
        } else if (pdfNumber.isDoubleNumber()) {
            this.writeDouble(pdfNumber.getValue());
        } else {
            this.writeInteger(pdfNumber.intValue());
        }
    }

    private boolean isNotMetadataPdfStream(PdfStream pdfStream) {
        return pdfStream.getAsName(PdfName.Type) == null || pdfStream.getAsName(PdfName.Type) != null && !pdfStream.getAsName(PdfName.Type).equals(PdfName.Metadata);
    }

    private boolean isXRefStream(PdfStream pdfStream) {
        return PdfName.XRef.equals(pdfStream.getAsName(PdfName.Type));
    }

    private void write(PdfStream pdfStream) {
        block23: {
            try {
                ByteArrayOutputStream byteArrayStream;
                boolean allowCompression;
                boolean userDefinedCompression;
                boolean bl = userDefinedCompression = pdfStream.getCompressionLevel() != Integer.MIN_VALUE;
                if (!userDefinedCompression) {
                    int defaultCompressionLevel = this.document != null ? this.document.getWriter().getCompressionLevel() : -1;
                    pdfStream.setCompressionLevel(defaultCompressionLevel);
                }
                boolean toCompress = pdfStream.getCompressionLevel() != 0;
                boolean bl2 = allowCompression = !pdfStream.containsKey(PdfName.Filter) && this.isNotMetadataPdfStream(pdfStream);
                if (pdfStream.getInputStream() != null) {
                    int n;
                    Object fout = this;
                    DeflaterOutputStream def = null;
                    OutputStreamEncryption ose = null;
                    if (this.crypto != null && (!this.crypto.isEmbeddedFilesOnly() || this.document.doesStreamBelongToEmbeddedFile(pdfStream))) {
                        ose = this.crypto.getEncryptionStream((OutputStream)fout);
                        fout = ose;
                    }
                    if (toCompress && (allowCompression || userDefinedCompression)) {
                        this.updateCompressionFilter(pdfStream);
                        def = new DeflaterOutputStream((OutputStream)fout, pdfStream.getCompressionLevel(), 32768);
                        fout = def;
                    }
                    this.write((PdfDictionary)pdfStream);
                    this.writeBytes(stream);
                    long beginStreamContent = this.getCurrentPos();
                    byte[] buf = new byte[4192];
                    while ((n = pdfStream.getInputStream().read(buf)) > 0) {
                        ((OutputStream)fout).write(buf, 0, n);
                    }
                    if (def != null) {
                        def.finish();
                    }
                    if (ose != null) {
                        ose.finish();
                    }
                    PdfNumber length = pdfStream.getAsNumber(PdfName.Length);
                    length.setValue((int)(this.getCurrentPos() - beginStreamContent));
                    pdfStream.updateLength(length.intValue());
                    this.writeBytes(endstream);
                    break block23;
                }
                if (pdfStream.getOutputStream() == null && pdfStream.getIndirectReference().getReader() != null) {
                    byte[] bytes = pdfStream.getIndirectReference().getReader().readStreamBytes(pdfStream, false);
                    if (userDefinedCompression) {
                        bytes = this.decodeFlateBytes(pdfStream, bytes);
                    }
                    pdfStream.initOutputStream((OutputStream)new ByteArrayOutputStream(bytes.length));
                    pdfStream.getOutputStream().write(bytes);
                }
                assert (pdfStream.getOutputStream() != null) : "PdfStream lost OutputStream";
                try {
                    if (toCompress && !this.containsFlateFilter(pdfStream) && PdfOutputStream.decodeParamsArrayNotFlushed(pdfStream) && (allowCompression || userDefinedCompression)) {
                        this.updateCompressionFilter(pdfStream);
                        byteArrayStream = new ByteArrayOutputStream();
                        DeflaterOutputStream zip = new DeflaterOutputStream((OutputStream)byteArrayStream, pdfStream.getCompressionLevel());
                        if (pdfStream instanceof PdfObjectStream) {
                            PdfObjectStream objectStream = (PdfObjectStream)pdfStream;
                            ((ByteArrayOutputStream)objectStream.getIndexStream().getOutputStream()).writeTo((OutputStream)zip);
                            ((ByteArrayOutputStream)objectStream.getOutputStream().getOutputStream()).writeTo((OutputStream)zip);
                        } else {
                            assert (pdfStream.getOutputStream() != null) : "Error in outputStream";
                            ((ByteArrayOutputStream)pdfStream.getOutputStream().getOutputStream()).writeTo((OutputStream)zip);
                        }
                        zip.finish();
                    } else if (pdfStream instanceof PdfObjectStream) {
                        PdfObjectStream objectStream = (PdfObjectStream)pdfStream;
                        byteArrayStream = new ByteArrayOutputStream();
                        ((ByteArrayOutputStream)objectStream.getIndexStream().getOutputStream()).writeTo((OutputStream)byteArrayStream);
                        ((ByteArrayOutputStream)objectStream.getOutputStream().getOutputStream()).writeTo((OutputStream)byteArrayStream);
                    } else {
                        assert (pdfStream.getOutputStream() != null) : "Error in outputStream";
                        byteArrayStream = (ByteArrayOutputStream)pdfStream.getOutputStream().getOutputStream();
                    }
                    if (this.checkEncryption(pdfStream)) {
                        ByteArrayOutputStream encodedStream = new ByteArrayOutputStream();
                        OutputStreamEncryption ose = this.crypto.getEncryptionStream((OutputStream)encodedStream);
                        byteArrayStream.writeTo((OutputStream)ose);
                        ose.finish();
                        byteArrayStream = encodedStream;
                    }
                }
                catch (IOException ioe) {
                    throw new PdfException("I/O exception.", ioe);
                }
                pdfStream.put(PdfName.Length, new PdfNumber(byteArrayStream.size()));
                pdfStream.updateLength(byteArrayStream.size());
                this.write((PdfDictionary)pdfStream);
                this.writeBytes(stream);
                byteArrayStream.writeTo((OutputStream)((Object)this));
                byteArrayStream.close();
                this.writeBytes(endstream);
            }
            catch (IOException e) {
                throw new PdfException("Cannot write to PdfStream.", e, pdfStream);
            }
        }
    }

    protected boolean checkEncryption(PdfStream pdfStream) {
        if (this.crypto == null || this.crypto.isEmbeddedFilesOnly() && !this.document.doesStreamBelongToEmbeddedFile(pdfStream)) {
            return false;
        }
        if (this.isXRefStream(pdfStream)) {
            return false;
        }
        PdfObject filter = pdfStream.get(PdfName.Filter, true);
        if (filter == null) {
            return true;
        }
        if (filter.isFlushed()) {
            IndirectFilterUtils.throwFlushedFilterException(pdfStream);
        }
        if (PdfName.Crypt.equals(filter)) {
            return false;
        }
        if (filter.getType() == 1) {
            PdfArray filters = (PdfArray)filter;
            if (filters.isEmpty()) {
                return true;
            }
            if (filters.get(0).isFlushed()) {
                IndirectFilterUtils.throwFlushedFilterException(pdfStream);
            }
            return !PdfName.Crypt.equals(filters.get(0, true));
        }
        return true;
    }

    protected boolean containsFlateFilter(PdfStream pdfStream) {
        PdfObject filter = pdfStream.get(PdfName.Filter);
        if (filter == null) {
            return false;
        }
        if (filter.isFlushed()) {
            IndirectFilterUtils.logFilterWasAlreadyFlushed(LOGGER, pdfStream);
            return true;
        }
        if (filter.getType() != 6 && filter.getType() != 1) {
            throw new PdfException("filter is not a name or array.");
        }
        if (filter.getType() == 6) {
            return PdfName.FlateDecode.equals(filter);
        }
        for (PdfObject obj : (PdfArray)filter) {
            if (!obj.isFlushed()) continue;
            IndirectFilterUtils.logFilterWasAlreadyFlushed(LOGGER, pdfStream);
            return true;
        }
        return ((PdfArray)filter).contains(PdfName.FlateDecode);
    }

    protected void updateCompressionFilter(PdfStream pdfStream) {
        PdfObject filter = pdfStream.get(PdfName.Filter);
        if (filter == null) {
            pdfStream.remove(PdfName.DecodeParms);
            pdfStream.put(PdfName.Filter, PdfName.FlateDecode);
            return;
        }
        PdfArray filters = new PdfArray();
        filters.add(PdfName.FlateDecode);
        if (filter instanceof PdfArray) {
            filters.addAll((PdfArray)filter);
        } else {
            filters.add(filter);
        }
        PdfObject decodeParms = pdfStream.get(PdfName.DecodeParms);
        if (decodeParms != null) {
            if (decodeParms instanceof PdfDictionary) {
                PdfArray array = new PdfArray();
                array.add(new PdfNull());
                array.add(decodeParms);
                pdfStream.put(PdfName.DecodeParms, array);
            } else if (decodeParms instanceof PdfArray) {
                ((PdfArray)decodeParms).add(0, new PdfNull());
            } else {
                throw new PdfException("Decode parameter type {0} is not supported.").setMessageParams(decodeParms.getClass().toString());
            }
        }
        pdfStream.put(PdfName.Filter, filters);
    }

    protected byte[] decodeFlateBytes(PdfStream stream, byte[] bytes) {
        PdfObject decodeParams;
        PdfName filterName;
        PdfObject filterObject = stream.get(PdfName.Filter);
        if (filterObject == null) {
            return bytes;
        }
        PdfArray filtersArray = null;
        if (filterObject instanceof PdfName) {
            filterName = (PdfName)filterObject;
        } else if (filterObject instanceof PdfArray) {
            filtersArray = (PdfArray)filterObject;
            if (filtersArray.isFlushed()) {
                IndirectFilterUtils.logFilterWasAlreadyFlushed(LOGGER, stream);
                return bytes;
            }
            filterName = filtersArray.getAsName(0);
        } else {
            throw new PdfException("filter is not a name or array.");
        }
        if (filterName.isFlushed()) {
            IndirectFilterUtils.logFilterWasAlreadyFlushed(LOGGER, stream);
            return bytes;
        }
        if (!PdfName.FlateDecode.equals(filterName)) {
            return bytes;
        }
        PdfArray decodeParamsArray = null;
        PdfObject decodeParamsObject = stream.get(PdfName.DecodeParms);
        if (decodeParamsObject == null) {
            decodeParams = null;
        } else {
            if (decodeParamsObject.isFlushed()) {
                IndirectFilterUtils.logFilterWasAlreadyFlushed(LOGGER, stream);
                return bytes;
            }
            if (decodeParamsObject.getType() == 3) {
                decodeParams = (PdfDictionary)decodeParamsObject;
            } else if (decodeParamsObject.getType() == 1) {
                decodeParamsArray = (PdfArray)decodeParamsObject;
                decodeParams = decodeParamsArray.getAsDictionary(0);
            } else {
                throw new PdfException("Decode parameter type {0} is not supported.").setMessageParams(decodeParamsObject.getClass().toString());
            }
        }
        if (decodeParams != null && (decodeParams.isFlushed() || PdfOutputStream.isFlushed((PdfDictionary)decodeParams, PdfName.Predictor) || PdfOutputStream.isFlushed((PdfDictionary)decodeParams, PdfName.Columns) || PdfOutputStream.isFlushed((PdfDictionary)decodeParams, PdfName.Colors) || PdfOutputStream.isFlushed((PdfDictionary)decodeParams, PdfName.BitsPerComponent))) {
            IndirectFilterUtils.logFilterWasAlreadyFlushed(LOGGER, stream);
            return bytes;
        }
        byte[] res = FlateDecodeFilter.flateDecode(bytes, true);
        if (res == null) {
            res = FlateDecodeFilter.flateDecode(bytes, false);
        }
        bytes = FlateDecodeFilter.decodePredictor(res, decodeParams);
        filterObject = null;
        if (filtersArray != null) {
            filtersArray.remove(0);
            if (filtersArray.size() == 1) {
                filterObject = filtersArray.get(0);
            } else if (!filtersArray.isEmpty()) {
                filterObject = filtersArray;
            }
        }
        decodeParamsObject = null;
        if (decodeParamsArray != null) {
            decodeParamsArray.remove(0);
            if (decodeParamsArray.size() == 1 && decodeParamsArray.get(0).getType() != 7) {
                decodeParamsObject = decodeParamsArray.get(0);
            } else if (!decodeParamsArray.isEmpty()) {
                decodeParamsObject = decodeParamsArray;
            }
        }
        if (filterObject == null) {
            stream.remove(PdfName.Filter);
        } else {
            stream.put(PdfName.Filter, filterObject);
        }
        if (decodeParamsObject == null) {
            stream.remove(PdfName.DecodeParms);
        } else {
            stream.put(PdfName.DecodeParms, decodeParamsObject);
        }
        return bytes;
    }

    private static boolean isFlushed(PdfDictionary dict, PdfName name) {
        PdfObject obj = dict.get(name);
        return obj != null && obj.isFlushed();
    }

    private static boolean decodeParamsArrayNotFlushed(PdfStream pdfStream) {
        PdfArray decodeParams = pdfStream.getAsArray(PdfName.DecodeParms);
        if (decodeParams == null) {
            return true;
        }
        if (decodeParams.isFlushed()) {
            IndirectFilterUtils.logFilterWasAlreadyFlushed(LOGGER, pdfStream);
            return false;
        }
        return true;
    }
}

