/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.filter.And;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.InternalFunction;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.factory.GeoTools;

public class DuplicatingFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    protected final FilterFactory ff;

    public DuplicatingFilterVisitor() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public DuplicatingFilterVisitor(FilterFactory factory) {
        this.ff = factory;
    }

    protected FilterFactory getFactory(Object extraData) {
        if (extraData instanceof FilterFactory) {
            return (FilterFactory)extraData;
        }
        return this.ff;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return filter;
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return filter;
    }

    protected Expression visit(Expression expression, Object extraData) {
        if (expression == null) {
            return null;
        }
        return (Expression)expression.accept((ExpressionVisitor)this, extraData);
    }

    public Object visit(And filter, Object extraData) {
        List children = filter.getChildren();
        ArrayList<Filter> newChildren = new ArrayList<Filter>();
        for (Filter child : children) {
            if (child == null) continue;
            Filter newChild = (Filter)child.accept((FilterVisitor)this, extraData);
            newChildren.add(newChild);
        }
        return this.getFactory(extraData).and(newChildren);
    }

    public Object visit(Id filter, Object extraData) {
        return this.getFactory(extraData).id(filter.getIdentifiers());
    }

    public Object visit(Not filter, Object extraData) {
        return this.getFactory(extraData).not((Filter)filter.getFilter().accept((FilterVisitor)this, extraData));
    }

    public Object visit(Or filter, Object extraData) {
        List children = filter.getChildren();
        ArrayList<Filter> newChildren = new ArrayList<Filter>();
        for (Filter child : children) {
            if (child == null) continue;
            Filter newChild = (Filter)child.accept((FilterVisitor)this, extraData);
            newChildren.add(newChild);
        }
        return this.getFactory(extraData).or(newChildren);
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        Expression expr = this.visit(filter.getExpression(), extraData);
        Expression lower = this.visit(filter.getLowerBoundary(), extraData);
        Expression upper = this.visit(filter.getUpperBoundary(), extraData);
        return this.getFactory(extraData).between(expr, lower, upper, filter.getMatchAction());
    }

    public Object visit(PropertyIsEqualTo filter, Object extraData) {
        Expression expr1 = this.visit(filter.getExpression1(), extraData);
        Expression expr2 = this.visit(filter.getExpression2(), extraData);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).equal(expr1, expr2, matchCase, filter.getMatchAction());
    }

    public Object visit(PropertyIsNotEqualTo filter, Object extraData) {
        Expression expr1 = this.visit(filter.getExpression1(), extraData);
        Expression expr2 = this.visit(filter.getExpression2(), extraData);
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).notEqual(expr1, expr2, matchCase, filter.getMatchAction());
    }

    public Object visit(PropertyIsGreaterThan filter, Object extraData) {
        Expression expr1 = this.visit(filter.getExpression1(), extraData);
        Expression expr2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).greater(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object extraData) {
        Expression expr1 = this.visit(filter.getExpression1(), extraData);
        Expression expr2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).greaterOrEqual(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsLessThan filter, Object extraData) {
        Expression expr1 = this.visit(filter.getExpression1(), extraData);
        Expression expr2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).less(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsLessThanOrEqualTo filter, Object extraData) {
        Expression expr1 = this.visit(filter.getExpression1(), extraData);
        Expression expr2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).lessOrEqual(expr1, expr2, filter.isMatchingCase(), filter.getMatchAction());
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        Expression expr = this.visit(filter.getExpression(), extraData);
        String pattern = filter.getLiteral();
        String wildcard = filter.getWildCard();
        String singleChar = filter.getSingleChar();
        String escape = filter.getEscape();
        boolean matchCase = filter.isMatchingCase();
        return this.getFactory(extraData).like(expr, pattern, wildcard, singleChar, escape, matchCase, filter.getMatchAction());
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        Expression expr = this.visit(filter.getExpression(), extraData);
        return this.getFactory(extraData).isNull(expr);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        Expression expr = this.visit(filter.getExpression(), extraData);
        return this.getFactory(extraData).isNil(expr, filter.getNilReason());
    }

    public Object visit(BBOX filter, Object extraData) {
        Expression propertyName = this.visit(filter.getExpression1(), extraData);
        Expression box = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).bbox(propertyName, box, filter.getMatchAction());
    }

    public Object visit(Beyond filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        double distance = filter.getDistance();
        String units = filter.getDistanceUnits();
        return this.getFactory(extraData).beyond(geometry1, geometry2, distance, units, filter.getMatchAction());
    }

    public Object visit(Contains filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).contains(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visit(Crosses filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).crosses(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visit(Disjoint filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).disjoint(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visit(DWithin filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        double distance = filter.getDistance();
        String units = filter.getDistanceUnits();
        return this.getFactory(extraData).dwithin(geometry1, geometry2, distance, units, filter.getMatchAction());
    }

    public Object visit(Equals filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).equal(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visit(Intersects filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).intersects(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visit(Overlaps filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).overlaps(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visit(Touches filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).touches(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visit(Within filter, Object extraData) {
        Expression geometry1 = this.visit(filter.getExpression1(), extraData);
        Expression geometry2 = this.visit(filter.getExpression2(), extraData);
        return this.getFactory(extraData).within(geometry1, geometry2, filter.getMatchAction());
    }

    public Object visitNullFilter(Object extraData) {
        return null;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return expression;
    }

    public Object visit(Add expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).add(expr1, expr2);
    }

    public Object visit(Divide expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).divide(expr1, expr2);
    }

    public Object visit(Function expression, Object extraData) {
        List old = expression.getParameters();
        Expression[] args = new Expression[old.size()];
        int i = 0;
        for (Expression exp : old) {
            args[i++] = this.visit(exp, extraData);
        }
        Object duplicate = expression instanceof InternalFunction ? ((InternalFunction)expression).duplicate(args) : this.getFactory(extraData).function(expression.getName(), args);
        return duplicate;
    }

    public Object visit(Literal expression, Object extraData) {
        return this.getFactory(extraData).literal(expression.getValue());
    }

    public Object visit(Multiply expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).multiply(expr1, expr2);
    }

    public Object visit(PropertyName expression, Object extraData) {
        return this.getFactory(extraData).property(expression.getPropertyName(), expression.getNamespaceContext());
    }

    public Object visit(Subtract expression, Object extraData) {
        Expression expr1 = this.visit(expression.getExpression1(), extraData);
        Expression expr2 = this.visit(expression.getExpression2(), extraData);
        return this.getFactory(extraData).subtract(expr1, expr2);
    }

    public Object visit(After after, Object extraData) {
        return this.getFactory(extraData).after(this.visit(after.getExpression1(), extraData), this.visit(after.getExpression2(), extraData), after.getMatchAction());
    }

    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.getFactory(extraData).anyInteracts(this.visit(anyInteracts.getExpression1(), extraData), this.visit(anyInteracts.getExpression2(), extraData), anyInteracts.getMatchAction());
    }

    public Object visit(Before before, Object extraData) {
        return this.getFactory(extraData).before(this.visit(before.getExpression1(), extraData), this.visit(before.getExpression2(), extraData), before.getMatchAction());
    }

    public Object visit(Begins begins, Object extraData) {
        return this.getFactory(extraData).begins(this.visit(begins.getExpression1(), extraData), this.visit(begins.getExpression2(), extraData), begins.getMatchAction());
    }

    public Object visit(BegunBy begunBy, Object extraData) {
        return this.getFactory(extraData).begunBy(this.visit(begunBy.getExpression1(), extraData), this.visit(begunBy.getExpression2(), extraData), begunBy.getMatchAction());
    }

    public Object visit(During during, Object extraData) {
        return this.getFactory(extraData).during(this.visit(during.getExpression1(), extraData), this.visit(during.getExpression2(), extraData), during.getMatchAction());
    }

    public Object visit(EndedBy endedBy, Object extraData) {
        return this.getFactory(extraData).endedBy(this.visit(endedBy.getExpression1(), extraData), this.visit(endedBy.getExpression2(), extraData), endedBy.getMatchAction());
    }

    public Object visit(Ends ends, Object extraData) {
        return this.getFactory(extraData).ends(this.visit(ends.getExpression1(), extraData), this.visit(ends.getExpression2(), extraData), ends.getMatchAction());
    }

    public Object visit(Meets meets, Object extraData) {
        return this.getFactory(extraData).meets(this.visit(meets.getExpression1(), extraData), this.visit(meets.getExpression2(), extraData), meets.getMatchAction());
    }

    public Object visit(MetBy metBy, Object extraData) {
        return this.getFactory(extraData).metBy(this.visit(metBy.getExpression1(), extraData), this.visit(metBy.getExpression2(), extraData), metBy.getMatchAction());
    }

    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.getFactory(extraData).overlappedBy(this.visit(overlappedBy.getExpression1(), extraData), this.visit(overlappedBy.getExpression2(), extraData), overlappedBy.getMatchAction());
    }

    public Object visit(TContains contains, Object extraData) {
        return this.getFactory(extraData).tcontains(this.visit(contains.getExpression1(), extraData), this.visit(contains.getExpression2(), extraData), contains.getMatchAction());
    }

    public Object visit(TEquals equals, Object extraData) {
        return this.getFactory(extraData).tequals(this.visit(equals.getExpression1(), extraData), this.visit(equals.getExpression2(), extraData), equals.getMatchAction());
    }

    public Object visit(TOverlaps contains, Object extraData) {
        return this.getFactory(extraData).tcontains(this.visit(contains.getExpression1(), extraData), this.visit(contains.getExpression2(), extraData), contains.getMatchAction());
    }

    public Object visit(NativeFilter filter, Object extraData) {
        return this.getFactory(extraData).nativeFilter(filter.getNative());
    }
}

