/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.List;
import org.geotools.api.feature.type.AttributeType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.api.filter.Filter;
import org.geotools.api.util.InternationalString;
import org.geotools.feature.type.PropertyTypeImpl;
import org.geotools.util.Classes;

public class AttributeTypeImpl
extends PropertyTypeImpl
implements AttributeType {
    protected final boolean identified;

    public AttributeTypeImpl(Name name, Class<?> binding, boolean identified, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) {
        super(name, binding, isAbstract, restrictions, (PropertyType)superType, description);
        this.identified = identified;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        return value;
    }

    public Object createDefaultValue() {
        return null;
    }

    public AttributeType getSuper() {
        return (AttributeType)super.getSuper();
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ Boolean.valueOf(this.identified).hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AttributeType)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        AttributeType att = (AttributeType)other;
        return this.identified == att.isIdentified();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer(Classes.getShortClassName((Object)this));
        sb.append(" ");
        sb.append(this.getName());
        if (this.isAbstract()) {
            sb.append(" abstract");
        }
        if (this.isIdentified()) {
            sb.append(" identified");
        }
        if (this.superType != null) {
            sb.append(" extends ");
            sb.append(this.superType.getName().getLocalPart());
        }
        if (this.binding != null) {
            sb.append("<");
            sb.append(Classes.getShortName((Class)this.binding));
            sb.append(">");
        }
        if (this.description != null) {
            sb.append("\n\tdescription=");
            sb.append((CharSequence)this.description);
        }
        if (this.restrictions != null && !this.restrictions.isEmpty()) {
            sb.append("\nrestrictions=");
            boolean first = true;
            for (Filter filter : this.restrictions) {
                if (first) {
                    first = false;
                } else {
                    sb.append(" AND ");
                }
                sb.append(filter);
            }
        }
        return sb.toString();
    }
}

