/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.EqualAreaListVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.AbstractQuantityClassificationFunction;
import org.geotools.filter.function.RangedClassifier;

public class EqualAreaFunction
extends AbstractQuantityClassificationFunction {
    private static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();
    public static FunctionName NAME = new FunctionNameImpl("EqualArea", RangedClassifier.class, FunctionNameImpl.parameter("value", Double.class), FunctionNameImpl.parameter("classes", Integer.class), FunctionNameImpl.parameter("areaFunction", Double.class, 0, 1), FunctionNameImpl.parameter("percentages", Boolean.class, 0, 1));

    public EqualAreaFunction() {
        super(NAME);
    }

    public static Function getCartesianAreaFunction() {
        return FF.function("area2", new Expression[]{FF.property("")});
    }

    @Override
    protected FeatureCalc getListVisitor() {
        Literal areaFunction = this.getEqualAreaParameter();
        if (areaFunction == null) {
            areaFunction = EqualAreaFunction.getCartesianAreaFunction();
        }
        return new EqualAreaListVisitor(this.getParameters().get(0), (Expression)areaFunction, this.getClasses());
    }

    @Override
    protected boolean percentages() {
        Object value;
        if (this.getParameters().size() > 3 && (value = ((Literal)this.getParameters().get(3)).getValue()) instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private Literal getEqualAreaParameter() {
        Literal literal;
        if (this.getParameters().size() > 2 && (literal = (Literal)this.getParameters().get(2)).getValue() instanceof Double) {
            return literal;
        }
        return null;
    }
}

