/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;

public class FilterFunction_setCRS
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("setCRS", Geometry.class, FunctionNameImpl.parameter("geometry", Geometry.class), FunctionNameImpl.parameter("CRS", String.class));

    public FilterFunction_setCRS() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        CoordinateReferenceSystem crs;
        Geometry geom;
        try {
            geom = (Geometry)this.getExpression(0).evaluate(feature, Geometry.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected argument of type Geometry for argument #0");
        }
        try {
            crs = (CoordinateReferenceSystem)this.getExpression(1).evaluate(feature, CoordinateReferenceSystem.class);
            if (crs == null) {
                String srs = (String)this.getExpression(1).evaluate(feature, String.class);
                try {
                    crs = CRS.decode(srs);
                }
                catch (FactoryException e) {
                    crs = CRS.parseWKT(srs);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected argument of type CoordinateReferenceSystem, WKT or valid EPSG code for argument #1");
        }
        if (geom != null) {
            geom.setUserData((Object)crs);
        }
        return geom;
    }
}

