/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl.converters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import nl.b3p.topnl.TopNLType;
import nl.b3p.topnl.converters.Converter;
import nl.b3p.topnl.entities.FunctioneelGebied;
import nl.b3p.topnl.entities.Gebouw;
import nl.b3p.topnl.entities.GeografischGebied;
import nl.b3p.topnl.entities.Hoogte;
import nl.b3p.topnl.entities.Inrichtingselement;
import nl.b3p.topnl.entities.Plaats;
import nl.b3p.topnl.entities.PlanTopografie;
import nl.b3p.topnl.entities.RegistratiefGebied;
import nl.b3p.topnl.entities.Relief;
import nl.b3p.topnl.entities.Spoorbaandeel;
import nl.b3p.topnl.entities.Terrein;
import nl.b3p.topnl.entities.TopNLEntity;
import nl.b3p.topnl.entities.Waterdeel;
import nl.b3p.topnl.entities.Wegdeel;
import nl.b3p.topnl.top10nl.BRTHogeEnLageZijdeType;
import nl.b3p.topnl.top10nl.BRTJaNeeWaardeType;
import nl.b3p.topnl.top10nl.CodeType;
import nl.b3p.topnl.top10nl.FeatureMemberType;
import nl.b3p.topnl.top10nl.FunctioneelGebiedType;
import nl.b3p.topnl.top10nl.GebouwType;
import nl.b3p.topnl.top10nl.GeografischGebiedType;
import nl.b3p.topnl.top10nl.HoogteType;
import nl.b3p.topnl.top10nl.InrichtingselementType;
import nl.b3p.topnl.top10nl.PlaatsType;
import nl.b3p.topnl.top10nl.PlanTopografieType;
import nl.b3p.topnl.top10nl.RegistratiefGebiedType;
import nl.b3p.topnl.top10nl.ReliefType;
import nl.b3p.topnl.top10nl.SpoorbaandeelType;
import nl.b3p.topnl.top10nl.TerreinType;
import nl.b3p.topnl.top10nl.Top10NlObjectType;
import nl.b3p.topnl.top10nl.WaterdeelType;
import nl.b3p.topnl.top10nl.WegdeelType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Top10NLConverter
extends Converter {
    protected static final Log log = LogFactory.getLog(Top10NLConverter.class);

    @Override
    public List<TopNLEntity> convert(List jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        List<TopNLEntity> entities = null;
        if (jaxbObject instanceof ArrayList) {
            entities = this.convertFeatureCollection(jaxbObject);
        } else {
            entities = new ArrayList<TopNLEntity>();
            entities.add(this.convertObject(jaxbObject));
        }
        return entities;
    }

    @Override
    public List<TopNLEntity> convertFeatureCollection(List jaxbFeatureCollection) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        ArrayList<TopNLEntity> entities = new ArrayList<TopNLEntity>();
        for (Object fm : jaxbFeatureCollection) {
            FeatureMemberType featureMember = (FeatureMemberType)fm;
            JAXBElement<? extends Top10NlObjectType> jaxbObject = featureMember.getTop10NlObject();
            Object obj = jaxbObject.getValue();
            TopNLEntity entity = this.convertObject(obj);
            entities.add(entity);
        }
        return entities;
    }

    @Override
    public TopNLEntity convertObject(Object featureMember) throws IOException, SAXException, ParserConfigurationException, TransformerException, IllegalArgumentException {
        TopNLEntity entity = null;
        if (featureMember instanceof FeatureMemberType) {
            FeatureMemberType fm = (FeatureMemberType)featureMember;
            JAXBElement<? extends Top10NlObjectType> jaxbObject = fm.getTop10NlObject();
            return this.convertObject(jaxbObject.getValue());
        }
        if (featureMember instanceof HoogteType) {
            entity = this.convertHoogte(featureMember);
        } else if (featureMember instanceof FunctioneelGebiedType) {
            entity = this.convertFunctioneelGebied(featureMember);
        } else if (featureMember instanceof GebouwType) {
            entity = this.convertGebouw(featureMember);
        } else if (featureMember instanceof GeografischGebiedType) {
            entity = this.convertGeografischGebied(featureMember);
        } else if (featureMember instanceof InrichtingselementType) {
            entity = this.convertInrichtingselement(featureMember);
        } else if (featureMember instanceof PlaatsType) {
            entity = this.convertPlaats(featureMember);
        } else if (featureMember instanceof RegistratiefGebiedType) {
            entity = this.convertRegistratiefGebied(featureMember);
        } else if (featureMember instanceof ReliefType) {
            entity = this.convertRelief(featureMember);
        } else if (featureMember instanceof SpoorbaandeelType) {
            entity = this.convertSpoorbaandeel(featureMember);
        } else if (featureMember instanceof TerreinType) {
            entity = this.convertTerrein(featureMember);
        } else if (featureMember instanceof WaterdeelType) {
            entity = this.convertWaterdeel(featureMember);
        } else if (featureMember instanceof WegdeelType) {
            entity = this.convertWegdeel(featureMember);
        } else if (featureMember instanceof PlanTopografieType) {
            entity = this.convertPlanTopografie(featureMember);
        } else {
            throw new IllegalArgumentException("Type not recognized: " + String.valueOf(featureMember.getClass()));
        }
        log.debug((Object)("Converted type " + String.valueOf(entity.getClass()) + ", identificatie: " + entity.getIdentificatie()));
        entity.setTopnltype(TopNLType.TOP10NL.getType());
        return entity;
    }

    @Override
    public Hoogte convertHoogte(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        HoogteType h = (HoogteType)jaxbObject;
        Hoogte hoogte = new Hoogte();
        this.convertTop10NlObjectType(h, hoogte);
        hoogte.setTypeHoogte(h.getTypeHoogte().getValue());
        hoogte.setHoogte(h.getHoogte());
        hoogte.setObjectEindTijd(h.getObjectEindTijd() != null ? h.getObjectEindTijd().getTime() : null);
        Element el = h.getGeometrie();
        Geometry geom = this.gc.convertGeometry(el);
        hoogte.setGeometrie(geom);
        hoogte.setReferentieVlak(h.getReferentievlak() != null ? h.getReferentievlak().getValue() : null);
        return hoogte;
    }

    public String convertIdentificatie(Top10NlObjectType.Identificatie identificatie) {
        String idString = identificatie.getNEN3610ID().getNamespace().trim() + "." + identificatie.getNEN3610ID().getLokaalID();
        return idString;
    }

    private void convertTop10NlObjectType(Top10NlObjectType type, TopNLEntity entity) {
        entity.setIdentificatie(this.convertIdentificatie(type.getIdentificatie()));
        entity.setBrontype(type.getBrontype().getValue());
        entity.setBronactualiteit(type.getBronactualiteit().getTime());
        entity.setBronbeschrijving(type.getBronbeschrijving());
        entity.setBronnauwkeurigheid(type.getBronnauwkeurigheid());
        entity.setObjectBeginTijd(type.getObjectBeginTijd().getTime());
        entity.setVisualisatieCode(type.getVisualisatieCode() != null ? Long.valueOf(type.getVisualisatieCode().longValue()) : null);
    }

    @Override
    public FunctioneelGebied convertFunctioneelGebied(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        FunctioneelGebiedType f = (FunctioneelGebiedType)jaxbObject;
        FunctioneelGebied fg = new FunctioneelGebied();
        this.convertTop10NlObjectType(f, fg);
        fg.setTypeFunctioneelGebied(f.getTypeFunctioneelGebied().getValue());
        fg.setNaamFries(String.join((CharSequence)",", f.getNaamFries()));
        fg.setNaamNL(String.join((CharSequence)",", f.getNaamNL()));
        fg.setGeometrie(this.gc.convertGeometry(f.getGeometrie()));
        return fg;
    }

    @Override
    public Gebouw convertGebouw(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        GebouwType g = (GebouwType)jaxbObject;
        Gebouw gb = new Gebouw();
        this.convertTop10NlObjectType(g, gb);
        Object types = "";
        for (CodeType typeGebouwT10Type : g.getTypeGebouw()) {
            if (((String)types).length() != 0) {
                types = (String)types + ",";
            }
            types = (String)types + typeGebouwT10Type.getValue();
        }
        gb.setTypeGebouw((String)types);
        gb.setFysiekVoorkomen(g.getFysiekVoorkomen() != null ? g.getFysiekVoorkomen().getValue() : null);
        gb.setHoogteklasse(g.getHoogteklasse() != null ? g.getHoogteklasse().getValue() : null);
        gb.setHoogte(g.getHoogte());
        gb.setNaam(String.join((CharSequence)",", g.getNaam()));
        gb.setSoortnaam(g.getSoortnaam());
        gb.setStatus(g.getStatus() != null ? g.getStatus().getValue() : null);
        gb.setGeometrie(this.gc.convertGeometry(g.getGeometrie()));
        return gb;
    }

    @Override
    public GeografischGebied convertGeografischGebied(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        GeografischGebiedType g = (GeografischGebiedType)jaxbObject;
        GeografischGebied gb = new GeografischGebied();
        this.convertTop10NlObjectType(g, gb);
        gb.setGeometrie(this.gc.convertGeometry(g.getGeometrie()));
        gb.setNaamFries(String.join((CharSequence)",", g.getNaamFries()));
        gb.setNaamNL(String.join((CharSequence)",", g.getNaamNL()));
        gb.setTypeGeografischGebied(g.getTypeGeografischGebied().getValue());
        return gb;
    }

    @Override
    public Inrichtingselement convertInrichtingselement(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        InrichtingselementType i = (InrichtingselementType)jaxbObject;
        Inrichtingselement ie = new Inrichtingselement();
        this.convertTop10NlObjectType(i, ie);
        ie.setGeometrie(this.gc.convertGeometry(i.getGeometrie()));
        ie.setTypeInrichtingselement(i.getTypeInrichtingselement() != null ? i.getTypeInrichtingselement().getValue() : null);
        ie.setHoogteniveau(i.getHoogteniveau().longValue());
        return ie;
    }

    @Override
    public Plaats convertPlaats(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        PlaatsType p = (PlaatsType)jaxbObject;
        Plaats pl = new Plaats();
        this.convertTop10NlObjectType(p, pl);
        pl.setGeometrie(this.gc.convertGeometry(p.getGeometrie()));
        pl.setAantalInwoners(p.getAantalinwoners() != null ? Long.valueOf(p.getAantalinwoners().longValue()) : null);
        pl.setNaamFries(p.getNaamFries());
        pl.setNaamNL(p.getNaamNL());
        pl.setNaamOfficieel(p.getNaamOfficieel());
        pl.setTypeGebied(p.getTypeGebied().getValue());
        return pl;
    }

    @Override
    public RegistratiefGebied convertRegistratiefGebied(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        RegistratiefGebiedType r = (RegistratiefGebiedType)jaxbObject;
        RegistratiefGebied rg = new RegistratiefGebied();
        this.convertTop10NlObjectType(r, rg);
        rg.setGeometrie(this.gc.convertGeometry(r.getGeometrie()));
        rg.setNaamFries(String.join((CharSequence)",", r.getNaamFries()));
        rg.setNaamNL(String.join((CharSequence)",", r.getNaamNL()));
        rg.setNaamOfficieel(String.join((CharSequence)",", r.getNaamOfficieel()));
        rg.setNummer(String.join((CharSequence)",", r.getNummer()));
        rg.setTypeRegistratiefGebied(r.getTypeRegistratiefGebied() != null ? r.getTypeRegistratiefGebied().getValue() : null);
        return rg;
    }

    @Override
    public Relief convertRelief(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        ReliefType r = (ReliefType)jaxbObject;
        Relief rg = new Relief();
        this.convertTop10NlObjectType(r, rg);
        if (r.getLijnGeometrie() != null) {
            rg.setGeometrie((LineString)this.gc.convertGeometry(r.getLijnGeometrie()));
        }
        if (r.getTaludGeometrie() != null) {
            Element[] els;
            BRTHogeEnLageZijdeType hl = r.getTaludGeometrie().getBRTHogeEnLageZijde();
            for (Element el : els = hl.getHogeZijde()) {
                LineString g = (LineString)this.gc.convertGeometry(el);
                if (el.getLocalName().equals("lageZijde")) {
                    rg.setTaludLageZijde(g);
                    continue;
                }
                if (!el.getLocalName().equals("hogeZijde")) continue;
                rg.setTaludHogeZijde(g);
            }
        }
        rg.setHoogteklasse(r.getHoogteklasse().getValue());
        rg.setTypeRelief(r.getTypeRelief() != null ? r.getTypeRelief().getValue() : null);
        rg.setHoogteniveau(r.getHoogteniveau().longValue());
        return rg;
    }

    @Override
    public Spoorbaandeel convertSpoorbaandeel(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException, ClassCastException {
        SpoorbaandeelType r = (SpoorbaandeelType)jaxbObject;
        Spoorbaandeel rg = new Spoorbaandeel();
        this.convertTop10NlObjectType(r, rg);
        Geometry g = this.gc.convertGeometry(r.getGeometrie());
        if (g instanceof LineString) {
            rg.setGeometrie((LineString)g);
        } else {
            rg.setPuntGeometrie((Point)g);
        }
        Object fysieks = "";
        for (CodeType fk : r.getFysiekVoorkomen()) {
            if (((String)fysieks).length() != 0) {
                fysieks = (String)fysieks + ",";
            }
            fysieks = (String)fysieks + fk.getValue();
        }
        rg.setFysiekVoorkomen((String)fysieks);
        rg.setTypeSpoorbaan(r.getTypeSpoorbaan() != null ? r.getTypeSpoorbaan().getValue() : null);
        rg.setAantalSporen(r.getAantalSporen() != null ? r.getAantalSporen().getValue() : null);
        rg.setStatus(r.getStatus().getValue());
        rg.setHoogteniveau(r.getHoogteniveau().longValue());
        rg.setTypeInfrastructuur(r.getTypeInfrastructuur() != null ? r.getTypeInfrastructuur().getValue() : null);
        rg.setSpoorbreedte(r.getSpoorbreedte() != null ? r.getSpoorbreedte().getValue() : null);
        rg.setVervoerfunctie(r.getVervoerfunctie() != null ? r.getVervoerfunctie().getValue() : null);
        rg.setElektrificatie(r.getElektrificatie() != null ? Boolean.valueOf(r.getElektrificatie().equals((Object)BRTJaNeeWaardeType.JA)) : null);
        return rg;
    }

    @Override
    public Terrein convertTerrein(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        TerreinType r = (TerreinType)jaxbObject;
        Terrein rg = new Terrein();
        this.convertTop10NlObjectType(r, rg);
        rg.setGeometrie((Polygon)this.gc.convertGeometry(r.getGeometrieVlak()));
        rg.setTypeLandgebruik(r.getTypeLandgebruik() != null ? r.getTypeLandgebruik().getValue() : null);
        return rg;
    }

    @Override
    public PlanTopografie convertPlanTopografie(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        PlanTopografieType r = (PlanTopografieType)jaxbObject;
        PlanTopografie pt = new PlanTopografie();
        this.convertTop10NlObjectType(r, pt);
        pt.setGeometrie(this.gc.convertGeometry(r.getGeometrie()));
        pt.setNaam(r.getNaam());
        pt.setTypePlanTopografie(r.getTypeObject().getValue());
        return pt;
    }

    @Override
    public Waterdeel convertWaterdeel(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        WaterdeelType r = (WaterdeelType)jaxbObject;
        Waterdeel rg = new Waterdeel();
        this.convertTop10NlObjectType(r, rg);
        rg.setGeometrie(this.gc.convertGeometry(r.getGeometrie()));
        Object fysieks = "";
        for (CodeType fk : r.getFysiekVoorkomen()) {
            if (((String)fysieks).length() != 0) {
                fysieks = (String)fysieks + ",";
            }
            fysieks = (String)fysieks + fk.getValue();
        }
        rg.setFysiekVoorkomen((String)fysieks);
        rg.setTypeWater(r.getTypeWater() != null ? r.getTypeWater().getValue() : null);
        rg.setBreedteklasse(r.getBreedteklasse() != null ? r.getBreedteklasse().getValue() : null);
        rg.setHoogteniveau(r.getHoogteniveau().longValue());
        rg.setGetijdeinvloed(r.getGetijdeinvloed() != null ? r.getGetijdeinvloed().equals((Object)BRTJaNeeWaardeType.JA) : false);
        rg.setHoofdAfwatering(r.getHoofdafwatering() != null ? r.getHoofdafwatering().equals((Object)BRTJaNeeWaardeType.JA) : false);
        rg.setFunctie(r.getFunctie() != null ? r.getFunctie().getValue() : null);
        return rg;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Wegdeel convertWegdeel(Object jaxbObject) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Element[] elementArray;
        void var6_9;
        WegdeelType r = (WegdeelType)jaxbObject;
        Wegdeel rg = new Wegdeel();
        this.convertTop10NlObjectType(r, rg);
        Object fysieks = "";
        for (CodeType codeType : r.getFysiekVoorkomen()) {
            if (((String)fysieks).length() != 0) {
                fysieks = (String)fysieks + ",";
            }
            fysieks = (String)fysieks + codeType.getValue();
        }
        rg.setFysiekVoorkomen((String)fysieks);
        Object typeweg = "";
        for (CodeType codeType : r.getTypeWeg()) {
            if (((String)typeweg).length() != 0) {
                typeweg = (String)typeweg + ",";
            }
            typeweg = (String)typeweg + codeType.getValue();
        }
        rg.setTypeWeg((String)typeweg);
        String string = "";
        for (CodeType codeType : r.getHoofdverkeersgebruik()) {
            void var6_11;
            if (var6_9.length() != 0) {
                String string2 = (String)var6_9 + ",";
            }
            String string3 = (String)var6_11 + codeType.getValue();
        }
        rg.setHoofdverkeersgebruik((String)var6_9);
        rg.setNaam(String.join((CharSequence)",", r.getNaam()));
        for (Element el : elementArray = r.getHartGeometrie()) {
            String localname = el.getLocalName();
            Geometry g = this.gc.convertGeometry(el);
            if (localname.equals("hoofdGeometrie")) {
                rg.setGeometrie(g);
                continue;
            }
            if (!localname.equals("hartGeometrie")) continue;
            rg.setHartGeometrie(g);
        }
        rg.setTypeInfrastructuur(r.getTypeInfrastructuur() != null ? r.getTypeInfrastructuur().getValue() : null);
        rg.setVerhardingstype(r.getVerhardingstype().getValue());
        rg.setVerhardingsbreedteklasse(r.getVerhardingsbreedteklasse() != null ? r.getVerhardingsbreedteklasse().getValue() : null);
        rg.setGescheidenRijbaan(r.getGescheidenRijbaan() == BRTJaNeeWaardeType.JA);
        rg.setaWegnummer(String.join((CharSequence)",", r.getAWegnummer()));
        rg.setnWegnummer(String.join((CharSequence)",", r.getNWegnummer()));
        rg.seteWegnummer(String.join((CharSequence)",", r.getEWegnummer()));
        rg.setsWegnummer(String.join((CharSequence)",", r.getSWegnummer()));
        rg.setAfritnummer(r.getAfritnummer());
        rg.setAfritnaam(String.join((CharSequence)",", r.getAfritnaam()));
        rg.setKnooppuntnaam(String.join((CharSequence)",", r.getKnooppuntnaam()));
        rg.setBrugnaam(String.join((CharSequence)",", r.getBrugnaam()));
        rg.setTunnelnaam(String.join((CharSequence)",", r.getTunnelnaam()));
        rg.setHoogteniveau(r.getHoogteniveau().longValue());
        rg.setStatus(r.getStatus().getValue());
        return rg;
    }
}

