/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.jdbc.util.converter;

import com.microsoft.sqlserver.jdbc.Geometry;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.sql.SQLException;
import nl.b3p.jdbc.util.converter.GeometryJdbcConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.io.ParseException;

public class MssqlJdbcConverter
extends GeometryJdbcConverter {
    private static final Log LOG = LogFactory.getLog(MssqlJdbcConverter.class);
    private String schema = "dbo";
    private static final String NOT_IMPLEMENTED_DUMMY_SQL_SELECT = "select 1 where 1 = 2";
    private static final String NOT_IMPLEMENTED_DUMMY_SQL_UPDATE = "while 1 = 0 break";

    @Override
    public boolean isDuplicateKeyViolationMessage(String message) {
        return message != null && message.contains("Cannot insert duplicate key in object");
    }

    @Override
    public boolean isFKConstraintViolationMessage(String message) {
        return message != null && message.startsWith("The INSERT statement conflicted with the FOREIGN KEY constraint");
    }

    @Override
    public Object convertToNativeGeometryObject(org.locationtech.jts.geom.Geometry g, int srid) throws SQLException {
        if (g == null) {
            return null;
        }
        String param = g.toText();
        if (param == null || param.trim().length() == 0) {
            return null;
        }
        LOG.trace((Object)("Converted geom WKT: " + param + ", SRID: " + srid));
        Geometry sqlGeom = Geometry.STGeomFromText((String)param, (int)srid);
        LOG.trace((Object)("mssql geom: " + String.valueOf(sqlGeom)));
        return sqlGeom;
    }

    @Override
    public Object convertToNativeGeometryObject(org.locationtech.jts.geom.Geometry g) throws SQLException {
        return this.convertToNativeGeometryObject(g, 28992);
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    @Override
    public String getGeomTypeName() {
        return "geometry";
    }

    @Override
    public String buildPaginationSql(String sql, int offset, int limit) {
        StringBuilder builder = new StringBuilder(sql);
        if (!StringUtils.containsIgnoreCase((CharSequence)sql, (CharSequence)"ORDER BY")) {
            builder.append(" ORDER BY id ");
        }
        builder.append(" OFFSET ");
        builder.append(offset);
        builder.append(" ROWS FETCH NEXT ");
        builder.append(limit);
        builder.append(" ROWS ONLY ");
        return builder.toString();
    }

    @Override
    public StringBuilder buildLimitSql(StringBuilder sql, int limit) {
        String s = this.buildPaginationSql(sql.toString(), 0, limit);
        return new StringBuilder(s);
    }

    @Override
    public boolean useSavepoints() {
        return false;
    }

    @Override
    public boolean isPmdKnownBroken() {
        return false;
    }

    @Override
    public String getGeotoolsDBTypeName() {
        return "sqlserver";
    }

    @Override
    public String getMViewsSQL() {
        return NOT_IMPLEMENTED_DUMMY_SQL_SELECT;
    }

    @Override
    public String getMViewRefreshSQL(String mview) {
        return NOT_IMPLEMENTED_DUMMY_SQL_UPDATE;
    }

    @Override
    public String getSelectNextValueFromSequenceSQL(String seqName) {
        return String.format("SELECT NEXT VALUE FOR %s", seqName);
    }

    @Override
    public org.locationtech.jts.geom.Geometry convertToJTSGeometryObject(Object nativeObj) {
        org.locationtech.jts.geom.Geometry jts = null;
        if (nativeObj == null) {
            return jts;
        }
        if (Geometry.class.isAssignableFrom(nativeObj.getClass())) {
            try {
                jts = this.wkt.read(((Geometry)nativeObj).STAsText());
                jts.setSRID(((Geometry)nativeObj).getSrid());
            }
            catch (SQLServerException | ParseException e) {
                LOG.error((Object)"Error converting SQL Server to JTS geometry", e);
            }
        }
        return jts;
    }
}

