/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.cql2;

import java.io.StringReader;
import java.util.List;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.During;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.text.commons.ICompiler;
import org.geotools.filter.text.commons.IToken;
import org.geotools.filter.text.commons.Result;
import org.geotools.filter.text.commons.TokenAdapter;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.cql2.CQLFilterBuilder;
import org.geotools.filter.text.generated.parsers.CQLParser;
import org.geotools.filter.text.generated.parsers.Node;
import org.geotools.filter.text.generated.parsers.ParseException;
import org.geotools.filter.text.generated.parsers.TokenMgrError;

public class CQLCompiler
extends CQLParser
implements ICompiler {
    private static final String ATTRIBUTE_PATH_SEPARATOR = "/";
    private final String source;
    private CQLFilterBuilder builder;

    public CQLCompiler(String cqlSource, FilterFactory filterFactory) {
        super(new StringReader(cqlSource));
        assert (filterFactory != null) : "filterFactory cannot be null";
        this.source = cqlSource;
        this.builder = new CQLFilterBuilder(cqlSource, filterFactory);
    }

    @Override
    public void compileFilter() throws CQLException {
        try {
            super.FilterCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileExpression() throws CQLException {
        try {
            super.ExpressionCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public void compileFilterList() throws CQLException {
        try {
            super.FilterListCompilationUnit();
        }
        catch (TokenMgrError tokenError) {
            throw new CQLException(tokenError.getMessage(), this.getTokenInPosition(0), this.source);
        }
        catch (CQLException e) {
            throw e;
        }
        catch (ParseException e) {
            throw new CQLException(e.getMessage(), this.getTokenInPosition(0), e.getCause(), this.source);
        }
    }

    @Override
    public final String getSource() {
        return this.source;
    }

    @Override
    public final Filter getFilter() throws CQLException {
        return this.builder.getFilter();
    }

    @Override
    public final Expression getExpression() throws CQLException {
        return this.builder.getExpression();
    }

    @Override
    public final List<Filter> getFilterList() throws CQLException {
        return this.builder.getFilterList();
    }

    @Override
    public IToken getTokenInPosition(int index) {
        return TokenAdapter.newAdapterFor(super.getToken(index));
    }

    @Override
    public final void jjtreeOpenNodeScope(Node n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void jjtreeCloseNodeScope(Node n) throws ParseException {
        try {
            Object built = this.build(n);
            IToken tokenAdapter = TokenAdapter.newAdapterFor(this.token);
            Result r = new Result(built, tokenAdapter, n.getType());
            this.builder.pushResult(r);
        }
        finally {
            n.dispose();
        }
    }

    private Object build(Node cqlNode) throws CQLException {
        switch (cqlNode.getType()) {
            case 55: {
                return this.builder.buildLiteralInteger(this.getToken((int)0).image);
            }
            case 56: {
                return this.builder.buildLiteralDouble(this.getToken((int)0).image);
            }
            case 59: {
                return this.builder.buildLiteralString(this.getToken((int)0).image);
            }
            case 51: {
                return this.builder.buildIdentifier(52);
            }
            case 52: {
                return this.builder.buildIdentifierPart(this.getTokenInPosition(0));
            }
            case 53: {
                return this.builder.buildSimpleAttribute();
            }
            case 54: {
                return this.builder.buildCompoundAttribute(53, ATTRIBUTE_PATH_SEPARATOR);
            }
            case 60: {
                return this.builder.buildFunction(61);
            }
            case 61: {
                return cqlNode;
            }
            case 62: {
                return cqlNode;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                return this.buildBinaryExpression(cqlNode.getType());
            }
            case 2: {
                return this.buildLogicFilter(2);
            }
            case 1: {
                return this.buildLogicFilter(1);
            }
            case 3: {
                return this.buildLogicFilter(3);
            }
            case 46: {
                return this.builder.buildBetween();
            }
            case 45: {
                return this.builder.buildNotBetween();
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return this.buildBinaryComparasionOperator(cqlNode.getType());
            }
            case 27: {
                BinaryComparisonOperator eq = this.buildBinaryComparasionOperator(22);
                Not notFilter = this.builder.buildNotFilter((Filter)eq);
                return notFilter;
            }
            case 44: {
                return this.builder.buildLikeFilter(true);
            }
            case 43: {
                return this.builder.buildNotLikeFilter(true);
            }
            case 28: {
                return this.builder.buildPropertyIsNull();
            }
            case 29: {
                return this.builder.buildPorpertyNotIsNull();
            }
            case 39: {
                return this.builder.buildDateTimeExpression(this.getTokenInPosition(0));
            }
            case 40: {
                return this.builder.buildDurationExpression(this.getTokenInPosition(0));
            }
            case 38: {
                return this.builder.buildPeriodBetweenDates();
            }
            case 37: {
                return this.builder.buildPeriodDateAndDuration();
            }
            case 36: {
                return this.builder.buildPeriodDurationAndDate();
            }
            case 30: {
                return this.builder.buildTEquals();
            }
            case 31: {
                return this.buildBeforePredicate();
            }
            case 33: {
                return this.buildAfterPredicate();
            }
            case 34: {
                return this.buildDuring();
            }
            case 32: {
                return this.buildBeforeOrDuring();
            }
            case 35: {
                return this.buildDuringOrAfter();
            }
            case 41: {
                return this.builder.buildPropertyExists();
            }
            case 42: {
                PropertyIsEqualTo filter = this.builder.buildPropertyExists();
                Not filterPropNotExist = this.builder.buildNotFilter((Filter)filter);
                return filterPropNotExist;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.buildBinarySpatialOperator(cqlNode.getType());
            }
            case 14: 
            case 15: {
                return this.buildBBox(cqlNode.getType());
            }
            case 12: {
                return this.builder.buildSpatialRelateFilter();
            }
            case 13: {
                return this.builder.buildDE9IM(this.getToken((int)0).image);
            }
            case 18: {
                return this.builder.buildTolerance();
            }
            case 19: {
                return this.builder.buildDistanceUnit(this.getTokenInPosition(0));
            }
            case 16: 
            case 17: {
                return this.buildDistanceBufferOperator(cqlNode.getType());
            }
            case 63: {
                return this.builder.buildGeometry(TokenAdapter.newAdapterFor(cqlNode.getToken()));
            }
            case 64: {
                return this.builder.buildEnvelope(TokenAdapter.newAdapterFor(cqlNode.getToken()));
            }
            case 20: {
                return Filter.INCLUDE;
            }
            case 21: {
                return Filter.EXCLUDE;
            }
            case 57: {
                return this.builder.buildTrueLiteral();
            }
            case 58: {
                return this.builder.buildFalseLiteral();
            }
        }
        return null;
    }

    private BinaryExpression buildBinaryExpression(int nodeType) throws CQLException {
        BinaryExpression expr = null;
        switch (nodeType) {
            case 47: {
                expr = this.builder.buildAddExpression();
                break;
            }
            case 48: {
                expr = this.builder.buildSubtractExression();
                break;
            }
            case 49: {
                expr = this.builder.buildMultiplyExpression();
                break;
            }
            case 50: {
                expr = this.builder.buildDivideExpression();
                break;
            }
        }
        return expr;
    }

    private Filter buildLogicFilter(int nodeType) throws CQLException {
        try {
            Filter logicFilter;
            switch (nodeType) {
                case 2: {
                    logicFilter = this.builder.buildAndFilter();
                    break;
                }
                case 1: {
                    logicFilter = this.builder.buildOrFilter();
                    break;
                }
                case 3: {
                    logicFilter = this.builder.buildNotFilter();
                    break;
                }
                default: {
                    throw new CQLException("Expression not supported. And, Or, Not is required", this.getTokenInPosition(0), this.source);
                }
            }
            return logicFilter;
        }
        catch (IllegalFilterException ife) {
            throw new CQLException("Exception building LogicFilter", this.getTokenInPosition(0), ife, this.source);
        }
    }

    private BinarySpatialOperator buildBinarySpatialOperator(int nodeType) throws CQLException {
        BinarySpatialOperator filter = null;
        switch (nodeType) {
            case 4: {
                filter = this.builder.buildSpatialEqualFilter();
                break;
            }
            case 5: {
                filter = this.builder.buildSpatialDisjointFilter();
                break;
            }
            case 6: {
                filter = this.builder.buildSpatialIntersectsFilter();
                break;
            }
            case 7: {
                filter = this.builder.buildSpatialTouchesFilter();
                break;
            }
            case 8: {
                filter = this.builder.buildSpatialCrossesFilter();
                break;
            }
            case 9: {
                filter = this.builder.buildSpatialWithinFilter();
                break;
            }
            case 10: {
                filter = this.builder.buildSpatialContainsFilter();
                break;
            }
            case 11: {
                filter = this.builder.buildSpatialOverlapsFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private Filter buildBBox(int nodeType) throws CQLException {
        if (nodeType == 15) {
            return this.builder.buildBBoxWithCRS();
        }
        return this.builder.buildBBox();
    }

    private DistanceBufferOperator buildDistanceBufferOperator(int nodeType) throws CQLException {
        DistanceBufferOperator filter = null;
        switch (nodeType) {
            case 16: {
                filter = this.builder.buildSpatialDWithinFilter();
                break;
            }
            case 17: {
                filter = this.builder.buildSpatialBeyondFilter();
                break;
            }
            default: {
                throw new CQLException("Binary spatial operator unexpected");
            }
        }
        return filter;
    }

    private Or buildBeforeOrDuring() throws CQLException {
        Or filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 36: 
            case 37: 
            case 38: {
                filter = this.builder.buildBeforeOrDuring();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Or buildDuringOrAfter() throws CQLException {
        Or filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 36: 
            case 37: 
            case 38: {
                filter = this.builder.buildDuringOrAfter();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private Before buildBeforePredicate() throws CQLException {
        Before filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 39: {
                filter = this.builder.buildBeforeDate();
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                filter = this.builder.buildBeforePeriod();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private During buildDuring() throws CQLException {
        During filter = null;
        Result node = this.builder.peekResult();
        switch (node.getNodeType()) {
            case 36: 
            case 37: 
            case 38: {
                filter = this.builder.buildDuringPeriod();
                break;
            }
            default: {
                throw new CQLException("unexpeted period expression in temporal predicate.", node.getToken(), this.source);
            }
        }
        return filter;
    }

    private After buildAfterPredicate() throws CQLException {
        After filter = null;
        Result result = this.builder.peekResult();
        switch (result.getNodeType()) {
            case 39: {
                filter = this.builder.buildAfterDate();
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                filter = this.builder.buildAfterPeriod();
                break;
            }
            default: {
                throw new CQLException("unexpeted date time expression in temporal predicate.", result.getToken(), this.source);
            }
        }
        return filter;
    }

    private BinaryComparisonOperator buildBinaryComparasionOperator(int filterType) throws CQLException {
        switch (filterType) {
            case 22: {
                return this.builder.buildEquals();
            }
            case 23: {
                return this.builder.buildGreater();
            }
            case 24: {
                return this.builder.buildLess();
            }
            case 25: {
                return this.builder.buildGreaterOrEqual();
            }
            case 26: {
                return this.builder.buildLessOrEqual();
            }
        }
        throw new CQLException("unexpeted filter type.");
    }

    public static void main(String[] args) throws ParseException {
        CQL.main(args);
    }
}

