/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfConformance;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.tagutils.AccessibilityProperties;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import com.itextpdf.layout.tagging.LayoutTaggingHelper;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;

public abstract class AbstractFormFieldRenderer
extends BlockRenderer {
    protected IRenderer flatRenderer;

    AbstractFormFieldRenderer(IFormField modelElement) {
        super((IElement)modelElement);
    }

    public boolean isFlatten() {
        Boolean flatten;
        if (this.parent != null) {
            for (IRenderer nextParent = this.parent; nextParent != null; nextParent = nextParent.getParent()) {
                if (!(nextParent instanceof AbstractFormFieldRenderer)) continue;
                return true;
            }
        }
        return (flatten = this.getPropertyAsBoolean(0x200001)) == null ? ((Boolean)this.modelElement.getDefaultProperty(0x200001)).booleanValue() : flatten.booleanValue();
    }

    public String getDefaultValue() {
        String defaultValue = (String)this.getProperty(0x200003);
        return defaultValue == null ? (String)this.modelElement.getDefaultProperty(0x200003) : defaultValue;
    }

    public LayoutResult layout(LayoutContext layoutContext) {
        this.childRenderers.clear();
        this.flatRenderer = null;
        float parentWidth = layoutContext.getArea().getBBox().getWidth();
        float parentHeight = layoutContext.getArea().getBBox().getHeight();
        IRenderer renderer = this.createFlatRenderer();
        if (renderer.getOwnProperty(103) == null) {
            renderer.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        }
        if (renderer.getOwnProperty(104) == null) {
            renderer.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        }
        this.addChild(renderer);
        LayoutTaggingHelper taggingHelper = (LayoutTaggingHelper)this.getProperty(108);
        if (taggingHelper != null) {
            taggingHelper.addKidsHint((IPropertyContainer)this, Collections.singletonList(renderer));
            LayoutTaggingHelper.addTreeHints((LayoutTaggingHelper)taggingHelper, (IRenderer)renderer);
        }
        Rectangle bBox = layoutContext.getArea().getBBox().clone().moveDown(1000000.0f - parentHeight).setHeight(1000000.0f);
        layoutContext.getArea().setBBox(bBox);
        boolean isForcedPlacement = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
        LayoutResult result = super.layout(layoutContext);
        if (this.childRenderers.isEmpty()) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot layout form field. It won't be displayed");
            this.occupiedArea.getBBox().setWidth(0.0f).setHeight(0.0f);
        } else {
            this.flatRenderer = (IRenderer)this.childRenderers.get(0);
            this.processLangAttribute();
            this.childRenderers.clear();
            this.childRenderers.add(this.flatRenderer);
            this.adjustFieldLayout(layoutContext);
            if (this.isLayoutBasedOnFlatRenderer()) {
                Rectangle fBox = this.flatRenderer.getOccupiedArea().getBBox();
                this.occupiedArea.getBBox().setX(fBox.getX()).setY(fBox.getY()).setWidth(fBox.getWidth()).setHeight(fBox.getHeight());
                this.applyPaddings(this.occupiedArea.getBBox(), true);
                this.applyBorderBox(this.occupiedArea.getBBox(), true);
                this.applyMargins(this.occupiedArea.getBBox(), true);
            } else if (isForcedPlacement) {
                Rectangle fBox = this.getOccupiedArea().getBBox();
                LayoutArea childOccupiedArea = this.flatRenderer.getOccupiedArea();
                childOccupiedArea.getBBox().setY(fBox.getY()).setHeight(fBox.getHeight());
            }
        }
        if (!isForcedPlacement && !this.isRendererFit(parentWidth, parentHeight)) {
            this.occupiedArea.getBBox().setWidth(0.0f).setHeight(0.0f);
            return new MinMaxWidthLayoutResult(3, this.occupiedArea, null, (IRenderer)this, (IRenderer)this).setMinMaxWidth(new MinMaxWidth());
        }
        if (result.getStatus() != 1 || !this.isRendererFit(parentWidth, parentHeight)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Input field doesn't fit in outer object. It will be clipped");
        }
        return new MinMaxWidthLayoutResult(1, this.occupiedArea, (IRenderer)this, null).setMinMaxWidth(new MinMaxWidth(this.occupiedArea.getBBox().getWidth(), this.occupiedArea.getBBox().getWidth(), 0.0f));
    }

    public void draw(DrawContext drawContext) {
        if (this.flatRenderer != null) {
            if (this.isFlatten()) {
                super.draw(drawContext);
            } else {
                this.drawChildren(drawContext);
            }
        }
    }

    public MinMaxWidth getMinMaxWidth() {
        this.childRenderers.clear();
        this.flatRenderer = null;
        IRenderer renderer = this.createFlatRenderer();
        this.addChild(renderer);
        MinMaxWidth minMaxWidth = super.getMinMaxWidth();
        return minMaxWidth;
    }

    public void drawChildren(DrawContext drawContext) {
        drawContext.getCanvas().saveState();
        boolean flatten = this.isFlatten();
        if (flatten) {
            PdfCanvas canvas = drawContext.getCanvas();
            canvas.rectangle(this.applyBorderBox(this.occupiedArea.getBBox(), false)).clip().endPath();
            this.flatRenderer.draw(drawContext);
        } else {
            this.applyAcroField(drawContext);
            this.writeAcroFormFieldLangAttribute(drawContext.getDocument());
        }
        drawContext.getCanvas().restoreState();
    }

    protected void applyAccessibilityProperties(PdfFormField formField, PdfDocument pdfDocument) {
        PdfFormField.applyAccessibilityProperties(formField, (IAccessibleElement)this.modelElement, pdfDocument);
    }

    protected abstract void adjustFieldLayout(LayoutContext var1);

    protected abstract IRenderer createFlatRenderer();

    protected abstract void applyAcroField(DrawContext var1);

    protected String getModelId() {
        return ((IFormField)this.getModelElement()).getId();
    }

    protected boolean isRendererFit(float availableWidth, float availableHeight) {
        if (this.occupiedArea == null) {
            return false;
        }
        return availableHeight >= this.occupiedArea.getBBox().getHeight() && (availableWidth >= this.occupiedArea.getBBox().getWidth() || this.getProperty(103) == OverflowPropertyValue.VISIBLE);
    }

    protected String getLang() {
        String language = null;
        if (this.getModelElement() instanceof IAccessibleElement) {
            language = ((IAccessibleElement)this.getModelElement()).getAccessibilityProperties().getLanguage();
        }
        return language;
    }

    protected PdfConformance getConformance(PdfDocument document) {
        PdfConformance conformance = (PdfConformance)this.getProperty(0x20000F);
        if (conformance != null) {
            return conformance;
        }
        if (document == null) {
            return null;
        }
        return document.getConformance();
    }

    protected boolean isLayoutBasedOnFlatRenderer() {
        return true;
    }

    protected void writeAcroFormFieldLangAttribute(PdfDocument pdfDoc) {
        if (pdfDoc.isTagged()) {
            TagTreePointer formParentPointer = pdfDoc.getTagStructureContext().getAutoTaggingPointer();
            List kidsRoles = formParentPointer.getKidsRoles();
            int lastFormIndex = kidsRoles.lastIndexOf("Form");
            TagTreePointer formPointer = formParentPointer.moveToKid(lastFormIndex);
            if (this.getLang() != null) {
                formPointer.getProperties().setLanguage(this.getLang());
            }
            formParentPointer.moveToParent();
        }
    }

    private void processLangAttribute() {
        AccessibilityProperties properties;
        IPropertyContainer propertyContainer = this.flatRenderer.getModelElement();
        String lang = this.getLang();
        if (propertyContainer instanceof IAccessibleElement && lang != null && (properties = ((IAccessibleElement)propertyContainer).getAccessibilityProperties()).getLanguage() == null) {
            properties.setLanguage(lang);
        }
    }
}

