/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.jdbc.util.converter;

import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.postgresql.PGConnection;

public class PGConnectionUnwrapper {
    private static final Log LOG = LogFactory.getLog(PGConnectionUnwrapper.class);

    public static PGConnection unwrap(Connection connection) throws SQLException {
        LOG.trace((Object)("Connection class: " + connection.getClass().getName()));
        LOG.trace((Object)("isWrapperFor(PGConnection.class): " + connection.isWrapperFor(PGConnection.class)));
        Connection metadataConnection = connection.getMetaData().getConnection();
        LOG.trace((Object)("MetaData connection class: " + metadataConnection.getClass().getName()));
        LOG.trace((Object)("MetaData isWrapperFor(PGConnection.class): " + metadataConnection.isWrapperFor(PGConnection.class)));
        if (connection.isWrapperFor(PGConnection.class)) {
            LOG.trace((Object)"Unwrap Connection voor PGConnection");
            return connection.unwrap(PGConnection.class);
        }
        if (metadataConnection instanceof PGConnection) {
            LOG.trace((Object)"Cast MetaData Connection naar PGConnection");
            return (PGConnection)metadataConnection;
        }
        if (metadataConnection instanceof PoolableConnection) {
            LOG.trace((Object)"Cast naar matadataConnection PGConnection via cast naar tomcat DelegatingConnection");
            return (PGConnection)((DelegatingConnection)metadataConnection).getDelegate();
        }
        if (DelegatingConnection.class.isAssignableFrom(connection.getClass())) {
            LOG.trace((Object)"Cast InnermostDelegate van DelegatingConnection connection");
            return (PGConnection)((DelegatingConnection)connection).getInnermostDelegate();
        }
        throw new SQLException("Kan connectie niet unwrappen naar PGConnection van meta connectie: " + metadataConnection.getClass().getName() + ", connection: " + connection.getClass().getName());
    }
}

